// Copyright 2019 The go-github AUTHORS. All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by gen-stringify-tests; DO NOT EDIT.
// Instead, please run "go generate ./..." as described here:
// https://github.com/google/go-github/blob/master/CONTRIBUTING.md#submitting-a-patch

package github

import (
	"testing"
)

func TestActionsAllowed_String(t *testing.T) {
	t.Parallel()
	v := ActionsAllowed{
		GithubOwnedAllowed: Ptr(false),
		VerifiedAllowed:    Ptr(false),
		PatternsAllowed:    []string{""},
	}
	want := `github.ActionsAllowed{GithubOwnedAllowed:false, VerifiedAllowed:false, PatternsAllowed:[""]}`
	if got := v.String(); got != want {
		t.Errorf("ActionsAllowed.String = %v, want %v", got, want)
	}
}

func TestActionsPermissions_String(t *testing.T) {
	t.Parallel()
	v := ActionsPermissions{
		EnabledRepositories: Ptr(""),
		AllowedActions:      Ptr(""),
		SelectedActionsURL:  Ptr(""),
	}
	want := `github.ActionsPermissions{EnabledRepositories:"", AllowedActions:"", SelectedActionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("ActionsPermissions.String = %v, want %v", got, want)
	}
}

func TestActionsPermissionsEnterprise_String(t *testing.T) {
	t.Parallel()
	v := ActionsPermissionsEnterprise{
		EnabledOrganizations: Ptr(""),
		AllowedActions:       Ptr(""),
		SelectedActionsURL:   Ptr(""),
	}
	want := `github.ActionsPermissionsEnterprise{EnabledOrganizations:"", AllowedActions:"", SelectedActionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("ActionsPermissionsEnterprise.String = %v, want %v", got, want)
	}
}

func TestActionsPermissionsRepository_String(t *testing.T) {
	t.Parallel()
	v := ActionsPermissionsRepository{
		Enabled:            Ptr(false),
		AllowedActions:     Ptr(""),
		SelectedActionsURL: Ptr(""),
	}
	want := `github.ActionsPermissionsRepository{Enabled:false, AllowedActions:"", SelectedActionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("ActionsPermissionsRepository.String = %v, want %v", got, want)
	}
}

func TestAdminStats_String(t *testing.T) {
	t.Parallel()
	v := AdminStats{
		Issues:     &IssueStats{},
		Hooks:      &HookStats{},
		Milestones: &MilestoneStats{},
		Orgs:       &OrgStats{},
		Comments:   &CommentStats{},
		Pages:      &PageStats{},
		Users:      &UserStats{},
		Gists:      &GistStats{},
		Pulls:      &PullStats{},
		Repos:      &RepoStats{},
	}
	want := `github.AdminStats{Issues:github.IssueStats{}, Hooks:github.HookStats{}, Milestones:github.MilestoneStats{}, Orgs:github.OrgStats{}, Comments:github.CommentStats{}, Pages:github.PageStats{}, Users:github.UserStats{}, Gists:github.GistStats{}, Pulls:github.PullStats{}, Repos:github.RepoStats{}}`
	if got := v.String(); got != want {
		t.Errorf("AdminStats.String = %v, want %v", got, want)
	}
}

func TestAdvancedSecurity_String(t *testing.T) {
	t.Parallel()
	v := AdvancedSecurity{
		Status: Ptr(""),
	}
	want := `github.AdvancedSecurity{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("AdvancedSecurity.String = %v, want %v", got, want)
	}
}

func TestAuthorization_String(t *testing.T) {
	t.Parallel()
	v := Authorization{
		ID:             Ptr(int64(0)),
		URL:            Ptr(""),
		Scopes:         []Scope{ScopeNone},
		Token:          Ptr(""),
		TokenLastEight: Ptr(""),
		HashedToken:    Ptr(""),
		App:            &AuthorizationApp{},
		Note:           Ptr(""),
		NoteURL:        Ptr(""),
		UpdatedAt:      &Timestamp{},
		CreatedAt:      &Timestamp{},
		Fingerprint:    Ptr(""),
		User:           &User{},
	}
	want := `github.Authorization{ID:0, URL:"", Scopes:["(no scope)"], Token:"", TokenLastEight:"", HashedToken:"", App:github.AuthorizationApp{}, Note:"", NoteURL:"", UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Fingerprint:"", User:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("Authorization.String = %v, want %v", got, want)
	}
}

func TestAuthorizationApp_String(t *testing.T) {
	t.Parallel()
	v := AuthorizationApp{
		URL:      Ptr(""),
		Name:     Ptr(""),
		ClientID: Ptr(""),
	}
	want := `github.AuthorizationApp{URL:"", Name:"", ClientID:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationApp.String = %v, want %v", got, want)
	}
}

func TestAuthorizationRequest_String(t *testing.T) {
	t.Parallel()
	v := AuthorizationRequest{
		Scopes:       []Scope{ScopeNone},
		Note:         Ptr(""),
		NoteURL:      Ptr(""),
		ClientID:     Ptr(""),
		ClientSecret: Ptr(""),
		Fingerprint:  Ptr(""),
	}
	want := `github.AuthorizationRequest{Scopes:["(no scope)"], Note:"", NoteURL:"", ClientID:"", ClientSecret:"", Fingerprint:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationRequest.String = %v, want %v", got, want)
	}
}

func TestAuthorizationUpdateRequest_String(t *testing.T) {
	t.Parallel()
	v := AuthorizationUpdateRequest{
		Scopes:       []string{""},
		AddScopes:    []string{""},
		RemoveScopes: []string{""},
		Note:         Ptr(""),
		NoteURL:      Ptr(""),
		Fingerprint:  Ptr(""),
	}
	want := `github.AuthorizationUpdateRequest{Scopes:[""], AddScopes:[""], RemoveScopes:[""], Note:"", NoteURL:"", Fingerprint:""}`
	if got := v.String(); got != want {
		t.Errorf("AuthorizationUpdateRequest.String = %v, want %v", got, want)
	}
}

func TestCheckRun_String(t *testing.T) {
	t.Parallel()
	v := CheckRun{
		ID:          Ptr(int64(0)),
		NodeID:      Ptr(""),
		HeadSHA:     Ptr(""),
		ExternalID:  Ptr(""),
		URL:         Ptr(""),
		HTMLURL:     Ptr(""),
		DetailsURL:  Ptr(""),
		Status:      Ptr(""),
		Conclusion:  Ptr(""),
		StartedAt:   &Timestamp{},
		CompletedAt: &Timestamp{},
		Output:      &CheckRunOutput{},
		Name:        Ptr(""),
		CheckSuite:  &CheckSuite{},
		App:         &App{},
	}
	want := `github.CheckRun{ID:0, NodeID:"", HeadSHA:"", ExternalID:"", URL:"", HTMLURL:"", DetailsURL:"", Status:"", Conclusion:"", StartedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CompletedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Output:github.CheckRunOutput{}, Name:"", CheckSuite:github.CheckSuite{}, App:github.App{}}`
	if got := v.String(); got != want {
		t.Errorf("CheckRun.String = %v, want %v", got, want)
	}
}

func TestCheckSuite_String(t *testing.T) {
	t.Parallel()
	v := CheckSuite{
		ID:                   Ptr(int64(0)),
		NodeID:               Ptr(""),
		HeadBranch:           Ptr(""),
		HeadSHA:              Ptr(""),
		URL:                  Ptr(""),
		BeforeSHA:            Ptr(""),
		AfterSHA:             Ptr(""),
		Status:               Ptr(""),
		Conclusion:           Ptr(""),
		CreatedAt:            &Timestamp{},
		UpdatedAt:            &Timestamp{},
		App:                  &App{},
		Repository:           &Repository{},
		HeadCommit:           &Commit{},
		LatestCheckRunsCount: Ptr(int64(0)),
		Rerequestable:        Ptr(false),
		RunsRerequestable:    Ptr(false),
	}
	want := `github.CheckSuite{ID:0, NodeID:"", HeadBranch:"", HeadSHA:"", URL:"", BeforeSHA:"", AfterSHA:"", Status:"", Conclusion:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, App:github.App{}, Repository:github.Repository{}, HeadCommit:github.Commit{}, LatestCheckRunsCount:0, Rerequestable:false, RunsRerequestable:false}`
	if got := v.String(); got != want {
		t.Errorf("CheckSuite.String = %v, want %v", got, want)
	}
}

func TestCodeOfConduct_String(t *testing.T) {
	t.Parallel()
	v := CodeOfConduct{
		Name: Ptr(""),
		Key:  Ptr(""),
		URL:  Ptr(""),
		Body: Ptr(""),
	}
	want := `github.CodeOfConduct{Name:"", Key:"", URL:"", Body:""}`
	if got := v.String(); got != want {
		t.Errorf("CodeOfConduct.String = %v, want %v", got, want)
	}
}

func TestCodeResult_String(t *testing.T) {
	t.Parallel()
	v := CodeResult{
		Name:       Ptr(""),
		Path:       Ptr(""),
		SHA:        Ptr(""),
		HTMLURL:    Ptr(""),
		Repository: &Repository{},
	}
	want := `github.CodeResult{Name:"", Path:"", SHA:"", HTMLURL:"", Repository:github.Repository{}}`
	if got := v.String(); got != want {
		t.Errorf("CodeResult.String = %v, want %v", got, want)
	}
}

func TestCombinedStatus_String(t *testing.T) {
	t.Parallel()
	v := CombinedStatus{
		State:         Ptr(""),
		Name:          Ptr(""),
		SHA:           Ptr(""),
		TotalCount:    Ptr(0),
		CommitURL:     Ptr(""),
		RepositoryURL: Ptr(""),
	}
	want := `github.CombinedStatus{State:"", Name:"", SHA:"", TotalCount:0, CommitURL:"", RepositoryURL:""}`
	if got := v.String(); got != want {
		t.Errorf("CombinedStatus.String = %v, want %v", got, want)
	}
}

func TestCommentStats_String(t *testing.T) {
	t.Parallel()
	v := CommentStats{
		TotalCommitComments:      Ptr(0),
		TotalGistComments:        Ptr(0),
		TotalIssueComments:       Ptr(0),
		TotalPullRequestComments: Ptr(0),
	}
	want := `github.CommentStats{TotalCommitComments:0, TotalGistComments:0, TotalIssueComments:0, TotalPullRequestComments:0}`
	if got := v.String(); got != want {
		t.Errorf("CommentStats.String = %v, want %v", got, want)
	}
}

func TestCommit_String(t *testing.T) {
	t.Parallel()
	v := Commit{
		SHA:          Ptr(""),
		Author:       &CommitAuthor{},
		Committer:    &CommitAuthor{},
		Message:      Ptr(""),
		Tree:         &Tree{},
		HTMLURL:      Ptr(""),
		URL:          Ptr(""),
		Verification: &SignatureVerification{},
		NodeID:       Ptr(""),
		CommentCount: Ptr(0),
	}
	want := `github.Commit{SHA:"", Author:github.CommitAuthor{}, Committer:github.CommitAuthor{}, Message:"", Tree:github.Tree{}, HTMLURL:"", URL:"", Verification:github.SignatureVerification{}, NodeID:"", CommentCount:0}`
	if got := v.String(); got != want {
		t.Errorf("Commit.String = %v, want %v", got, want)
	}
}

func TestCommitAuthor_String(t *testing.T) {
	t.Parallel()
	v := CommitAuthor{
		Date:  &Timestamp{},
		Name:  Ptr(""),
		Email: Ptr(""),
		Login: Ptr(""),
	}
	want := `github.CommitAuthor{Date:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Name:"", Email:"", Login:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitAuthor.String = %v, want %v", got, want)
	}
}

func TestCommitFile_String(t *testing.T) {
	t.Parallel()
	v := CommitFile{
		SHA:              Ptr(""),
		Filename:         Ptr(""),
		Additions:        Ptr(0),
		Deletions:        Ptr(0),
		Changes:          Ptr(0),
		Status:           Ptr(""),
		Patch:            Ptr(""),
		BlobURL:          Ptr(""),
		RawURL:           Ptr(""),
		ContentsURL:      Ptr(""),
		PreviousFilename: Ptr(""),
	}
	want := `github.CommitFile{SHA:"", Filename:"", Additions:0, Deletions:0, Changes:0, Status:"", Patch:"", BlobURL:"", RawURL:"", ContentsURL:"", PreviousFilename:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitFile.String = %v, want %v", got, want)
	}
}

func TestCommitStats_String(t *testing.T) {
	t.Parallel()
	v := CommitStats{
		Additions: Ptr(0),
		Deletions: Ptr(0),
		Total:     Ptr(0),
	}
	want := `github.CommitStats{Additions:0, Deletions:0, Total:0}`
	if got := v.String(); got != want {
		t.Errorf("CommitStats.String = %v, want %v", got, want)
	}
}

func TestCommitsComparison_String(t *testing.T) {
	t.Parallel()
	v := CommitsComparison{
		BaseCommit:      &RepositoryCommit{},
		MergeBaseCommit: &RepositoryCommit{},
		Status:          Ptr(""),
		AheadBy:         Ptr(0),
		BehindBy:        Ptr(0),
		TotalCommits:    Ptr(0),
		HTMLURL:         Ptr(""),
		PermalinkURL:    Ptr(""),
		DiffURL:         Ptr(""),
		PatchURL:        Ptr(""),
		URL:             Ptr(""),
	}
	want := `github.CommitsComparison{BaseCommit:github.RepositoryCommit{}, MergeBaseCommit:github.RepositoryCommit{}, Status:"", AheadBy:0, BehindBy:0, TotalCommits:0, HTMLURL:"", PermalinkURL:"", DiffURL:"", PatchURL:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("CommitsComparison.String = %v, want %v", got, want)
	}
}

func TestContributorStats_String(t *testing.T) {
	t.Parallel()
	v := ContributorStats{
		Author: &Contributor{},
		Total:  Ptr(0),
	}
	want := `github.ContributorStats{Author:github.Contributor{}, Total:0}`
	if got := v.String(); got != want {
		t.Errorf("ContributorStats.String = %v, want %v", got, want)
	}
}

func TestDependabotSecurityUpdates_String(t *testing.T) {
	t.Parallel()
	v := DependabotSecurityUpdates{
		Status: Ptr(""),
	}
	want := `github.DependabotSecurityUpdates{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("DependabotSecurityUpdates.String = %v, want %v", got, want)
	}
}

func TestDiscussionComment_String(t *testing.T) {
	t.Parallel()
	v := DiscussionComment{
		Author:        &User{},
		Body:          Ptr(""),
		BodyHTML:      Ptr(""),
		BodyVersion:   Ptr(""),
		CreatedAt:     &Timestamp{},
		LastEditedAt:  &Timestamp{},
		DiscussionURL: Ptr(""),
		HTMLURL:       Ptr(""),
		NodeID:        Ptr(""),
		Number:        Ptr(0),
		UpdatedAt:     &Timestamp{},
		URL:           Ptr(""),
		Reactions:     &Reactions{},
	}
	want := `github.DiscussionComment{Author:github.User{}, Body:"", BodyHTML:"", BodyVersion:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, LastEditedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, DiscussionURL:"", HTMLURL:"", NodeID:"", Number:0, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", Reactions:github.Reactions{}}`
	if got := v.String(); got != want {
		t.Errorf("DiscussionComment.String = %v, want %v", got, want)
	}
}

func TestDraftReviewComment_String(t *testing.T) {
	t.Parallel()
	v := DraftReviewComment{
		Path:      Ptr(""),
		Position:  Ptr(0),
		Body:      Ptr(""),
		StartSide: Ptr(""),
		Side:      Ptr(""),
		StartLine: Ptr(0),
		Line:      Ptr(0),
	}
	want := `github.DraftReviewComment{Path:"", Position:0, Body:"", StartSide:"", Side:"", StartLine:0, Line:0}`
	if got := v.String(); got != want {
		t.Errorf("DraftReviewComment.String = %v, want %v", got, want)
	}
}

func TestEnterprise_String(t *testing.T) {
	t.Parallel()
	v := Enterprise{
		ID:          Ptr(0),
		Slug:        Ptr(""),
		Name:        Ptr(""),
		NodeID:      Ptr(""),
		AvatarURL:   Ptr(""),
		Description: Ptr(""),
		WebsiteURL:  Ptr(""),
		HTMLURL:     Ptr(""),
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
	}
	want := `github.Enterprise{ID:0, Slug:"", Name:"", NodeID:"", AvatarURL:"", Description:"", WebsiteURL:"", HTMLURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Enterprise.String = %v, want %v", got, want)
	}
}

func TestEvent_String(t *testing.T) {
	t.Parallel()
	v := Event{
		Type:      Ptr(""),
		Public:    Ptr(false),
		Repo:      &Repository{},
		Actor:     &User{},
		Org:       &Organization{},
		CreatedAt: &Timestamp{},
		ID:        Ptr(""),
	}
	want := `github.Event{Type:"", Public:false, Repo:github.Repository{}, Actor:github.User{}, Org:github.Organization{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, ID:""}`
	if got := v.String(); got != want {
		t.Errorf("Event.String = %v, want %v", got, want)
	}
}

func TestGPGKey_String(t *testing.T) {
	t.Parallel()
	v := GPGKey{
		ID:                Ptr(int64(0)),
		PrimaryKeyID:      Ptr(int64(0)),
		KeyID:             Ptr(""),
		RawKey:            Ptr(""),
		PublicKey:         Ptr(""),
		CanSign:           Ptr(false),
		CanEncryptComms:   Ptr(false),
		CanEncryptStorage: Ptr(false),
		CanCertify:        Ptr(false),
		CreatedAt:         &Timestamp{},
		ExpiresAt:         &Timestamp{},
	}
	want := `github.GPGKey{ID:0, PrimaryKeyID:0, KeyID:"", RawKey:"", PublicKey:"", CanSign:false, CanEncryptComms:false, CanEncryptStorage:false, CanCertify:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, ExpiresAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("GPGKey.String = %v, want %v", got, want)
	}
}

func TestGist_String(t *testing.T) {
	t.Parallel()
	v := Gist{
		ID:          Ptr(""),
		Description: Ptr(""),
		Public:      Ptr(false),
		Owner:       &User{},
		Comments:    Ptr(0),
		HTMLURL:     Ptr(""),
		GitPullURL:  Ptr(""),
		GitPushURL:  Ptr(""),
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
		NodeID:      Ptr(""),
	}
	want := `github.Gist{ID:"", Description:"", Public:false, Owner:github.User{}, Comments:0, HTMLURL:"", GitPullURL:"", GitPushURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Gist.String = %v, want %v", got, want)
	}
}

func TestGistComment_String(t *testing.T) {
	t.Parallel()
	v := GistComment{
		ID:        Ptr(int64(0)),
		URL:       Ptr(""),
		Body:      Ptr(""),
		User:      &User{},
		CreatedAt: &Timestamp{},
	}
	want := `github.GistComment{ID:0, URL:"", Body:"", User:github.User{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("GistComment.String = %v, want %v", got, want)
	}
}

func TestGistCommit_String(t *testing.T) {
	t.Parallel()
	v := GistCommit{
		URL:          Ptr(""),
		Version:      Ptr(""),
		User:         &User{},
		ChangeStatus: &CommitStats{},
		CommittedAt:  &Timestamp{},
		NodeID:       Ptr(""),
	}
	want := `github.GistCommit{URL:"", Version:"", User:github.User{}, ChangeStatus:github.CommitStats{}, CommittedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("GistCommit.String = %v, want %v", got, want)
	}
}

func TestGistFile_String(t *testing.T) {
	t.Parallel()
	v := GistFile{
		Size:     Ptr(0),
		Filename: Ptr(""),
		Language: Ptr(""),
		Type:     Ptr(""),
		RawURL:   Ptr(""),
		Content:  Ptr(""),
	}
	want := `github.GistFile{Size:0, Filename:"", Language:"", Type:"", RawURL:"", Content:""}`
	if got := v.String(); got != want {
		t.Errorf("GistFile.String = %v, want %v", got, want)
	}
}

func TestGistFork_String(t *testing.T) {
	t.Parallel()
	v := GistFork{
		URL:       Ptr(""),
		User:      &User{},
		ID:        Ptr(""),
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		NodeID:    Ptr(""),
	}
	want := `github.GistFork{URL:"", User:github.User{}, ID:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("GistFork.String = %v, want %v", got, want)
	}
}

func TestGistStats_String(t *testing.T) {
	t.Parallel()
	v := GistStats{
		TotalGists:   Ptr(0),
		PrivateGists: Ptr(0),
		PublicGists:  Ptr(0),
	}
	want := `github.GistStats{TotalGists:0, PrivateGists:0, PublicGists:0}`
	if got := v.String(); got != want {
		t.Errorf("GistStats.String = %v, want %v", got, want)
	}
}

func TestGitObject_String(t *testing.T) {
	t.Parallel()
	v := GitObject{
		Type: Ptr(""),
		SHA:  Ptr(""),
		URL:  Ptr(""),
	}
	want := `github.GitObject{Type:"", SHA:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("GitObject.String = %v, want %v", got, want)
	}
}

func TestGitignore_String(t *testing.T) {
	t.Parallel()
	v := Gitignore{
		Name:   Ptr(""),
		Source: Ptr(""),
	}
	want := `github.Gitignore{Name:"", Source:""}`
	if got := v.String(); got != want {
		t.Errorf("Gitignore.String = %v, want %v", got, want)
	}
}

func TestGrant_String(t *testing.T) {
	t.Parallel()
	v := Grant{
		ID:        Ptr(int64(0)),
		URL:       Ptr(""),
		App:       &AuthorizationApp{},
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		Scopes:    []string{""},
	}
	want := `github.Grant{ID:0, URL:"", App:github.AuthorizationApp{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Scopes:[""]}`
	if got := v.String(); got != want {
		t.Errorf("Grant.String = %v, want %v", got, want)
	}
}

func TestHeadCommit_String(t *testing.T) {
	t.Parallel()
	v := HeadCommit{
		Message:   Ptr(""),
		Author:    &CommitAuthor{},
		URL:       Ptr(""),
		Distinct:  Ptr(false),
		SHA:       Ptr(""),
		ID:        Ptr(""),
		TreeID:    Ptr(""),
		Timestamp: &Timestamp{},
		Committer: &CommitAuthor{},
		Added:     []string{""},
		Removed:   []string{""},
		Modified:  []string{""},
	}
	want := `github.HeadCommit{Message:"", Author:github.CommitAuthor{}, URL:"", Distinct:false, SHA:"", ID:"", TreeID:"", Timestamp:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Committer:github.CommitAuthor{}, Added:[""], Removed:[""], Modified:[""]}`
	if got := v.String(); got != want {
		t.Errorf("HeadCommit.String = %v, want %v", got, want)
	}
}

func TestHook_String(t *testing.T) {
	t.Parallel()
	v := Hook{
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		URL:       Ptr(""),
		ID:        Ptr(int64(0)),
		Type:      Ptr(""),
		Name:      Ptr(""),
		TestURL:   Ptr(""),
		PingURL:   Ptr(""),
		Config:    &HookConfig{},
		Events:    []string{""},
		Active:    Ptr(false),
	}
	want := `github.Hook{CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", ID:0, Type:"", Name:"", TestURL:"", PingURL:"", Config:github.HookConfig{}, Events:[""], Active:false}`
	if got := v.String(); got != want {
		t.Errorf("Hook.String = %v, want %v", got, want)
	}
}

func TestHookDelivery_String(t *testing.T) {
	t.Parallel()
	v := HookDelivery{
		ID:             Ptr(int64(0)),
		GUID:           Ptr(""),
		DeliveredAt:    &Timestamp{},
		Redelivery:     Ptr(false),
		Duration:       Ptr(0.0),
		Status:         Ptr(""),
		StatusCode:     Ptr(0),
		Event:          Ptr(""),
		Action:         Ptr(""),
		InstallationID: Ptr(int64(0)),
		RepositoryID:   Ptr(int64(0)),
		Request:        &HookRequest{},
		Response:       &HookResponse{},
	}
	want := `github.HookDelivery{ID:0, GUID:"", DeliveredAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Redelivery:false, Duration:0, Status:"", StatusCode:0, Event:"", Action:"", InstallationID:0, RepositoryID:0, Request:github.HookRequest{}, Response:github.HookResponse{}}`
	if got := v.String(); got != want {
		t.Errorf("HookDelivery.String = %v, want %v", got, want)
	}
}

func TestHookStats_String(t *testing.T) {
	t.Parallel()
	v := HookStats{
		TotalHooks:    Ptr(0),
		ActiveHooks:   Ptr(0),
		InactiveHooks: Ptr(0),
	}
	want := `github.HookStats{TotalHooks:0, ActiveHooks:0, InactiveHooks:0}`
	if got := v.String(); got != want {
		t.Errorf("HookStats.String = %v, want %v", got, want)
	}
}

func TestImport_String(t *testing.T) {
	t.Parallel()
	v := Import{
		VCSURL:          Ptr(""),
		VCS:             Ptr(""),
		VCSUsername:     Ptr(""),
		VCSPassword:     Ptr(""),
		TFVCProject:     Ptr(""),
		UseLFS:          Ptr(""),
		HasLargeFiles:   Ptr(false),
		LargeFilesSize:  Ptr(0),
		LargeFilesCount: Ptr(0),
		Status:          Ptr(""),
		CommitCount:     Ptr(0),
		StatusText:      Ptr(""),
		AuthorsCount:    Ptr(0),
		Percent:         Ptr(0),
		PushPercent:     Ptr(0),
		URL:             Ptr(""),
		HTMLURL:         Ptr(""),
		AuthorsURL:      Ptr(""),
		RepositoryURL:   Ptr(""),
		Message:         Ptr(""),
		FailedStep:      Ptr(""),
		HumanName:       Ptr(""),
	}
	want := `github.Import{VCSURL:"", VCS:"", VCSUsername:"", VCSPassword:"", TFVCProject:"", UseLFS:"", HasLargeFiles:false, LargeFilesSize:0, LargeFilesCount:0, Status:"", CommitCount:0, StatusText:"", AuthorsCount:0, Percent:0, PushPercent:0, URL:"", HTMLURL:"", AuthorsURL:"", RepositoryURL:"", Message:"", FailedStep:"", HumanName:""}`
	if got := v.String(); got != want {
		t.Errorf("Import.String = %v, want %v", got, want)
	}
}

func TestInstallation_String(t *testing.T) {
	t.Parallel()
	v := Installation{
		ID:                     Ptr(int64(0)),
		NodeID:                 Ptr(""),
		AppID:                  Ptr(int64(0)),
		AppSlug:                Ptr(""),
		TargetID:               Ptr(int64(0)),
		Account:                &User{},
		AccessTokensURL:        Ptr(""),
		RepositoriesURL:        Ptr(""),
		HTMLURL:                Ptr(""),
		TargetType:             Ptr(""),
		SingleFileName:         Ptr(""),
		RepositorySelection:    Ptr(""),
		Events:                 []string{""},
		SingleFilePaths:        []string{""},
		Permissions:            &InstallationPermissions{},
		CreatedAt:              &Timestamp{},
		UpdatedAt:              &Timestamp{},
		HasMultipleSingleFiles: Ptr(false),
		SuspendedBy:            &User{},
		SuspendedAt:            &Timestamp{},
	}
	want := `github.Installation{ID:0, NodeID:"", AppID:0, AppSlug:"", TargetID:0, Account:github.User{}, AccessTokensURL:"", RepositoriesURL:"", HTMLURL:"", TargetType:"", SingleFileName:"", RepositorySelection:"", Events:[""], SingleFilePaths:[""], Permissions:github.InstallationPermissions{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HasMultipleSingleFiles:false, SuspendedBy:github.User{}, SuspendedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Installation.String = %v, want %v", got, want)
	}
}

func TestInvitation_String(t *testing.T) {
	t.Parallel()
	v := Invitation{
		ID:                Ptr(int64(0)),
		NodeID:            Ptr(""),
		Login:             Ptr(""),
		Email:             Ptr(""),
		Role:              Ptr(""),
		CreatedAt:         &Timestamp{},
		Inviter:           &User{},
		TeamCount:         Ptr(0),
		InvitationTeamURL: Ptr(""),
		FailedAt:          &Timestamp{},
		FailedReason:      Ptr(""),
	}
	want := `github.Invitation{ID:0, NodeID:"", Login:"", Email:"", Role:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Inviter:github.User{}, TeamCount:0, InvitationTeamURL:"", FailedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, FailedReason:""}`
	if got := v.String(); got != want {
		t.Errorf("Invitation.String = %v, want %v", got, want)
	}
}

func TestIssue_String(t *testing.T) {
	t.Parallel()
	v := Issue{
		ID:                Ptr(int64(0)),
		Number:            Ptr(0),
		State:             Ptr(""),
		StateReason:       Ptr(""),
		Locked:            Ptr(false),
		Title:             Ptr(""),
		Body:              Ptr(""),
		AuthorAssociation: Ptr(""),
		User:              &User{},
		Assignee:          &User{},
		Comments:          Ptr(0),
		ClosedAt:          &Timestamp{},
		CreatedAt:         &Timestamp{},
		UpdatedAt:         &Timestamp{},
		ClosedBy:          &User{},
		URL:               Ptr(""),
		HTMLURL:           Ptr(""),
		CommentsURL:       Ptr(""),
		EventsURL:         Ptr(""),
		LabelsURL:         Ptr(""),
		RepositoryURL:     Ptr(""),
		Milestone:         &Milestone{},
		PullRequestLinks:  &PullRequestLinks{},
		Repository:        &Repository{},
		Reactions:         &Reactions{},
		NodeID:            Ptr(""),
		Draft:             Ptr(false),
		Type:              &IssueType{},
		ActiveLockReason:  Ptr(""),
	}
	want := `github.Issue{ID:0, Number:0, State:"", StateReason:"", Locked:false, Title:"", Body:"", AuthorAssociation:"", User:github.User{}, Assignee:github.User{}, Comments:0, ClosedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, ClosedBy:github.User{}, URL:"", HTMLURL:"", CommentsURL:"", EventsURL:"", LabelsURL:"", RepositoryURL:"", Milestone:github.Milestone{}, PullRequestLinks:github.PullRequestLinks{}, Repository:github.Repository{}, Reactions:github.Reactions{}, NodeID:"", Draft:false, Type:github.IssueType{}, ActiveLockReason:""}`
	if got := v.String(); got != want {
		t.Errorf("Issue.String = %v, want %v", got, want)
	}
}

func TestIssueComment_String(t *testing.T) {
	t.Parallel()
	v := IssueComment{
		ID:                Ptr(int64(0)),
		NodeID:            Ptr(""),
		Body:              Ptr(""),
		User:              &User{},
		Reactions:         &Reactions{},
		CreatedAt:         &Timestamp{},
		UpdatedAt:         &Timestamp{},
		AuthorAssociation: Ptr(""),
		URL:               Ptr(""),
		HTMLURL:           Ptr(""),
		IssueURL:          Ptr(""),
	}
	want := `github.IssueComment{ID:0, NodeID:"", Body:"", User:github.User{}, Reactions:github.Reactions{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, AuthorAssociation:"", URL:"", HTMLURL:"", IssueURL:""}`
	if got := v.String(); got != want {
		t.Errorf("IssueComment.String = %v, want %v", got, want)
	}
}

func TestIssueStats_String(t *testing.T) {
	t.Parallel()
	v := IssueStats{
		TotalIssues:  Ptr(0),
		OpenIssues:   Ptr(0),
		ClosedIssues: Ptr(0),
	}
	want := `github.IssueStats{TotalIssues:0, OpenIssues:0, ClosedIssues:0}`
	if got := v.String(); got != want {
		t.Errorf("IssueStats.String = %v, want %v", got, want)
	}
}

func TestKey_String(t *testing.T) {
	t.Parallel()
	v := Key{
		ID:        Ptr(int64(0)),
		Key:       Ptr(""),
		URL:       Ptr(""),
		Title:     Ptr(""),
		ReadOnly:  Ptr(false),
		Verified:  Ptr(false),
		CreatedAt: &Timestamp{},
		AddedBy:   Ptr(""),
		LastUsed:  &Timestamp{},
	}
	want := `github.Key{ID:0, Key:"", URL:"", Title:"", ReadOnly:false, Verified:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, AddedBy:"", LastUsed:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Key.String = %v, want %v", got, want)
	}
}

func TestLabel_String(t *testing.T) {
	t.Parallel()
	v := Label{
		ID:          Ptr(int64(0)),
		URL:         Ptr(""),
		Name:        Ptr(""),
		Color:       Ptr(""),
		Description: Ptr(""),
		Default:     Ptr(false),
		NodeID:      Ptr(""),
	}
	want := `github.Label{ID:0, URL:"", Name:"", Color:"", Description:"", Default:false, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Label.String = %v, want %v", got, want)
	}
}

func TestLabelResult_String(t *testing.T) {
	t.Parallel()
	v := LabelResult{
		ID:          Ptr(int64(0)),
		URL:         Ptr(""),
		Name:        Ptr(""),
		Color:       Ptr(""),
		Default:     Ptr(false),
		Description: Ptr(""),
		Score:       Ptr(0.0),
	}
	want := `github.LabelResult{ID:0, URL:"", Name:"", Color:"", Default:false, Description:"", Score:0}`
	if got := v.String(); got != want {
		t.Errorf("LabelResult.String = %v, want %v", got, want)
	}
}

func TestLargeFile_String(t *testing.T) {
	t.Parallel()
	v := LargeFile{
		RefName: Ptr(""),
		Path:    Ptr(""),
		OID:     Ptr(""),
		Size:    Ptr(0),
	}
	want := `github.LargeFile{RefName:"", Path:"", OID:"", Size:0}`
	if got := v.String(); got != want {
		t.Errorf("LargeFile.String = %v, want %v", got, want)
	}
}

func TestLicense_String(t *testing.T) {
	t.Parallel()
	v := License{
		Key:            Ptr(""),
		Name:           Ptr(""),
		URL:            Ptr(""),
		SPDXID:         Ptr(""),
		HTMLURL:        Ptr(""),
		Featured:       Ptr(false),
		Description:    Ptr(""),
		Implementation: Ptr(""),
		Body:           Ptr(""),
	}
	want := `github.License{Key:"", Name:"", URL:"", SPDXID:"", HTMLURL:"", Featured:false, Description:"", Implementation:"", Body:""}`
	if got := v.String(); got != want {
		t.Errorf("License.String = %v, want %v", got, want)
	}
}

func TestMembership_String(t *testing.T) {
	t.Parallel()
	v := Membership{
		URL:             Ptr(""),
		State:           Ptr(""),
		Role:            Ptr(""),
		OrganizationURL: Ptr(""),
		Organization:    &Organization{},
		User:            &User{},
	}
	want := `github.Membership{URL:"", State:"", Role:"", OrganizationURL:"", Organization:github.Organization{}, User:github.User{}}`
	if got := v.String(); got != want {
		t.Errorf("Membership.String = %v, want %v", got, want)
	}
}

func TestMigration_String(t *testing.T) {
	t.Parallel()
	v := Migration{
		ID:                 Ptr(int64(0)),
		GUID:               Ptr(""),
		State:              Ptr(""),
		LockRepositories:   Ptr(false),
		ExcludeAttachments: Ptr(false),
		URL:                Ptr(""),
		CreatedAt:          Ptr(""),
		UpdatedAt:          Ptr(""),
	}
	want := `github.Migration{ID:0, GUID:"", State:"", LockRepositories:false, ExcludeAttachments:false, URL:"", CreatedAt:"", UpdatedAt:""}`
	if got := v.String(); got != want {
		t.Errorf("Migration.String = %v, want %v", got, want)
	}
}

func TestMilestone_String(t *testing.T) {
	t.Parallel()
	v := Milestone{
		URL:          Ptr(""),
		HTMLURL:      Ptr(""),
		LabelsURL:    Ptr(""),
		ID:           Ptr(int64(0)),
		Number:       Ptr(0),
		State:        Ptr(""),
		Title:        Ptr(""),
		Description:  Ptr(""),
		Creator:      &User{},
		OpenIssues:   Ptr(0),
		ClosedIssues: Ptr(0),
		CreatedAt:    &Timestamp{},
		UpdatedAt:    &Timestamp{},
		ClosedAt:     &Timestamp{},
		DueOn:        &Timestamp{},
		NodeID:       Ptr(""),
	}
	want := `github.Milestone{URL:"", HTMLURL:"", LabelsURL:"", ID:0, Number:0, State:"", Title:"", Description:"", Creator:github.User{}, OpenIssues:0, ClosedIssues:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, ClosedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, DueOn:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Milestone.String = %v, want %v", got, want)
	}
}

func TestMilestoneStats_String(t *testing.T) {
	t.Parallel()
	v := MilestoneStats{
		TotalMilestones:  Ptr(0),
		OpenMilestones:   Ptr(0),
		ClosedMilestones: Ptr(0),
	}
	want := `github.MilestoneStats{TotalMilestones:0, OpenMilestones:0, ClosedMilestones:0}`
	if got := v.String(); got != want {
		t.Errorf("MilestoneStats.String = %v, want %v", got, want)
	}
}

func TestNewTeam_String(t *testing.T) {
	t.Parallel()
	v := NewTeam{
		Name:                "",
		Description:         Ptr(""),
		Maintainers:         []string{""},
		RepoNames:           []string{""},
		ParentTeamID:        Ptr(int64(0)),
		NotificationSetting: Ptr(""),
		Permission:          Ptr(""),
		Privacy:             Ptr(""),
		LDAPDN:              Ptr(""),
	}
	want := `github.NewTeam{Name:"", Description:"", Maintainers:[""], RepoNames:[""], ParentTeamID:0, NotificationSetting:"", Permission:"", Privacy:"", LDAPDN:""}`
	if got := v.String(); got != want {
		t.Errorf("NewTeam.String = %v, want %v", got, want)
	}
}

func TestOAuthAPP_String(t *testing.T) {
	t.Parallel()
	v := OAuthAPP{
		URL:      Ptr(""),
		Name:     Ptr(""),
		ClientID: Ptr(""),
	}
	want := `github.OAuthAPP{URL:"", Name:"", ClientID:""}`
	if got := v.String(); got != want {
		t.Errorf("OAuthAPP.String = %v, want %v", got, want)
	}
}

func TestOrgStats_String(t *testing.T) {
	t.Parallel()
	v := OrgStats{
		TotalOrgs:        Ptr(0),
		DisabledOrgs:     Ptr(0),
		TotalTeams:       Ptr(0),
		TotalTeamMembers: Ptr(0),
	}
	want := `github.OrgStats{TotalOrgs:0, DisabledOrgs:0, TotalTeams:0, TotalTeamMembers:0}`
	if got := v.String(); got != want {
		t.Errorf("OrgStats.String = %v, want %v", got, want)
	}
}

func TestOrganization_String(t *testing.T) {
	t.Parallel()
	v := Organization{
		Login:                                Ptr(""),
		ID:                                   Ptr(int64(0)),
		NodeID:                               Ptr(""),
		AvatarURL:                            Ptr(""),
		HTMLURL:                              Ptr(""),
		Name:                                 Ptr(""),
		Company:                              Ptr(""),
		Blog:                                 Ptr(""),
		Location:                             Ptr(""),
		Email:                                Ptr(""),
		TwitterUsername:                      Ptr(""),
		Description:                          Ptr(""),
		PublicRepos:                          Ptr(0),
		PublicGists:                          Ptr(0),
		Followers:                            Ptr(0),
		Following:                            Ptr(0),
		CreatedAt:                            &Timestamp{},
		UpdatedAt:                            &Timestamp{},
		TotalPrivateRepos:                    Ptr(int64(0)),
		OwnedPrivateRepos:                    Ptr(int64(0)),
		PrivateGists:                         Ptr(0),
		DiskUsage:                            Ptr(0),
		Collaborators:                        Ptr(0),
		BillingEmail:                         Ptr(""),
		Type:                                 Ptr(""),
		Plan:                                 &Plan{},
		TwoFactorRequirementEnabled:          Ptr(false),
		IsVerified:                           Ptr(false),
		HasOrganizationProjects:              Ptr(false),
		HasRepositoryProjects:                Ptr(false),
		DefaultRepoPermission:                Ptr(""),
		DefaultRepoSettings:                  Ptr(""),
		MembersCanCreateRepos:                Ptr(false),
		MembersCanCreatePublicRepos:          Ptr(false),
		MembersCanCreatePrivateRepos:         Ptr(false),
		MembersCanCreateInternalRepos:        Ptr(false),
		MembersCanForkPrivateRepos:           Ptr(false),
		MembersAllowedRepositoryCreationType: Ptr(""),
		MembersCanCreatePages:                Ptr(false),
		MembersCanCreatePublicPages:          Ptr(false),
		MembersCanCreatePrivatePages:         Ptr(false),
		WebCommitSignoffRequired:             Ptr(false),
		AdvancedSecurityEnabledForNewRepos:   Ptr(false),
		DependabotAlertsEnabledForNewRepos:   Ptr(false),
		DependabotSecurityUpdatesEnabledForNewRepos:    Ptr(false),
		DependencyGraphEnabledForNewRepos:              Ptr(false),
		SecretScanningEnabledForNewRepos:               Ptr(false),
		SecretScanningPushProtectionEnabledForNewRepos: Ptr(false),
		SecretScanningValidityChecksEnabled:            Ptr(false),
		URL:                                            Ptr(""),
		EventsURL:                                      Ptr(""),
		HooksURL:                                       Ptr(""),
		IssuesURL:                                      Ptr(""),
		MembersURL:                                     Ptr(""),
		PublicMembersURL:                               Ptr(""),
		ReposURL:                                       Ptr(""),
	}
	want := `github.Organization{Login:"", ID:0, NodeID:"", AvatarURL:"", HTMLURL:"", Name:"", Company:"", Blog:"", Location:"", Email:"", TwitterUsername:"", Description:"", PublicRepos:0, PublicGists:0, Followers:0, Following:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, TotalPrivateRepos:0, OwnedPrivateRepos:0, PrivateGists:0, DiskUsage:0, Collaborators:0, BillingEmail:"", Type:"", Plan:github.Plan{}, TwoFactorRequirementEnabled:false, IsVerified:false, HasOrganizationProjects:false, HasRepositoryProjects:false, DefaultRepoPermission:"", DefaultRepoSettings:"", MembersCanCreateRepos:false, MembersCanCreatePublicRepos:false, MembersCanCreatePrivateRepos:false, MembersCanCreateInternalRepos:false, MembersCanForkPrivateRepos:false, MembersAllowedRepositoryCreationType:"", MembersCanCreatePages:false, MembersCanCreatePublicPages:false, MembersCanCreatePrivatePages:false, WebCommitSignoffRequired:false, AdvancedSecurityEnabledForNewRepos:false, DependabotAlertsEnabledForNewRepos:false, DependabotSecurityUpdatesEnabledForNewRepos:false, DependencyGraphEnabledForNewRepos:false, SecretScanningEnabledForNewRepos:false, SecretScanningPushProtectionEnabledForNewRepos:false, SecretScanningValidityChecksEnabled:false, URL:"", EventsURL:"", HooksURL:"", IssuesURL:"", MembersURL:"", PublicMembersURL:"", ReposURL:""}`
	if got := v.String(); got != want {
		t.Errorf("Organization.String = %v, want %v", got, want)
	}
}

func TestPackage_String(t *testing.T) {
	t.Parallel()
	v := Package{
		ID:             Ptr(int64(0)),
		Name:           Ptr(""),
		PackageType:    Ptr(""),
		HTMLURL:        Ptr(""),
		Visibility:     Ptr(""),
		Owner:          &User{},
		Repository:     &Repository{},
		CreatedAt:      &Timestamp{},
		UpdatedAt:      &Timestamp{},
		Namespace:      Ptr(""),
		Description:    Ptr(""),
		Ecosystem:      Ptr(""),
		PackageVersion: &PackageVersion{},
		Registry:       &PackageRegistry{},
		URL:            Ptr(""),
		VersionCount:   Ptr(int64(0)),
	}
	want := `github.Package{ID:0, Name:"", PackageType:"", HTMLURL:"", Visibility:"", Owner:github.User{}, Repository:github.Repository{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Namespace:"", Description:"", Ecosystem:"", PackageVersion:github.PackageVersion{}, Registry:github.PackageRegistry{}, URL:"", VersionCount:0}`
	if got := v.String(); got != want {
		t.Errorf("Package.String = %v, want %v", got, want)
	}
}

func TestPackageContainerMetadata_String(t *testing.T) {
	t.Parallel()
	v := PackageContainerMetadata{
		Tags: []string{""},
	}
	want := `github.PackageContainerMetadata{Tags:[""]}`
	if got := v.String(); got != want {
		t.Errorf("PackageContainerMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageEventContainerMetadata_String(t *testing.T) {
	t.Parallel()
	v := PackageEventContainerMetadata{
		Tag: &PackageEventContainerMetadataTag{},
	}
	want := `github.PackageEventContainerMetadata{Tag:github.PackageEventContainerMetadataTag{}}`
	if got := v.String(); got != want {
		t.Errorf("PackageEventContainerMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageEventContainerMetadataTag_String(t *testing.T) {
	t.Parallel()
	v := PackageEventContainerMetadataTag{
		Name:   Ptr(""),
		Digest: Ptr(""),
	}
	want := `github.PackageEventContainerMetadataTag{Name:"", Digest:""}`
	if got := v.String(); got != want {
		t.Errorf("PackageEventContainerMetadataTag.String = %v, want %v", got, want)
	}
}

func TestPackageFile_String(t *testing.T) {
	t.Parallel()
	v := PackageFile{
		DownloadURL: Ptr(""),
		ID:          Ptr(int64(0)),
		Name:        Ptr(""),
		SHA256:      Ptr(""),
		SHA1:        Ptr(""),
		MD5:         Ptr(""),
		ContentType: Ptr(""),
		State:       Ptr(""),
		Author:      &User{},
		Size:        Ptr(int64(0)),
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
	}
	want := `github.PackageFile{DownloadURL:"", ID:0, Name:"", SHA256:"", SHA1:"", MD5:"", ContentType:"", State:"", Author:github.User{}, Size:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("PackageFile.String = %v, want %v", got, want)
	}
}

func TestPackageMetadata_String(t *testing.T) {
	t.Parallel()
	v := PackageMetadata{
		PackageType: Ptr(""),
		Container:   &PackageContainerMetadata{},
	}
	want := `github.PackageMetadata{PackageType:"", Container:github.PackageContainerMetadata{}}`
	if got := v.String(); got != want {
		t.Errorf("PackageMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageNPMMetadata_String(t *testing.T) {
	t.Parallel()
	v := PackageNPMMetadata{
		Name:                Ptr(""),
		Version:             Ptr(""),
		NPMUser:             Ptr(""),
		Description:         Ptr(""),
		GitHead:             Ptr(""),
		Homepage:            Ptr(""),
		License:             Ptr(""),
		Main:                Ptr(""),
		ID:                  Ptr(""),
		NodeVersion:         Ptr(""),
		NPMVersion:          Ptr(""),
		HasShrinkwrap:       Ptr(false),
		Maintainers:         []any{nil},
		Contributors:        []any{nil},
		Keywords:            []string{""},
		Files:               []string{""},
		OS:                  []string{""},
		CPU:                 []string{""},
		Readme:              Ptr(""),
		InstallationCommand: Ptr(""),
		ReleaseID:           Ptr(int64(0)),
		CommitOID:           Ptr(""),
		PublishedViaActions: Ptr(false),
		DeletedByID:         Ptr(int64(0)),
	}
	want := `github.PackageNPMMetadata{Name:"", Version:"", NPMUser:"", Description:"", GitHead:"", Homepage:"", License:"", Main:"", ID:"", NodeVersion:"", NPMVersion:"", HasShrinkwrap:false, Maintainers:[<nil>], Contributors:[<nil>], Keywords:[""], Files:[""], OS:[""], CPU:[""], Readme:"", InstallationCommand:"", ReleaseID:0, CommitOID:"", PublishedViaActions:false, DeletedByID:0}`
	if got := v.String(); got != want {
		t.Errorf("PackageNPMMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageNugetMetadata_String(t *testing.T) {
	t.Parallel()
	v := PackageNugetMetadata{
		Name: Ptr(""),
	}
	want := `github.PackageNugetMetadata{Name:""}`
	if got := v.String(); got != want {
		t.Errorf("PackageNugetMetadata.String = %v, want %v", got, want)
	}
}

func TestPackageRegistry_String(t *testing.T) {
	t.Parallel()
	v := PackageRegistry{
		AboutURL: Ptr(""),
		Name:     Ptr(""),
		Type:     Ptr(""),
		URL:      Ptr(""),
		Vendor:   Ptr(""),
	}
	want := `github.PackageRegistry{AboutURL:"", Name:"", Type:"", URL:"", Vendor:""}`
	if got := v.String(); got != want {
		t.Errorf("PackageRegistry.String = %v, want %v", got, want)
	}
}

func TestPackageRelease_String(t *testing.T) {
	t.Parallel()
	v := PackageRelease{
		URL:             Ptr(""),
		HTMLURL:         Ptr(""),
		ID:              Ptr(int64(0)),
		TagName:         Ptr(""),
		TargetCommitish: Ptr(""),
		Name:            Ptr(""),
		Draft:           Ptr(false),
		Author:          &User{},
		Prerelease:      Ptr(false),
		CreatedAt:       &Timestamp{},
		PublishedAt:     &Timestamp{},
	}
	want := `github.PackageRelease{URL:"", HTMLURL:"", ID:0, TagName:"", TargetCommitish:"", Name:"", Draft:false, Author:github.User{}, Prerelease:false, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PublishedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("PackageRelease.String = %v, want %v", got, want)
	}
}

func TestPackageVersion_String(t *testing.T) {
	t.Parallel()
	v := PackageVersion{
		ID:                  Ptr(int64(0)),
		Name:                Ptr(""),
		URL:                 Ptr(""),
		PackageHTMLURL:      Ptr(""),
		License:             Ptr(""),
		Description:         Ptr(""),
		CreatedAt:           &Timestamp{},
		UpdatedAt:           &Timestamp{},
		Version:             Ptr(""),
		Summary:             Ptr(""),
		BodyHTML:            Ptr(""),
		Release:             &PackageRelease{},
		Manifest:            Ptr(""),
		HTMLURL:             Ptr(""),
		TagName:             Ptr(""),
		TargetCommitish:     Ptr(""),
		TargetOID:           Ptr(""),
		Draft:               Ptr(false),
		Prerelease:          Ptr(false),
		ContainerMetadata:   &PackageEventContainerMetadata{},
		DockerMetadata:      []any{nil},
		NPMMetadata:         &PackageNPMMetadata{},
		PackageURL:          Ptr(""),
		Author:              &User{},
		SourceURL:           Ptr(""),
		InstallationCommand: Ptr(""),
		DeletedAt:           &Timestamp{},
	}
	want := `github.PackageVersion{ID:0, Name:"", URL:"", PackageHTMLURL:"", License:"", Description:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Version:"", Summary:"", BodyHTML:"", Release:github.PackageRelease{}, Manifest:"", HTMLURL:"", TagName:"", TargetCommitish:"", TargetOID:"", Draft:false, Prerelease:false, ContainerMetadata:github.PackageEventContainerMetadata{}, DockerMetadata:[<nil>], NPMMetadata:github.PackageNPMMetadata{}, PackageURL:"", Author:github.User{}, SourceURL:"", InstallationCommand:"", DeletedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("PackageVersion.String = %v, want %v", got, want)
	}
}

func TestPackageVersionBody_String(t *testing.T) {
	t.Parallel()
	v := PackageVersionBody{
		Repo: &Repository{},
		Info: &PackageVersionBodyInfo{},
	}
	want := `github.PackageVersionBody{Repo:github.Repository{}, Info:github.PackageVersionBodyInfo{}}`
	if got := v.String(); got != want {
		t.Errorf("PackageVersionBody.String = %v, want %v", got, want)
	}
}

func TestPackageVersionBodyInfo_String(t *testing.T) {
	t.Parallel()
	v := PackageVersionBodyInfo{
		Type:       Ptr(""),
		OID:        Ptr(""),
		Mode:       Ptr(int64(0)),
		Name:       Ptr(""),
		Path:       Ptr(""),
		Size:       Ptr(int64(0)),
		Collection: Ptr(false),
	}
	want := `github.PackageVersionBodyInfo{Type:"", OID:"", Mode:0, Name:"", Path:"", Size:0, Collection:false}`
	if got := v.String(); got != want {
		t.Errorf("PackageVersionBodyInfo.String = %v, want %v", got, want)
	}
}

func TestPageStats_String(t *testing.T) {
	t.Parallel()
	v := PageStats{
		TotalPages: Ptr(0),
	}
	want := `github.PageStats{TotalPages:0}`
	if got := v.String(); got != want {
		t.Errorf("PageStats.String = %v, want %v", got, want)
	}
}

func TestPlan_String(t *testing.T) {
	t.Parallel()
	v := Plan{
		Name:          Ptr(""),
		Space:         Ptr(0),
		Collaborators: Ptr(0),
		PrivateRepos:  Ptr(int64(0)),
		FilledSeats:   Ptr(0),
		Seats:         Ptr(0),
	}
	want := `github.Plan{Name:"", Space:0, Collaborators:0, PrivateRepos:0, FilledSeats:0, Seats:0}`
	if got := v.String(); got != want {
		t.Errorf("Plan.String = %v, want %v", got, want)
	}
}

func TestPreReceiveHook_String(t *testing.T) {
	t.Parallel()
	v := PreReceiveHook{
		ID:          Ptr(int64(0)),
		Name:        Ptr(""),
		Enforcement: Ptr(""),
		ConfigURL:   Ptr(""),
	}
	want := `github.PreReceiveHook{ID:0, Name:"", Enforcement:"", ConfigURL:""}`
	if got := v.String(); got != want {
		t.Errorf("PreReceiveHook.String = %v, want %v", got, want)
	}
}

func TestPullRequest_String(t *testing.T) {
	t.Parallel()
	v := PullRequest{
		ID:                  Ptr(int64(0)),
		Number:              Ptr(0),
		State:               Ptr(""),
		Locked:              Ptr(false),
		Title:               Ptr(""),
		Body:                Ptr(""),
		CreatedAt:           &Timestamp{},
		UpdatedAt:           &Timestamp{},
		ClosedAt:            &Timestamp{},
		MergedAt:            &Timestamp{},
		User:                &User{},
		Draft:               Ptr(false),
		URL:                 Ptr(""),
		HTMLURL:             Ptr(""),
		IssueURL:            Ptr(""),
		StatusesURL:         Ptr(""),
		DiffURL:             Ptr(""),
		PatchURL:            Ptr(""),
		CommitsURL:          Ptr(""),
		CommentsURL:         Ptr(""),
		ReviewCommentsURL:   Ptr(""),
		ReviewCommentURL:    Ptr(""),
		Assignee:            &User{},
		Milestone:           &Milestone{},
		AuthorAssociation:   Ptr(""),
		NodeID:              Ptr(""),
		AutoMerge:           &PullRequestAutoMerge{},
		Merged:              Ptr(false),
		Mergeable:           Ptr(false),
		MergeableState:      Ptr(""),
		Rebaseable:          Ptr(false),
		MergedBy:            &User{},
		MergeCommitSHA:      Ptr(""),
		Comments:            Ptr(0),
		Commits:             Ptr(0),
		Additions:           Ptr(0),
		Deletions:           Ptr(0),
		ChangedFiles:        Ptr(0),
		MaintainerCanModify: Ptr(false),
		ReviewComments:      Ptr(0),
		Links:               &PRLinks{},
		Head:                &PullRequestBranch{},
		Base:                &PullRequestBranch{},
		ActiveLockReason:    Ptr(""),
	}
	want := `github.PullRequest{ID:0, Number:0, State:"", Locked:false, Title:"", Body:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, ClosedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, MergedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, User:github.User{}, Draft:false, URL:"", HTMLURL:"", IssueURL:"", StatusesURL:"", DiffURL:"", PatchURL:"", CommitsURL:"", CommentsURL:"", ReviewCommentsURL:"", ReviewCommentURL:"", Assignee:github.User{}, Milestone:github.Milestone{}, AuthorAssociation:"", NodeID:"", AutoMerge:github.PullRequestAutoMerge{}, Merged:false, Mergeable:false, MergeableState:"", Rebaseable:false, MergedBy:github.User{}, MergeCommitSHA:"", Comments:0, Commits:0, Additions:0, Deletions:0, ChangedFiles:0, MaintainerCanModify:false, ReviewComments:0, Links:github.PRLinks{}, Head:github.PullRequestBranch{}, Base:github.PullRequestBranch{}, ActiveLockReason:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestComment_String(t *testing.T) {
	t.Parallel()
	v := PullRequestComment{
		ID:                  Ptr(int64(0)),
		NodeID:              Ptr(""),
		InReplyTo:           Ptr(int64(0)),
		Body:                Ptr(""),
		Path:                Ptr(""),
		DiffHunk:            Ptr(""),
		PullRequestReviewID: Ptr(int64(0)),
		Position:            Ptr(0),
		OriginalPosition:    Ptr(0),
		StartLine:           Ptr(0),
		Line:                Ptr(0),
		OriginalLine:        Ptr(0),
		OriginalStartLine:   Ptr(0),
		Side:                Ptr(""),
		StartSide:           Ptr(""),
		CommitID:            Ptr(""),
		OriginalCommitID:    Ptr(""),
		User:                &User{},
		Reactions:           &Reactions{},
		CreatedAt:           &Timestamp{},
		UpdatedAt:           &Timestamp{},
		AuthorAssociation:   Ptr(""),
		URL:                 Ptr(""),
		HTMLURL:             Ptr(""),
		PullRequestURL:      Ptr(""),
		SubjectType:         Ptr(""),
	}
	want := `github.PullRequestComment{ID:0, NodeID:"", InReplyTo:0, Body:"", Path:"", DiffHunk:"", PullRequestReviewID:0, Position:0, OriginalPosition:0, StartLine:0, Line:0, OriginalLine:0, OriginalStartLine:0, Side:"", StartSide:"", CommitID:"", OriginalCommitID:"", User:github.User{}, Reactions:github.Reactions{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, AuthorAssociation:"", URL:"", HTMLURL:"", PullRequestURL:"", SubjectType:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestComment.String = %v, want %v", got, want)
	}
}

func TestPullRequestReview_String(t *testing.T) {
	t.Parallel()
	v := PullRequestReview{
		ID:                Ptr(int64(0)),
		NodeID:            Ptr(""),
		User:              &User{},
		Body:              Ptr(""),
		SubmittedAt:       &Timestamp{},
		CommitID:          Ptr(""),
		HTMLURL:           Ptr(""),
		PullRequestURL:    Ptr(""),
		State:             Ptr(""),
		AuthorAssociation: Ptr(""),
	}
	want := `github.PullRequestReview{ID:0, NodeID:"", User:github.User{}, Body:"", SubmittedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, CommitID:"", HTMLURL:"", PullRequestURL:"", State:"", AuthorAssociation:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReview.String = %v, want %v", got, want)
	}
}

func TestPullRequestReviewDismissalRequest_String(t *testing.T) {
	t.Parallel()
	v := PullRequestReviewDismissalRequest{
		Message: Ptr(""),
	}
	want := `github.PullRequestReviewDismissalRequest{Message:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReviewDismissalRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestReviewRequest_String(t *testing.T) {
	t.Parallel()
	v := PullRequestReviewRequest{
		NodeID:   Ptr(""),
		CommitID: Ptr(""),
		Body:     Ptr(""),
		Event:    Ptr(""),
	}
	want := `github.PullRequestReviewRequest{NodeID:"", CommitID:"", Body:"", Event:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestReviewRequest.String = %v, want %v", got, want)
	}
}

func TestPullRequestThread_String(t *testing.T) {
	t.Parallel()
	v := PullRequestThread{
		ID:     Ptr(int64(0)),
		NodeID: Ptr(""),
	}
	want := `github.PullRequestThread{ID:0, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("PullRequestThread.String = %v, want %v", got, want)
	}
}

func TestPullStats_String(t *testing.T) {
	t.Parallel()
	v := PullStats{
		TotalPulls:       Ptr(0),
		MergedPulls:      Ptr(0),
		MergeablePulls:   Ptr(0),
		UnmergeablePulls: Ptr(0),
	}
	want := `github.PullStats{TotalPulls:0, MergedPulls:0, MergeablePulls:0, UnmergeablePulls:0}`
	if got := v.String(); got != want {
		t.Errorf("PullStats.String = %v, want %v", got, want)
	}
}

func TestPushEvent_String(t *testing.T) {
	t.Parallel()
	v := PushEvent{
		PushID:       Ptr(int64(0)),
		Head:         Ptr(""),
		Ref:          Ptr(""),
		Size:         Ptr(0),
		Before:       Ptr(""),
		DistinctSize: Ptr(0),
		Action:       Ptr(""),
		After:        Ptr(""),
		Created:      Ptr(false),
		Deleted:      Ptr(false),
		Forced:       Ptr(false),
		BaseRef:      Ptr(""),
		Compare:      Ptr(""),
		Repo:         &PushEventRepository{},
		HeadCommit:   &HeadCommit{},
		Pusher:       &CommitAuthor{},
		Sender:       &User{},
		Installation: &Installation{},
		Organization: &Organization{},
	}
	want := `github.PushEvent{PushID:0, Head:"", Ref:"", Size:0, Before:"", DistinctSize:0, Action:"", After:"", Created:false, Deleted:false, Forced:false, BaseRef:"", Compare:"", Repo:github.PushEventRepository{}, HeadCommit:github.HeadCommit{}, Pusher:github.CommitAuthor{}, Sender:github.User{}, Installation:github.Installation{}, Organization:github.Organization{}}`
	if got := v.String(); got != want {
		t.Errorf("PushEvent.String = %v, want %v", got, want)
	}
}

func TestRate_String(t *testing.T) {
	t.Parallel()
	v := Rate{
		Limit:     0,
		Remaining: 0,
		Used:      0,
		Reset:     Timestamp{},
		Resource:  "",
	}
	want := `github.Rate{Limit:0, Remaining:0, Used:0, Reset:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Resource:""}`
	if got := v.String(); got != want {
		t.Errorf("Rate.String = %v, want %v", got, want)
	}
}

func TestReaction_String(t *testing.T) {
	t.Parallel()
	v := Reaction{
		ID:        Ptr(int64(0)),
		User:      &User{},
		NodeID:    Ptr(""),
		Content:   Ptr(""),
		CreatedAt: &Timestamp{},
	}
	want := `github.Reaction{ID:0, User:github.User{}, NodeID:"", Content:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("Reaction.String = %v, want %v", got, want)
	}
}

func TestReference_String(t *testing.T) {
	t.Parallel()
	v := Reference{
		Ref:    Ptr(""),
		URL:    Ptr(""),
		Object: &GitObject{},
		NodeID: Ptr(""),
	}
	want := `github.Reference{Ref:"", URL:"", Object:github.GitObject{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("Reference.String = %v, want %v", got, want)
	}
}

func TestReleaseAsset_String(t *testing.T) {
	t.Parallel()
	v := ReleaseAsset{
		ID:                 Ptr(int64(0)),
		URL:                Ptr(""),
		Name:               Ptr(""),
		Label:              Ptr(""),
		State:              Ptr(""),
		ContentType:        Ptr(""),
		Size:               Ptr(0),
		DownloadCount:      Ptr(0),
		CreatedAt:          &Timestamp{},
		UpdatedAt:          &Timestamp{},
		BrowserDownloadURL: Ptr(""),
		Uploader:           &User{},
		NodeID:             Ptr(""),
	}
	want := `github.ReleaseAsset{ID:0, URL:"", Name:"", Label:"", State:"", ContentType:"", Size:0, DownloadCount:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, BrowserDownloadURL:"", Uploader:github.User{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("ReleaseAsset.String = %v, want %v", got, want)
	}
}

func TestRename_String(t *testing.T) {
	t.Parallel()
	v := Rename{
		From: Ptr(""),
		To:   Ptr(""),
	}
	want := `github.Rename{From:"", To:""}`
	if got := v.String(); got != want {
		t.Errorf("Rename.String = %v, want %v", got, want)
	}
}

func TestRepoStats_String(t *testing.T) {
	t.Parallel()
	v := RepoStats{
		TotalRepos:  Ptr(0),
		RootRepos:   Ptr(0),
		ForkRepos:   Ptr(0),
		OrgRepos:    Ptr(0),
		TotalPushes: Ptr(0),
		TotalWikis:  Ptr(0),
	}
	want := `github.RepoStats{TotalRepos:0, RootRepos:0, ForkRepos:0, OrgRepos:0, TotalPushes:0, TotalWikis:0}`
	if got := v.String(); got != want {
		t.Errorf("RepoStats.String = %v, want %v", got, want)
	}
}

func TestRepoStatus_String(t *testing.T) {
	t.Parallel()
	v := RepoStatus{
		ID:          Ptr(int64(0)),
		NodeID:      Ptr(""),
		URL:         Ptr(""),
		State:       Ptr(""),
		TargetURL:   Ptr(""),
		Description: Ptr(""),
		Context:     Ptr(""),
		AvatarURL:   Ptr(""),
		Creator:     &User{},
		CreatedAt:   &Timestamp{},
		UpdatedAt:   &Timestamp{},
	}
	want := `github.RepoStatus{ID:0, NodeID:"", URL:"", State:"", TargetURL:"", Description:"", Context:"", AvatarURL:"", Creator:github.User{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("RepoStatus.String = %v, want %v", got, want)
	}
}

func TestRepository_String(t *testing.T) {
	t.Parallel()
	v := Repository{
		ID:                        Ptr(int64(0)),
		NodeID:                    Ptr(""),
		Owner:                     &User{},
		Name:                      Ptr(""),
		FullName:                  Ptr(""),
		Description:               Ptr(""),
		Homepage:                  Ptr(""),
		CodeOfConduct:             &CodeOfConduct{},
		DefaultBranch:             Ptr(""),
		MasterBranch:              Ptr(""),
		CreatedAt:                 &Timestamp{},
		PushedAt:                  &Timestamp{},
		UpdatedAt:                 &Timestamp{},
		HTMLURL:                   Ptr(""),
		CloneURL:                  Ptr(""),
		GitURL:                    Ptr(""),
		MirrorURL:                 Ptr(""),
		SSHURL:                    Ptr(""),
		SVNURL:                    Ptr(""),
		Language:                  Ptr(""),
		Fork:                      Ptr(false),
		ForksCount:                Ptr(0),
		NetworkCount:              Ptr(0),
		OpenIssuesCount:           Ptr(0),
		OpenIssues:                Ptr(0),
		StargazersCount:           Ptr(0),
		SubscribersCount:          Ptr(0),
		WatchersCount:             Ptr(0),
		Watchers:                  Ptr(0),
		Size:                      Ptr(0),
		AutoInit:                  Ptr(false),
		Parent:                    &Repository{},
		Source:                    &Repository{},
		TemplateRepository:        &Repository{},
		Organization:              &Organization{},
		AllowRebaseMerge:          Ptr(false),
		AllowUpdateBranch:         Ptr(false),
		AllowSquashMerge:          Ptr(false),
		AllowMergeCommit:          Ptr(false),
		AllowAutoMerge:            Ptr(false),
		AllowForking:              Ptr(false),
		WebCommitSignoffRequired:  Ptr(false),
		DeleteBranchOnMerge:       Ptr(false),
		UseSquashPRTitleAsDefault: Ptr(false),
		SquashMergeCommitTitle:    Ptr(""),
		SquashMergeCommitMessage:  Ptr(""),
		MergeCommitTitle:          Ptr(""),
		MergeCommitMessage:        Ptr(""),
		Topics:                    []string{""},
		Archived:                  Ptr(false),
		Disabled:                  Ptr(false),
		License:                   &License{},
		Private:                   Ptr(false),
		HasIssues:                 Ptr(false),
		HasWiki:                   Ptr(false),
		HasPages:                  Ptr(false),
		HasProjects:               Ptr(false),
		HasDownloads:              Ptr(false),
		HasDiscussions:            Ptr(false),
		IsTemplate:                Ptr(false),
		LicenseTemplate:           Ptr(""),
		GitignoreTemplate:         Ptr(""),
		SecurityAndAnalysis:       &SecurityAndAnalysis{},
		TeamID:                    Ptr(int64(0)),
		URL:                       Ptr(""),
		ArchiveURL:                Ptr(""),
		AssigneesURL:              Ptr(""),
		BlobsURL:                  Ptr(""),
		BranchesURL:               Ptr(""),
		CollaboratorsURL:          Ptr(""),
		CommentsURL:               Ptr(""),
		CommitsURL:                Ptr(""),
		CompareURL:                Ptr(""),
		ContentsURL:               Ptr(""),
		ContributorsURL:           Ptr(""),
		DeploymentsURL:            Ptr(""),
		DownloadsURL:              Ptr(""),
		EventsURL:                 Ptr(""),
		ForksURL:                  Ptr(""),
		GitCommitsURL:             Ptr(""),
		GitRefsURL:                Ptr(""),
		GitTagsURL:                Ptr(""),
		HooksURL:                  Ptr(""),
		IssueCommentURL:           Ptr(""),
		IssueEventsURL:            Ptr(""),
		IssuesURL:                 Ptr(""),
		KeysURL:                   Ptr(""),
		LabelsURL:                 Ptr(""),
		LanguagesURL:              Ptr(""),
		MergesURL:                 Ptr(""),
		MilestonesURL:             Ptr(""),
		NotificationsURL:          Ptr(""),
		PullsURL:                  Ptr(""),
		ReleasesURL:               Ptr(""),
		StargazersURL:             Ptr(""),
		StatusesURL:               Ptr(""),
		SubscribersURL:            Ptr(""),
		SubscriptionURL:           Ptr(""),
		TagsURL:                   Ptr(""),
		TreesURL:                  Ptr(""),
		TeamsURL:                  Ptr(""),
		Visibility:                Ptr(""),
		RoleName:                  Ptr(""),
	}
	want := `github.Repository{ID:0, NodeID:"", Owner:github.User{}, Name:"", FullName:"", Description:"", Homepage:"", CodeOfConduct:github.CodeOfConduct{}, DefaultBranch:"", MasterBranch:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PushedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HTMLURL:"", CloneURL:"", GitURL:"", MirrorURL:"", SSHURL:"", SVNURL:"", Language:"", Fork:false, ForksCount:0, NetworkCount:0, OpenIssuesCount:0, OpenIssues:0, StargazersCount:0, SubscribersCount:0, WatchersCount:0, Watchers:0, Size:0, AutoInit:false, Parent:github.Repository{}, Source:github.Repository{}, TemplateRepository:github.Repository{}, Organization:github.Organization{}, AllowRebaseMerge:false, AllowUpdateBranch:false, AllowSquashMerge:false, AllowMergeCommit:false, AllowAutoMerge:false, AllowForking:false, WebCommitSignoffRequired:false, DeleteBranchOnMerge:false, UseSquashPRTitleAsDefault:false, SquashMergeCommitTitle:"", SquashMergeCommitMessage:"", MergeCommitTitle:"", MergeCommitMessage:"", Topics:[""], Archived:false, Disabled:false, License:github.License{}, Private:false, HasIssues:false, HasWiki:false, HasPages:false, HasProjects:false, HasDownloads:false, HasDiscussions:false, IsTemplate:false, LicenseTemplate:"", GitignoreTemplate:"", SecurityAndAnalysis:github.SecurityAndAnalysis{}, TeamID:0, URL:"", ArchiveURL:"", AssigneesURL:"", BlobsURL:"", BranchesURL:"", CollaboratorsURL:"", CommentsURL:"", CommitsURL:"", CompareURL:"", ContentsURL:"", ContributorsURL:"", DeploymentsURL:"", DownloadsURL:"", EventsURL:"", ForksURL:"", GitCommitsURL:"", GitRefsURL:"", GitTagsURL:"", HooksURL:"", IssueCommentURL:"", IssueEventsURL:"", IssuesURL:"", KeysURL:"", LabelsURL:"", LanguagesURL:"", MergesURL:"", MilestonesURL:"", NotificationsURL:"", PullsURL:"", ReleasesURL:"", StargazersURL:"", StatusesURL:"", SubscribersURL:"", SubscriptionURL:"", TagsURL:"", TreesURL:"", TeamsURL:"", Visibility:"", RoleName:""}`
	if got := v.String(); got != want {
		t.Errorf("Repository.String = %v, want %v", got, want)
	}
}

func TestRepositoryComment_String(t *testing.T) {
	t.Parallel()
	v := RepositoryComment{
		HTMLURL:   Ptr(""),
		URL:       Ptr(""),
		ID:        Ptr(int64(0)),
		NodeID:    Ptr(""),
		CommitID:  Ptr(""),
		User:      &User{},
		Reactions: &Reactions{},
		CreatedAt: &Timestamp{},
		UpdatedAt: &Timestamp{},
		Body:      Ptr(""),
		Path:      Ptr(""),
		Position:  Ptr(0),
	}
	want := `github.RepositoryComment{HTMLURL:"", URL:"", ID:0, NodeID:"", CommitID:"", User:github.User{}, Reactions:github.Reactions{}, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Body:"", Path:"", Position:0}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryComment.String = %v, want %v", got, want)
	}
}

func TestRepositoryCommit_String(t *testing.T) {
	t.Parallel()
	v := RepositoryCommit{
		NodeID:      Ptr(""),
		SHA:         Ptr(""),
		Commit:      &Commit{},
		Author:      &User{},
		Committer:   &User{},
		HTMLURL:     Ptr(""),
		URL:         Ptr(""),
		CommentsURL: Ptr(""),
		Stats:       &CommitStats{},
	}
	want := `github.RepositoryCommit{NodeID:"", SHA:"", Commit:github.Commit{}, Author:github.User{}, Committer:github.User{}, HTMLURL:"", URL:"", CommentsURL:"", Stats:github.CommitStats{}}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryCommit.String = %v, want %v", got, want)
	}
}

func TestRepositoryContent_String(t *testing.T) {
	t.Parallel()
	v := RepositoryContent{
		Type:            Ptr(""),
		Target:          Ptr(""),
		Encoding:        Ptr(""),
		Size:            Ptr(0),
		Name:            Ptr(""),
		Path:            Ptr(""),
		Content:         Ptr(""),
		SHA:             Ptr(""),
		URL:             Ptr(""),
		GitURL:          Ptr(""),
		HTMLURL:         Ptr(""),
		DownloadURL:     Ptr(""),
		SubmoduleGitURL: Ptr(""),
	}
	want := `github.RepositoryContent{Type:"", Target:"", Encoding:"", Size:0, Name:"", Path:"", Content:"", SHA:"", URL:"", GitURL:"", HTMLURL:"", DownloadURL:"", SubmoduleGitURL:""}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryContent.String = %v, want %v", got, want)
	}
}

func TestRepositoryLicense_String(t *testing.T) {
	t.Parallel()
	v := RepositoryLicense{
		Name:        Ptr(""),
		Path:        Ptr(""),
		SHA:         Ptr(""),
		Size:        Ptr(0),
		URL:         Ptr(""),
		HTMLURL:     Ptr(""),
		GitURL:      Ptr(""),
		DownloadURL: Ptr(""),
		Type:        Ptr(""),
		Content:     Ptr(""),
		Encoding:    Ptr(""),
		License:     &License{},
	}
	want := `github.RepositoryLicense{Name:"", Path:"", SHA:"", Size:0, URL:"", HTMLURL:"", GitURL:"", DownloadURL:"", Type:"", Content:"", Encoding:"", License:github.License{}}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryLicense.String = %v, want %v", got, want)
	}
}

func TestRepositoryParticipation_String(t *testing.T) {
	t.Parallel()
	v := RepositoryParticipation{
		All:   []int{0},
		Owner: []int{0},
	}
	want := `github.RepositoryParticipation{All:[0], Owner:[0]}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryParticipation.String = %v, want %v", got, want)
	}
}

func TestRepositoryRelease_String(t *testing.T) {
	t.Parallel()
	v := RepositoryRelease{
		TagName:                Ptr(""),
		TargetCommitish:        Ptr(""),
		Name:                   Ptr(""),
		Body:                   Ptr(""),
		Draft:                  Ptr(false),
		Prerelease:             Ptr(false),
		MakeLatest:             Ptr(""),
		DiscussionCategoryName: Ptr(""),
		GenerateReleaseNotes:   Ptr(false),
		ID:                     Ptr(int64(0)),
		CreatedAt:              &Timestamp{},
		PublishedAt:            &Timestamp{},
		URL:                    Ptr(""),
		HTMLURL:                Ptr(""),
		AssetsURL:              Ptr(""),
		UploadURL:              Ptr(""),
		ZipballURL:             Ptr(""),
		TarballURL:             Ptr(""),
		Author:                 &User{},
		NodeID:                 Ptr(""),
	}
	want := `github.RepositoryRelease{TagName:"", TargetCommitish:"", Name:"", Body:"", Draft:false, Prerelease:false, MakeLatest:"", DiscussionCategoryName:"", GenerateReleaseNotes:false, ID:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, PublishedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", HTMLURL:"", AssetsURL:"", UploadURL:"", ZipballURL:"", TarballURL:"", Author:github.User{}, NodeID:""}`
	if got := v.String(); got != want {
		t.Errorf("RepositoryRelease.String = %v, want %v", got, want)
	}
}

func TestSBOM_String(t *testing.T) {
	t.Parallel()
	v := SBOM{
		SBOM: &SBOMInfo{},
	}
	want := `github.SBOM{SBOM:github.SBOMInfo{}}`
	if got := v.String(); got != want {
		t.Errorf("SBOM.String = %v, want %v", got, want)
	}
}

func TestSSHSigningKey_String(t *testing.T) {
	t.Parallel()
	v := SSHSigningKey{
		ID:        Ptr(int64(0)),
		Key:       Ptr(""),
		Title:     Ptr(""),
		CreatedAt: &Timestamp{},
	}
	want := `github.SSHSigningKey{ID:0, Key:"", Title:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("SSHSigningKey.String = %v, want %v", got, want)
	}
}

func TestSecretScanning_String(t *testing.T) {
	t.Parallel()
	v := SecretScanning{
		Status: Ptr(""),
	}
	want := `github.SecretScanning{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("SecretScanning.String = %v, want %v", got, want)
	}
}

func TestSecretScanningPushProtection_String(t *testing.T) {
	t.Parallel()
	v := SecretScanningPushProtection{
		Status: Ptr(""),
	}
	want := `github.SecretScanningPushProtection{Status:""}`
	if got := v.String(); got != want {
		t.Errorf("SecretScanningPushProtection.String = %v, want %v", got, want)
	}
}

func TestSecurityAndAnalysis_String(t *testing.T) {
	t.Parallel()
	v := SecurityAndAnalysis{
		AdvancedSecurity:             &AdvancedSecurity{},
		SecretScanning:               &SecretScanning{},
		SecretScanningPushProtection: &SecretScanningPushProtection{},
		DependabotSecurityUpdates:    &DependabotSecurityUpdates{},
		SecretScanningValidityChecks: &SecretScanningValidityChecks{},
	}
	want := `github.SecurityAndAnalysis{AdvancedSecurity:github.AdvancedSecurity{}, SecretScanning:github.SecretScanning{}, SecretScanningPushProtection:github.SecretScanningPushProtection{}, DependabotSecurityUpdates:github.DependabotSecurityUpdates{}, SecretScanningValidityChecks:github.SecretScanningValidityChecks{}}`
	if got := v.String(); got != want {
		t.Errorf("SecurityAndAnalysis.String = %v, want %v", got, want)
	}
}

func TestSourceImportAuthor_String(t *testing.T) {
	t.Parallel()
	v := SourceImportAuthor{
		ID:         Ptr(int64(0)),
		RemoteID:   Ptr(""),
		RemoteName: Ptr(""),
		Email:      Ptr(""),
		Name:       Ptr(""),
		URL:        Ptr(""),
		ImportURL:  Ptr(""),
	}
	want := `github.SourceImportAuthor{ID:0, RemoteID:"", RemoteName:"", Email:"", Name:"", URL:"", ImportURL:""}`
	if got := v.String(); got != want {
		t.Errorf("SourceImportAuthor.String = %v, want %v", got, want)
	}
}

func TestTeam_String(t *testing.T) {
	t.Parallel()
	v := Team{
		ID:                  Ptr(int64(0)),
		NodeID:              Ptr(""),
		Name:                Ptr(""),
		Description:         Ptr(""),
		URL:                 Ptr(""),
		Slug:                Ptr(""),
		Permission:          Ptr(""),
		Privacy:             Ptr(""),
		NotificationSetting: Ptr(""),
		MembersCount:        Ptr(0),
		ReposCount:          Ptr(0),
		Organization:        &Organization{},
		HTMLURL:             Ptr(""),
		MembersURL:          Ptr(""),
		RepositoriesURL:     Ptr(""),
		Parent:              &Team{},
		LDAPDN:              Ptr(""),
		Assignment:          Ptr(""),
	}
	want := `github.Team{ID:0, NodeID:"", Name:"", Description:"", URL:"", Slug:"", Permission:"", Privacy:"", NotificationSetting:"", MembersCount:0, ReposCount:0, Organization:github.Organization{}, HTMLURL:"", MembersURL:"", RepositoriesURL:"", Parent:github.Team{}, LDAPDN:"", Assignment:""}`
	if got := v.String(); got != want {
		t.Errorf("Team.String = %v, want %v", got, want)
	}
}

func TestTeamDiscussion_String(t *testing.T) {
	t.Parallel()
	v := TeamDiscussion{
		Author:        &User{},
		Body:          Ptr(""),
		BodyHTML:      Ptr(""),
		BodyVersion:   Ptr(""),
		CommentsCount: Ptr(0),
		CommentsURL:   Ptr(""),
		CreatedAt:     &Timestamp{},
		LastEditedAt:  &Timestamp{},
		HTMLURL:       Ptr(""),
		NodeID:        Ptr(""),
		Number:        Ptr(0),
		Pinned:        Ptr(false),
		Private:       Ptr(false),
		TeamURL:       Ptr(""),
		Title:         Ptr(""),
		UpdatedAt:     &Timestamp{},
		URL:           Ptr(""),
		Reactions:     &Reactions{},
	}
	want := `github.TeamDiscussion{Author:github.User{}, Body:"", BodyHTML:"", BodyVersion:"", CommentsCount:0, CommentsURL:"", CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, LastEditedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, HTMLURL:"", NodeID:"", Number:0, Pinned:false, Private:false, TeamURL:"", Title:"", UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, URL:"", Reactions:github.Reactions{}}`
	if got := v.String(); got != want {
		t.Errorf("TeamDiscussion.String = %v, want %v", got, want)
	}
}

func TestTeamLDAPMapping_String(t *testing.T) {
	t.Parallel()
	v := TeamLDAPMapping{
		ID:              Ptr(int64(0)),
		LDAPDN:          Ptr(""),
		URL:             Ptr(""),
		Name:            Ptr(""),
		Slug:            Ptr(""),
		Description:     Ptr(""),
		Privacy:         Ptr(""),
		Permission:      Ptr(""),
		MembersURL:      Ptr(""),
		RepositoriesURL: Ptr(""),
	}
	want := `github.TeamLDAPMapping{ID:0, LDAPDN:"", URL:"", Name:"", Slug:"", Description:"", Privacy:"", Permission:"", MembersURL:"", RepositoriesURL:""}`
	if got := v.String(); got != want {
		t.Errorf("TeamLDAPMapping.String = %v, want %v", got, want)
	}
}

func TestTextMatch_String(t *testing.T) {
	t.Parallel()
	v := TextMatch{
		ObjectURL:  Ptr(""),
		ObjectType: Ptr(""),
		Property:   Ptr(""),
		Fragment:   Ptr(""),
	}
	want := `github.TextMatch{ObjectURL:"", ObjectType:"", Property:"", Fragment:""}`
	if got := v.String(); got != want {
		t.Errorf("TextMatch.String = %v, want %v", got, want)
	}
}

func TestTree_String(t *testing.T) {
	t.Parallel()
	v := Tree{
		SHA:       Ptr(""),
		Truncated: Ptr(false),
	}
	want := `github.Tree{SHA:"", Truncated:false}`
	if got := v.String(); got != want {
		t.Errorf("Tree.String = %v, want %v", got, want)
	}
}

func TestTreeEntry_String(t *testing.T) {
	t.Parallel()
	v := TreeEntry{
		SHA:     Ptr(""),
		Path:    Ptr(""),
		Mode:    Ptr(""),
		Type:    Ptr(""),
		Size:    Ptr(0),
		Content: Ptr(""),
		URL:     Ptr(""),
	}
	want := `github.TreeEntry{SHA:"", Path:"", Mode:"", Type:"", Size:0, Content:"", URL:""}`
	if got := v.String(); got != want {
		t.Errorf("TreeEntry.String = %v, want %v", got, want)
	}
}

func TestUser_String(t *testing.T) {
	t.Parallel()
	v := User{
		Login:                   Ptr(""),
		ID:                      Ptr(int64(0)),
		NodeID:                  Ptr(""),
		AvatarURL:               Ptr(""),
		HTMLURL:                 Ptr(""),
		GravatarID:              Ptr(""),
		Name:                    Ptr(""),
		Company:                 Ptr(""),
		Blog:                    Ptr(""),
		Location:                Ptr(""),
		Email:                   Ptr(""),
		Hireable:                Ptr(false),
		Bio:                     Ptr(""),
		TwitterUsername:         Ptr(""),
		PublicRepos:             Ptr(0),
		PublicGists:             Ptr(0),
		Followers:               Ptr(0),
		Following:               Ptr(0),
		CreatedAt:               &Timestamp{},
		UpdatedAt:               &Timestamp{},
		SuspendedAt:             &Timestamp{},
		Type:                    Ptr(""),
		SiteAdmin:               Ptr(false),
		TotalPrivateRepos:       Ptr(int64(0)),
		OwnedPrivateRepos:       Ptr(int64(0)),
		PrivateGists:            Ptr(0),
		DiskUsage:               Ptr(0),
		Collaborators:           Ptr(0),
		TwoFactorAuthentication: Ptr(false),
		Plan:                    &Plan{},
		LdapDn:                  Ptr(""),
		URL:                     Ptr(""),
		EventsURL:               Ptr(""),
		FollowingURL:            Ptr(""),
		FollowersURL:            Ptr(""),
		GistsURL:                Ptr(""),
		OrganizationsURL:        Ptr(""),
		ReceivedEventsURL:       Ptr(""),
		ReposURL:                Ptr(""),
		StarredURL:              Ptr(""),
		SubscriptionsURL:        Ptr(""),
		RoleName:                Ptr(""),
		Assignment:              Ptr(""),
	}
	want := `github.User{Login:"", ID:0, NodeID:"", AvatarURL:"", HTMLURL:"", GravatarID:"", Name:"", Company:"", Blog:"", Location:"", Email:"", Hireable:false, Bio:"", TwitterUsername:"", PublicRepos:0, PublicGists:0, Followers:0, Following:0, CreatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, UpdatedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, SuspendedAt:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Type:"", SiteAdmin:false, TotalPrivateRepos:0, OwnedPrivateRepos:0, PrivateGists:0, DiskUsage:0, Collaborators:0, TwoFactorAuthentication:false, Plan:github.Plan{}, LdapDn:"", URL:"", EventsURL:"", FollowingURL:"", FollowersURL:"", GistsURL:"", OrganizationsURL:"", ReceivedEventsURL:"", ReposURL:"", StarredURL:"", SubscriptionsURL:"", RoleName:"", Assignment:""}`
	if got := v.String(); got != want {
		t.Errorf("User.String = %v, want %v", got, want)
	}
}

func TestUserLDAPMapping_String(t *testing.T) {
	t.Parallel()
	v := UserLDAPMapping{
		ID:                Ptr(int64(0)),
		LDAPDN:            Ptr(""),
		Login:             Ptr(""),
		AvatarURL:         Ptr(""),
		GravatarID:        Ptr(""),
		Type:              Ptr(""),
		SiteAdmin:         Ptr(false),
		URL:               Ptr(""),
		EventsURL:         Ptr(""),
		FollowingURL:      Ptr(""),
		FollowersURL:      Ptr(""),
		GistsURL:          Ptr(""),
		OrganizationsURL:  Ptr(""),
		ReceivedEventsURL: Ptr(""),
		ReposURL:          Ptr(""),
		StarredURL:        Ptr(""),
		SubscriptionsURL:  Ptr(""),
	}
	want := `github.UserLDAPMapping{ID:0, LDAPDN:"", Login:"", AvatarURL:"", GravatarID:"", Type:"", SiteAdmin:false, URL:"", EventsURL:"", FollowingURL:"", FollowersURL:"", GistsURL:"", OrganizationsURL:"", ReceivedEventsURL:"", ReposURL:"", StarredURL:"", SubscriptionsURL:""}`
	if got := v.String(); got != want {
		t.Errorf("UserLDAPMapping.String = %v, want %v", got, want)
	}
}

func TestUserMigration_String(t *testing.T) {
	t.Parallel()
	v := UserMigration{
		ID:                 Ptr(int64(0)),
		GUID:               Ptr(""),
		State:              Ptr(""),
		LockRepositories:   Ptr(false),
		ExcludeAttachments: Ptr(false),
		URL:                Ptr(""),
		CreatedAt:          Ptr(""),
		UpdatedAt:          Ptr(""),
	}
	want := `github.UserMigration{ID:0, GUID:"", State:"", LockRepositories:false, ExcludeAttachments:false, URL:"", CreatedAt:"", UpdatedAt:""}`
	if got := v.String(); got != want {
		t.Errorf("UserMigration.String = %v, want %v", got, want)
	}
}

func TestUserStats_String(t *testing.T) {
	t.Parallel()
	v := UserStats{
		TotalUsers:     Ptr(0),
		AdminUsers:     Ptr(0),
		SuspendedUsers: Ptr(0),
	}
	want := `github.UserStats{TotalUsers:0, AdminUsers:0, SuspendedUsers:0}`
	if got := v.String(); got != want {
		t.Errorf("UserStats.String = %v, want %v", got, want)
	}
}

func TestWeeklyCommitActivity_String(t *testing.T) {
	t.Parallel()
	v := WeeklyCommitActivity{
		Days:  []int{0},
		Total: Ptr(0),
		Week:  &Timestamp{},
	}
	want := `github.WeeklyCommitActivity{Days:[0], Total:0, Week:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}}`
	if got := v.String(); got != want {
		t.Errorf("WeeklyCommitActivity.String = %v, want %v", got, want)
	}
}

func TestWeeklyStats_String(t *testing.T) {
	t.Parallel()
	v := WeeklyStats{
		Week:      &Timestamp{},
		Additions: Ptr(0),
		Deletions: Ptr(0),
		Commits:   Ptr(0),
	}
	want := `github.WeeklyStats{Week:github.Timestamp{0001-01-01 00:00:00 +0000 UTC}, Additions:0, Deletions:0, Commits:0}`
	if got := v.String(); got != want {
		t.Errorf("WeeklyStats.String = %v, want %v", got, want)
	}
}
