// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package orgpolicy provides access to the Organization Policy API.
//
// For product documentation, see: https://cloud.google.com/orgpolicy/docs/reference/rest/index.html
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/orgpolicy/v2"
//	...
//	ctx := context.Background()
//	orgpolicyService, err := orgpolicy.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	orgpolicyService, err := orgpolicy.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	orgpolicyService, err := orgpolicy.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package orgpolicy // import "google.golang.org/api/orgpolicy/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "orgpolicy:v2"
const apiName = "orgpolicy"
const apiVersion = "v2"
const basePath = "https://orgpolicy.googleapis.com/"
const basePathTemplate = "https://orgpolicy.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://orgpolicy.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Constraints = NewFoldersConstraintsService(s)
	rs.Policies = NewFoldersPoliciesService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Constraints *FoldersConstraintsService

	Policies *FoldersPoliciesService
}

func NewFoldersConstraintsService(s *Service) *FoldersConstraintsService {
	rs := &FoldersConstraintsService{s: s}
	return rs
}

type FoldersConstraintsService struct {
	s *Service
}

func NewFoldersPoliciesService(s *Service) *FoldersPoliciesService {
	rs := &FoldersPoliciesService{s: s}
	return rs
}

type FoldersPoliciesService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Constraints = NewOrganizationsConstraintsService(s)
	rs.CustomConstraints = NewOrganizationsCustomConstraintsService(s)
	rs.Policies = NewOrganizationsPoliciesService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Constraints *OrganizationsConstraintsService

	CustomConstraints *OrganizationsCustomConstraintsService

	Policies *OrganizationsPoliciesService
}

func NewOrganizationsConstraintsService(s *Service) *OrganizationsConstraintsService {
	rs := &OrganizationsConstraintsService{s: s}
	return rs
}

type OrganizationsConstraintsService struct {
	s *Service
}

func NewOrganizationsCustomConstraintsService(s *Service) *OrganizationsCustomConstraintsService {
	rs := &OrganizationsCustomConstraintsService{s: s}
	return rs
}

type OrganizationsCustomConstraintsService struct {
	s *Service
}

func NewOrganizationsPoliciesService(s *Service) *OrganizationsPoliciesService {
	rs := &OrganizationsPoliciesService{s: s}
	return rs
}

type OrganizationsPoliciesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Constraints = NewProjectsConstraintsService(s)
	rs.Policies = NewProjectsPoliciesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Constraints *ProjectsConstraintsService

	Policies *ProjectsPoliciesService
}

func NewProjectsConstraintsService(s *Service) *ProjectsConstraintsService {
	rs := &ProjectsConstraintsService{s: s}
	return rs
}

type ProjectsConstraintsService struct {
	s *Service
}

func NewProjectsPoliciesService(s *Service) *ProjectsPoliciesService {
	rs := &ProjectsPoliciesService{s: s}
	return rs
}

type ProjectsPoliciesService struct {
	s *Service
}

// GoogleCloudOrgpolicyV2AlternatePolicySpec: Similar to PolicySpec but with an
// extra 'launch' field for launch reference. The PolicySpec here is specific
// for dry-run/darklaunch.
type GoogleCloudOrgpolicyV2AlternatePolicySpec struct {
	// Launch: Reference to the launch that will be used while audit logging and to
	// control the launch. Should be set only in the alternate policy.
	Launch string `json:"launch,omitempty"`
	// Spec: Specify constraint for configurations of Google Cloud resources.
	Spec *GoogleCloudOrgpolicyV2PolicySpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Launch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Launch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2AlternatePolicySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2AlternatePolicySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2Constraint: A constraint describes a way to restrict
// resource's configuration. For example, you could enforce a constraint that
// controls which Google Cloud services can be activated across an
// organization, or whether a Compute Engine instance can have serial port
// connections established. Constraints can be configured by the organization
// policy administrator to fit the needs of the organization by setting a
// policy that includes constraints at different locations in the
// organization's resource hierarchy. Policies are inherited down the resource
// hierarchy from higher levels, but can also be overridden. For details about
// the inheritance rules please read about `policies`. Constraints have a
// default behavior determined by the `constraint_default` field, which is the
// enforcement behavior that is used in the absence of a policy being defined
// or inherited for the resource in question.
type GoogleCloudOrgpolicyV2Constraint struct {
	// BooleanConstraint: Defines this constraint as being a BooleanConstraint.
	BooleanConstraint *GoogleCloudOrgpolicyV2ConstraintBooleanConstraint `json:"booleanConstraint,omitempty"`
	// ConstraintDefault: The evaluation behavior of this constraint in the absence
	// of a policy.
	//
	// Possible values:
	//   "CONSTRAINT_DEFAULT_UNSPECIFIED" - This is only used for distinguishing
	// unset values and should never be used.
	//   "ALLOW" - Indicate that all values are allowed for list constraints.
	// Indicate that enforcement is off for boolean constraints.
	//   "DENY" - Indicate that all values are denied for list constraints.
	// Indicate that enforcement is on for boolean constraints.
	ConstraintDefault string `json:"constraintDefault,omitempty"`
	// Description: Detailed description of what this constraint controls as well
	// as how and where it is enforced. Mutable.
	Description string `json:"description,omitempty"`
	// DisplayName: The human readable name. Mutable.
	DisplayName string `json:"displayName,omitempty"`
	// ListConstraint: Defines this constraint as being a ListConstraint.
	ListConstraint *GoogleCloudOrgpolicyV2ConstraintListConstraint `json:"listConstraint,omitempty"`
	// Name: Immutable. The resource name of the constraint. Must be in one of the
	// following forms: * `projects/{project_number}/constraints/{constraint_name}`
	// * `folders/{folder_id}/constraints/{constraint_name}` *
	// `organizations/{organization_id}/constraints/{constraint_name}` For example,
	// "/projects/123/constraints/compute.disableSerialPortAccess".
	Name string `json:"name,omitempty"`
	// SupportsDryRun: Shows if dry run is supported for this constraint or not.
	SupportsDryRun bool `json:"supportsDryRun,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BooleanConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BooleanConstraint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2Constraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2Constraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2ConstraintBooleanConstraint: A constraint that is
// either enforced or not. For example, a constraint
// `constraints/compute.disableSerialPortAccess`. If it is enforced on a VM
// instance, serial port connections will not be opened to that instance.
type GoogleCloudOrgpolicyV2ConstraintBooleanConstraint struct {
}

// GoogleCloudOrgpolicyV2ConstraintListConstraint: A constraint that allows or
// disallows a list of string values, which are configured by an Organization
// Policy administrator with a policy.
type GoogleCloudOrgpolicyV2ConstraintListConstraint struct {
	// SupportsIn: Indicates whether values grouped into categories can be used in
	// `Policy.allowed_values` and `Policy.denied_values`. For example,
	// "in:Python" would match any value in the 'Python' group.
	SupportsIn bool `json:"supportsIn,omitempty"`
	// SupportsUnder: Indicates whether subtrees of the Resource Manager resource
	// hierarchy can be used in `Policy.allowed_values` and `Policy.denied_values`.
	// For example, "under:folders/123" would match any resource under the
	// 'folders/123' folder.
	SupportsUnder bool `json:"supportsUnder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SupportsIn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SupportsIn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2ConstraintListConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2ConstraintListConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2CustomConstraint: A custom constraint defined by
// customers which can *only* be applied to the given resource types and
// organization. By creating a custom constraint, customers can apply policies
// of this custom constraint. *Creating a custom constraint itself does NOT
// apply any policy enforcement*.
type GoogleCloudOrgpolicyV2CustomConstraint struct {
	// ActionType: Allow or deny type.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Unspecified. Results in an error.
	//   "ALLOW" - Allowed action type.
	//   "DENY" - Deny action type.
	ActionType string `json:"actionType,omitempty"`
	// Condition: Org policy condition/expression. For example:
	// `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
	// `resource.management.auto_upgrade == true` The max length of the condition
	// is 1000 characters.
	Condition string `json:"condition,omitempty"`
	// Description: Detailed information about this custom policy constraint. The
	// max length of the description is 2000 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: One line display name for the UI. The max length of the
	// display_name is 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// MethodTypes: All the operations being applied for this constraint.
	//
	// Possible values:
	//   "METHOD_TYPE_UNSPECIFIED" - Unspecified. Results in an error.
	//   "CREATE" - Constraint applied when creating the resource.
	//   "UPDATE" - Constraint applied when updating the resource.
	//   "DELETE" - Constraint applied when deleting the resource. Not supported
	// yet.
	//   "REMOVE_GRANT" - Constraint applied when removing an IAM grant.
	//   "GOVERN_TAGS" - Constraint applied when enforcing forced tagging.
	MethodTypes []string `json:"methodTypes,omitempty"`
	// Name: Immutable. Name of the constraint. This is unique within the
	// organization. Format of the name should be *
	// `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	// Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
	// The max length is 70 characters and the minimum length is 1. Note that the
	// prefix `organizations/{organization_id}/customConstraints/` is not counted.
	Name string `json:"name,omitempty"`
	// ResourceTypes: Immutable. The resource instance type on which this policy
	// applies. Format will be of the form : `/` Example: *
	// `compute.googleapis.com/Instance`.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// UpdateTime: Output only. The last time this custom constraint was updated.
	// This represents the last time that the `CreateCustomConstraint` or
	// `UpdateCustomConstraint` RPC was called
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2CustomConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2CustomConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2ListConstraintsResponse: The response returned from
// the ListConstraints method.
type GoogleCloudOrgpolicyV2ListConstraintsResponse struct {
	// Constraints: The collection of constraints that are available on the
	// targeted resource.
	Constraints []*GoogleCloudOrgpolicyV2Constraint `json:"constraints,omitempty"`
	// NextPageToken: Page token used to retrieve the next page. This is currently
	// not used.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Constraints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Constraints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2ListConstraintsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2ListConstraintsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2ListCustomConstraintsResponse: The response returned
// from the ListCustomConstraints method. It will be empty if no custom
// constraints are set on the organization resource.
type GoogleCloudOrgpolicyV2ListCustomConstraintsResponse struct {
	// CustomConstraints: All custom constraints that exist on the organization
	// resource. It will be empty if no custom constraints are set.
	CustomConstraints []*GoogleCloudOrgpolicyV2CustomConstraint `json:"customConstraints,omitempty"`
	// NextPageToken: Page token used to retrieve the next page. This is currently
	// not used, but the server may at any point start supplying a valid token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraints") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2ListCustomConstraintsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2ListCustomConstraintsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2ListPoliciesResponse: The response returned from the
// ListPolicies method. It will be empty if no policies are set on the
// resource.
type GoogleCloudOrgpolicyV2ListPoliciesResponse struct {
	// NextPageToken: Page token used to retrieve the next page. This is currently
	// not used, but the server may at any point start supplying a valid token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Policies: All policies that exist on the resource. It will be empty if no
	// policies are set.
	Policies []*GoogleCloudOrgpolicyV2Policy `json:"policies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2ListPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2ListPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2Policy: Defines an organization policy which is used
// to specify constraints for configurations of Google Cloud resources.
type GoogleCloudOrgpolicyV2Policy struct {
	// Alternate: Deprecated.
	Alternate *GoogleCloudOrgpolicyV2AlternatePolicySpec `json:"alternate,omitempty"`
	// DryRunSpec: Dry-run policy. Audit-only policy, can be used to monitor how
	// the policy would have impacted the existing and future resources if it's
	// enforced.
	DryRunSpec *GoogleCloudOrgpolicyV2PolicySpec `json:"dryRunSpec,omitempty"`
	// Etag: Optional. An opaque tag indicating the current state of the policy,
	// used for concurrency control. This 'etag' is computed by the server based on
	// the value of other fields, and may be sent on update and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Name: Immutable. The resource name of the policy. Must be one of the
	// following forms, where `constraint_name` is the name of the constraint which
	// this policy configures: *
	// `projects/{project_number}/policies/{constraint_name}` *
	// `folders/{folder_id}/policies/{constraint_name}` *
	// `organizations/{organization_id}/policies/{constraint_name}` For example,
	// `projects/123/policies/compute.disableSerialPortAccess`. Note:
	// `projects/{project_id}/policies/{constraint_name}` is also an acceptable
	// name for API requests, but responses will return the name using the
	// equivalent project number.
	Name string `json:"name,omitempty"`
	// Spec: Basic information about the Organization Policy.
	Spec *GoogleCloudOrgpolicyV2PolicySpec `json:"spec,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Alternate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alternate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpec: Defines a Google Cloud policy
// specification which is used to specify constraints for configurations of
// Google Cloud resources.
type GoogleCloudOrgpolicyV2PolicySpec struct {
	// Etag: An opaque tag indicating the current version of the policySpec, used
	// for concurrency control. This field is ignored if used in a `CreatePolicy`
	// request. When the policy is returned from either a `GetPolicy` or a
	// `ListPolicies` request, this `etag` indicates the version of the current
	// policySpec to use when executing a read-modify-write loop. When the policy
	// is returned from a `GetEffectivePolicy` request, the `etag` will be unset.
	Etag string `json:"etag,omitempty"`
	// InheritFromParent: Determines the inheritance behavior for this policy. If
	// `inherit_from_parent` is true, policy rules set higher up in the hierarchy
	// (up to the closest root) are inherited and present in the effective policy.
	// If it is false, then no rules are inherited, and this policy becomes the new
	// root for evaluation. This field can be set only for policies which configure
	// list constraints.
	InheritFromParent bool `json:"inheritFromParent,omitempty"`
	// Reset: Ignores policies set above this resource and restores the
	// `constraint_default` enforcement behavior of the specific constraint at this
	// resource. This field can be set in policies for either list or boolean
	// constraints. If set, `rules` must be empty and `inherit_from_parent` must be
	// set to false.
	Reset bool `json:"reset,omitempty"`
	// Rules: In policies for boolean constraints, the following requirements
	// apply: - There must be one and only one policy rule where condition is
	// unset. - Boolean policy rules with conditions must set `enforced` to the
	// opposite of the policy rule without a condition. - During policy evaluation,
	// policy rules with conditions that are true for a target resource take
	// precedence.
	Rules []*GoogleCloudOrgpolicyV2PolicySpecPolicyRule `json:"rules,omitempty"`
	// UpdateTime: Output only. The time stamp this was previously updated. This
	// represents the last time a call to `CreatePolicy` or `UpdatePolicy` was made
	// for that policy.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpecPolicyRule: A rule used to express this
// policy.
type GoogleCloudOrgpolicyV2PolicySpecPolicyRule struct {
	// AllowAll: Setting this to true means that all values are allowed. This field
	// can be set only in policies for list constraints.
	AllowAll bool `json:"allowAll,omitempty"`
	// Condition: A condition which determines whether this rule is used in the
	// evaluation of the policy. When set, the `expression` field in the `Expr'
	// must include from 1 to 10 subexpressions, joined by the "||" or "&&"
	// operators. Each subexpression must be of the form
	// "resource.matchTag('/tag_key_short_name, 'tag_value_short_name')". or
	// "resource.matchTagId('tagKeys/key_id', 'tagValues/value_id')". where
	// key_name and value_name are the resource names for Label Keys and Values.
	// These names are available from the Tag Manager Service. An example
	// expression is: "resource.matchTag('123456789/environment, 'prod')". or
	// "resource.matchTagId('tagKeys/123', 'tagValues/456')".
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// DenyAll: Setting this to true means that all values are denied. This field
	// can be set only in policies for list constraints.
	DenyAll bool `json:"denyAll,omitempty"`
	// Enforce: If `true`, then the policy is enforced. If `false`, then any
	// configuration is acceptable. This field can be set only in policies for
	// boolean constraints.
	Enforce bool `json:"enforce,omitempty"`
	// Values: List of values to be used for this policy rule. This field can be
	// set only in policies for list constraints.
	Values *GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAll") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAll") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpecPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpecPolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues: A message that holds
// specific allowed and denied values. This message can define specific values
// and subtrees of the Resource Manager resource hierarchy (`Organizations`,
// `Folders`, `Projects`) that are allowed or denied. This is achieved by using
// the `under:` and optional `is:` prefixes. The `under:` prefix is used to
// denote resource subtree values. The `is:` prefix is used to denote specific
// values, and is required only if the value contains a ":". Values prefixed
// with "is:" are treated the same as values with no prefix. Ancestry subtrees
// must be in one of the following formats: - `projects/` (for example,
// `projects/tokyo-rain-123`) - `folders/` (for example, `folders/1234`) -
// `organizations/` (for example, `organizations/1234`) The `supports_under`
// field of the associated `Constraint` defines whether ancestry prefixes can
// be used.
type GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues struct {
	// AllowedValues: List of values allowed at this resource.
	AllowedValues []string `json:"allowedValues,omitempty"`
	// DeniedValues: List of values denied at this resource.
	DeniedValues []string `json:"deniedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FoldersConstraintsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists constraints that could be applied on the specified resource.
//
//   - parent: The Google Cloud resource that parents the constraint. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *FoldersConstraintsService) List(parent string) *FoldersConstraintsListCall {
	c := &FoldersConstraintsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *FoldersConstraintsListCall) PageSize(pageSize int64) *FoldersConstraintsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *FoldersConstraintsListCall) PageToken(pageToken string) *FoldersConstraintsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersConstraintsListCall) Fields(s ...googleapi.Field) *FoldersConstraintsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersConstraintsListCall) IfNoneMatch(entityTag string) *FoldersConstraintsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersConstraintsListCall) Context(ctx context.Context) *FoldersConstraintsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersConstraintsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersConstraintsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/constraints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.constraints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListConstraintsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersConstraintsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListConstraintsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListConstraintsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersConstraintsListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListConstraintsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersPoliciesCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Creates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a
// `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy
// already exists on the given Google Cloud resource.
//
//   - parent: The Google Cloud resource that will parent the new policy. Must be
//     in one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *FoldersPoliciesService) Create(parent string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *FoldersPoliciesCreateCall {
	c := &FoldersPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesCreateCall) Fields(s ...googleapi.Field) *FoldersPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesCreateCall) Context(ctx context.Context) *FoldersPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FoldersPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or organization policy does
// not exist.
//
// - name: Name of the policy to delete. See the policy entry for naming rules.
func (r *FoldersPoliciesService) Delete(name string) *FoldersPoliciesDeleteCall {
	c := &FoldersPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of policy. If an
// etag is provided and does not match the current etag of the policy, deletion
// will be blocked and an ABORTED error will be returned.
func (c *FoldersPoliciesDeleteCall) Etag(etag string) *FoldersPoliciesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesDeleteCall) Fields(s ...googleapi.Field) *FoldersPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesDeleteCall) Context(ctx context.Context) *FoldersPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FoldersPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a policy on a resource. If no policy is set on the resource,
// `NOT_FOUND` is returned. The `etag` value can be used with `UpdatePolicy()`
// to update a policy during read-modify-write.
//
// - name: Resource name of the policy. See Policy for naming requirements.
func (r *FoldersPoliciesService) Get(name string) *FoldersPoliciesGetCall {
	c := &FoldersPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesGetCall) Fields(s ...googleapi.Field) *FoldersPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersPoliciesGetCall) IfNoneMatch(entityTag string) *FoldersPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesGetCall) Context(ctx context.Context) *FoldersPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersPoliciesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FoldersPoliciesGetEffectivePolicyCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEffectivePolicy: Gets the effective policy on a resource. This is the
// result of merging policies in the resource hierarchy and evaluating
// conditions. The returned policy will not have an `etag` or `condition` set
// because it is an evaluated policy across multiple resources. Subtrees of
// Resource Manager resource hierarchy with 'under:' prefix will not be
// expanded.
//
// - name: The effective policy to compute. See Policy for naming requirements.
func (r *FoldersPoliciesService) GetEffectivePolicy(name string) *FoldersPoliciesGetEffectivePolicyCall {
	c := &FoldersPoliciesGetEffectivePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesGetEffectivePolicyCall) Fields(s ...googleapi.Field) *FoldersPoliciesGetEffectivePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersPoliciesGetEffectivePolicyCall) IfNoneMatch(entityTag string) *FoldersPoliciesGetEffectivePolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesGetEffectivePolicyCall) Context(ctx context.Context) *FoldersPoliciesGetEffectivePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesGetEffectivePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesGetEffectivePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:getEffectivePolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.getEffectivePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersPoliciesGetEffectivePolicyCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FoldersPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all of the policies that exist on a particular resource.
//
//   - parent: The target Google Cloud resource that parents the set of
//     constraints and policies that will be returned from this call. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *FoldersPoliciesService) List(parent string) *FoldersPoliciesListCall {
	c := &FoldersPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *FoldersPoliciesListCall) PageSize(pageSize int64) *FoldersPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *FoldersPoliciesListCall) PageToken(pageToken string) *FoldersPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesListCall) Fields(s ...googleapi.Field) *FoldersPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersPoliciesListCall) IfNoneMatch(entityTag string) *FoldersPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesListCall) Context(ctx context.Context) *FoldersPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListPoliciesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersPoliciesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersPoliciesListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersPoliciesPatchCall struct {
	s                            *Service
	name                         string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Patch: Updates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist.
// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
// supplied in the request does not match the persisted etag of the policy
// Note: the supplied policy will perform a full overwrite of all fields.
//
//   - name: Immutable. The resource name of the policy. Must be one of the
//     following forms, where `constraint_name` is the name of the constraint
//     which this policy configures: *
//     `projects/{project_number}/policies/{constraint_name}` *
//     `folders/{folder_id}/policies/{constraint_name}` *
//     `organizations/{organization_id}/policies/{constraint_name}` For example,
//     `projects/123/policies/compute.disableSerialPortAccess`. Note:
//     `projects/{project_id}/policies/{constraint_name}` is also an acceptable
//     name for API requests, but responses will return the name using the
//     equivalent project number.
func (r *FoldersPoliciesService) Patch(name string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *FoldersPoliciesPatchCall {
	c := &FoldersPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask used to
// specify the fields to be overwritten in the policy by the set. The fields
// specified in the update_mask are relative to the policy, not the full
// request.
func (c *FoldersPoliciesPatchCall) UpdateMask(updateMask string) *FoldersPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersPoliciesPatchCall) Fields(s ...googleapi.Field) *FoldersPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersPoliciesPatchCall) Context(ctx context.Context) *FoldersPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.folders.policies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsConstraintsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists constraints that could be applied on the specified resource.
//
//   - parent: The Google Cloud resource that parents the constraint. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *OrganizationsConstraintsService) List(parent string) *OrganizationsConstraintsListCall {
	c := &OrganizationsConstraintsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *OrganizationsConstraintsListCall) PageSize(pageSize int64) *OrganizationsConstraintsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *OrganizationsConstraintsListCall) PageToken(pageToken string) *OrganizationsConstraintsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsConstraintsListCall) Fields(s ...googleapi.Field) *OrganizationsConstraintsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsConstraintsListCall) IfNoneMatch(entityTag string) *OrganizationsConstraintsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsConstraintsListCall) Context(ctx context.Context) *OrganizationsConstraintsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsConstraintsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsConstraintsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/constraints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.constraints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListConstraintsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsConstraintsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListConstraintsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListConstraintsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsConstraintsListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListConstraintsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsCustomConstraintsCreateCall struct {
	s                                      *Service
	parent                                 string
	googlecloudorgpolicyv2customconstraint *GoogleCloudOrgpolicyV2CustomConstraint
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a custom constraint. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the organization does not exist. Returns a
// `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the constraint
// already exists on the given organization.
//
// - parent: Must be in the following form: * `organizations/{organization_id}`.
func (r *OrganizationsCustomConstraintsService) Create(parent string, googlecloudorgpolicyv2customconstraint *GoogleCloudOrgpolicyV2CustomConstraint) *OrganizationsCustomConstraintsCreateCall {
	c := &OrganizationsCustomConstraintsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudorgpolicyv2customconstraint = googlecloudorgpolicyv2customconstraint
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsCustomConstraintsCreateCall) Fields(s ...googleapi.Field) *OrganizationsCustomConstraintsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsCustomConstraintsCreateCall) Context(ctx context.Context) *OrganizationsCustomConstraintsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsCustomConstraintsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCustomConstraintsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2customconstraint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/customConstraints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.customConstraints.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2CustomConstraint.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsCustomConstraintsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2CustomConstraint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2CustomConstraint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsCustomConstraintsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a custom constraint. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint does not exist.
//
//   - name: Name of the custom constraint to delete. See the custom constraint
//     entry for naming rules.
func (r *OrganizationsCustomConstraintsService) Delete(name string) *OrganizationsCustomConstraintsDeleteCall {
	c := &OrganizationsCustomConstraintsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsCustomConstraintsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsCustomConstraintsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsCustomConstraintsDeleteCall) Context(ctx context.Context) *OrganizationsCustomConstraintsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsCustomConstraintsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCustomConstraintsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.customConstraints.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsCustomConstraintsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsCustomConstraintsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a custom constraint. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the custom constraint does not exist.
//
//   - name: Resource name of the custom constraint. See the custom constraint
//     entry for naming requirements.
func (r *OrganizationsCustomConstraintsService) Get(name string) *OrganizationsCustomConstraintsGetCall {
	c := &OrganizationsCustomConstraintsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsCustomConstraintsGetCall) Fields(s ...googleapi.Field) *OrganizationsCustomConstraintsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsCustomConstraintsGetCall) IfNoneMatch(entityTag string) *OrganizationsCustomConstraintsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsCustomConstraintsGetCall) Context(ctx context.Context) *OrganizationsCustomConstraintsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsCustomConstraintsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCustomConstraintsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.customConstraints.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2CustomConstraint.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsCustomConstraintsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2CustomConstraint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2CustomConstraint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsCustomConstraintsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all of the custom constraints that exist on a particular
// organization resource.
//
//   - parent: The target Google Cloud resource that parents the set of custom
//     constraints that will be returned from this call. Must be in one of the
//     following forms: * `organizations/{organization_id}`.
func (r *OrganizationsCustomConstraintsService) List(parent string) *OrganizationsCustomConstraintsListCall {
	c := &OrganizationsCustomConstraintsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *OrganizationsCustomConstraintsListCall) PageSize(pageSize int64) *OrganizationsCustomConstraintsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *OrganizationsCustomConstraintsListCall) PageToken(pageToken string) *OrganizationsCustomConstraintsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsCustomConstraintsListCall) Fields(s ...googleapi.Field) *OrganizationsCustomConstraintsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsCustomConstraintsListCall) IfNoneMatch(entityTag string) *OrganizationsCustomConstraintsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsCustomConstraintsListCall) Context(ctx context.Context) *OrganizationsCustomConstraintsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsCustomConstraintsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCustomConstraintsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/customConstraints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.customConstraints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListCustomConstraintsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsCustomConstraintsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListCustomConstraintsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListCustomConstraintsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsCustomConstraintsListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListCustomConstraintsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsCustomConstraintsPatchCall struct {
	s                                      *Service
	name                                   string
	googlecloudorgpolicyv2customconstraint *GoogleCloudOrgpolicyV2CustomConstraint
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates a custom constraint. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Note: the
// supplied policy will perform a full overwrite of all fields.
//
//   - name: Immutable. Name of the constraint. This is unique within the
//     organization. Format of the name should be *
//     `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
//     Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
//     The max length is 70 characters and the minimum length is 1. Note that the
//     prefix `organizations/{organization_id}/customConstraints/` is not
//     counted.
func (r *OrganizationsCustomConstraintsService) Patch(name string, googlecloudorgpolicyv2customconstraint *GoogleCloudOrgpolicyV2CustomConstraint) *OrganizationsCustomConstraintsPatchCall {
	c := &OrganizationsCustomConstraintsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudorgpolicyv2customconstraint = googlecloudorgpolicyv2customconstraint
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsCustomConstraintsPatchCall) Fields(s ...googleapi.Field) *OrganizationsCustomConstraintsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsCustomConstraintsPatchCall) Context(ctx context.Context) *OrganizationsCustomConstraintsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsCustomConstraintsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCustomConstraintsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2customconstraint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.customConstraints.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2CustomConstraint.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsCustomConstraintsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2CustomConstraint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2CustomConstraint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsPoliciesCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Creates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a
// `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy
// already exists on the given Google Cloud resource.
//
//   - parent: The Google Cloud resource that will parent the new policy. Must be
//     in one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *OrganizationsPoliciesService) Create(parent string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *OrganizationsPoliciesCreateCall {
	c := &OrganizationsPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesCreateCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesCreateCall) Context(ctx context.Context) *OrganizationsPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or organization policy does
// not exist.
//
// - name: Name of the policy to delete. See the policy entry for naming rules.
func (r *OrganizationsPoliciesService) Delete(name string) *OrganizationsPoliciesDeleteCall {
	c := &OrganizationsPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of policy. If an
// etag is provided and does not match the current etag of the policy, deletion
// will be blocked and an ABORTED error will be returned.
func (c *OrganizationsPoliciesDeleteCall) Etag(etag string) *OrganizationsPoliciesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesDeleteCall) Context(ctx context.Context) *OrganizationsPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a policy on a resource. If no policy is set on the resource,
// `NOT_FOUND` is returned. The `etag` value can be used with `UpdatePolicy()`
// to update a policy during read-modify-write.
//
// - name: Resource name of the policy. See Policy for naming requirements.
func (r *OrganizationsPoliciesService) Get(name string) *OrganizationsPoliciesGetCall {
	c := &OrganizationsPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesGetCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsPoliciesGetCall) IfNoneMatch(entityTag string) *OrganizationsPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesGetCall) Context(ctx context.Context) *OrganizationsPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsPoliciesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsPoliciesGetEffectivePolicyCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEffectivePolicy: Gets the effective policy on a resource. This is the
// result of merging policies in the resource hierarchy and evaluating
// conditions. The returned policy will not have an `etag` or `condition` set
// because it is an evaluated policy across multiple resources. Subtrees of
// Resource Manager resource hierarchy with 'under:' prefix will not be
// expanded.
//
// - name: The effective policy to compute. See Policy for naming requirements.
func (r *OrganizationsPoliciesService) GetEffectivePolicy(name string) *OrganizationsPoliciesGetEffectivePolicyCall {
	c := &OrganizationsPoliciesGetEffectivePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesGetEffectivePolicyCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesGetEffectivePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsPoliciesGetEffectivePolicyCall) IfNoneMatch(entityTag string) *OrganizationsPoliciesGetEffectivePolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesGetEffectivePolicyCall) Context(ctx context.Context) *OrganizationsPoliciesGetEffectivePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesGetEffectivePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesGetEffectivePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:getEffectivePolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.getEffectivePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsPoliciesGetEffectivePolicyCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrganizationsPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all of the policies that exist on a particular resource.
//
//   - parent: The target Google Cloud resource that parents the set of
//     constraints and policies that will be returned from this call. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *OrganizationsPoliciesService) List(parent string) *OrganizationsPoliciesListCall {
	c := &OrganizationsPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *OrganizationsPoliciesListCall) PageSize(pageSize int64) *OrganizationsPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *OrganizationsPoliciesListCall) PageToken(pageToken string) *OrganizationsPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesListCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsPoliciesListCall) IfNoneMatch(entityTag string) *OrganizationsPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesListCall) Context(ctx context.Context) *OrganizationsPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListPoliciesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsPoliciesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsPoliciesListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsPoliciesPatchCall struct {
	s                            *Service
	name                         string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Patch: Updates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist.
// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
// supplied in the request does not match the persisted etag of the policy
// Note: the supplied policy will perform a full overwrite of all fields.
//
//   - name: Immutable. The resource name of the policy. Must be one of the
//     following forms, where `constraint_name` is the name of the constraint
//     which this policy configures: *
//     `projects/{project_number}/policies/{constraint_name}` *
//     `folders/{folder_id}/policies/{constraint_name}` *
//     `organizations/{organization_id}/policies/{constraint_name}` For example,
//     `projects/123/policies/compute.disableSerialPortAccess`. Note:
//     `projects/{project_id}/policies/{constraint_name}` is also an acceptable
//     name for API requests, but responses will return the name using the
//     equivalent project number.
func (r *OrganizationsPoliciesService) Patch(name string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *OrganizationsPoliciesPatchCall {
	c := &OrganizationsPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask used to
// specify the fields to be overwritten in the policy by the set. The fields
// specified in the update_mask are relative to the policy, not the full
// request.
func (c *OrganizationsPoliciesPatchCall) UpdateMask(updateMask string) *OrganizationsPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsPoliciesPatchCall) Fields(s ...googleapi.Field) *OrganizationsPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsPoliciesPatchCall) Context(ctx context.Context) *OrganizationsPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.organizations.policies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsConstraintsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists constraints that could be applied on the specified resource.
//
//   - parent: The Google Cloud resource that parents the constraint. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *ProjectsConstraintsService) List(parent string) *ProjectsConstraintsListCall {
	c := &ProjectsConstraintsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *ProjectsConstraintsListCall) PageSize(pageSize int64) *ProjectsConstraintsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *ProjectsConstraintsListCall) PageToken(pageToken string) *ProjectsConstraintsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsConstraintsListCall) Fields(s ...googleapi.Field) *ProjectsConstraintsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsConstraintsListCall) IfNoneMatch(entityTag string) *ProjectsConstraintsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsConstraintsListCall) Context(ctx context.Context) *ProjectsConstraintsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsConstraintsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsConstraintsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/constraints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.constraints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListConstraintsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsConstraintsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListConstraintsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListConstraintsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsConstraintsListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListConstraintsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPoliciesCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Creates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint does not exist. Returns a
// `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the policy
// already exists on the given Google Cloud resource.
//
//   - parent: The Google Cloud resource that will parent the new policy. Must be
//     in one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *ProjectsPoliciesService) Create(parent string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *ProjectsPoliciesCreateCall {
	c := &ProjectsPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesCreateCall) Context(ctx context.Context) *ProjectsPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or organization policy does
// not exist.
//
// - name: Name of the policy to delete. See the policy entry for naming rules.
func (r *ProjectsPoliciesService) Delete(name string) *ProjectsPoliciesDeleteCall {
	c := &ProjectsPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The current etag of policy. If an
// etag is provided and does not match the current etag of the policy, deletion
// will be blocked and an ABORTED error will be returned.
func (c *ProjectsPoliciesDeleteCall) Etag(etag string) *ProjectsPoliciesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesDeleteCall) Context(ctx context.Context) *ProjectsPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a policy on a resource. If no policy is set on the resource,
// `NOT_FOUND` is returned. The `etag` value can be used with `UpdatePolicy()`
// to update a policy during read-modify-write.
//
// - name: Resource name of the policy. See Policy for naming requirements.
func (r *ProjectsPoliciesService) Get(name string) *ProjectsPoliciesGetCall {
	c := &ProjectsPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesGetCall) Context(ctx context.Context) *ProjectsPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPoliciesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsPoliciesGetEffectivePolicyCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEffectivePolicy: Gets the effective policy on a resource. This is the
// result of merging policies in the resource hierarchy and evaluating
// conditions. The returned policy will not have an `etag` or `condition` set
// because it is an evaluated policy across multiple resources. Subtrees of
// Resource Manager resource hierarchy with 'under:' prefix will not be
// expanded.
//
// - name: The effective policy to compute. See Policy for naming requirements.
func (r *ProjectsPoliciesService) GetEffectivePolicy(name string) *ProjectsPoliciesGetEffectivePolicyCall {
	c := &ProjectsPoliciesGetEffectivePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesGetEffectivePolicyCall) Fields(s ...googleapi.Field) *ProjectsPoliciesGetEffectivePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPoliciesGetEffectivePolicyCall) IfNoneMatch(entityTag string) *ProjectsPoliciesGetEffectivePolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesGetEffectivePolicyCall) Context(ctx context.Context) *ProjectsPoliciesGetEffectivePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesGetEffectivePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesGetEffectivePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:getEffectivePolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.getEffectivePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPoliciesGetEffectivePolicyCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all of the policies that exist on a particular resource.
//
//   - parent: The target Google Cloud resource that parents the set of
//     constraints and policies that will be returned from this call. Must be in
//     one of the following forms: * `projects/{project_number}` *
//     `projects/{project_id}` * `folders/{folder_id}` *
//     `organizations/{organization_id}`.
func (r *ProjectsPoliciesService) List(parent string) *ProjectsPoliciesListCall {
	c := &ProjectsPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the pages to be
// returned. This is currently unsupported and will be ignored. The server may
// at any point start using this field to limit page size.
func (c *ProjectsPoliciesListCall) PageSize(pageSize int64) *ProjectsPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token used to
// retrieve the next page. This is currently unsupported and will be ignored.
// The server may at any point start using this field.
func (c *ProjectsPoliciesListCall) PageToken(pageToken string) *ProjectsPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesListCall) Context(ctx context.Context) *ProjectsPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2ListPoliciesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPoliciesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2ListPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2ListPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsPoliciesListCall) Pages(ctx context.Context, f func(*GoogleCloudOrgpolicyV2ListPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPoliciesPatchCall struct {
	s                            *Service
	name                         string
	googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Patch: Updates a policy. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the constraint or the policy do not exist.
// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
// supplied in the request does not match the persisted etag of the policy
// Note: the supplied policy will perform a full overwrite of all fields.
//
//   - name: Immutable. The resource name of the policy. Must be one of the
//     following forms, where `constraint_name` is the name of the constraint
//     which this policy configures: *
//     `projects/{project_number}/policies/{constraint_name}` *
//     `folders/{folder_id}/policies/{constraint_name}` *
//     `organizations/{organization_id}/policies/{constraint_name}` For example,
//     `projects/123/policies/compute.disableSerialPortAccess`. Note:
//     `projects/{project_id}/policies/{constraint_name}` is also an acceptable
//     name for API requests, but responses will return the name using the
//     equivalent project number.
func (r *ProjectsPoliciesService) Patch(name string, googlecloudorgpolicyv2policy *GoogleCloudOrgpolicyV2Policy) *ProjectsPoliciesPatchCall {
	c := &ProjectsPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudorgpolicyv2policy = googlecloudorgpolicyv2policy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask used to
// specify the fields to be overwritten in the policy by the set. The fields
// specified in the update_mask are relative to the policy, not the full
// request.
func (c *ProjectsPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPoliciesPatchCall) Context(ctx context.Context) *ProjectsPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudorgpolicyv2policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "orgpolicy.projects.policies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudOrgpolicyV2Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudOrgpolicyV2Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudOrgpolicyV2Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
