// Copyright 2015 Google LLC
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package main

// canonicalDocsURL is a map from auto-generated documentation URL (originating from
// "documentationLink") to a valid (possibly through 301 redirect[s]) URL.
// If the auto-generated URL is not valid, then it maps to "" and will not
// be added to the auto-generated API comments.
// Note that this map is currently updated manually.
var canonicalDocsURL = map[string]string{
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/cancel":              "https://cloud.google.com/compute/docs/instance-groups/manager/#cancelrollingupdate",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/get":                 "https://cloud.google.com/compute/docs/instance-groups/manager/#getlistrollingupdate",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/insert":              "https://cloud.google.com/compute/docs/instance-groups/manager/#starting_an_update",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/list":                "https://cloud.google.com/compute/docs/instance-groups/manager/#getlistrollingupdate",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/listInstanceUpdates": "https://cloud.google.com/compute/docs/instance-groups/manager/#getlistrollingupdate",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/pause":               "https://cloud.google.com/compute/docs/instance-groups/manager/#pausing_a_rolling_update",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/resume":              "https://cloud.google.com/compute/docs/instance-groups/manager/#continuerollingupdate",
	"https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_servicerollingUpdates/rollback":            "https://cloud.google.com/compute/docs/instance-groups/manager/#rollingbackupdate",

	"https://developers.google.com/compute/docs/reference/latest/addresses/aggregatedList":           "https://cloud.google.com/compute/docs/reference/latest/addresses/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/addresses/delete":                   "https://cloud.google.com/compute/docs/reference/latest/addresses/delete",
	"https://developers.google.com/compute/docs/reference/latest/addresses/get":                      "https://cloud.google.com/compute/docs/reference/latest/addresses/get",
	"https://developers.google.com/compute/docs/reference/latest/addresses/insert":                   "https://cloud.google.com/compute/docs/reference/latest/addresses/insert",
	"https://developers.google.com/compute/docs/reference/latest/addresses/list":                     "https://cloud.google.com/compute/docs/reference/latest/addresses/list",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/delete":             "https://cloud.google.com/compute/docs/reference/latest/backendServices/delete",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/get":                "https://cloud.google.com/compute/docs/reference/latest/backendServices/get",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/getHealth":          "https://cloud.google.com/compute/docs/reference/latest/backendServices/getHealth",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/insert":             "https://cloud.google.com/compute/docs/reference/latest/backendServices/insert",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/list":               "https://cloud.google.com/compute/docs/reference/latest/backendServices/list",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/patch":              "https://cloud.google.com/compute/docs/reference/latest/backendServices/patch",
	"https://developers.google.com/compute/docs/reference/latest/backendServices/update":             "https://cloud.google.com/compute/docs/reference/latest/backendServices/update",
	"https://developers.google.com/compute/docs/reference/latest/diskTypes/aggregatedList":           "https://cloud.google.com/compute/docs/reference/latest/diskTypes/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/diskTypes/get":                      "https://cloud.google.com/compute/docs/reference/latest/diskTypes/get",
	"https://developers.google.com/compute/docs/reference/latest/diskTypes/list":                     "https://cloud.google.com/compute/docs/reference/latest/diskTypes/list",
	"https://developers.google.com/compute/docs/reference/latest/disks/aggregatedList":               "https://cloud.google.com/compute/docs/reference/latest/disks/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/disks/createSnapshot":               "https://cloud.google.com/compute/docs/reference/latest/disks/createSnapshot",
	"https://developers.google.com/compute/docs/reference/latest/disks/delete":                       "https://cloud.google.com/compute/docs/reference/latest/disks/delete",
	"https://developers.google.com/compute/docs/reference/latest/disks/get":                          "https://cloud.google.com/compute/docs/reference/latest/disks/get",
	"https://developers.google.com/compute/docs/reference/latest/disks/insert":                       "https://cloud.google.com/compute/docs/reference/latest/disks/insert",
	"https://developers.google.com/compute/docs/reference/latest/disks/list":                         "https://cloud.google.com/compute/docs/reference/latest/disks/list",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/delete":                   "https://cloud.google.com/compute/docs/reference/latest/firewalls/delete",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/get":                      "https://cloud.google.com/compute/docs/reference/latest/firewalls/get",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/insert":                   "https://cloud.google.com/compute/docs/reference/latest/firewalls/insert",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/list":                     "https://cloud.google.com/compute/docs/reference/latest/firewalls/list",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/patch":                    "https://cloud.google.com/compute/docs/reference/latest/firewalls/patch",
	"https://developers.google.com/compute/docs/reference/latest/firewalls/update":                   "https://cloud.google.com/compute/docs/reference/latest/firewalls/update",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/aggregatedList":     "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/delete":             "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/delete",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/get":                "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/get",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/insert":             "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/insert",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/list":               "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/list",
	"https://developers.google.com/compute/docs/reference/latest/forwardingRules/setTarget":          "https://cloud.google.com/compute/docs/reference/latest/forwardingRules/setTarget",
	"https://developers.google.com/compute/docs/reference/latest/globalAddresses/delete":             "https://cloud.google.com/compute/docs/reference/latest/globalAddresses/delete",
	"https://developers.google.com/compute/docs/reference/latest/globalAddresses/get":                "https://cloud.google.com/compute/docs/reference/latest/globalAddresses/get",
	"https://developers.google.com/compute/docs/reference/latest/globalAddresses/insert":             "https://cloud.google.com/compute/docs/reference/latest/globalAddresses/insert",
	"https://developers.google.com/compute/docs/reference/latest/globalAddresses/list":               "https://cloud.google.com/compute/docs/reference/latest/globalAddresses/list",
	"https://developers.google.com/compute/docs/reference/latest/globalForwardingRules/delete":       "https://cloud.google.com/compute/docs/reference/latest/globalForwardingRules/delete",
	"https://developers.google.com/compute/docs/reference/latest/globalForwardingRules/get":          "https://cloud.google.com/compute/docs/reference/latest/globalForwardingRules/get",
	"https://developers.google.com/compute/docs/reference/latest/globalForwardingRules/insert":       "https://cloud.google.com/compute/docs/reference/latest/globalForwardingRules/insert",
	"https://developers.google.com/compute/docs/reference/latest/globalForwardingRules/list":         "https://cloud.google.com/compute/docs/reference/latest/globalForwardingRules/list",
	"https://developers.google.com/compute/docs/reference/latest/globalForwardingRules/setTarget":    "https://cloud.google.com/compute/docs/reference/latest/globalForwardingRules/setTarget",
	"https://developers.google.com/compute/docs/reference/latest/globalOperations/aggregatedList":    "https://cloud.google.com/compute/docs/reference/latest/globalOperations/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/globalOperations/delete":            "https://cloud.google.com/compute/docs/reference/latest/globalOperations/delete",
	"https://developers.google.com/compute/docs/reference/latest/globalOperations/get":               "https://cloud.google.com/compute/docs/reference/latest/globalOperations/get",
	"https://developers.google.com/compute/docs/reference/latest/globalOperations/list":              "https://cloud.google.com/compute/docs/reference/latest/globalOperations/list",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/delete":            "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/delete",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/get":               "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/get",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/insert":            "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/insert",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/list":              "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/list",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/patch":             "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/patch",
	"https://developers.google.com/compute/docs/reference/latest/httpHealthChecks/update":            "https://cloud.google.com/compute/docs/reference/latest/httpHealthChecks/update",
	"https://developers.google.com/compute/docs/reference/latest/images/delete":                      "https://cloud.google.com/compute/docs/reference/latest/images/delete",
	"https://developers.google.com/compute/docs/reference/latest/images/deprecate":                   "https://cloud.google.com/compute/docs/reference/latest/images/deprecate",
	"https://developers.google.com/compute/docs/reference/latest/images/get":                         "https://cloud.google.com/compute/docs/reference/latest/images/get",
	"https://developers.google.com/compute/docs/reference/latest/images/insert":                      "https://cloud.google.com/compute/docs/reference/latest/images/insert",
	"https://developers.google.com/compute/docs/reference/latest/images/list":                        "https://cloud.google.com/compute/docs/reference/latest/images/list",
	"https://developers.google.com/compute/docs/reference/latest/instanceTemplates/delete":           "https://cloud.google.com/compute/docs/reference/latest/instanceTemplates/delete",
	"https://developers.google.com/compute/docs/reference/latest/instanceTemplates/get":              "https://cloud.google.com/compute/docs/reference/latest/instanceTemplates/get",
	"https://developers.google.com/compute/docs/reference/latest/instanceTemplates/insert":           "https://cloud.google.com/compute/docs/reference/latest/instanceTemplates/insert",
	"https://developers.google.com/compute/docs/reference/latest/instanceTemplates/list":             "https://cloud.google.com/compute/docs/reference/latest/instanceTemplates/list",
	"https://developers.google.com/compute/docs/reference/latest/instances/addAccessConfig":          "https://cloud.google.com/compute/docs/reference/latest/instances/addAccessConfig",
	"https://developers.google.com/compute/docs/reference/latest/instances/aggregatedList":           "https://cloud.google.com/compute/docs/reference/latest/instances/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/instances/attachDisk":               "https://cloud.google.com/compute/docs/reference/latest/instances/attachDisk",
	"https://developers.google.com/compute/docs/reference/latest/instances/delete":                   "https://cloud.google.com/compute/docs/reference/latest/instances/delete",
	"https://developers.google.com/compute/docs/reference/latest/instances/deleteAccessConfig":       "https://cloud.google.com/compute/docs/reference/latest/instances/deleteAccessConfig",
	"https://developers.google.com/compute/docs/reference/latest/instances/detachDisk":               "https://cloud.google.com/compute/docs/reference/latest/instances/detachDisk",
	"https://developers.google.com/compute/docs/reference/latest/instances/get":                      "https://cloud.google.com/compute/docs/reference/latest/instances/get",
	"https://developers.google.com/compute/docs/reference/latest/instances/getSerialPortOutput":      "https://cloud.google.com/compute/docs/reference/latest/instances/getSerialPortOutput",
	"https://developers.google.com/compute/docs/reference/latest/instances/insert":                   "https://cloud.google.com/compute/docs/reference/latest/instances/insert",
	"https://developers.google.com/compute/docs/reference/latest/instances/list":                     "https://cloud.google.com/compute/docs/reference/latest/instances/list",
	"https://developers.google.com/compute/docs/reference/latest/instances/reset":                    "https://cloud.google.com/compute/docs/reference/latest/instances/reset",
	"https://developers.google.com/compute/docs/reference/latest/instances/setDiskAutoDelete":        "https://cloud.google.com/compute/docs/reference/latest/instances/setDiskAutoDelete",
	"https://developers.google.com/compute/docs/reference/latest/instances/setMetadata":              "https://cloud.google.com/compute/docs/reference/latest/instances/setMetadata",
	"https://developers.google.com/compute/docs/reference/latest/instances/setScheduling":            "https://cloud.google.com/compute/docs/reference/latest/instances/setScheduling",
	"https://developers.google.com/compute/docs/reference/latest/instances/setTags":                  "https://cloud.google.com/compute/docs/reference/latest/instances/setTags",
	"https://developers.google.com/compute/docs/reference/latest/instances/start":                    "https://cloud.google.com/compute/docs/reference/latest/instances/start",
	"https://developers.google.com/compute/docs/reference/latest/instances/stop":                     "https://cloud.google.com/compute/docs/reference/latest/instances/stop",
	"https://developers.google.com/compute/docs/reference/latest/licenses/get":                       "https://cloud.google.com/compute/docs/reference/latest/licenses/get",
	"https://developers.google.com/compute/docs/reference/latest/machineTypes/aggregatedList":        "https://cloud.google.com/compute/docs/reference/latest/machineTypes/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/machineTypes/get":                   "https://cloud.google.com/compute/docs/reference/latest/machineTypes/get",
	"https://developers.google.com/compute/docs/reference/latest/machineTypes/list":                  "https://cloud.google.com/compute/docs/reference/latest/machineTypes/list",
	"https://developers.google.com/compute/docs/reference/latest/networks/delete":                    "https://cloud.google.com/compute/docs/reference/latest/networks/delete",
	"https://developers.google.com/compute/docs/reference/latest/networks/get":                       "https://cloud.google.com/compute/docs/reference/latest/networks/get",
	"https://developers.google.com/compute/docs/reference/latest/networks/insert":                    "https://cloud.google.com/compute/docs/reference/latest/networks/insert",
	"https://developers.google.com/compute/docs/reference/latest/networks/list":                      "https://cloud.google.com/compute/docs/reference/latest/networks/list",
	"https://developers.google.com/compute/docs/reference/latest/projects/get":                       "https://cloud.google.com/compute/docs/reference/latest/projects/get",
	"https://developers.google.com/compute/docs/reference/latest/projects/setCommonInstanceMetadata": "https://cloud.google.com/compute/docs/reference/latest/projects/setCommonInstanceMetadata",
	"https://developers.google.com/compute/docs/reference/latest/projects/setUsageExportBucket":      "https://cloud.google.com/compute/docs/reference/latest/projects/setUsageExportBucket",
	"https://developers.google.com/compute/docs/reference/latest/regionOperations/delete":            "https://cloud.google.com/compute/docs/reference/latest/regionOperations/delete",
	"https://developers.google.com/compute/docs/reference/latest/regionOperations/get":               "https://cloud.google.com/compute/docs/reference/latest/regionOperations/get",
	"https://developers.google.com/compute/docs/reference/latest/regionOperations/list":              "https://cloud.google.com/compute/docs/reference/latest/regionOperations/list",
	"https://developers.google.com/compute/docs/reference/latest/regions/get":                        "https://cloud.google.com/compute/docs/reference/latest/regions/get",
	"https://developers.google.com/compute/docs/reference/latest/regions/list":                       "https://cloud.google.com/compute/docs/reference/latest/regions/list",
	"https://developers.google.com/compute/docs/reference/latest/routes/delete":                      "https://cloud.google.com/compute/docs/reference/latest/routes/delete",
	"https://developers.google.com/compute/docs/reference/latest/routes/get":                         "https://cloud.google.com/compute/docs/reference/latest/routes/get",
	"https://developers.google.com/compute/docs/reference/latest/routes/insert":                      "https://cloud.google.com/compute/docs/reference/latest/routes/insert",
	"https://developers.google.com/compute/docs/reference/latest/routes/list":                        "https://cloud.google.com/compute/docs/reference/latest/routes/list",
	"https://developers.google.com/compute/docs/reference/latest/snapshots/delete":                   "https://cloud.google.com/compute/docs/reference/latest/snapshots/delete",
	"https://developers.google.com/compute/docs/reference/latest/snapshots/get":                      "https://cloud.google.com/compute/docs/reference/latest/snapshots/get",
	"https://developers.google.com/compute/docs/reference/latest/snapshots/list":                     "https://cloud.google.com/compute/docs/reference/latest/snapshots/list",
	"https://developers.google.com/compute/docs/reference/latest/targetHttpProxies/delete":           "https://cloud.google.com/compute/docs/reference/latest/targetHttpProxies/delete",
	"https://developers.google.com/compute/docs/reference/latest/targetHttpProxies/get":              "https://cloud.google.com/compute/docs/reference/latest/targetHttpProxies/get",
	"https://developers.google.com/compute/docs/reference/latest/targetHttpProxies/insert":           "https://cloud.google.com/compute/docs/reference/latest/targetHttpProxies/insert",
	"https://developers.google.com/compute/docs/reference/latest/targetHttpProxies/list":             "https://cloud.google.com/compute/docs/reference/latest/targetHttpProxies/list",
	"https://developers.google.com/compute/docs/reference/latest/targetHttpProxies/setUrlMap":        "https://cloud.google.com/compute/docs/reference/latest/targetHttpProxies/setUrlMap",
	"https://developers.google.com/compute/docs/reference/latest/targetInstances/aggregatedList":     "https://cloud.google.com/compute/docs/reference/latest/targetInstances/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/targetInstances/delete":             "https://cloud.google.com/compute/docs/reference/latest/targetInstances/delete",
	"https://developers.google.com/compute/docs/reference/latest/targetInstances/get":                "https://cloud.google.com/compute/docs/reference/latest/targetInstances/get",
	"https://developers.google.com/compute/docs/reference/latest/targetInstances/insert":             "https://cloud.google.com/compute/docs/reference/latest/targetInstances/insert",
	"https://developers.google.com/compute/docs/reference/latest/targetInstances/list":               "https://cloud.google.com/compute/docs/reference/latest/targetInstances/list",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/addHealthCheck":         "https://cloud.google.com/compute/docs/reference/latest/targetPools/addHealthCheck",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/addInstance":            "https://cloud.google.com/compute/docs/reference/latest/targetPools/addInstance",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/aggregatedList":         "https://cloud.google.com/compute/docs/reference/latest/targetPools/aggregatedList",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/delete":                 "https://cloud.google.com/compute/docs/reference/latest/targetPools/delete",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/get":                    "https://cloud.google.com/compute/docs/reference/latest/targetPools/get",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/getHealth":              "https://cloud.google.com/compute/docs/reference/latest/targetPools/getHealth",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/insert":                 "https://cloud.google.com/compute/docs/reference/latest/targetPools/insert",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/list":                   "https://cloud.google.com/compute/docs/reference/latest/targetPools/list",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/removeHealthCheck":      "https://cloud.google.com/compute/docs/reference/latest/targetPools/removeHealthCheck",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/removeInstance":         "https://cloud.google.com/compute/docs/reference/latest/targetPools/removeInstance",
	"https://developers.google.com/compute/docs/reference/latest/targetPools/setBackup":              "https://cloud.google.com/compute/docs/reference/latest/targetPools/setBackup",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/delete":                     "https://cloud.google.com/compute/docs/reference/latest/urlMaps/delete",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/get":                        "https://cloud.google.com/compute/docs/reference/latest/urlMaps/get",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/insert":                     "https://cloud.google.com/compute/docs/reference/latest/urlMaps/insert",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/list":                       "https://cloud.google.com/compute/docs/reference/latest/urlMaps/list",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/patch":                      "https://cloud.google.com/compute/docs/reference/latest/urlMaps/patch",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/update":                     "https://cloud.google.com/compute/docs/reference/latest/urlMaps/update",
	"https://developers.google.com/compute/docs/reference/latest/urlMaps/validate":                   "https://cloud.google.com/compute/docs/reference/latest/urlMaps/validate",
	"https://developers.google.com/compute/docs/reference/latest/zoneOperations/delete":              "https://cloud.google.com/compute/docs/reference/latest/zoneOperations/delete",
	"https://developers.google.com/compute/docs/reference/latest/zoneOperations/get":                 "https://cloud.google.com/compute/docs/reference/latest/zoneOperations/get",
	"https://developers.google.com/compute/docs/reference/latest/zoneOperations/list":                "https://cloud.google.com/compute/docs/reference/latest/zoneOperations/list",
	"https://developers.google.com/compute/docs/reference/latest/zones/get":                          "https://cloud.google.com/compute/docs/reference/latest/zones/get",
	"https://developers.google.com/compute/docs/reference/latest/zones/list":                         "https://cloud.google.com/compute/docs/reference/latest/zones/list",
}
