package expression_test

import (
	"testing"

	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/types/known/structpb"

	"gitlab.com/gitlab-org/step-runner/pkg/internal/expression"
)

func TestEvaluate(t *testing.T) {
	evaluateTests := []struct {
		value       string
		expectedVal *structpb.Value
		expectedErr string
	}{{
		value:       "job.job_id",
		expectedVal: structpb.NewStringValue("1982"),
	}, {
		value:       "  job.job_id  ",
		expectedVal: structpb.NewStringValue("1982"),
	}, {
		value:       "job.undefined_key",
		expectedErr: `job.undefined_key: the "undefined_key" was not found`,
	}}
	for _, et := range evaluateTests {
		t.Run(et.value, func(t *testing.T) {
			got, err := expression.Evaluate(textContextSteps(t), et.value)
			if et.expectedErr != "" {
				require.Error(t, err)
				require.ErrorContains(t, err, et.expectedErr)
			} else {
				require.NoError(t, err)
				require.Equal(t, et.expectedVal, got.Value)
			}
		})
	}
}
