# Settings

Settings provide a mechanism for a user to control the behavior of a `cmd2` based application.
Settings are stored in a protected instance attribute on your subclass of [cmd2.Cmd][]. Developers
may set default values for these settings and users can view and modify them at runtime using the
[set](./builtin_commands.md#set) command. Developers can [Create New Settings](#create-new-settings)
and can also [Hide Builtin Settings](#hide-builtin-settings) from the user.

## Builtin Settings

`cmd2` has a number of built-in settings. These settings control the behavior of certain application
features and [Buildin Commands](./builtin_commands.md). Users can use the
[set](./builtin_commands.md#set) command to show all settings and to modify the value of any
setting.

### allow_style

Output generated by `cmd2` programs may contain ANSI escape sequences which instruct the terminal to
apply colors or text styling (i.e. bold) to the output. The `allow_style` setting controls the
behavior of these escape sequences in output generated with any of the following methods:

- **`cmd2.Cmd.poutput`**
- **`cmd2.Cmd.perror`**
- **`cmd2.Cmd.pwarning`**
- **`cmd2.Cmd.pexcept`**
- **`cmd2.Cmd.pfeedback`**
- **`cmd2.Cmd.ppaged`**
- **`cmd2.Cmd.ppretty`**

This setting can be one of three values:

- `Never` - all ANSI escape sequences which instruct the terminal to style output are stripped from
  the output.
- `Terminal` - (the default value) pass through ANSI escape sequences when the output is being sent
  to the terminal, but if the output is redirected to a pipe or a file the escape sequences are
  stripped.
- `Always` - ANSI escape sequences are always passed through to the output

### always_show_hint

If `True`, display tab completion hint even when completion suggestions print. The default value of
this setting is `False`.

### debug

The default value of this setting is `False`, which causes the `cmd2.Cmd.pexcept` method to only
display the message from an exception. However, if the debug setting is `True`, then the entire
stack trace will be printed.

### echo

If `True`, each command the user issues will be repeated to the screen before it is executed. This
is particularly useful when running scripts. This behavior does not occur when running a command at
the prompt.

### editor

Similar to the `EDITOR` shell variable, this setting contains the name of the program which should
be run by the [edit](./builtin_commands.md#edit) command.

### feedback_to_output

Controls whether feedback generated with the `cmd2.Cmd.pfeedback` method is sent to `sys.stdout` or
`sys.stderr`. If `False` the output will be sent to `sys.stderr`

If `True` the output is sent to `stdout` (which is often the screen but may be
[redirected](./redirection.md#output-redirection-and-pipes)). The feedback output will be mixed in
with and indistinguishable from output generated with `cmd2.Cmd.poutput`.

### max_completion_items

Maximum number of CompletionItems to display during tab completion. A CompletionItem is a special
kind of tab completion hint which displays both a value and description and uses one line for each
hint. Tab complete the `set` command for an example.

If the number of tab completion hints exceeds `max_completion_items`, then they will be displayed in
the typical columnized format and will not include the description text of the CompletionItem.

### quiet

If `True`, output generated by calling `cmd2.Cmd.pfeedback` is suppressed. If `False`, the
[feedback_to_output](#feedback_to_output) setting controls where the output is sent.

### scripts_add_to_history

If `True`, scripts and pyscripts add commands to history. The default value of this setting is
`True`.

### timing

If `True`, the elapsed time is reported for each command executed.

## Create New Settings

Your application can define user-settable parameters which your code can reference. In your
initialization code:

1.  Create an instance attribute with a default value
1.  Create a [Settable][cmd2.Settable] object which describes your setting
1.  Pass the `Settable` object to the [add_settable][cmd2.Cmd.add_settable] method

Here's an example, from
[examples/environment.py](https://github.com/python-cmd2/cmd2/blob/main/examples/environment.py):

!!! example "examples/environment.py"

    ```py
    --8<-- "examples/environment.py"
    ```

If you want to be notified when a setting changes (as we do above), then be sure to supply a method
to the `onchange_cb` parameter of the `cmd2.utils.Settable`. This method will be called after the
user changes a setting, and will receive both the old value and the new value.

```text
(Cmd) set | grep sunny
sunny                 False                           Is it sunny outside?
(Cmd) set | grep degrees
degrees_c             22                              Temperature in Celsius
(Cmd) sunbathe
Too dim.
(Cmd) set degrees_c 41
degrees_c - was: 22
now: 41
(Cmd) set sunny
sunny: True
(Cmd) sunbathe
UV is bad for your skin.
(Cmd) set degrees_c 13
degrees_c - was: 41
now: 13
(Cmd) sunbathe
It's 13 C - are you a penguin?
```

## Hide Builtin Settings

You may want to prevent a user from modifying a built-in setting. Let's say that you never want end
users of your program to be able to enable full debug tracebacks to print out if an error occurs.
You might want to hide the [debug](#debug) setting. The [cmd2.Cmd.remove_settable][] method makes
this easy:

```py
class MyApp(cmd2.Cmd):

    def __init__(self):
        super().__init__()
      self.remove_settable('debug')
```
