---
title: "FileLu"
description: "Rclone docs for FileLu"
versionIntroduced: "v1.70"
---

# {{< icon "fa fa-folder" >}} FileLu

[FileLu](https://filelu.com/) is a reliable cloud storage provider
offering features like secure file uploads, downloads, flexible
storage options, and sharing capabilities. With support for high
storage limits and seamless integration with rclone, FileLu makes
managing files in the cloud easy. Its cross-platform file backup
services let you upload and back up files from any internet-connected
device.

## Configuration

Here is an example of how to make a remote called `filelu`. First, run:

     rclone config

This will guide you through an interactive setup process:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> filelu
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
xx / FileLu Cloud Storage
   \ "filelu"
[snip]
Storage> filelu
Enter your FileLu Rclone Key:
key> YOUR_FILELU_RCLONE_KEY RC_xxxxxxxxxxxxxxxxxxxxxxxx
Configuration complete.

Keep this "filelu" remote?
y) Yes this is OK
e) Edit this remote
d) Delete this remote
y/e/d> y
```

### Paths

A path without an initial `/` will operate in the `Rclone` directory.

A path with an initial `/` will operate at the root where you can see
the `Rclone` directory.

```
$ rclone lsf TestFileLu:/
CCTV/
Camera/
Documents/
Music/
Photos/
Rclone/
Vault/
Videos/
```

### Example Commands

Create a new folder named `foldername` in the `Rclone` directory:

    rclone mkdir filelu:foldername

Delete a folder on FileLu:

    rclone rmdir filelu:/folder/path/

Delete a file on FileLu:

    rclone delete filelu:/hello.txt

List files from your FileLu account:

    rclone ls filelu:

List all folders:

    rclone lsd filelu:

Copy a specific file to the FileLu root:

    rclone copy D:\\hello.txt filelu:

Copy files from a local directory to a FileLu directory:

    rclone copy D:/local-folder filelu:/remote-folder/path/
    
Download a file from FileLu into a local directory:

    rclone copy filelu:/file-path/hello.txt D:/local-folder

Move files from a local directory to a FileLu directory:

    rclone move D:\\local-folder filelu:/remote-path/

Sync files from a local directory to a FileLu directory:

    rclone sync --interactive D:/local-folder filelu:/remote-path/
    
Mount remote to local Linux:

    rclone mount filelu: /root/mnt --vfs-cache-mode full

Mount remote to local Windows:

    rclone mount filelu: D:/local_mnt --vfs-cache-mode full

Get storage info about the FileLu account:

    rclone about filelu:

All the other rclone commands are supported by this backend.

### FolderID instead of folder path

We use the FolderID instead of the folder name to prevent errors when
users have identical folder names or paths. For example, if a user has
two or three folders named "test_folders," the system may become
confused and won't know which folder to move. In large storage
systems, some clients have hundred of thousands of folders and a few
millions of files, duplicate folder names or paths are quite common.

### Modification Times and Hashes

FileLu supports both modification times and MD5 hashes.

FileLu only supports filenames and folder names up to 255 characters in length, where a
character is a Unicode character.

### Duplicated Files

When uploading and syncing via Rclone, FileLu does not allow uploading
duplicate files within the same directory. However, you can upload
duplicate files, provided they are in different directories (folders).

### Failure to Log / Invalid Credentials or KEY

Ensure that you have the correct Rclone key, which can be found in [My
Account](https://filelu.com/account/). Every time you toggle Rclone
OFF and ON in My Account, a new RC_xxxxxxxxxxxxxxxxxxxx key is
generated. Be sure to update your Rclone configuration with the new
key.

If you are connecting to your FileLu remote for the first time and
encounter an error such as:

```
Failed to create file system for "my-filelu-remote:": couldn't login: Invalid credentials
```

Ensure your Rclone Key is correct.

### Process `killed`

Accounts with large files or extensive metadata may experience
significant memory usage during list/sync operations. Ensure the
system running `rclone` has sufficient memory and CPU to handle these
operations.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/filelu/filelu.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to filelu (FileLu Cloud Storage).

#### --filelu-key

Your FileLu Rclone key from My Account

Properties:

- Config:      key
- Env Var:     RCLONE_FILELU_KEY
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to filelu (FileLu Cloud Storage).

#### --filelu-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_FILELU_ENCODING
- Type:        Encoding
- Default:     Slash,LtGt,DoubleQuote,SingleQuote,BackQuote,Dollar,Colon,Question,Asterisk,Pipe,Hash,Percent,BackSlash,CrLf,Del,Ctl,LeftSpace,LeftPeriod,LeftTilde,LeftCrLfHtVt,RightSpace,RightPeriod,RightCrLfHtVt,InvalidUtf8,Dot,SquareBracket,Semicolon,Exclamation

#### --filelu-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_FILELU_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}

## Limitations

This backend uses a custom library implementing the FileLu API. While
it supports file transfers, some advanced features may not yet be
available. Please report any issues to the [rclone forum](https://forum.rclone.org/)
for troubleshooting and updates.

For further information, visit [FileLu's website](https://filelu.com/).
