//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcomparefunction?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCompareFunction(pub NSUInteger);
impl MTLCompareFunction {
    #[doc(alias = "MTLCompareFunctionNever")]
    pub const Never: Self = Self(0);
    #[doc(alias = "MTLCompareFunctionLess")]
    pub const Less: Self = Self(1);
    #[doc(alias = "MTLCompareFunctionEqual")]
    pub const Equal: Self = Self(2);
    #[doc(alias = "MTLCompareFunctionLessEqual")]
    pub const LessEqual: Self = Self(3);
    #[doc(alias = "MTLCompareFunctionGreater")]
    pub const Greater: Self = Self(4);
    #[doc(alias = "MTLCompareFunctionNotEqual")]
    pub const NotEqual: Self = Self(5);
    #[doc(alias = "MTLCompareFunctionGreaterEqual")]
    pub const GreaterEqual: Self = Self(6);
    #[doc(alias = "MTLCompareFunctionAlways")]
    pub const Always: Self = Self(7);
}

unsafe impl Encode for MTLCompareFunction {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCompareFunction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstenciloperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLStencilOperation(pub NSUInteger);
impl MTLStencilOperation {
    #[doc(alias = "MTLStencilOperationKeep")]
    pub const Keep: Self = Self(0);
    #[doc(alias = "MTLStencilOperationZero")]
    pub const Zero: Self = Self(1);
    #[doc(alias = "MTLStencilOperationReplace")]
    pub const Replace: Self = Self(2);
    #[doc(alias = "MTLStencilOperationIncrementClamp")]
    pub const IncrementClamp: Self = Self(3);
    #[doc(alias = "MTLStencilOperationDecrementClamp")]
    pub const DecrementClamp: Self = Self(4);
    #[doc(alias = "MTLStencilOperationInvert")]
    pub const Invert: Self = Self(5);
    #[doc(alias = "MTLStencilOperationIncrementWrap")]
    pub const IncrementWrap: Self = Self(6);
    #[doc(alias = "MTLStencilOperationDecrementWrap")]
    pub const DecrementWrap: Self = Self(7);
}

unsafe impl Encode for MTLStencilOperation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLStencilOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstencildescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLStencilDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLStencilDescriptor {}
);

unsafe impl CopyingHelper for MTLStencilDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLStencilDescriptor {}
);

impl MTLStencilDescriptor {
    extern_methods!(
        #[unsafe(method(stencilCompareFunction))]
        #[unsafe(method_family = none)]
        pub fn stencilCompareFunction(&self) -> MTLCompareFunction;

        /// Setter for [`stencilCompareFunction`][Self::stencilCompareFunction].
        #[unsafe(method(setStencilCompareFunction:))]
        #[unsafe(method_family = none)]
        pub fn setStencilCompareFunction(&self, stencil_compare_function: MTLCompareFunction);

        /// Stencil is tested first.  stencilFailureOperation declares how the stencil buffer is updated when the stencil test fails.
        #[unsafe(method(stencilFailureOperation))]
        #[unsafe(method_family = none)]
        pub fn stencilFailureOperation(&self) -> MTLStencilOperation;

        /// Setter for [`stencilFailureOperation`][Self::stencilFailureOperation].
        #[unsafe(method(setStencilFailureOperation:))]
        #[unsafe(method_family = none)]
        pub fn setStencilFailureOperation(&self, stencil_failure_operation: MTLStencilOperation);

        /// If stencil passes, depth is tested next.  Declare what happens when the depth test fails.
        #[unsafe(method(depthFailureOperation))]
        #[unsafe(method_family = none)]
        pub fn depthFailureOperation(&self) -> MTLStencilOperation;

        /// Setter for [`depthFailureOperation`][Self::depthFailureOperation].
        #[unsafe(method(setDepthFailureOperation:))]
        #[unsafe(method_family = none)]
        pub fn setDepthFailureOperation(&self, depth_failure_operation: MTLStencilOperation);

        /// If both the stencil and depth tests pass, declare how the stencil buffer is updated.
        #[unsafe(method(depthStencilPassOperation))]
        #[unsafe(method_family = none)]
        pub fn depthStencilPassOperation(&self) -> MTLStencilOperation;

        /// Setter for [`depthStencilPassOperation`][Self::depthStencilPassOperation].
        #[unsafe(method(setDepthStencilPassOperation:))]
        #[unsafe(method_family = none)]
        pub fn setDepthStencilPassOperation(
            &self,
            depth_stencil_pass_operation: MTLStencilOperation,
        );

        #[unsafe(method(readMask))]
        #[unsafe(method_family = none)]
        pub fn readMask(&self) -> u32;

        /// Setter for [`readMask`][Self::readMask].
        #[unsafe(method(setReadMask:))]
        #[unsafe(method_family = none)]
        pub fn setReadMask(&self, read_mask: u32);

        #[unsafe(method(writeMask))]
        #[unsafe(method_family = none)]
        pub fn writeMask(&self) -> u32;

        /// Setter for [`writeMask`][Self::writeMask].
        #[unsafe(method(setWriteMask:))]
        #[unsafe(method_family = none)]
        pub fn setWriteMask(&self, write_mask: u32);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLStencilDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldepthstencildescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLDepthStencilDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLDepthStencilDescriptor {}
);

unsafe impl CopyingHelper for MTLDepthStencilDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLDepthStencilDescriptor {}
);

impl MTLDepthStencilDescriptor {
    extern_methods!(
        #[unsafe(method(depthCompareFunction))]
        #[unsafe(method_family = none)]
        pub fn depthCompareFunction(&self) -> MTLCompareFunction;

        /// Setter for [`depthCompareFunction`][Self::depthCompareFunction].
        #[unsafe(method(setDepthCompareFunction:))]
        #[unsafe(method_family = none)]
        pub fn setDepthCompareFunction(&self, depth_compare_function: MTLCompareFunction);

        #[unsafe(method(isDepthWriteEnabled))]
        #[unsafe(method_family = none)]
        pub fn isDepthWriteEnabled(&self) -> bool;

        /// Setter for [`isDepthWriteEnabled`][Self::isDepthWriteEnabled].
        #[unsafe(method(setDepthWriteEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setDepthWriteEnabled(&self, depth_write_enabled: bool);

        #[unsafe(method(frontFaceStencil))]
        #[unsafe(method_family = none)]
        pub fn frontFaceStencil(&self) -> Retained<MTLStencilDescriptor>;

        /// Setter for [`frontFaceStencil`][Self::frontFaceStencil].
        #[unsafe(method(setFrontFaceStencil:))]
        #[unsafe(method_family = none)]
        pub fn setFrontFaceStencil(&self, front_face_stencil: Option<&MTLStencilDescriptor>);

        #[unsafe(method(backFaceStencil))]
        #[unsafe(method_family = none)]
        pub fn backFaceStencil(&self) -> Retained<MTLStencilDescriptor>;

        /// Setter for [`backFaceStencil`][Self::backFaceStencil].
        #[unsafe(method(setBackFaceStencil:))]
        #[unsafe(method_family = none)]
        pub fn setBackFaceStencil(&self, back_face_stencil: Option<&MTLStencilDescriptor>);

        /// A string to help identify the created object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        pub fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        pub fn setLabel(&self, label: Option<&NSString>);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLDepthStencilDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldepthstencilstate?language=objc)
    pub unsafe trait MTLDepthStencilState: NSObjectProtocol {
        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.  This resource can only be used with this device.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;
    }
);
