// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`Converse`](crate::operation::converse::builders::ConverseFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`model_id(impl Into<String>)`](crate::operation::converse::builders::ConverseFluentBuilder::model_id) / [`set_model_id(Option<String>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_model_id):<br>required: **true**<br><p>Specifies the model or throughput with which to run inference, or the prompt resource to use in inference. The value depends on the resource that you use:</p> <ul>  <li>   <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting provisioned model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>  <li>   <p>To include a prompt that was defined in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Prompt management</a>, specify the ARN of the prompt version to use.</p></li> </ul> <p>The Converse API doesn't support <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported models</a>.</p><br>
    ///   - [`messages(Message)`](crate::operation::converse::builders::ConverseFluentBuilder::messages) / [`set_messages(Option<Vec::<Message>>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_messages):<br>required: **false**<br><p>The messages that you want to send to the model.</p><br>
    ///   - [`system(SystemContentBlock)`](crate::operation::converse::builders::ConverseFluentBuilder::system) / [`set_system(Option<Vec::<SystemContentBlock>>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_system):<br>required: **false**<br><p>A prompt that provides instructions or context to the model about the task it should perform, or the persona it should adopt during the conversation.</p><br>
    ///   - [`inference_config(InferenceConfiguration)`](crate::operation::converse::builders::ConverseFluentBuilder::inference_config) / [`set_inference_config(Option<InferenceConfiguration>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_inference_config):<br>required: **false**<br><p>Inference parameters to pass to the model. <code>Converse</code> and <code>ConverseStream</code> support a base set of inference parameters. If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field.</p><br>
    ///   - [`tool_config(ToolConfiguration)`](crate::operation::converse::builders::ConverseFluentBuilder::tool_config) / [`set_tool_config(Option<ToolConfiguration>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_tool_config):<br>required: **false**<br><p>Configuration information for the tools that the model can use when generating a response.</p> <p>For information about models that support tool use, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference.html#conversation-inference-supported-models-features">Supported models and model features</a>.</p><br>
    ///   - [`guardrail_config(GuardrailConfiguration)`](crate::operation::converse::builders::ConverseFluentBuilder::guardrail_config) / [`set_guardrail_config(Option<GuardrailConfiguration>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_guardrail_config):<br>required: **false**<br><p>Configuration information for a guardrail that you want to use in the request. If you include <code>guardContent</code> blocks in the <code>content</code> field in the <code>messages</code> field, the guardrail operates only on those messages. If you include no <code>guardContent</code> blocks, the guardrail operates on all messages in the request body and in any included prompt resource.</p><br>
    ///   - [`additional_model_request_fields(Document)`](crate::operation::converse::builders::ConverseFluentBuilder::additional_model_request_fields) / [`set_additional_model_request_fields(Option<Document>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_additional_model_request_fields):<br>required: **false**<br><p>Additional inference parameters that the model supports, beyond the base set of inference parameters that <code>Converse</code> and <code>ConverseStream</code> support in the <code>inferenceConfig</code> field. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model parameters</a>.</p><br>
    ///   - [`prompt_variables(impl Into<String>, PromptVariableValues)`](crate::operation::converse::builders::ConverseFluentBuilder::prompt_variables) / [`set_prompt_variables(Option<HashMap::<String, PromptVariableValues>>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_prompt_variables):<br>required: **false**<br><p>Contains a map of variables in a prompt from Prompt management to objects containing the values to fill in for them when running model invocation. This field is ignored if you don't specify a prompt resource in the <code>modelId</code> field.</p><br>
    ///   - [`additional_model_response_field_paths(impl Into<String>)`](crate::operation::converse::builders::ConverseFluentBuilder::additional_model_response_field_paths) / [`set_additional_model_response_field_paths(Option<Vec::<String>>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_additional_model_response_field_paths):<br>required: **false**<br><p>Additional model parameters field paths to return in the response. <code>Converse</code> and <code>ConverseStream</code> return the requested fields as a JSON Pointer object in the <code>additionalModelResponseFields</code> field. The following is example JSON for <code>additionalModelResponseFieldPaths</code>.</p> <p><code>\[ "/stop_sequence" \]</code></p> <p>For information about the JSON Pointer syntax, see the <a href="https://datatracker.ietf.org/doc/html/rfc6901">Internet Engineering Task Force (IETF)</a> documentation.</p> <p><code>Converse</code> and <code>ConverseStream</code> reject an empty JSON Pointer or incorrectly structured JSON Pointer with a <code>400</code> error code. if the JSON Pointer is valid, but the requested field is not in the model response, it is ignored by <code>Converse</code>.</p><br>
    ///   - [`request_metadata(impl Into<String>, impl Into<String>)`](crate::operation::converse::builders::ConverseFluentBuilder::request_metadata) / [`set_request_metadata(Option<HashMap::<String, String>>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_request_metadata):<br>required: **false**<br><p>Key-value pairs that you can use to filter invocation logs.</p><br>
    ///   - [`performance_config(PerformanceConfiguration)`](crate::operation::converse::builders::ConverseFluentBuilder::performance_config) / [`set_performance_config(Option<PerformanceConfiguration>)`](crate::operation::converse::builders::ConverseFluentBuilder::set_performance_config):<br>required: **false**<br><p>Model performance settings for the request.</p><br>
    /// - On success, responds with [`ConverseOutput`](crate::operation::converse::ConverseOutput) with field(s):
    ///   - [`output(Option<ConverseOutput>)`](crate::operation::converse::ConverseOutput::output): <p>The result from the call to <code>Converse</code>.</p>
    ///   - [`stop_reason(StopReason)`](crate::operation::converse::ConverseOutput::stop_reason): <p>The reason why the model stopped generating output.</p>
    ///   - [`usage(Option<TokenUsage>)`](crate::operation::converse::ConverseOutput::usage): <p>The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the model and the tokens generated by the model.</p>
    ///   - [`metrics(Option<ConverseMetrics>)`](crate::operation::converse::ConverseOutput::metrics): <p>Metrics for the call to <code>Converse</code>.</p>
    ///   - [`additional_model_response_fields(Option<Document>)`](crate::operation::converse::ConverseOutput::additional_model_response_fields): <p>Additional fields in the response that are unique to the model.</p>
    ///   - [`trace(Option<ConverseTrace>)`](crate::operation::converse::ConverseOutput::trace): <p>A trace object that contains information about the Guardrail behavior.</p>
    ///   - [`performance_config(Option<PerformanceConfiguration>)`](crate::operation::converse::ConverseOutput::performance_config): <p>Model performance settings for the request.</p>
    /// - On failure, responds with [`SdkError<ConverseError>`](crate::operation::converse::ConverseError)
    pub fn converse(&self) -> crate::operation::converse::builders::ConverseFluentBuilder {
        crate::operation::converse::builders::ConverseFluentBuilder::new(self.handle.clone())
    }
}
