/* This adds definitions for thread_info api in mach/thread_act.h, generated by:

bindgen /usr/include/mach/thread_act.h \
     --allowlist-function thread_info \
     --allowlist-type thread_.*_info \
     --allowlist-var TH_.*
*/
#![allow(dead_code)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(clippy::useless_transmute)]
#![allow(clippy::default_trait_access)]
#![allow(clippy::cast_lossless)]
#![allow(clippy::trivially_copy_pass_by_ref)]

/* automatically generated by rust-bindgen */

pub const THREAD_STATE_MAX: u32 = 614;
pub const THREAD_STATE_NONE: u32 = 13;
pub const THREAD_MACHINE_STATE_MAX: u32 = 614;
pub const THREAD_STATE_FLAVOR_LIST: u32 = 0;
pub const THREAD_STATE_FLAVOR_LIST_NEW: u32 = 128;
pub const THREAD_STATE_FLAVOR_LIST_10_9: u32 = 129;
pub const THREAD_STATE_FLAVOR_LIST_10_13: u32 = 130;
pub const THREAD_INFO_MAX: u32 = 32;
pub const THREAD_BASIC_INFO: u32 = 3;
pub const THREAD_IDENTIFIER_INFO: u32 = 4;
pub const TH_USAGE_SCALE: u32 = 1000;
pub const TH_STATE_RUNNING: u32 = 1;
pub const TH_STATE_STOPPED: u32 = 2;
pub const TH_STATE_WAITING: u32 = 3;
pub const TH_STATE_UNINTERRUPTIBLE: u32 = 4;
pub const TH_STATE_HALTED: u32 = 5;
pub const TH_FLAGS_SWAPPED: u32 = 1;
pub const TH_FLAGS_IDLE: u32 = 2;
pub const TH_FLAGS_GLOBAL_FORCED_IDLE: u32 = 4;
pub const THREAD_EXTENDED_INFO: u32 = 5;
pub const THREAD_DEBUG_INFO_INTERNAL: u32 = 6;
pub const THREAD_SCHED_TIMESHARE_INFO: u32 = 10;
pub const THREAD_SCHED_RR_INFO: u32 = 11;
pub const THREAD_SCHED_FIFO_INFO: u32 = 12;
pub const THREAD_STANDARD_POLICY: u32 = 1;
pub const THREAD_STANDARD_POLICY_COUNT: u32 = 0;
pub const THREAD_EXTENDED_POLICY: u32 = 1;
pub const THREAD_TIME_CONSTRAINT_POLICY: u32 = 2;
pub const THREAD_PRECEDENCE_POLICY: u32 = 3;
pub const THREAD_AFFINITY_POLICY: u32 = 4;
pub const THREAD_AFFINITY_TAG_NULL: u32 = 0;
pub const THREAD_BACKGROUND_POLICY: u32 = 5;
pub const THREAD_BACKGROUND_POLICY_DARWIN_BG: u32 = 4096;
pub const THREAD_LATENCY_QOS_POLICY: u32 = 7;
pub const THREAD_THROUGHPUT_QOS_POLICY: u32 = 8;
pub const THREAD_KERNEL_PORT: u32 = 1;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type kern_return_t = ::std::os::raw::c_int;
pub type natural_t = __darwin_natural_t;
pub type integer_t = ::std::os::raw::c_int;
pub type mach_port_t = __darwin_mach_port_t;
pub type mach_msg_type_number_t = natural_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct time_value {
    pub seconds: integer_t,
    pub microseconds: integer_t,
}
pub type time_value_t = time_value;
pub type policy_t = ::std::os::raw::c_int;
pub type thread_flavor_t = natural_t;
pub type thread_info_t = *mut integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_basic_info {
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub cpu_usage: integer_t,
    pub policy: policy_t,
    pub run_state: integer_t,
    pub flags: integer_t,
    pub suspend_count: integer_t,
    pub sleep_time: integer_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_identifier_info {
    pub thread_id: u64,
    pub thread_handle: u64,
    pub dispatch_qaddr: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct thread_extended_info {
    pub pth_user_time: u64,
    pub pth_system_time: u64,
    pub pth_cpu_usage: i32,
    pub pth_policy: i32,
    pub pth_run_state: i32,
    pub pth_flags: i32,
    pub pth_sleep_time: i32,
    pub pth_curpri: i32,
    pub pth_priority: i32,
    pub pth_maxpriority: i32,
    pub pth_name: [::std::os::raw::c_char; 64usize],
}
pub type thread_inspect_t = mach_port_t;
extern "C" {
    #[link_name = "\u{1}_thread_info"]
    pub fn thread_info(
        target_act: thread_inspect_t,
        flavor: thread_flavor_t,
        thread_info_out: thread_info_t,
        thread_info_outCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
/* automatically generated by rust-bindgen */

pub const x86_THREAD_STATE64: u32 = 4;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
pub type x86_thread_state64_t = __darwin_x86_thread_state64;
