/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class DataObjectEncodingQueryImplementation
extends FileEncodingQueryImplementation {
    private static ThreadLocal<DataFolder> TARGET = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(DataObjectEncodingQueryImplementation.class.getName());
    private static final Map<String, Boolean> MIME_TYPE_CHECK_MAP = new HashMap<String, Boolean>();

    public static DataFolder enterIgnoreTargetFolder(DataFolder dataFolder) {
        DataFolder dataFolder2 = TARGET.get();
        TARGET.set(dataFolder);
        return dataFolder2;
    }

    public static void exitIgnoreTargetFolder(DataFolder dataFolder) {
        TARGET.set(dataFolder);
    }

    public Charset getEncoding(FileObject fileObject) {
        Comparable<Charset> comparable;
        assert (fileObject != null);
        DataFolder dataFolder = TARGET.get();
        String string = fileObject.getMIMEType();
        FileEncodingQueryImplementation fileEncodingQueryImplementation = (FileEncodingQueryImplementation)MimeLookup.getLookup((String)string).lookup(FileEncodingQueryImplementation.class);
        if (fileEncodingQueryImplementation != null && (comparable = fileEncodingQueryImplementation.getEncoding(fileObject)) != null) {
            return comparable;
        }
        if (dataFolder != null && dataFolder.getPrimaryFile().equals(fileObject.getParent())) {
            return null;
        }
        comparable = MIME_TYPE_CHECK_MAP.get(string);
        if (comparable == null || ((Boolean)comparable).booleanValue() || "content/unknown".equals(string)) {
            DataObject dataObject;
            try {
                dataObject = DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.warning("Invalid DataObject: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return null;
            }
            fileEncodingQueryImplementation = (FileEncodingQueryImplementation)dataObject.getLookup().lookup(FileEncodingQueryImplementation.class);
            if (fileEncodingQueryImplementation != null) {
                MIME_TYPE_CHECK_MAP.put(string, Boolean.TRUE);
                return fileEncodingQueryImplementation.getEncoding(fileObject);
            }
            MIME_TYPE_CHECK_MAP.put(string, Boolean.FALSE);
        }
        return null;
    }
}

