complete -c mksquashfs -o b -d 'Data block size'
complete -c mksquashfs -o comp -d 'Selects the compression scheme' -xa 'gzip lzo lz4 xz zstd lzma'
complete -c mksquashfs -o noI -o noInodeCompression -d 'Do not compress inode table'
complete -c mksquashfs -o noId -o noIdTableCompression -d 'Do not compress the uid/gid table'
complete -c mksquashfs -o noD -o noDataCompression -d 'Do not compress data blocks'
complete -c mksquashfs -o noF -o noFragmentCompression -d 'Do not compress fragment blocks'
complete -c mksquashfs -o noX -o noXattrCompression -d 'Do not compress extended attributes'
complete -c mksquashfs -o no-compression -d 'Do not compress any of the data or metadata'
complete -c mksquashfs -o tar -d 'Read uncompressed tar file from standard in (stdin)'
complete -c mksquashfs -o no-strip -o tarstyle -d 'Act like tar, and do not strip leading directories from source files'
complete -c mksquashfs -o cpiostyle -d 'Act like cpio, and read file pathnames from standard in (stdin)'
complete -c mksquashfs -o cpiostyle0 -d 'Like -cpiostyle, but filenames are null terminated'
complete -c mksquashfs -o reproducible -d 'Build filesystems that are reproducible'
complete -c mksquashfs -o not-reproducible -d 'Build filesystems that are not reproducible'
complete -c mksquashfs -o mkfs-time -o fstime -xd 'Set filesystem creation timestamp'
complete -c mksquashfs -o all-time -xd 'Set all file timestamps'
complete -c mksquashfs -o root-time -xd 'Set root directory time'
complete -c mksquashfs -o root-mode -xd 'Set root directory permissions to octal <mode>'
complete -c mksquashfs -o root-uid -xa '(__fish_complete_user_ids)' -d 'Set root directory owner'
complete -c mksquashfs -o root-gid -xa '(__fish_complete_group_ids)' -d 'Set root directory group'
complete -c mksquashfs -o all-root -o root-owned -d 'Make all files owned by root'
complete -c mksquashfs -o force-uid -xa '(__fish_complete_user_ids)' -d 'Set all file uids'
complete -c mksquashfs -o force-gid -xa '(__fish_complete_group_ids)' -d 'Set all file gids'
complete -c mksquashfs -o pseudo-override -d 'Make pseudo file uids and gids override -all-root, -force-uid and -force-gid options'
complete -c mksquashfs -o no-exports -d 'Do not make filesystem exportable via NFS'
complete -c mksquashfs -o exports -d 'Make filesystem exportable via NFS'
complete -c mksquashfs -o no-sparse -d 'Do not detect sparse files'
complete -c mksquashfs -o no-tailends -d 'Do not pack tail ends into fragments'
complete -c mksquashfs -o tailends -o always-use-fragments -d 'Pack tail ends into fragments'
complete -c mksquashfs -o no-fragments -d 'Do not use fragments'
complete -c mksquashfs -o no-duplicates -d 'Do not perform duplicate checking'
complete -c mksquashfs -o no-hardlinks -d 'Do not hardlink files, instead store duplicates'
complete -c mksquashfs -o keep-as-directory -d 'If one source directory is specified, create a root directory containing that directory, rather than the contents of the directory'
complete -c mksquashfs -o p -xd 'Add pseudo file definition'
complete -c mksquashfs -o pf -rd 'Add list of pseudo file definitions from <pseudo-file>'
complete -c mksquashfs -o sort -rd 'Sort files according to priorities in <sort_file>'
complete -c mksquashfs -o ef -rd 'List of exclude dirs/files'
complete -c mksquashfs -o wildcards -d 'Allow extended shell wildcards (globbing) to be used in exclude dirs/files'
complete -c mksquashfs -o regex -d 'Allow POSIX regular expressions to be used in exclude dirs/files'
complete -c mksquashfs -o max-depth -xd 'Descend at most <levels> of directories when scanning filesystem'
complete -c mksquashfs -o one-file-system -d 'Do not cross filesystem boundaries'
complete -c mksquashfs -o one-file-system-x -d 'Do not cross filesystem boundaries'
complete -c mksquashfs -o no-xattrs -d 'Do not store extended attributes'
complete -c mksquashfs -o xattrs -d 'Store extended attributes'
complete -c mksquashfs -o xattrs-exclude -xd 'Exclude any xattr names matching <regex>'
complete -c mksquashfs -o xattrs-include -xd 'Include any xattr names matching <regex>'
complete -c mksquashfs -o xattrs-add -xd 'Add the xattr <name> with <val> to files'
complete -c mksquashfs -o version -d 'Print version, licence and copyright message'
complete -c mksquashfs -o exit-on-error -d 'Treat normally ignored errors as fatal'
complete -c mksquashfs -o quiet -d 'No verbose output'
complete -c mksquashfs -o info -d 'Print files written to filesystem'
complete -c mksquashfs -o no-progress -d 'Do not display the progress bar'
complete -c mksquashfs -o progress -d 'Display progress bar when using the -info option'
complete -c mksquashfs -o percentage -d 'Display a percentage rather than the full progress bar'
complete -c mksquashfs -o throttle -xd 'Throttle the I/O input rate by the given percentage'
complete -c mksquashfs -o limit -xd 'Limit the I/O input rate to the given percentage'
complete -c mksquashfs -o processors -xd 'Use <number> processors'
complete -c mksquashfs -o mem -xd 'Use <size> physical memory for caches'
complete -c mksquashfs -o mem-percent -xd 'Use <percent> physical memory for caches'
complete -c mksquashfs -o mem-default -d 'Print default memory usage in Mbytes'
complete -c mksquashfs -o noappend -d 'Do not append to existing filesystem'
complete -c mksquashfs -o root-becomes -xd 'When appending source files/directories, make the original root become a subdirectory in the new root called <name>, rather than adding the new source items to the original root'
complete -c mksquashfs -o no-recovery -d 'Do not generate a recovery file'
complete -c mksquashfs -o recovery-path -rd 'Use <name> as the directory to store the recovery file'
complete -c mksquashfs -o recover -rd 'Recover filesystem data using recovery file'
complete -c mksquashfs -o action -xd 'Evaluate <expr> on every file, and execute <action> if it returns TRUE'
complete -c mksquashfs -o log-action -xd 'As -action, but log expression evaluation results and actions performed'
complete -c mksquashfs -o true-action -xd 'As -action, but only log expressions which return TRUE'
complete -c mksquashfs -o false-action -xd 'As -action, but only log expressions which return FALSE'
complete -c mksquashfs -o action-file -rd 'As -action, but read actions from <file>'
complete -c mksquashfs -o log-action-file -rd 'As -log-action, but read actions from <file>'
complete -c mksquashfs -o true-action-file -rd 'As -true-action, but read actions from <f>'
complete -c mksquashfs -o false-action-file -rd 'As -false-action, but read actions from <f>'
complete -c mksquashfs -o default-mode -xd 'Sets the default directory permissions to octal <mode>'
complete -c mksquashfs -o default-uid -xa '(__fish_complete_user_ids)' -d 'Sets the default directory user'
complete -c mksquashfs -o default-gid -xa '(__fish_complete_group_ids)' -d 'Sets the default directory group'
complete -c mksquashfs -o ignore-zeros -d 'Allow tar files to be concatenated together and fed to Mksquashfs'
complete -c mksquashfs -o nopad -d 'Do not pad filesystem to a multiple of 4K'
complete -c mksquashfs -o o -o offset -xd 'Skip <offset> bytes at the beginning of FILESYSTEM'
complete -c mksquashfs -o h -o help -d 'Print help and exit'

complete -c mksquashfs -o Xhelp -d 'Print compressor options for selected compressor'
complete -c mksquashfs -o Xwindow-size -xd 'Window size in range 8 .. 15 (gzip only)'
complete -c mksquashfs -o Xstrategy -xa 'default filtered huffman_only run_length_encoded fixed' -d 'Strategy to use (gzip only)'
complete -c mksquashfs -o Xalgorithm -xa 'lzo1x_1 lzo1x_1_11 lzo1x_1_12 lzo1x_1_15 lzo1x_999' -d 'Algorithm to use (lzo only)'
complete -c mksquashfs -o Xhc -d 'Compress using LZ4 High Compression (lz4 only)'
complete -c mksquashfs -o Xbcj -xa 'x86 arm armthumb powerpc sparc ia64' -d 'Compress using filters in turn and choose the best compression (xz only)'
complete -c mksquashfs -o Xdict-size -xd 'Set xz dictionary size (xz only)'

# Specialize description if compressor name appears in argv. Misdetection is possible.
complete -c mksquashfs -o Xcompression-level -xd 'Compression level setting (lzo, gzip, zstd)'
complete -c mksquashfs -n '__fish_seen_argument lzo' -o Xcompression-level -xd 'Sets compression level for lzo1x_999 algorithm in range 1 .. 9'
complete -c mksquashfs -n '__fish_seen_argument gzip' -o Xcompression-level -xd 'Sets gzip compression level in range 1 .. 9'
complete -c mksquashfs -n '__fish_seen_argument zstd' -o Xcompression-level -xd 'Sets zstd compression level in range 1 .. 22'
