//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctline?language=objc)
#[doc(alias = "CTLineRef")]
#[repr(C)]
pub struct CTLine {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTLine {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTLine"> for CTLine {}
);

/// Options for CTLineGetBoundsWithOptions.
///
///
/// Passing 0 (no options) returns the typographic bounds,
/// including typographic leading and shifts.
///
///
/// Pass this option to exclude typographic leading.
///
///
/// Pass this option to ignore cross-stream shifts due to
/// positioning (such as kerning or baseline alignment).
///
///
/// Normally line bounds include all glyphs; pass this option to
/// treat standard punctuation hanging off either end of the line
/// as fully hanging.
///
///
/// Pass this option to use glyph path bounds rather than the
/// default typographic bounds.
///
///
/// Pass this option to use optical bounds, as determined by
/// CTFontGetOpticalBoundsForGlyphs. This option overrides
/// kCTLineBoundsUseGlyphPathBounds.
///
///
/// Pass this option to include additional space based on common
/// glyph sequences for various languages. The result is intended
/// to be used when drawing to avoid clipping that may be caused
/// by the typographic bounds. This option does not have any effect
/// when used with kCTLineBoundsUseGlyphPathBounds.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctlineboundsoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTLineBoundsOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CTLineBoundsOptions: CFOptionFlags {
        #[doc(alias = "kCTLineBoundsExcludeTypographicLeading")]
        const ExcludeTypographicLeading = 1<<0;
        #[doc(alias = "kCTLineBoundsExcludeTypographicShifts")]
        const ExcludeTypographicShifts = 1<<1;
        #[doc(alias = "kCTLineBoundsUseHangingPunctuation")]
        const UseHangingPunctuation = 1<<2;
        #[doc(alias = "kCTLineBoundsUseGlyphPathBounds")]
        const UseGlyphPathBounds = 1<<3;
        #[doc(alias = "kCTLineBoundsUseOpticalBounds")]
        const UseOpticalBounds = 1<<4;
        #[doc(alias = "kCTLineBoundsIncludeLanguageExtents")]
        const IncludeLanguageExtents = 1<<5;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTLineBoundsOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTLineBoundsOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Truncation types required by CTLineCreateTruncatedLine. These
/// will tell truncation engine which type of truncation is being
/// requested.
///
///
/// Truncate at the beginning of the line, leaving the end portion
/// visible.
///
///
/// Truncate at the end of the line, leaving the start portion
/// visible.
///
///
/// Truncate in the middle of the line, leaving both the start
/// and the end portions visible.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctlinetruncationtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTLineTruncationType(pub u32);
impl CTLineTruncationType {
    #[doc(alias = "kCTLineTruncationStart")]
    pub const Start: Self = Self(0);
    #[doc(alias = "kCTLineTruncationEnd")]
    pub const End: Self = Self(1);
    #[doc(alias = "kCTLineTruncationMiddle")]
    pub const Middle: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTLineTruncationType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTLineTruncationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CTLine {
    /// Returns the CFType of the line object
    #[doc(alias = "CTLineGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTLineGetTypeID() -> CFTypeID;
        }
        unsafe { CTLineGetTypeID() }
    }
}

impl CTLine {
    /// Creates a single immutable line object directly from an
    /// attributed string.
    ///
    ///
    /// This will allow clients who need very simple line generation to
    /// create a line without needing to create a typesetter object. The
    /// typesetting will be done under the hood. Without a typesetter
    /// object, the line cannot be properly broken. However, for simple
    /// things like text labels and other things, this is not an issue.
    ///
    ///
    /// Parameter `attrString`: The attributed string which the line will be created for.
    ///
    ///
    /// Returns: This function will return a reference to a CTLine object.
    #[doc(alias = "CTLineCreateWithAttributedString")]
    #[inline]
    pub unsafe fn with_attributed_string(attr_string: &CFAttributedString) -> CFRetained<CTLine> {
        extern "C-unwind" {
            fn CTLineCreateWithAttributedString(
                attr_string: &CFAttributedString,
            ) -> Option<NonNull<CTLine>>;
        }
        let ret = unsafe { CTLineCreateWithAttributedString(attr_string) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates a truncated line from an existing line.
    ///
    ///
    /// Parameter `line`: The line that you want to create a truncated line for.
    ///
    ///
    /// Parameter `width`: The width at which truncation will begin. The line will be
    /// truncated if its width is greater than the width passed in this.
    ///
    ///
    /// Parameter `truncationType`: The type of truncation to perform if needed.
    ///
    ///
    /// Parameter `truncationToken`: This token will be added to the point where truncation took place
    /// to indicate that the line was truncated. Usually, the truncation
    /// token is the ellipsis character (U+2026). If this parameter is
    /// set to NULL, then no truncation token is used, and the line is
    /// simply cut off. The line specified in truncationToken should have
    /// a width less than the width specified by the width parameter. If
    /// the width of the line specified in truncationToken is greater,
    /// this function will return NULL if truncation is needed.
    ///
    ///
    /// Returns: This function will return a reference to a truncated CTLine
    /// object if the call was successful. Otherwise, it will return
    /// NULL.
    #[doc(alias = "CTLineCreateTruncatedLine")]
    #[inline]
    pub unsafe fn truncated_line(
        &self,
        width: c_double,
        truncation_type: CTLineTruncationType,
        truncation_token: Option<&CTLine>,
    ) -> Option<CFRetained<CTLine>> {
        extern "C-unwind" {
            fn CTLineCreateTruncatedLine(
                line: &CTLine,
                width: c_double,
                truncation_type: CTLineTruncationType,
                truncation_token: Option<&CTLine>,
            ) -> Option<NonNull<CTLine>>;
        }
        let ret =
            unsafe { CTLineCreateTruncatedLine(self, width, truncation_type, truncation_token) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a justified line from an existing line.
    ///
    ///
    /// Parameter `line`: The line that you want to create a justified line for.
    ///
    ///
    /// Parameter `justificationFactor`: Allows for full or partial justification. When set to 1.0 or
    /// greater indicates, full justification will be performed. If less
    /// than 1.0, varying degrees of partial justification will be
    /// performed. If set to 0 or less, then no justification will be
    /// performed.
    ///
    ///
    /// Parameter `justificationWidth`: The width to which the resultant line will be justified. If
    /// justificationWidth is less than the actual width of the line,
    /// then negative justification will be performed ("text squishing").
    ///
    ///
    /// Returns: This function will return a reference to a justified CTLine
    /// object if the call was successful. Otherwise, it will return
    /// NULL.
    #[doc(alias = "CTLineCreateJustifiedLine")]
    #[inline]
    pub unsafe fn justified_line(
        &self,
        justification_factor: CGFloat,
        justification_width: c_double,
    ) -> Option<CFRetained<CTLine>> {
        extern "C-unwind" {
            fn CTLineCreateJustifiedLine(
                line: &CTLine,
                justification_factor: CGFloat,
                justification_width: c_double,
            ) -> Option<NonNull<CTLine>>;
        }
        let ret =
            unsafe { CTLineCreateJustifiedLine(self, justification_factor, justification_width) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the total glyph count for the line object.
    ///
    ///
    /// The total glyph count is equal to the sum of all of the glyphs in
    /// the glyph runs forming the line.
    ///
    ///
    /// Parameter `line`: The line that you want to obtain the glyph count for.
    ///
    ///
    /// Returns: The total glyph count for the line passed in.
    #[doc(alias = "CTLineGetGlyphCount")]
    #[inline]
    pub unsafe fn glyph_count(&self) -> CFIndex {
        extern "C-unwind" {
            fn CTLineGetGlyphCount(line: &CTLine) -> CFIndex;
        }
        unsafe { CTLineGetGlyphCount(self) }
    }

    /// Returns the array of glyph runs that make up the line object.
    ///
    ///
    /// Parameter `line`: The line that you want to obtain the glyph run array for.
    ///
    ///
    /// Returns: A CFArrayRef containing the CTRun objects that make up the line.
    #[doc(alias = "CTLineGetGlyphRuns")]
    #[inline]
    pub unsafe fn glyph_runs(&self) -> CFRetained<CFArray> {
        extern "C-unwind" {
            fn CTLineGetGlyphRuns(line: &CTLine) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTLineGetGlyphRuns(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::retain(ret) }
    }

    /// Gets the range of characters that originally spawned the glyphs
    /// in the line.
    ///
    ///
    /// Parameter `line`: The line that you want to obtain the string range from.
    ///
    ///
    /// Returns: A CFRange that contains the range over the backing store string
    /// that spawned the glyphs. If the function fails for any reason, an
    /// empty range will be returned.
    #[doc(alias = "CTLineGetStringRange")]
    #[inline]
    pub unsafe fn string_range(&self) -> CFRange {
        extern "C-unwind" {
            fn CTLineGetStringRange(line: &CTLine) -> CFRange;
        }
        unsafe { CTLineGetStringRange(self) }
    }

    /// Gets the pen offset required to draw flush text.
    ///
    ///
    /// Parameter `line`: The line that you want to obtain a flush position from.
    ///
    ///
    /// Parameter `flushFactor`: Specifies what kind of flushness you want. A flushFactor of 0 or
    /// less indicates left flush. A flushFactor of 1.0 or more indicates
    /// right flush. Flush factors between 0 and 1.0 indicate varying
    /// degrees of center flush, with a value of 0.5 being totally center
    /// flush.
    ///
    ///
    /// Parameter `flushWidth`: Specifies the width that the flushness operation should apply to.
    ///
    ///
    /// Returns: A value which can be used to offset the current pen position for
    /// the flush operation.
    #[doc(alias = "CTLineGetPenOffsetForFlush")]
    #[inline]
    pub unsafe fn pen_offset_for_flush(
        &self,
        flush_factor: CGFloat,
        flush_width: c_double,
    ) -> c_double {
        extern "C-unwind" {
            fn CTLineGetPenOffsetForFlush(
                line: &CTLine,
                flush_factor: CGFloat,
                flush_width: c_double,
            ) -> c_double;
        }
        unsafe { CTLineGetPenOffsetForFlush(self, flush_factor, flush_width) }
    }

    /// Draws a line.
    ///
    ///
    /// This is a convenience call, since the line could be drawn
    /// run-by-run by getting the glyph runs and accessing the glyphs out
    /// of them. This call may leave the graphics context in any state and
    /// does not flush the context after drawing. This call also expects
    /// a text matrix with `y` values increasing from bottom to top; a
    /// flipped text matrix may result in misplaced diacritics.
    ///
    ///
    /// Parameter `line`: The line that you want to draw.
    ///
    ///
    /// Parameter `context`: The context to which the line will be drawn.
    #[doc(alias = "CTLineDraw")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn draw(&self, context: &CGContext) {
        extern "C-unwind" {
            fn CTLineDraw(line: &CTLine, context: &CGContext);
        }
        unsafe { CTLineDraw(self, context) }
    }

    /// Calculates the typographic bounds for a line.
    ///
    ///
    /// A line's typographic width is the distance to the rightmost
    /// glyph advance width edge. Note that this distance includes
    /// trailing whitespace glyphs.
    ///
    ///
    /// Parameter `line`: The line that you want to calculate the typographic bounds for.
    ///
    ///
    /// Parameter `ascent`: Upon return, this parameter will contain the ascent of the line.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Parameter `descent`: Upon return, this parameter will contain the descent of the line.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Parameter `leading`: Upon return, this parameter will contain the leading of the line.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Returns: The typographic width of the line. If line is invalid, this
    /// function will always return zero.
    ///
    ///
    /// See also: CTLineGetTrailingWhitespaceWidth
    ///
    /// # Safety
    ///
    /// - `ascent` must be a valid pointer or null.
    /// - `descent` must be a valid pointer or null.
    /// - `leading` must be a valid pointer or null.
    #[doc(alias = "CTLineGetTypographicBounds")]
    #[inline]
    pub unsafe fn typographic_bounds(
        &self,
        ascent: *mut CGFloat,
        descent: *mut CGFloat,
        leading: *mut CGFloat,
    ) -> c_double {
        extern "C-unwind" {
            fn CTLineGetTypographicBounds(
                line: &CTLine,
                ascent: *mut CGFloat,
                descent: *mut CGFloat,
                leading: *mut CGFloat,
            ) -> c_double;
        }
        unsafe { CTLineGetTypographicBounds(self, ascent, descent, leading) }
    }

    /// Calculates the bounds for a line.
    ///
    ///
    /// Parameter `line`: The line that you want to calculate the bounds for.
    ///
    ///
    /// Parameter `options`: Desired options or 0 if none.
    ///
    ///
    /// Returns: The bounds of the line as specified by the type and options,
    /// such that the coordinate origin is coincident with the line
    /// origin and the rect origin is at the bottom left. If the line
    /// is invalid this function will return CGRectNull.
    #[doc(alias = "CTLineGetBoundsWithOptions")]
    #[inline]
    pub unsafe fn bounds_with_options(&self, options: CTLineBoundsOptions) -> CGRect {
        extern "C-unwind" {
            fn CTLineGetBoundsWithOptions(line: &CTLine, options: CTLineBoundsOptions) -> CGRect;
        }
        unsafe { CTLineGetBoundsWithOptions(self, options) }
    }

    /// Calculates the trailing whitespace width for a line.
    ///
    ///
    /// Parameter `line`: The line that you want to calculate the trailing whitespace width
    /// for. Creating a line for a width can result in a line that is
    /// actually longer than the desired width due to trailing
    /// whitespace. Normally this is not an issue due to whitespace being
    /// invisible, but this function may be used to determine what amount
    /// of a line's width is due to trailing whitespace.
    ///
    ///
    /// Returns: The width of the line's trailing whitespace. If line is invalid,
    /// this function will always return zero.
    #[doc(alias = "CTLineGetTrailingWhitespaceWidth")]
    #[inline]
    pub unsafe fn trailing_whitespace_width(&self) -> c_double {
        extern "C-unwind" {
            fn CTLineGetTrailingWhitespaceWidth(line: &CTLine) -> c_double;
        }
        unsafe { CTLineGetTrailingWhitespaceWidth(self) }
    }

    /// Calculates the image bounds for a line.
    ///
    ///
    /// The image bounds for a line is the union of all non-empty glyph
    /// bounding rects, each positioned as it would be if drawn using
    /// CTLineDraw using the current context. Note that the result is
    /// ideal and does not account for raster coverage due to rendering.
    /// This function is purely a convenience for using glyphs as an
    /// image and should not be used for typographic purposes.
    ///
    ///
    /// Parameter `line`: The line that you want to calculate the image bounds for.
    ///
    ///
    /// Parameter `context`: The context which the image bounds will be calculated for or NULL,
    /// in which case the bounds are relative to CGPointZero.
    ///
    ///
    /// Returns: A rectangle that tightly encloses the paths of the line's glyphs,
    /// which will be translated by the supplied context's text position.
    /// If the line is invalid, CGRectNull will be returned.
    ///
    ///
    /// See also: CTLineGetTypographicBounds
    ///
    /// See also: CTLineGetBoundsWithOptions
    ///
    /// See also: CTLineGetPenOffsetForFlush
    #[doc(alias = "CTLineGetImageBounds")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn image_bounds(&self, context: Option<&CGContext>) -> CGRect {
        extern "C-unwind" {
            fn CTLineGetImageBounds(line: &CTLine, context: Option<&CGContext>) -> CGRect;
        }
        unsafe { CTLineGetImageBounds(self, context) }
    }

    /// Performs hit testing.
    ///
    ///
    /// This function can be used to determine the string index for a
    /// mouse click or other event. This string index corresponds to the
    /// character before which the next character should be inserted.
    /// This determination is made by analyzing the string from which a
    /// typesetter was created and the corresponding glyphs as embodied
    /// by a particular line.
    ///
    ///
    /// Parameter `line`: The line being examined.
    ///
    ///
    /// Parameter `position`: The location of the mouse click relative to the line's origin.
    ///
    ///
    /// Returns: The string index for the position. Relative to the line's string
    /// range, this value will be no less than the first string index and
    /// no greater than one plus the last string index. In the event of
    /// failure, this function will return kCFNotFound.
    #[doc(alias = "CTLineGetStringIndexForPosition")]
    #[inline]
    pub unsafe fn string_index_for_position(&self, position: CGPoint) -> CFIndex {
        extern "C-unwind" {
            fn CTLineGetStringIndexForPosition(line: &CTLine, position: CGPoint) -> CFIndex;
        }
        unsafe { CTLineGetStringIndexForPosition(self, position) }
    }

    /// Determines the graphical offset(s) for a string index.
    ///
    ///
    /// This function returns the graphical offset(s) corresponding to
    /// a string index, suitable for movement between adjacent lines or
    /// for drawing a custom caret. For the former, the primary offset
    /// may be adjusted for any relative indentation of the two lines;
    /// a CGPoint constructed with the adjusted offset for its x value
    /// and 0.0 for its y value is suitable for passing to
    /// CTLineGetStringIndexForPosition. In either case, the primary
    /// offset corresponds to the portion of the caret that represents
    /// the visual insertion location for a character whose direction
    /// matches the line's writing direction.
    ///
    ///
    /// Parameter `line`: The line from which the offset is requested.
    ///
    ///
    /// Parameter `charIndex`: The string index corresponding to the desired position.
    ///
    ///
    /// Parameter `secondaryOffset`: An output parameter that will be set to the secondary offset
    /// along the baseline for charIndex. When a single caret is
    /// sufficient for a string index, this value will be the same as
    /// the primary offset, which is the return value of this function.
    /// This parameter may be NULL.
    ///
    ///
    /// Returns: The primary offset along the baseline for charIndex, or 0.0 in
    /// the event of failure.
    ///
    /// # Safety
    ///
    /// `secondary_offset` must be a valid pointer or null.
    #[doc(alias = "CTLineGetOffsetForStringIndex")]
    #[inline]
    pub unsafe fn offset_for_string_index(
        &self,
        char_index: CFIndex,
        secondary_offset: *mut CGFloat,
    ) -> CGFloat {
        extern "C-unwind" {
            fn CTLineGetOffsetForStringIndex(
                line: &CTLine,
                char_index: CFIndex,
                secondary_offset: *mut CGFloat,
            ) -> CGFloat;
        }
        unsafe { CTLineGetOffsetForStringIndex(self, char_index, secondary_offset) }
    }

    /// Enumerates caret offsets for characters in a line.
    ///
    ///
    /// The provided block is invoked once for each logical caret edge in the line, in left-to-right visual order.
    ///
    ///
    /// Parameter `block`: The offset parameter is relative to the line origin. The leadingEdge parameter of this block refers to logical order.
    #[doc(alias = "CTLineEnumerateCaretOffsets")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn enumerate_caret_offsets(
        &self,
        block: &block2::DynBlock<dyn Fn(c_double, CFIndex, bool, NonNull<bool>)>,
    ) {
        extern "C-unwind" {
            fn CTLineEnumerateCaretOffsets(
                line: &CTLine,
                block: &block2::DynBlock<dyn Fn(c_double, CFIndex, bool, NonNull<bool>)>,
            );
        }
        unsafe { CTLineEnumerateCaretOffsets(self, block) }
    }
}

#[deprecated = "renamed to `CTLine::with_attributed_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CTLineCreateWithAttributedString(
    attr_string: &CFAttributedString,
) -> CFRetained<CTLine> {
    extern "C-unwind" {
        fn CTLineCreateWithAttributedString(
            attr_string: &CFAttributedString,
        ) -> Option<NonNull<CTLine>>;
    }
    let ret = unsafe { CTLineCreateWithAttributedString(attr_string) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTLine::truncated_line`"]
#[inline]
pub unsafe extern "C-unwind" fn CTLineCreateTruncatedLine(
    line: &CTLine,
    width: c_double,
    truncation_type: CTLineTruncationType,
    truncation_token: Option<&CTLine>,
) -> Option<CFRetained<CTLine>> {
    extern "C-unwind" {
        fn CTLineCreateTruncatedLine(
            line: &CTLine,
            width: c_double,
            truncation_type: CTLineTruncationType,
            truncation_token: Option<&CTLine>,
        ) -> Option<NonNull<CTLine>>;
    }
    let ret = unsafe { CTLineCreateTruncatedLine(line, width, truncation_type, truncation_token) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTLine::justified_line`"]
#[inline]
pub unsafe extern "C-unwind" fn CTLineCreateJustifiedLine(
    line: &CTLine,
    justification_factor: CGFloat,
    justification_width: c_double,
) -> Option<CFRetained<CTLine>> {
    extern "C-unwind" {
        fn CTLineCreateJustifiedLine(
            line: &CTLine,
            justification_factor: CGFloat,
            justification_width: c_double,
        ) -> Option<NonNull<CTLine>>;
    }
    let ret = unsafe { CTLineCreateJustifiedLine(line, justification_factor, justification_width) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::glyph_count`"]
    pub fn CTLineGetGlyphCount(line: &CTLine) -> CFIndex;
}

#[deprecated = "renamed to `CTLine::glyph_runs`"]
#[inline]
pub unsafe extern "C-unwind" fn CTLineGetGlyphRuns(line: &CTLine) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTLineGetGlyphRuns(line: &CTLine) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTLineGetGlyphRuns(line) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::retain(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::string_range`"]
    pub fn CTLineGetStringRange(line: &CTLine) -> CFRange;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::pen_offset_for_flush`"]
    pub fn CTLineGetPenOffsetForFlush(
        line: &CTLine,
        flush_factor: CGFloat,
        flush_width: c_double,
    ) -> c_double;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTLine::draw`"]
    pub fn CTLineDraw(line: &CTLine, context: &CGContext);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::typographic_bounds`"]
    pub fn CTLineGetTypographicBounds(
        line: &CTLine,
        ascent: *mut CGFloat,
        descent: *mut CGFloat,
        leading: *mut CGFloat,
    ) -> c_double;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::bounds_with_options`"]
    pub fn CTLineGetBoundsWithOptions(line: &CTLine, options: CTLineBoundsOptions) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::trailing_whitespace_width`"]
    pub fn CTLineGetTrailingWhitespaceWidth(line: &CTLine) -> c_double;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTLine::image_bounds`"]
    pub fn CTLineGetImageBounds(line: &CTLine, context: Option<&CGContext>) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::string_index_for_position`"]
    pub fn CTLineGetStringIndexForPosition(line: &CTLine, position: CGPoint) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTLine::offset_for_string_index`"]
    pub fn CTLineGetOffsetForStringIndex(
        line: &CTLine,
        char_index: CFIndex,
        secondary_offset: *mut CGFloat,
    ) -> CGFloat;
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `CTLine::enumerate_caret_offsets`"]
    pub fn CTLineEnumerateCaretOffsets(
        line: &CTLine,
        block: &block2::DynBlock<dyn Fn(c_double, CFIndex, bool, NonNull<bool>)>,
    );
}
