// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolAnyValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue{}
		},
	}

	ProtoPoolAnyValue_StringValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_StringValue{}
		},
	}

	ProtoPoolAnyValue_BoolValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_BoolValue{}
		},
	}

	ProtoPoolAnyValue_IntValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_IntValue{}
		},
	}

	ProtoPoolAnyValue_DoubleValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_DoubleValue{}
		},
	}

	ProtoPoolAnyValue_ArrayValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_ArrayValue{}
		},
	}

	ProtoPoolAnyValue_KvlistValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_KvlistValue{}
		},
	}

	ProtoPoolAnyValue_BytesValue = sync.Pool{
		New: func() any {
			return &otlpcommon.AnyValue_BytesValue{}
		},
	}
)

func NewOrigAnyValue() *otlpcommon.AnyValue {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcommon.AnyValue{}
	}
	return protoPoolAnyValue.Get().(*otlpcommon.AnyValue)
}

func DeleteOrigAnyValue(orig *otlpcommon.AnyValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	switch ov := orig.Value.(type) {
	case *otlpcommon.AnyValue_StringValue:
		if UseProtoPooling.IsEnabled() {
			ov.StringValue = ""
			ProtoPoolAnyValue_StringValue.Put(ov)
		}
	case *otlpcommon.AnyValue_BoolValue:
		if UseProtoPooling.IsEnabled() {
			ov.BoolValue = false
			ProtoPoolAnyValue_BoolValue.Put(ov)
		}
	case *otlpcommon.AnyValue_IntValue:
		if UseProtoPooling.IsEnabled() {
			ov.IntValue = int64(0)
			ProtoPoolAnyValue_IntValue.Put(ov)
		}
	case *otlpcommon.AnyValue_DoubleValue:
		if UseProtoPooling.IsEnabled() {
			ov.DoubleValue = float64(0)
			ProtoPoolAnyValue_DoubleValue.Put(ov)
		}
	case *otlpcommon.AnyValue_ArrayValue:
		DeleteOrigArrayValue(ov.ArrayValue, true)
		ov.ArrayValue = nil
		ProtoPoolAnyValue_ArrayValue.Put(ov)
	case *otlpcommon.AnyValue_KvlistValue:
		DeleteOrigKeyValueList(ov.KvlistValue, true)
		ov.KvlistValue = nil
		ProtoPoolAnyValue_KvlistValue.Put(ov)
	case *otlpcommon.AnyValue_BytesValue:
		if UseProtoPooling.IsEnabled() {
			ov.BytesValue = nil
			ProtoPoolAnyValue_BytesValue.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolAnyValue.Put(orig)
	}
}

func CopyOrigAnyValue(dest, src *otlpcommon.AnyValue) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	switch t := src.Value.(type) {
	case *otlpcommon.AnyValue_StringValue:
		var ov *otlpcommon.AnyValue_StringValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_StringValue{}
		} else {
			ov = ProtoPoolAnyValue_StringValue.Get().(*otlpcommon.AnyValue_StringValue)
		}
		ov.StringValue = t.StringValue
		dest.Value = ov
	case *otlpcommon.AnyValue_BoolValue:
		var ov *otlpcommon.AnyValue_BoolValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_BoolValue{}
		} else {
			ov = ProtoPoolAnyValue_BoolValue.Get().(*otlpcommon.AnyValue_BoolValue)
		}
		ov.BoolValue = t.BoolValue
		dest.Value = ov
	case *otlpcommon.AnyValue_IntValue:
		var ov *otlpcommon.AnyValue_IntValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_IntValue{}
		} else {
			ov = ProtoPoolAnyValue_IntValue.Get().(*otlpcommon.AnyValue_IntValue)
		}
		ov.IntValue = t.IntValue
		dest.Value = ov
	case *otlpcommon.AnyValue_DoubleValue:
		var ov *otlpcommon.AnyValue_DoubleValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_DoubleValue{}
		} else {
			ov = ProtoPoolAnyValue_DoubleValue.Get().(*otlpcommon.AnyValue_DoubleValue)
		}
		ov.DoubleValue = t.DoubleValue
		dest.Value = ov
	case *otlpcommon.AnyValue_ArrayValue:
		var ov *otlpcommon.AnyValue_ArrayValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_ArrayValue{}
		} else {
			ov = ProtoPoolAnyValue_ArrayValue.Get().(*otlpcommon.AnyValue_ArrayValue)
		}
		ov.ArrayValue = NewOrigArrayValue()
		CopyOrigArrayValue(ov.ArrayValue, t.ArrayValue)
		dest.Value = ov
	case *otlpcommon.AnyValue_KvlistValue:
		var ov *otlpcommon.AnyValue_KvlistValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_KvlistValue{}
		} else {
			ov = ProtoPoolAnyValue_KvlistValue.Get().(*otlpcommon.AnyValue_KvlistValue)
		}
		ov.KvlistValue = NewOrigKeyValueList()
		CopyOrigKeyValueList(ov.KvlistValue, t.KvlistValue)
		dest.Value = ov
	case *otlpcommon.AnyValue_BytesValue:
		var ov *otlpcommon.AnyValue_BytesValue
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpcommon.AnyValue_BytesValue{}
		} else {
			ov = ProtoPoolAnyValue_BytesValue.Get().(*otlpcommon.AnyValue_BytesValue)
		}
		ov.BytesValue = t.BytesValue
		dest.Value = ov
	}
}

func GenTestOrigAnyValue() *otlpcommon.AnyValue {
	orig := NewOrigAnyValue()
	orig.Value = &otlpcommon.AnyValue_BoolValue{BoolValue: true}
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigAnyValue(orig *otlpcommon.AnyValue, dest *json.Stream) {
	dest.WriteObjectStart()
	switch orig := orig.Value.(type) {
	case *otlpcommon.AnyValue_StringValue:
		dest.WriteObjectField("stringValue")
		dest.WriteString(orig.StringValue)
	case *otlpcommon.AnyValue_BoolValue:
		dest.WriteObjectField("boolValue")
		dest.WriteBool(orig.BoolValue)
	case *otlpcommon.AnyValue_IntValue:
		dest.WriteObjectField("intValue")
		dest.WriteInt64(orig.IntValue)
	case *otlpcommon.AnyValue_DoubleValue:
		dest.WriteObjectField("doubleValue")
		dest.WriteFloat64(orig.DoubleValue)
	case *otlpcommon.AnyValue_ArrayValue:
		if orig.ArrayValue != nil {
			dest.WriteObjectField("arrayValue")
			MarshalJSONOrigArrayValue(orig.ArrayValue, dest)
		}
	case *otlpcommon.AnyValue_KvlistValue:
		if orig.KvlistValue != nil {
			dest.WriteObjectField("kvlistValue")
			MarshalJSONOrigKeyValueList(orig.KvlistValue, dest)
		}
	case *otlpcommon.AnyValue_BytesValue:

		dest.WriteObjectField("bytesValue")
		dest.WriteBytes(orig.BytesValue)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigValue unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigAnyValue(orig *otlpcommon.AnyValue, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {

		case "stringValue", "string_value":
			{
				var ov *otlpcommon.AnyValue_StringValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_StringValue{}
				} else {
					ov = ProtoPoolAnyValue_StringValue.Get().(*otlpcommon.AnyValue_StringValue)
				}
				ov.StringValue = iter.ReadString()
				orig.Value = ov
			}

		case "boolValue", "bool_value":
			{
				var ov *otlpcommon.AnyValue_BoolValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_BoolValue{}
				} else {
					ov = ProtoPoolAnyValue_BoolValue.Get().(*otlpcommon.AnyValue_BoolValue)
				}
				ov.BoolValue = iter.ReadBool()
				orig.Value = ov
			}

		case "intValue", "int_value":
			{
				var ov *otlpcommon.AnyValue_IntValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_IntValue{}
				} else {
					ov = ProtoPoolAnyValue_IntValue.Get().(*otlpcommon.AnyValue_IntValue)
				}
				ov.IntValue = iter.ReadInt64()
				orig.Value = ov
			}

		case "doubleValue", "double_value":
			{
				var ov *otlpcommon.AnyValue_DoubleValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_DoubleValue{}
				} else {
					ov = ProtoPoolAnyValue_DoubleValue.Get().(*otlpcommon.AnyValue_DoubleValue)
				}
				ov.DoubleValue = iter.ReadFloat64()
				orig.Value = ov
			}

		case "arrayValue", "array_value":
			{
				var ov *otlpcommon.AnyValue_ArrayValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_ArrayValue{}
				} else {
					ov = ProtoPoolAnyValue_ArrayValue.Get().(*otlpcommon.AnyValue_ArrayValue)
				}
				ov.ArrayValue = NewOrigArrayValue()
				UnmarshalJSONOrigArrayValue(ov.ArrayValue, iter)
				orig.Value = ov
			}

		case "kvlistValue", "kvlist_value":
			{
				var ov *otlpcommon.AnyValue_KvlistValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_KvlistValue{}
				} else {
					ov = ProtoPoolAnyValue_KvlistValue.Get().(*otlpcommon.AnyValue_KvlistValue)
				}
				ov.KvlistValue = NewOrigKeyValueList()
				UnmarshalJSONOrigKeyValueList(ov.KvlistValue, iter)
				orig.Value = ov
			}

		case "bytesValue", "bytes_value":
			{
				var ov *otlpcommon.AnyValue_BytesValue
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpcommon.AnyValue_BytesValue{}
				} else {
					ov = ProtoPoolAnyValue_BytesValue.Get().(*otlpcommon.AnyValue_BytesValue)
				}
				ov.BytesValue = iter.ReadBytes()
				orig.Value = ov
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigAnyValue(orig *otlpcommon.AnyValue) int {
	var n int
	var l int
	_ = l
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *otlpcommon.AnyValue_StringValue:
		l = len(orig.StringValue)
		n += 1 + proto.Sov(uint64(l)) + l
	case *otlpcommon.AnyValue_BoolValue:
		n += 2
	case *otlpcommon.AnyValue_IntValue:
		n += 1 + proto.Sov(uint64(orig.IntValue))
	case *otlpcommon.AnyValue_DoubleValue:
		n += 9
	case *otlpcommon.AnyValue_ArrayValue:
		l = SizeProtoOrigArrayValue(orig.ArrayValue)
		n += 1 + proto.Sov(uint64(l)) + l
	case *otlpcommon.AnyValue_KvlistValue:
		l = SizeProtoOrigKeyValueList(orig.KvlistValue)
		n += 1 + proto.Sov(uint64(l)) + l
	case *otlpcommon.AnyValue_BytesValue:
		l = len(orig.BytesValue)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigAnyValue(orig *otlpcommon.AnyValue, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	switch orig := orig.Value.(type) {
	case *otlpcommon.AnyValue_StringValue:
		l = len(orig.StringValue)
		pos -= l
		copy(buf[pos:], orig.StringValue)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa

	case *otlpcommon.AnyValue_BoolValue:
		pos--
		if orig.BoolValue {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x10

	case *otlpcommon.AnyValue_IntValue:
		pos = proto.EncodeVarint(buf, pos, uint64(orig.IntValue))
		pos--
		buf[pos] = 0x18

	case *otlpcommon.AnyValue_DoubleValue:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.DoubleValue))
		pos--
		buf[pos] = 0x21

	case *otlpcommon.AnyValue_ArrayValue:

		l = MarshalProtoOrigArrayValue(orig.ArrayValue, buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a

	case *otlpcommon.AnyValue_KvlistValue:

		l = MarshalProtoOrigKeyValueList(orig.KvlistValue, buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32

	case *otlpcommon.AnyValue_BytesValue:
		l = len(orig.BytesValue)
		pos -= l
		copy(buf[pos:], orig.BytesValue)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a

	}
	return len(buf) - pos
}

func UnmarshalProtoOrigAnyValue(orig *otlpcommon.AnyValue, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *otlpcommon.AnyValue_StringValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_StringValue{}
			} else {
				ov = ProtoPoolAnyValue_StringValue.Get().(*otlpcommon.AnyValue_StringValue)
			}
			ov.StringValue = string(buf[startPos:pos])
			orig.Value = ov

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpcommon.AnyValue_BoolValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_BoolValue{}
			} else {
				ov = ProtoPoolAnyValue_BoolValue.Get().(*otlpcommon.AnyValue_BoolValue)
			}
			ov.BoolValue = num != 0
			orig.Value = ov

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpcommon.AnyValue_IntValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_IntValue{}
			} else {
				ov = ProtoPoolAnyValue_IntValue.Get().(*otlpcommon.AnyValue_IntValue)
			}
			ov.IntValue = int64(num)
			orig.Value = ov

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpcommon.AnyValue_DoubleValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_DoubleValue{}
			} else {
				ov = ProtoPoolAnyValue_DoubleValue.Get().(*otlpcommon.AnyValue_DoubleValue)
			}
			ov.DoubleValue = math.Float64frombits(num)
			orig.Value = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ArrayValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *otlpcommon.AnyValue_ArrayValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_ArrayValue{}
			} else {
				ov = ProtoPoolAnyValue_ArrayValue.Get().(*otlpcommon.AnyValue_ArrayValue)
			}
			ov.ArrayValue = NewOrigArrayValue()
			err = UnmarshalProtoOrigArrayValue(ov.ArrayValue, buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field KvlistValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *otlpcommon.AnyValue_KvlistValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_KvlistValue{}
			} else {
				ov = ProtoPoolAnyValue_KvlistValue.Get().(*otlpcommon.AnyValue_KvlistValue)
			}
			ov.KvlistValue = NewOrigKeyValueList()
			err = UnmarshalProtoOrigKeyValueList(ov.KvlistValue, buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Value = ov

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *otlpcommon.AnyValue_BytesValue
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpcommon.AnyValue_BytesValue{}
			} else {
				ov = ProtoPoolAnyValue_BytesValue.Get().(*otlpcommon.AnyValue_BytesValue)
			}
			if length != 0 {
				ov.BytesValue = make([]byte, length)
				copy(ov.BytesValue, buf[startPos:pos])
			}
			orig.Value = ov
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
