# glossaries-prefix package
# Matthew Bertucci 2025/10/17 for v4.8

#include:glossaries

#keyvals:\usepackage/glossaries-prefix#c
nowarn
nolangwarn
noredefwarn
translate=#true,false,babel
notranslate
languages=%<language%>
nolong
nosuper
nolist
notree
nostyles
makeindex
xindy
xindy={%<options%>}
xindygloss
xindynoglsnumbers
acronym#true,false
acronyms
debug=#false,true,showtargets,showaccsupp
savewrites#true,false
hyperfirst#true,false
writeglslabels
writeglslabelnames
toc#true,false
numberline#true,false
section=%<section unit%>
ucmark#true,false
numberedsection=#false,nolabel,autolabel
savenumberlist#true,false
entrycounter#true,false
counterwithin=%<counter%>
subentrycounter#true,false
style=%<style-name%>
nonumberlist
seeautonumberlist
counter=%<counter%>
nopostdot#true,false
nogroupskip#true,false
seenoindex=#error,warn,ignore
esclocations#true,false
indexonlyfirst#true,false
sanitizesort#true,false
sort=#none,clear,def,use,standard
order=#word,letter
automake=#false,delayed,immediate,makegloss,lite
automakegloss
automakeglosslite
disablemakegloss
restoremakegloss
nohypertypes={%<list%>}
symbols
numbers
index
noglossaryindex
acronymlists={%<label-list%>}
shortcuts#true,false
mfirstuc=#expanded,unexpanded
kernelglossredefs=#false,true,nowarn
#endkeyvals

## need same options as glossaries
#ifOption:translate
#include:translator
#include:tracklang
#endif
#ifOption:translate=true
#include:translator
#include:tracklang
#endif
#ifOption:translate=babel
#include:glossaries-babel
#endif

#ifOption:symbols
\printsymbols
\printsymbols[options%keyvals]
#endif

#ifOption:numbers
\printnumbers
\printnumbers[options%keyvals]
#endif

#ifOption:index
\newterm{gls-label%specialDef}#s#%gls-label
\newterm[options%keyvals]{gls-label%specialDef}#s#%gls-label
\printindex
\printindex[options%keyvals]
#endif

#ifOption:acronym
\printacronyms
\printacronyms[options%keyvals]
#endif
#ifOption:acronym=true
\printacronyms
\printacronyms[options%keyvals]
#endif
#ifOption:acronyms
\printacronyms
\printacronyms[options%keyvals]
#endif

#ifOption:shortcuts
\acs{gls-label%special}
\acs[options%keyvals]{gls-label%special}
\acs{gls-label%special}[insert]#*
\acs[options%keyvals]{gls-label%special}[insert]#*
\acs*{gls-label%special}#S
\acs*[options%keyvals]{gls-label%special}#S
\acs*{gls-label%special}[insert]#S
\acs*[options%keyvals]{gls-label%special}[insert]#S
\acs+{gls-label%special}#S
\acs+[options%keyvals]{gls-label%special}#S
\acs+{gls-label%special}[insert]#S
\acs+[options%keyvals]{gls-label%special}[insert]#S
\Acs{gls-label%special}
\Acs[options%keyvals]{gls-label%special}
\Acs{gls-label%special}[insert]#*
\Acs[options%keyvals]{gls-label%special}[insert]#*
\Acs*{gls-label%special}#S
\Acs*[options%keyvals]{gls-label%special}#S
\Acs*{gls-label%special}[insert]#S
\Acs*[options%keyvals]{gls-label%special}[insert]#S
\Acs+{gls-label%special}#S
\Acs+[options%keyvals]{gls-label%special}#S
\Acs+{gls-label%special}[insert]#S
\Acs+[options%keyvals]{gls-label%special}[insert]#S
\acsp{gls-label%special}#*
\acsp[options%keyvals]{gls-label%special}#*
\acsp{gls-label%special}[insert]#*
\acsp[options%keyvals]{gls-label%special}[insert]#*
\acsp*{gls-label%special}#S
\acsp*[options%keyvals]{gls-label%special}#S
\acsp*{gls-label%special}[insert]#S
\acsp*[options%keyvals]{gls-label%special}[insert]#S
\acsp+{gls-label%special}#S
\acsp+[options%keyvals]{gls-label%special}#S
\acsp+{gls-label%special}[insert]#S
\acsp+[options%keyvals]{gls-label%special}[insert]#S
\Acsp{gls-label%special}#*
\Acsp[options%keyvals]{gls-label%special}#*
\Acsp{gls-label%special}[insert]#*
\Acsp[options%keyvals]{gls-label%special}[insert]#*
\Acsp*{gls-label%special}#S
\Acsp*[options%keyvals]{gls-label%special}#S
\Acsp*{gls-label%special}[insert]#S
\Acsp*[options%keyvals]{gls-label%special}[insert]#S
\Acsp+{gls-label%special}#S
\Acsp+[options%keyvals]{gls-label%special}#S
\Acsp+{gls-label%special}[insert]#S
\Acsp+[options%keyvals]{gls-label%special}[insert]#S
\acl{gls-label%special}
\acl[options%keyvals]{gls-label%special}
\acl{gls-label%special}[insert]#*
\acl[options%keyvals]{gls-label%special}[insert]#*
\acl*{gls-label%special}#S
\acl*[options%keyvals]{gls-label%special}#S
\acl*{gls-label%special}[insert]#S
\acl*[options%keyvals]{gls-label%special}[insert]#S
\acl+{gls-label%special}#S
\acl+[options%keyvals]{gls-label%special}#S
\acl+{gls-label%special}[insert]#S
\acl+[options%keyvals]{gls-label%special}[insert]#S
\Acl{gls-label%special}
\Acl[options%keyvals]{gls-label%special}
\Acl{gls-label%special}[insert]#*
\Acl[options%keyvals]{gls-label%special}[insert]#*
\Acl*{gls-label%special}#S
\Acl*[options%keyvals]{gls-label%special}#S
\Acl*{gls-label%special}[insert]#S
\Acl*[options%keyvals]{gls-label%special}[insert]#S
\Acl+{gls-label%special}#S
\Acl+[options%keyvals]{gls-label%special}#S
\Acl+{gls-label%special}[insert]#S
\Acl+[options%keyvals]{gls-label%special}[insert]#S
\aclp{gls-label%special}#*
\aclp[options%keyvals]{gls-label%special}#*
\aclp{gls-label%special}[insert]#*
\aclp[options%keyvals]{gls-label%special}[insert]#*
\aclp*{gls-label%special}#S
\aclp*[options%keyvals]{gls-label%special}#S
\aclp*{gls-label%special}[insert]#S
\aclp*[options%keyvals]{gls-label%special}[insert]#S
\aclp+{gls-label%special}#S
\aclp+[options%keyvals]{gls-label%special}#S
\aclp+{gls-label%special}[insert]#S
\aclp+[options%keyvals]{gls-label%special}[insert]#S
\Aclp{gls-label%special}#*
\Aclp[options%keyvals]{gls-label%special}#*
\Aclp{gls-label%special}[insert]#*
\Aclp[options%keyvals]{gls-label%special}[insert]#*
\Aclp*{gls-label%special}#S
\Aclp*[options%keyvals]{gls-label%special}#S
\Aclp*{gls-label%special}[insert]#S
\Aclp*[options%keyvals]{gls-label%special}[insert]#S
\Aclp+{gls-label%special}#S
\Aclp+[options%keyvals]{gls-label%special}#S
\Aclp+{gls-label%special}[insert]#S
\Aclp+[options%keyvals]{gls-label%special}[insert]#S
\acf{gls-label%special}
\acf[options%keyvals]{gls-label%special}
\acf{gls-label%special}[insert]#*
\acf[options%keyvals]{gls-label%special}[insert]#*
\acf*{gls-label%special}#S
\acf*[options%keyvals]{gls-label%special}#S
\acf*{gls-label%special}[insert]#S
\acf*[options%keyvals]{gls-label%special}[insert]#S
\acf+{gls-label%special}#S
\acf+[options%keyvals]{gls-label%special}#S
\acf+{gls-label%special}[insert]#S
\acf+[options%keyvals]{gls-label%special}[insert]#S
\Acf{gls-label%special}
\Acf[options%keyvals]{gls-label%special}
\Acf{gls-label%special}[insert]#*
\Acf[options%keyvals]{gls-label%special}[insert]#*
\Acf*{gls-label%special}#S
\Acf*[options%keyvals]{gls-label%special}#S
\Acf*{gls-label%special}[insert]#S
\Acf*[options%keyvals]{gls-label%special}[insert]#S
\Acf+{gls-label%special}#S
\Acf+[options%keyvals]{gls-label%special}#S
\Acf+{gls-label%special}[insert]#S
\Acf+[options%keyvals]{gls-label%special}[insert]#S
\acfp{gls-label%special}#*
\acfp[options%keyvals]{gls-label%special}#*
\acfp{gls-label%special}[insert]#*
\acfp[options%keyvals]{gls-label%special}[insert]#*
\acfp*{gls-label%special}#S
\acfp*[options%keyvals]{gls-label%special}#S
\acfp*{gls-label%special}[insert]#S
\acfp*[options%keyvals]{gls-label%special}[insert]#S
\acfp+{gls-label%special}#S
\acfp+[options%keyvals]{gls-label%special}#S
\acfp+{gls-label%special}[insert]#S
\acfp+[options%keyvals]{gls-label%special}[insert]#S
\Acfp{gls-label%special}#*
\Acfp[options%keyvals]{gls-label%special}#*
\Acfp{gls-label%special}[insert]#*
\Acfp[options%keyvals]{gls-label%special}[insert]#*
\Acfp*{gls-label%special}#S
\Acfp*[options%keyvals]{gls-label%special}#S
\Acfp*{gls-label%special}[insert]#S
\Acfp*[options%keyvals]{gls-label%special}[insert]#S
\Acfp+{gls-label%special}#S
\Acfp+[options%keyvals]{gls-label%special}#S
\Acfp+{gls-label%special}[insert]#S
\Acfp+[options%keyvals]{gls-label%special}[insert]#S
\ac{gls-label%special}
\ac[options%keyvals]{gls-label%special}
\ac{gls-label%special}[insert]#*
\ac[options%keyvals]{gls-label%special}[insert]#*
\Ac{gls-label%special}
\Ac[options%keyvals]{gls-label%special}
\Ac{gls-label%special}[insert]#*
\Ac[options%keyvals]{gls-label%special}[insert]#*
\ac*{gls-label%special}#S
\ac*[options%keyvals]{gls-label%special}#S
\ac*{gls-label%special}[insert]#S
\ac*[options%keyvals]{gls-label%special}[insert]#S
\Ac*{gls-label%special}#S
\Ac*[options%keyvals]{gls-label%special}#S
\Ac*{gls-label%special}[insert]#S
\Ac*[options%keyvals]{gls-label%special}[insert]#S
\ac+{gls-label%special}#S
\ac+[options%keyvals]{gls-label%special}#S
\ac+{gls-label%special}[insert]#S
\ac+[options%keyvals]{gls-label%special}[insert]#S
\Ac+{gls-label%special}#S
\Ac+[options%keyvals]{gls-label%special}#S
\Ac+{gls-label%special}[insert]#S
\Ac+[options%keyvals]{gls-label%special}[insert]#S
\acp{gls-label%special}
\acp[options%keyvals]{gls-label%special}
\acp{gls-label%special}[insert]#*
\acp[options%keyvals]{gls-label%special}[insert]#*
\Acp{gls-label%special}
\Acp[options%keyvals]{gls-label%special}
\Acp{gls-label%special}[insert]#*
\Acp[options%keyvals]{gls-label%special}[insert]#*
\acp*{gls-label%special}#S
\acp*[options%keyvals]{gls-label%special}#S
\acp*{gls-label%special}[insert]#S
\acp*[options%keyvals]{gls-label%special}[insert]#S
\Acp*{gls-label%special}#S
\Acp*[options%keyvals]{gls-label%special}#S
\Acp*{gls-label%special}[insert]#S
\Acp*[options%keyvals]{gls-label%special}[insert]#S
\acp+{gls-label%special}#S
\acp+[options%keyvals]{gls-label%special}#S
\acp+{gls-label%special}[insert]#S
\acp+[options%keyvals]{gls-label%special}[insert]#S
\Acp+{gls-label%special}#S
\Acp+[options%keyvals]{gls-label%special}#S
\Acp+{gls-label%special}[insert]#S
\Acp+[options%keyvals]{gls-label%special}[insert]#S
#endif

#ifOption:xindy
## Required Styles ##
\GlsAddXdyStyle{style-name}
\GlsSetXdyStyles{style name list}
## Language and Encodings ##
\GlsSetXdyLanguage{language}
\GlsSetXdyLanguage[glossary-type]{language}
\GlsSetXdyCodePage{codepage}
## Locations and Number lists ##
\GlsAddXdyCounters{counter list}
\GlsAddXdyAttribute{name}
\GlsAddXdyLocation{name}{definition}
\GlsAddXdyLocation[H-prefix]{name}{definition}
\GlsSetXdyLocationClassOrder{location names}
\GlsSetXdyMinRangeLength{integer}
## Glossary Groups ##
\GlsSetXdyFirstLetterAfterDigits{letter}
\GlsSetXdyNumberGroupOrder{relative location}
## other
\GlsAddLetterGroup{name}{xindy code}#*
\GlsAddSortRule{arg1}{arg2}#*
\GlsAddXdyAlphabet{name}{definition}#*
#endif

#keyvals:\newglossaryentry#c,\longnewglossaryentry#c,\provideglossaryentry#c,\longprovideglossaryentry#c,\newacronym#c,\newterm#c,\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
prefix=%<text%>
prefixplural=%<text%>
prefixfirst=%<text%>
prefixfirstplural=%<text%>
#endkeyvals

\glsprefixsep#*

\pgls{gls-label%special}
\pgls[options%keyvals]{gls-label%special}
\pgls{gls-label%special}[insert]#*
\pgls[options%keyvals]{gls-label%special}[insert]#*
\Pgls{gls-label%special}
\Pgls[options%keyvals]{gls-label%special}
\Pgls{gls-label%special}[insert]#*
\Pgls[options%keyvals]{gls-label%special}[insert]#*
\PGLS{gls-label%special}
\PGLS[options%keyvals]{gls-label%special}
\PGLS{gls-label%special}[insert]#*
\PGLS[options%keyvals]{gls-label%special}[insert]#*
\pgls*{gls-label%special}#S
\pgls*[options]{gls-label%special}#S
\pgls*{gls-label%special}[insert]#S
\pgls*[options]{gls-label%special}[insert]#S
\Pgls*{gls-label%special}#S
\Pgls*[options]{gls-label%special}#S
\Pgls*{gls-label%special}[insert]#S
\Pgls*[options]{gls-label%special}[insert]#S
\PGLS*{gls-label%special}#S
\PGLS*[options]{gls-label%special}#S
\PGLS*{gls-label%special}[insert]#S
\PGLS*[options]{gls-label%special}[insert]#S
\pgls+{gls-label%special}#S
\pgls+[options]{gls-label%special}#S
\pgls+{gls-label%special}[insert]#S
\pgls+[options]{gls-label%special}[insert]#S
\Pgls+{gls-label%special}#S
\Pgls+[options]{gls-label%special}#S
\Pgls+{gls-label%special}[insert]#S
\Pgls+[options]{gls-label%special}[insert]#S
\PGLS+{gls-label%special}#S
\PGLS+[options]{gls-label%special}#S
\PGLS+{gls-label%special}[insert]#S
\PGLS+[options]{gls-label%special}[insert]#S

\pglspl{gls-label%special}
\pglspl[options%keyvals]{gls-label%special}
\pglspl{gls-label%special}[insert]#*
\pglspl[options%keyvals]{gls-label%special}[insert]#*
\Pglspl{gls-label%special}
\Pglspl[options%keyvals]{gls-label%special}
\Pglspl{gls-label%special}[insert]#*
\Pglspl[options%keyvals]{gls-label%special}[insert]#*
\PGLSpl{gls-label%special}
\PGLSpl[options%keyvals]{gls-label%special}
\PGLSpl{gls-label%special}[insert]#*
\PGLSpl[options%keyvals]{gls-label%special}[insert]#*
\pglspl*{gls-label%special}#S
\pglspl*[options%keyvals]{gls-label%special}#S
\pglspl*{gls-label%special}[insert]#S
\pglspl*[options%keyvals]{gls-label%special}[insert]#S
\Pglspl*{gls-label%special}#S
\Pglspl*[options%keyvals]{gls-label%special}#S
\Pglspl*{gls-label%special}[insert]#S
\Pglspl*[options%keyvals]{gls-label%special}[insert]#S
\PGLSpl*{gls-label%special}#S
\PGLSpl*[options%keyvals]{gls-label%special}#S
\PGLSpl*{gls-label%special}[insert]#S
\PGLSpl*[options%keyvals]{gls-label%special}[insert]#S
\pglspl+{gls-label%special}#S
\pglspl+[options%keyvals]{gls-label%special}#S
\pglspl+{gls-label%special}[insert]#S
\pglspl+[options%keyvals]{gls-label%special}[insert]#S
\Pglspl+{gls-label%special}#S
\Pglspl+[options%keyvals]{gls-label%special}#S
\Pglspl+{gls-label%special}[insert]#S
\Pglspl+[options%keyvals]{gls-label%special}[insert]#S
\PGLSpl+{gls-label%special}#S
\PGLSpl+[options%keyvals]{gls-label%special}#S
\PGLSpl+{gls-label%special}[insert]#S
\PGLSpl+[options%keyvals]{gls-label%special}[insert]#S

#keyvals:\pgls#c,\Pgls#c,\PGLS#c,\pglspl#c,\Pglspl#c,\PGLSpl#c
hyper#true,false
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

#keyvals:\pgls*#c,\pgls+#c,\Pgls*#c,\Pgls+#c,\PGLS*#c,\PGLS+#c,\pglspl*#c,\pglspl+#c,\Pglspl*#c,\Pglspl+#c,\PGLSpl*#c,\PGLSpl+#c
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

\ifglshasprefix{gls-label%special}{true}{false}#*
\ifglshasprefixplural{gls-label%special}{true}{false}#*
\ifglshasprefixfirst{gls-label%special}{true}{false}#*
\ifglshasprefixfirstplural{gls-label%special}{true}{false}#*

\glsentryprefix{gls-label%special}#*
\glsentryprefixfirst{gls-label%special}#*
\glsentryprefixplural{gls-label%special}#*
\glsentryprefixfirstplural{gls-label%special}#*
\Glsentryprefix{gls-label%special}#*
\Glsentryprefixfirst{gls-label%special}#*
\Glsentryprefixplural{gls-label%special}#*
\Glsentryprefixfirstplural{gls-label%special}#*
