package imageaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScanText invokes the imageaudit.ScanText API synchronously
func (client *Client) ScanText(request *ScanTextRequest) (response *ScanTextResponse, err error) {
	response = CreateScanTextResponse()
	err = client.DoAction(request, response)
	return
}

// ScanTextWithChan invokes the imageaudit.ScanText API asynchronously
func (client *Client) ScanTextWithChan(request *ScanTextRequest) (<-chan *ScanTextResponse, <-chan error) {
	responseChan := make(chan *ScanTextResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScanText(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScanTextWithCallback invokes the imageaudit.ScanText API asynchronously
func (client *Client) ScanTextWithCallback(request *ScanTextRequest, callback func(response *ScanTextResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScanTextResponse
		var err error
		defer close(result)
		response, err = client.ScanText(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScanTextRequest is the request struct for api ScanText
type ScanTextRequest struct {
	*requests.RpcRequest
	Labels *[]ScanTextLabels `position:"Body" name:"Labels"  type:"Repeated"`
	Tasks  *[]ScanTextTasks  `position:"Body" name:"Tasks"  type:"Repeated"`
}

// ScanTextLabels is a repeated param struct in ScanTextRequest
type ScanTextLabels struct {
	Label string `name:"Label"`
}

// ScanTextTasks is a repeated param struct in ScanTextRequest
type ScanTextTasks struct {
	Content string `name:"Content"`
}

// ScanTextResponse is the response struct for api ScanText
type ScanTextResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScanTextRequest creates a request to invoke ScanText API
func CreateScanTextRequest() (request *ScanTextRequest) {
	request = &ScanTextRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageaudit", "2019-12-30", "ScanText", "imageaudit", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScanTextResponse creates a response to parse from ScanText response
func CreateScanTextResponse() (response *ScanTextResponse) {
	response = &ScanTextResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
