package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetManualDagInstances invokes the dataworks_public.GetManualDagInstances API synchronously
func (client *Client) GetManualDagInstances(request *GetManualDagInstancesRequest) (response *GetManualDagInstancesResponse, err error) {
	response = CreateGetManualDagInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// GetManualDagInstancesWithChan invokes the dataworks_public.GetManualDagInstances API asynchronously
func (client *Client) GetManualDagInstancesWithChan(request *GetManualDagInstancesRequest) (<-chan *GetManualDagInstancesResponse, <-chan error) {
	responseChan := make(chan *GetManualDagInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetManualDagInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetManualDagInstancesWithCallback invokes the dataworks_public.GetManualDagInstances API asynchronously
func (client *Client) GetManualDagInstancesWithCallback(request *GetManualDagInstancesRequest, callback func(response *GetManualDagInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetManualDagInstancesResponse
		var err error
		defer close(result)
		response, err = client.GetManualDagInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetManualDagInstancesRequest is the request struct for api GetManualDagInstances
type GetManualDagInstancesRequest struct {
	*requests.RpcRequest
	ProjectEnv  string `position:"Body" name:"ProjectEnv"`
	ProjectName string `position:"Body" name:"ProjectName"`
	DagId       string `position:"Body" name:"DagId"`
}

// GetManualDagInstancesResponse is the response struct for api GetManualDagInstances
type GetManualDagInstancesResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Instances []InstancesItem `json:"Instances" xml:"Instances"`
}

// CreateGetManualDagInstancesRequest creates a request to invoke GetManualDagInstances API
func CreateGetManualDagInstancesRequest() (request *GetManualDagInstancesRequest) {
	request = &GetManualDagInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetManualDagInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateGetManualDagInstancesResponse creates a response to parse from GetManualDagInstances response
func CreateGetManualDagInstancesResponse() (response *GetManualDagInstancesResponse) {
	response = &GetManualDagInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
