package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTitleGenerate invokes the alimt.GetTitleGenerate API synchronously
func (client *Client) GetTitleGenerate(request *GetTitleGenerateRequest) (response *GetTitleGenerateResponse, err error) {
	response = CreateGetTitleGenerateResponse()
	err = client.DoAction(request, response)
	return
}

// GetTitleGenerateWithChan invokes the alimt.GetTitleGenerate API asynchronously
func (client *Client) GetTitleGenerateWithChan(request *GetTitleGenerateRequest) (<-chan *GetTitleGenerateResponse, <-chan error) {
	responseChan := make(chan *GetTitleGenerateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTitleGenerate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTitleGenerateWithCallback invokes the alimt.GetTitleGenerate API asynchronously
func (client *Client) GetTitleGenerateWithCallback(request *GetTitleGenerateRequest, callback func(response *GetTitleGenerateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTitleGenerateResponse
		var err error
		defer close(result)
		response, err = client.GetTitleGenerate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTitleGenerateRequest is the request struct for api GetTitleGenerate
type GetTitleGenerateRequest struct {
	*requests.RpcRequest
	Language   string `position:"Body" name:"Language"`
	Title      string `position:"Body" name:"Title"`
	Platform   string `position:"Body" name:"Platform"`
	Extra      string `position:"Body" name:"Extra"`
	Attributes string `position:"Body" name:"Attributes"`
	HotWords   string `position:"Body" name:"HotWords"`
	CategoryId string `position:"Body" name:"CategoryId"`
}

// GetTitleGenerateResponse is the response struct for api GetTitleGenerate
type GetTitleGenerateResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetTitleGenerateRequest creates a request to invoke GetTitleGenerate API
func CreateGetTitleGenerateRequest() (request *GetTitleGenerateRequest) {
	request = &GetTitleGenerateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "GetTitleGenerate", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTitleGenerateResponse creates a response to parse from GetTitleGenerate response
func CreateGetTitleGenerateResponse() (response *GetTitleGenerateResponse) {
	response = &GetTitleGenerateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
