/* Calf DSP Library
 * A knob (dial) widget.
 *
 * Copyright (C) 2008-2010 Krzysztof Foltman, Torben Hohn, Markus
 * Schmidt and others
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA 02111-1307, USA.
 */

#ifndef CALF_CTL_KNOB_H
#define CALF_CTL_KNOB_H

#include <gtk/gtk.h>
#include <vector>
#include <calf/gui.h>

G_BEGIN_DECLS

#define CALF_TYPE_KNOB          (calf_knob_get_type())
#define CALF_KNOB(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALF_TYPE_KNOB, CalfKnob))
#define CALF_IS_KNOB(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALF_TYPE_KNOB))
#define CALF_KNOB_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass),  CALF_TYPE_KNOB, CalfKnobClass))
#define CALF_IS_KNOB_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CALF_TYPE_KNOB))

struct CalfKnob
{
    static const unsigned int debug = 0;
    GtkRange parent;
    int type;
    int size;
    double start_x, start_y, last_y, start_value, default_value;
    std::vector<double> ticks;
    GdkPixbuf *knob_image;
};

struct CalfKnobClass
{
    GtkRangeClass parent_class;
};

extern GtkWidget *calf_knob_new();
extern GtkWidget *calf_knob_new_with_adjustment(GtkAdjustment *_adjustment);
extern void calf_knob_set_size (CalfKnob*self, int size);
extern void calf_knob_set_pixbuf (CalfKnob*self, GdkPixbuf *pixbuf);

extern GType calf_knob_get_type();

G_END_DECLS

#endif
