# $Id: various.sed $
## @file
# Converts some C header elements into nasm/yasm syntax.
#
# This is used by 'incs' in /Maintenance.kmk (/Makefile.kmk) as well as the VMM
# for IEM headers.
#

#
# Copyright (C) 2006-2025 Oracle and/or its affiliates.
#
# This file is part of VirtualBox base platform packages, as
# available from https://www.virtualbox.org.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, in version 3 of the
# License.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <https://www.gnu.org/licenses>.
#
# The contents of this file may alternatively be used under the terms
# of the Common Development and Distribution License Version 1.0
# (CDDL), a copy of it is provided in the "COPYING.CDDL" file included
# in the VirtualBox distribution, in which case the provisions of the
# CDDL are applicable instead of those of the GPL.
#
# You may elect to license modified versions of this file under the
# terms and conditions of either the GPL or the CDDL or both.
#
# SPDX-License-Identifier: GPL-3.0-only OR CDDL-1.0
#

# Convert \r\n -> \n if running a windows checkout with unix tools (IEM).
s/[\r]$//

# Pass thru the file header and copyright.
1,/^\#ifndef/{
/^\#ifndef/b next
s/^[/ ]//
s/^\*\//;/
s/\*/;/g
4s/^.*$/; Automatically generated by various.sed.  DO NOT EDIT!/
b end
}
:next

# Check for block markers (typically in comments).
/ASM-NOINC-START/,/ASM-NOINC-END/ {
    d
}

# Newline escapes.
:check-newline-escape
/\\$/!bno-more-newline-escapes
N
s/[\r]$//
b check-newline-escape
:no-more-newline-escapes

# Check for line markers (typically in comments).
/ASM-INC/basm-inc
/ASM-NOINC/basm-noinc

# Save the original line in the hold space for error reporting.
h

# Strip comments.
/\/\*/!b strip_cpp_style_comment
:load_another_c_style_comment_line
/\*\//b strip_c_style_comment
N
s/[\r]$//
b load_another_c_style_comment_line
:strip_c_style_comment
s/\/\*.*\*\// /g

:strip_cpp_style_comment
s,//.*$, ,g

# Strip trailing spaces
s/[[:space:]][[:space:]]*$//g

# Try identify the statement.
/#[[:space:]]*define[[:space:]]/bdefine
/#[[:space:]]*ifdef[[:space:]]/bifdef
/#[[:space:]]*ifndef[[:space:]]/bifndef
/#[[:space:]]*if[[:space:]]/bif
/#[[:space:]]*elif[[:space:]]/belif
/#[[:space:]]*else$/belse
/#[[:space:]]*endif$/bendif

# Not recognized, drop it.
:asm-noinc
d
b end

#
# Defines needs some extra massaging to work in yasm.
# Things like trailing type indicators ('U', 'ULL' ++) does not go down well.
#
:define
/\$/d
s/#\([[:space:]]*\)define/\1%define/

s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)U$/\1/
s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)U\([[:space:]]*\))$/\1\2)/
s/\([[:space:]][0-9][0-9]*\)U[[:space:]]*$/\1/
s/\([[:space:]][0-9][0-9]*\)U\([[:space:]]*\))$/\1\2)/

s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)UL$/\1/
s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)UL\([[:space:]]*\))$/\1\2)/
s/\([[:space:]][0-9][0-9]*\)UL[[:space:]]*$/\1/
s/\([[:space:]][0-9][0-9]*\)UL\([[:space:]]*\))$/\1\2)/

s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)ULL$/\1/
s/\([[:space:]]0[xX][0-9a-fA-F][0-9a-fA-F]*\)ULL\([[:space:]]*\))$/\1\2)/
s/\([[:space:]][0-9][0-9]*\)ULL[[:space:]]*$/\1/
s/\([[:space:]][0-9][0-9]*\)ULL\([[:space:]]*\))$/\1\2)/

s/UINT64_C([[:space:]]*\(0[xX][0-9a-fA-F][0-9a-fA-F]*\)[[:space:]]*)/\1/
s/UINT64_C([[:space:]]*\([0-9][0-9]*\)[[:space:]]*)/\1/
s/UINT32_C([[:space:]]*\(0[xX][0-9a-fA-F][0-9a-fA-F]*\)[[:space:]]*)/\1/
s/UINT32_C([[:space:]]*\([0-9][0-9]*\)[[:space:]]*)/\1/
s/UINT16_C([[:space:]]*\(0[xX][0-9a-fA-F][0-9a-fA-F]*\)[[:space:]]*)/\1/
s/UINT16_C([[:space:]]*\([0-9][0-9]*\)[[:space:]]*)/\1/
s/UINT8_C([[:space:]]*\(0[xX][0-9a-fA-F][0-9a-fA-F]*\)[[:space:]]*)/\1/
s/UINT8_C([[:space:]]*\([0-9][0-9]*\)[[:space:]]*)/\1/

b end

#
# Conditional statements, 1:1.
#
:ifdef
s/#\([[:space:]]*\)ifdef/\1%ifdef/
b end


:ifndef
s/#\([[:space:]]*\)ifndef/\1%ifndef/
b end


:if
s/#\([[:space:]]*\)if/\1%if/

# Replace 'defined(DOXYGEN_RUNNING)' with '0' to simplify subsequent matching to '[0]' when we mean 'defined[(]DOXYGEN_RUNNING[)]'.
s/defined[(]DOXYGEN_RUNNING[)]/0/

# Simplify stuff that was turned into '0' in the previous step (or in the input file).
s/||[[:space:]]*0[[:space:]]*$//g
s/||[[:space:]]*0\([[:space:]|&]\)/\1/g
s/\([[:space:]|&]\)0[[:space:]]*||/\1/g
s/[[:space:]][[:space:]]*$//

# Convert #if [!]defined(xxxx) into %if[n]def xxxx
s/%if[[:space:]][[:space:]]*defined[(]\([^)][^)]*\)[)]$/%ifdef \1/
s/%if[[:space:]][[:space:]]*[!][[:space:]]*defined[(]\([^)][^)]*\)[)]$/%ifndef \1/

# Convert '#if ... && 0' and '#if 0 && ...' to %if 0
s/%if[[:space:]].*&&[[:space:]]*00*$/%if 0/
s/%if[[:space:]][[:space:]]*00*[[:space:]]*&&$/%if 0/

# Convert '#if ... || 1' and '#if 1 || ...' to '%if 1'
s/%if[[:space:]].*||[[:space:]]*1[0-9]*$/%if 1/
s/%if[[:space:]][[:space:]]*1[0-9]*[[:space:]]*||$/%if 1/

/defined/b defined_error
b end


:elif
s/#\([[:space:]]*\)elif/\1%elif/

# Replace 'defined(DOXYGEN_RUNNING)' with '0' to simplify subsequent matching to '[0]' when we mean 'defined[(]DOXYGEN_RUNNING[)]'.
s/defined[(]DOXYGEN_RUNNING[)]/0/

# Simplify stuff that was turned into '0' in the previous step (or in the input file).
s/||[[:space:]]*0[[:space:]]*$//g
s/||[[:space:]]*0\([[:space:]|&]\)/\1/g
s/\([[:space:]|&]\)0[[:space:]]*||/\1/g
s/[[:space:]][[:space:]]*$//

# Convert #if [!]defined(xxxx) into %if[n]def xxxx
s/%elif[[:space:]][[:space:]]*defined[(]\([^)][^)]*\)[)]$/%elifdef \1/
s/%elif[[:space:]][[:space:]]*[!][[:space:]]*defined[(]\([^)][^)]*\)[)]$/%elifndef \1/

# Convert '#elif ... && 0' and '#elif 0 && ...' to '%elif 0'
s/%elif[[:space:]].*&&[[:space:]]*00*$/%elif 0/
s/%elif[[:space:]][[:space:]]*00*[[:space:]]*&&$/%elif 0/

# Convert '#elif ... || 1' and '#elif 1 || ...' to '%elif 1'
s/%elif[[:space:]].*||[[:space:]]*1[0-9]*$/%elif 1/
s/%elif[[:space:]][[:space:]]*1[0-9]*[[:space:]]*||$/%elif 1/

/defined/b defined_error
b end


:else
s/#\([[:space:]]*\)else.*$/\1%else/
b end


:endif
s/#\([[:space:]]*\)endif.*$/\1%endif/
b end


:defined_error
x
s/^/error: yasm & nasm does not grok 'defined': /
p
x
s/^/info: state: /
q1


#
# Assembly statement inside a C-style comment.
#
:asm-inc
/\/\*[[:space:]]*ASM-INC:.*\*\//b asm-inc-c-style-oneliner
/\/\/[[:space:]]*ASM-INC:/b asm-inc-cpp-style-oneliner
/\/\*[[:space:]]*ASM-INC/b asm-inc-c-style-block
s/^/error: unknown ASM-INC form: /
q1

# /* ASM-INC: %include "whatever.mac" */
:asm-inc-c-style-oneliner
s/[[:space:]]*\/\*[[:space:]][[:space:]]*ASM-INC:[[:space:]]*\(.*\)[[:space:]]*\*\//\1/
b end

# // ASM-INC: %include "whatever.mac"
:asm-inc-cpp-style-oneliner
s/[[:space:]]*\/\/[[:space:]][[:space:]]*ASM-INC:[[:space:]]*\(.*\)[[:space:]]*$/\1/
b end

# /* ASM-INC
# %include "whatever.mac"
# */
:asm-inc-c-style-block
s/.*$//
:asm-inc-c-style-block-next
h
N
s/[\r]$//
/\*\//!b asm-inc-c-style-block-next
x
b end


:end

