/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.sdef.StringField;

class DateField
extends StringField {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("ddMMMyy"));

    public DateField(String name) {
        super(name, 7);
    }

    @Override
    public Object read(String line, int offset) {
        Date result;
        String value = (String)super.read(line, offset);
        if (value == null || value.isEmpty()) {
            result = null;
        } else {
            try {
                result = DATE_FORMAT.get().parse(value);
            }
            catch (ParseException e) {
                result = null;
            }
        }
        return result;
    }
}

