;; Tests for i16x8 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i16x8.add_sat_s") (param v128 v128) (result v128) (i16x8.add_sat_s (local.get 0) (local.get 1)))
  (func (export "i16x8.add_sat_u") (param v128 v128) (result v128) (i16x8.add_sat_u (local.get 0) (local.get 1)))
  (func (export "i16x8.sub_sat_s") (param v128 v128) (result v128) (i16x8.sub_sat_s (local.get 0) (local.get 1)))
  (func (export "i16x8.sub_sat_u") (param v128 v128) (result v128) (i16x8.sub_sat_u (local.get 0) (local.get 1)))
)


;; i16x8.add_sat_s
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i16x8 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i16x8 0x01 0xff81 0x01 0xff81 0x01 0xff81 0x01 0xff81))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i16x8 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i16x8 0x01 0xffc1 0x01 0xffc1 0x01 0xffc1 0x01 0xffc1))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 2 4 6 8 10 12 14))
                                         (v128.const i16x8 0 3 6 9 12 15 18 21))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 032_123 032_123 032_123 032_123 032_123 032_123 032_123 032_123))
                                         (v128.const i16x8 032_767 032_767 032_767 032_767 032_767 032_767 032_767 032_767))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                         (v128.const i16x8 03_598 03_598 03_598 03_598 03_598 03_598 03_598 03_598))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                         (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678))
                                         (v128.const i16x8 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac))
(assert_return (invoke "i16x8.add_sat_s" (v128.const i16x8 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB)
                                         (v128.const i16x8 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef))
                                         (v128.const i16x8 -0x0_8000 -0x0_8000 -0x0_8000 -0x0_8000 -0x0_8000 -0x0_8000 -0x0_8000 -0x0_8000))

;; i16x8.add_sat_u
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32769 32769 32769 32769 32769 32769 32769 32769))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 65534 65534 65534 65534 65534 65534 65534 65534))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                         (v128.const i16x8 65534 65534 65534 65534 65534 65534 65534 65534))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i16x8 0x8000 0xffff 0x8000 0xffff 0x8000 0xffff 0x8000 0xffff))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i16x8 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i16x8 0x01 0xff81 0x01 0xff81 0x01 0xff81 0x01 0xff81))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i16x8 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i16x8 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                         (v128.const i16x8 0 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 2 4 6 8 10 12 14))
                                         (v128.const i16x8 0 3 6 9 12 15 18 21))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                         (v128.const i16x8 065_535 065_535 065_535 065_535 065_535 065_535 065_535 065_535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345))
                                         (v128.const i16x8 065_535 065_535 065_535 065_535 065_535 065_535 065_535 065_535))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                         (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678))
                                         (v128.const i16x8 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac))
(assert_return (invoke "i16x8.add_sat_u" (v128.const i16x8 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB)
                                         (v128.const i16x8 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef))
                                         (v128.const i16x8 0x0_ffff 0x0_ffff 0x0_ffff 0x0_ffff 0x0_ffff 0x0_ffff 0x0_ffff 0x0_ffff))

;; i16x8.sub_sat_s
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32764 32764 32764 32764 32764 32764 32764 32764))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32765 -32765 -32765 -32765 -32765 -32765 -32765 -32765))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i16x8 0x8000 0 0x8000 0 0x8000 0 0x8000 0))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i16x8 0x01 0x8081 0x01 0x8081 0x01 0x8081 0x01 0x8081))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i16x8 0x01 0x81 0x01 0x81 0x01 0x81 0x01 0x81))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i16x8 0x01 0x8041 0x01 0x8041 0x01 0x8041 0x01 0x8041))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i16x8 0x01 0x41 0x01 0x41 0x01 0x41 0x01 0x41))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                         (v128.const i16x8 0 2 4 6 8 10 12 14))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 2 4 6 8 10 12 14))
                                         (v128.const i16x8 0 -1 -2 -3 -4 -5 -6 -7))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                         (v128.const i16x8 021_092 021_092 021_092 021_092 021_092 021_092 021_092 021_092))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345 -012_345))
                                         (v128.const i16x8 024_690 024_690 024_690 024_690 024_690 024_690 024_690 024_690))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                         (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678))
                                         (v128.const i16x8 0x0_bbbc 0x0_bbbc 0x0_bbbc 0x0_bbbc 0x0_bbbc 0x0_bbbc 0x0_bbbc 0x0_bbbc))
(assert_return (invoke "i16x8.sub_sat_s" (v128.const i16x8 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB)
                                         (v128.const i16x8 -0x1234 -0x1234 -0x1234 -0x1234 -0x1234 -0x1234 -0x1234 -0x1234))
                                         (v128.const i16x8 0xa2df 0xa2df 0xa2df 0xa2df 0xa2df 0xa2df 0xa2df 0xa2df))

;; i16x8.sub_sat_u
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                         (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                         (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32764 32764 32764 32764 32764 32764 32764 32764))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 65534 65534 65534 65534 65534 65534 65534 65534))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                         (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                         (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                         (v128.const i16x8 65534 65534 65534 65534 65534 65534 65534 65534))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                         (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                         (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                         (v128.const i16x8 0x8000 0 0x8000 0 0x8000 0 0x8000 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 +inf +inf +inf +inf))
                                         (v128.const i16x8 0x01 0 0x01 0 0x01 0 0x01 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -inf -inf -inf -inf))
                                         (v128.const i16x8 0x01 0 0x01 0 0x01 0 0x01 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 nan nan nan nan))
                                         (v128.const i16x8 0x01 0 0x01 0 0x01 0 0x01 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                         (v128.const f32x4 -nan -nan -nan -nan))
                                         (v128.const i16x8 0x01 0 0x01 0 0x01 0 0x01 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                         (v128.const i16x8 0 2 4 6 8 10 12 14))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                         (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789)
                                         (v128.const i16x8 -12_345 -12_345 -12_345 -12_345 -12_345 -12_345 -12_345 -12_345))
                                         (v128.const i16x8 03_598 03_598 03_598 03_598 03_598 03_598 03_598 03_598))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                         (v128.const i16x8 -0x0_5678 -0x0_5678 -0x0_5678 -0x0_5678 -0x0_5678 -0x0_5678 -0x0_5678 -0x0_5678))
                                         (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub_sat_u" (v128.const i16x8 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef)
                                         (v128.const i16x8 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB))
                                         (v128.const i16x8 0x0_3d44 0x0_3d44 0x0_3d44 0x0_3d44 0x0_3d44 0x0_3d44 0x0_3d44 0x0_3d44))

;; Malformed cases: non-existent op names
(assert_malformed (module quote
    "(func (result v128) (i16x8.add_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.sub_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.mul_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.div_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2)))")
    "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (i16x8.add_sat_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.add_sat_u (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.sub_sat_s (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.sub_sat_u (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.add_sat_s-1st-arg-empty (result v128)
      (i16x8.add_sat_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.add_sat_s-arg-empty (result v128)
      (i16x8.add_sat_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.add_sat_u-1st-arg-empty (result v128)
      (i16x8.add_sat_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.add_sat_u-arg-empty (result v128)
      (i16x8.add_sat_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub_sat_s-1st-arg-empty (result v128)
      (i16x8.sub_sat_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub_sat_s-arg-empty (result v128)
      (i16x8.sub_sat_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub_sat_u-1st-arg-empty (result v128)
      (i16x8.sub_sat_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub_sat_u-arg-empty (result v128)
      (i16x8.sub_sat_u)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "sat-add_s-sub_s") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-sub_u") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_s") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_u") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-neg") (param v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-add_u-neg") (param v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_s-neg") (param v128 v128) (result v128)
    (i16x8.sub_sat_s (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_u-neg") (param v128 v128) (result v128)
    (i16x8.sub_sat_u (i16x8.neg (local.get 0)) (local.get 1)))
)

(assert_return (invoke "sat-add_s-sub_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "sat-add_s-sub_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                         (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "sat-add_u-sub_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                         (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                         (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                         (v128.const i16x8 65534 65534 65534 65534 65534 65534 65534 65534))
(assert_return (invoke "sat-add_u-sub_u" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                         (v128.const i16x8 0 0 0 0 0 0 0 0)
                                         (v128.const i16x8 1 1 1 1 1 1 1 1))
                                         (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "sat-add_s-neg" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                       (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                       (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "sat-add_u-neg" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                       (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                       (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
(assert_return (invoke "sat-sub_s-neg" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                       (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                       (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "sat-sub_u-neg" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                       (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                       (v128.const i16x8 1 1 1 1 1 1 1 1))