/*========================== begin_copyright_notice ============================

Copyright (C) 2023-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_metric_sets_MTL_GT3.cpp
//
//     Abstract:   C++ automated generated file that defines Metric Sets
//                 for each Concurrent Group

#include "md_concurrent_group.h"
#include "md_metric_set.h"
#include "md_metric_sets_MTL_GT3.h"
#include "md_information.h"
#include "md_metric.h"
#include "md_utils.h"
#include <algorithm>

#if MD_INCLUDE_MTL_GT3_METRICS

namespace MetricsDiscoveryInternal::MetricSets_MTL_GT3_PipelineStatistics
{
    CPipelineStatsMetricSet::CPipelineStatsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CPipelineStatsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "", 0, 0, 0x80000206, 0, 0, "", 0, "Intel_Raw_Pipeline_Statistics_Query", 0 ) );

        metric = AddMetric( "IAVertices", "Input vertices",
            "The total number of vertices that entered the 3D Pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "vertices", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );

        metric = AddMetric( "IAPrimitives", "Input primitives",
            "The total number of rendering primitives assembled and put into the input assembly stage of the 3D Pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );

        metric = AddMetric( "VsInvocations", "VS per vertex invocations",
            "The total number of times a vertex shader was invoked. 3D rendering invokes the vertex shader once per vertex.",
            "3D Pipe/Vertex Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_VS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );

        metric = AddMetric( "HsInvocations", "HS invocations",
            "The total number of times a hull shader was invoked.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );

        metric = AddMetric( "DsInvocations", "DS invocations",
            "The total number of times a domain shader was invoked.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );

        metric = AddMetric( "GsInvocations", "GS per triangle invocations",
            "The total number of times a geometry shader was invoked per triangle.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );

        metric = AddMetric( "GsPrimitives", "Post-GS primitives",
            "The total number of primitives that flowed through from GS to the clipper if GS was enabled.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );

        metric = AddMetric( "ClipperInvocations", "Clipper invocations",
            "The total number of primitives sent to the Clipper.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );

        metric = AddMetric( "ClipperPrimitives", "Clipper primitives",
            "The total number of primitives that flowed out of the Clipper.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );

        metric = AddMetric( "PsInvocations", "PS invocations",
            "The total number of times a pixel shader was invoked. 3D rendering invokes a pixel shader once per pixel or subsample.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );

        metric = AddMetric( "CsInvocations", "CS invocations",
            "The total number of times a compute shader was invoked.",
            "3D Pipe/Compute Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );

        metric = AddMetric( "CpsInvocations", "CPS invocations",
            "The total number of times a coarse shader was invoked.",
            "3D Pipe/Compute Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );

        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

} // namespace MetricsDiscoveryInternal::MetricSets_MTL_GT3_PipelineStatistics

namespace MetricsDiscoveryInternal::MetricSets_MTL_GT3_OA
{
    TCompletionCode AddInformationSet( CConcurrentGroup* concurrentGroup )
    {
        CInformation* information = nullptr;

        information = concurrentGroup->AddInformation( "QueryBeginTime", "Query Begin Time", "The measurement begin time.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_TIMESTAMP, "ns", nullptr, 0 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x1c0" ) );
        MD_CHECK_CC( information->SetOverflowFunction( "NS_TIME" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyMHz", "GPU Core Frequency", "The last GPU core (unslice) frequency in the measurement.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 1 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 0x1ff AND 16666 UMUL 1000 UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x218 1000000 UDIV" ) );

        information = concurrentGroup->AddInformation( "XveSliceFrequencyMHz", "XVE Slice Frequency", "The last GPU Vector Engine Unit slice frequency in the measurement.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 2 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 25 >> dw@0x0 9 >> 0x3 AND OR 16666 UMUL 1000 UDIV" ) );

        information = concurrentGroup->AddInformation( "ReportReason", "Report Reason", "The reason of the report.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_REPORT_REASON, nullptr, nullptr, 3 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 19 >> 0x7f AND" ) );

        information = concurrentGroup->AddInformation( "ContextIdValid", "Context ID Valid", "When set indicates render context is valid", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_FLAG, nullptr, nullptr, 4 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 16 >> 0x1 AND" ) );

        information = concurrentGroup->AddInformation( "ContextId", "Context ID", "The context tag in which report has been taken.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_CONTEXT_ID_TAG, nullptr, nullptr, 5 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 0xfc7fffbf AND dw@0x0 16 >> 0x1 AND UMUL" ) );

        information = concurrentGroup->AddInformation( "SourceId", "SourceId", "SourceId", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 6 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 26 >> 0x3f AND" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyChanged", "GPU Core Frequency Changed", "The flag indicating that GPU core frequency has changed.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 7 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x214" ) );

        information = concurrentGroup->AddInformation( "QuerySplitOccurred", "Query Split Occurred", "The flag indicating that query has been split during execution on the GPU.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 8 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x210" ) );

        information = concurrentGroup->AddInformation( "ReportId", "Query report id", "Query report identification number.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 9 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x220" ) );

        information = concurrentGroup->AddInformation( "ReportsCount", "Query reports count", "The number of available query reports.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 10 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x224" ) );

        information = concurrentGroup->AddInformation( "OverrunOccured", "Query Overrun Occurred", "The flag indicating that Oa buffer has been overran.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 11 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1dc" ) );

        information = concurrentGroup->AddInformation( "MidQueryTimer", "Mid Query Timer", "The flag indicating that timer report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 12 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryProgramming", "Mid Query Programming", "The flag indicating that counter programming report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 13 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMarker", "Mid Query Marker", "The flag indicating that query marker report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 14 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x04 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryCtxSwitch", "Mid Query Context Switch", "The flag indicating that context switch report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 15 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryC6", "Mid Query C6", "The flag indicating that C6 report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 16 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryFreqChange", "Mid Query Freq Change", "The flag indicating that frequency change report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 17 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMmioTrigger", "Mid Query Mmio Trigger", "The flag indicating that mmio trigger report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 18 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x40 AND" ) );

        information = concurrentGroup->AddInformation( "StreamMarker", "Stream marker", "Stream marker value.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 19 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 dw@0x0 19 >> 0x8 AND 0x0 == UMUL" ) );

        information = concurrentGroup->AddInformation( "ReportError", "Query report error", "An error in the query execution, the received report should be ignored.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 20 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x33 AND" ) );

        information = concurrentGroup->AddInformation( "ReportLost", "Query report lost", "Begin or end query report has not been triggered due to hw limitations.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 21 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "ReportInconsistent", "Query report inconsistent", "The contextId inconsistency in the Oa buffer within the query window.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 22 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "ReportCtxSwitchLost", "Query report context switch lost", "Other contexts activity is not filter out from the query report.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 23 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "ReportWithoutWorkload", "Query report missing workload", "Missing workload between query begin and query end.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 24 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "ReportContextMismatch", "Query report context mismatch", "Contexts on query begin and query end are different.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 25 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "ReportQueryNotExecuted", "Query report not executed", "Begin or end query report was not executed.", "Report Meta Data", API_TYPE_DX12 | API_TYPE_VULKAN, INFORMATION_TYPE_FLAG, nullptr, nullptr, 26 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x04 AND" ) );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRenderBasicMetricSet::CRenderBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRenderBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuEmActive", "EM And FPU Pipes Active",
            "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsFpuActive", "VS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsEmActive", "VS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsSendActive", "VS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsFpuActive", "PS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsEmActive", "PS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsSendActive", "PS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "RasterizedPixels", "Rasterized Pixels",
            "The total number of rasterized pixels.",
            "3D Pipe/Rasterizer", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,pixel|fragment", "oa.fixed", 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x64:0xb5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xb8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HiDepthTestFails", "Early Hi-Depth Test Fails",
            "The total number of pixels dropped on early hierarchical depth test.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x68:0xb6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "EarlyDepthTestFails", "Early Depth Test Fails",
            "The total number of pixels dropped on early depth test.",
            "3D Pipe/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x6c:0xb7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplesKilledInPs", "Samples Killed in PS",
            "The total number of samples or pixels dropped in pixel shaders.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x70" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "PixelsFailingPostPsTests", "Pixels Failing Tests",
            "The total number of pixels dropped on post-PS alpha, stencil, or depth tests.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x74" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesWritten", "Samples Written",
            "The total number of samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x78" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesBlended", "Samples Blended",
            "The total number of blended samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x7c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplerTexels", "Sampler Texels",
            "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
            "Sampler/Sampler Input", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_IN * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x80:0xbc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplerTexelMisses", "Sampler Texels Misses",
            "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
            "Sampler/Sampler Cache", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_CACHE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_BATCH | USAGE_FLAG_FRAME | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 28 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x84:0xbd" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SlmReads", "SLM Bytes Read",
            "The total number of reads from shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 29 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x88:0xbe" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x100" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "SlmWrites", "SLM Writes",
            "The total number of writes into shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 30 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x8c:0xbf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x108" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "ShaderMemoryAccesses", "Shader Memory Accesses",
            "The total number of shader memory accesses to L3.",
            "L3/Data Port", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 31 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x90" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x110" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderAtomics", "Shader Atomic Memory Accesses",
            "The total number of shader atomic memory accesses.",
            "L3/Data Port/Atomics", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_ATOMICS * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 32 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderBarriers", "Shader Barrier Messages",
            "The total number of shader barrier messages.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 33 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GtiReadThroughput", "GTI Read Throughput",
            "The total number of GPU memory bytes read from GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 34 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "GtiWriteThroughput", "GTI Write Throughput",
            "The total number of GPU memory bytes written to GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 35 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "SamplersBusy", "Samplers Busy",
            "The percentage of time in which samplers or L1 cache are not idle.",
            "Sampler", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtXeCoreMask 1 AND", nullptr, nullptr, 36 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SamplerBottleneck", "Samplers Bottleneck",
            "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.",
            "Sampler", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_INDICATE | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_SLICE, "$GtXeCoreMask 1 AND", nullptr, nullptr, 37 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20042800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04042000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14040800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16040037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02085000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000bc000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0209a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aa000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00003008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00011010, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00050012, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00052051, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeBasicMetricSet::CComputeBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "FpuActive", "XVE FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "EmActive", "EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XmxActive", "XMX Pipe Active",
            "The percentage of time in which XVE XMX pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuEmActive", "EM And FPU Pipes Active",
            "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuXmxActive", "XMX And FPU Pipes Active",
            "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveAvgIpcRate", "XVE AVG IPC Rate",
            "The average rate of IPC calculated for 2 FPU pipelines.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_RATIO, RESULT_FLOAT, "number", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XveFpuEmActive $FpuActive $EmActive FADD $EmActive FSUB FDIV 1 FADD" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "2" ) );

        metric = AddMetric( "SendActive", "Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x4c:0xaf FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x88 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt16", "FPU FLT16 Instruction",
            "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt32", "FPU FLT32 Instruction",
            "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x54:0xb1" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x98" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt64", "FPU FLT64 Instruction",
            "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x58:0xb2" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "RasterizedPixels", "Rasterized Pixels",
            "The total number of rasterized pixels.",
            "3D Pipe/Rasterizer", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,pixel|fragment", "oa.fixed", 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x64:0xb5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xb8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HiDepthTestFails", "Early Hi-Depth Test Fails",
            "The total number of pixels dropped on early hierarchical depth test.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x68:0xb6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "EarlyDepthTestFails", "Early Depth Test Fails",
            "The total number of pixels dropped on early depth test.",
            "3D Pipe/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x6c:0xb7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplesKilledInPs", "Samples Killed in PS",
            "The total number of samples or pixels dropped in pixel shaders.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x70" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "PixelsFailingPostPsTests", "Pixels Failing Tests",
            "The total number of pixels dropped on post-PS alpha, stencil, or depth tests.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x74" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesWritten", "Samples Written",
            "The total number of samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 28 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x78" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesBlended", "Samples Blended",
            "The total number of blended samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 29 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x7c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplerTexels", "Sampler Texels",
            "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
            "Sampler/Sampler Input", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_IN * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 30 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x80:0xbc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplerTexelMisses", "Sampler Texels Misses",
            "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
            "Sampler/Sampler Cache", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_CACHE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_BATCH | USAGE_FLAG_FRAME | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 31 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x84:0xbd" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SlmReads", "SLM Bytes Read",
            "The total number of reads from shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 32 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x88:0xbe" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x100" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "SlmWrites", "SLM Writes",
            "The total number of writes into shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 33 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x8c:0xbf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x108" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "ShaderMemoryAccesses", "Shader Memory Accesses",
            "The total number of shader memory accesses to L3.",
            "L3/Data Port", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 34 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x90" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x110" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderAtomics", "Shader Atomic Memory Accesses",
            "The total number of shader atomic memory accesses.",
            "L3/Data Port/Atomics", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_ATOMICS * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 35 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderBarriers", "Shader Barrier Messages",
            "The total number of shader barrier messages.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 36 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GtiReadThroughput", "GTI Read Throughput",
            "The total number of GPU memory bytes read from GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 37 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "GtiWriteThroughput", "GTI Write Throughput",
            "The total number of GPU memory bytes written to GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 38 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00001000, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00003009, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x0000200a, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00006008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe55c, 0x0000b007, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CAsyncComputeMetricSet::CAsyncComputeMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CAsyncComputeMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "FpuActive", "XVE FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsFpuActive", "VS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsFpuActive", "PS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsFpuActive", "CS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "AsyncCsFpuActive", "ASYNC CS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "EmActive", "EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsEmActive", "VS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsEmActive", "PS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsEmActive", "CS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "AsyncCsEmActive", "ASYNC CS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x54:0xb1 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x98 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x58:0xb2" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x5c:0xb3" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00010000, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00060050, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00001090, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00051011, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00091061, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe55c, 0x00004008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe65c, 0x00000005, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CXveActivityMetricSet::CXveActivityMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CXveActivityMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HsFpuActive", "HS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsFpuActive", "DS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsFpuActive", "GS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HsEmActive", "HS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsEmActive", "DS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsEmActive", "GS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HsSendActive", "HS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsSendActive", "DS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsSendActive", "GS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsSendActive", "CS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00030020, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00021040, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00041031, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00032022, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00062042, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CGpuBusynessMetricSet::CGpuBusynessMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CGpuBusynessMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "RenderBusy", "Render Ring Busy",
            "The percentage of time when render command streamer was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ComputeEngine0Busy", "ComputeEngine0 Ring Busy",
            "The percentage of time when compute command streamer 0 was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "BlitterBusy", "Blitter Ring Busy",
            "The percentage of time when blitter command streamer was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18022400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c012400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26010009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011409, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16010100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18010014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CHDCAndSF1MetricSet::CHDCAndSF1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CHDCAndSF1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader00AccessStalledOnL3", "Slice0 Xe Core0 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core0)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader01AccessStalledOnL3", "Slice0 Xe Core1 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core1)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader02AccessStalledOnL3", "Slice0 Xe Core2 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core2)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader03AccessStalledOnL3", "Slice0 Xe Core3 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core3)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Poly0DataReady", "Polygon (Slice0) Data Ready",
            "The percentage of time in which geometry pipeline output is ready",
            "GPU/3D Pipe/Strip-Fans", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c023800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c223800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c423800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c623800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0209c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a220027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00280040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x084209c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08620027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b6400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010171, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040141, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b4e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000902c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a02a2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000202ae, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010155, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000302aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fffd, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fffb, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CHDCAndSF2MetricSet::CHDCAndSF2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CHDCAndSF2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader10AccessStalledOnL3", "Slice1 Xe Core0 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core0)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader11AccessStalledOnL3", "Slice1 Xe Core1 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core1)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader12AccessStalledOnL3", "Slice1 Xe Core2 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core2)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader13AccessStalledOnL3", "Slice1 Xe Core3 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core3)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Poly1DataReady", "Polygon (Slice1) Data Ready",
            "The percentage of time in which geometry pipeline output is ready",
            "GPU/3D Pipe/Strip-Fans", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c823800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ca23800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc23800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce23800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a820027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08a209c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c20027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e24e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b6400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0021015c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b09c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002900b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a02a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008202ab, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010155, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030155, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fffd, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fffb, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL3MetricSet::CL3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK0", "L3 Input Available L3bank0",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK1", "L3 Input Available L3bank1",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK2", "L3 Input Available L3bank2",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK3", "L3 Input Available L3bank3",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK4", "L3 Input Available L3bank4",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK5", "L3 Input Available L3bank5",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK6", "L3 Input Available L3bank6",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK7", "L3 Input Available L3bank7",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK0", "L3 Output Ready L3bank0",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK1", "L3 Output Ready L3bank1",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK2", "L3 Output Ready L3bank2",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK3", "L3 Output Ready L3bank3",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK4", "L3 Output Ready L3bank4",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK5", "L3 Output Ready L3bank5",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK6", "L3 Output Ready L3bank6",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK7", "L3 Output Ready L3bank7",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09010007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05210180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07610180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b6101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00012b1a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010163, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f8101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11810006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11a10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04814693, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRasterizerAndPixelBackend1MetricSet::CRasterizerAndPixelBackend1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRasterizerAndPixelBackend1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData10Ready", "Slice1 Pipe0 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice1  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData11Ready", "Slice1 Pipe1 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice1  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData00Ready", "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData01Ready", "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer1InputAvailable", "Slice1 Rasterizer Input Available",
            "The percentage of time in which slice1 rasterizer input is available",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer0InputAvailable", "Slice0 Rasterizer Input Available",
            "The percentage of time in which slice0 rasterizer input is available",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice0", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x260b6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x280b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0977d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e096000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0a7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0a6400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x262b6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x282b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c297000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e296000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c2a7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2a6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b01a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0d74, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0b003e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100a001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aaa80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00210015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02210500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02240500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b69a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x062b0fb5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b3000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04290200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122907d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08290000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02290000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042a0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x102a0400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122a001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022a0a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002aa80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820aa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00053c07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00023fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aa95, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203055a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00043c07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010601, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010403, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010c06, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000001c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000600, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00001800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00006000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00018000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRasterizerAndPixelBackend2MetricSet::CRasterizerAndPixelBackend2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRasterizerAndPixelBackend2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSOutput00Available", "PS00 Output Available",
            "The percentage of time in which PS00 output is available",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelValues00Ready", "Pixel Values 00 Ready",
            "The percentage of time in which pixel values 00 are ready",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSOutput01Available", "PS01 Output Available",
            "The percentage of time in which PS01 output is available",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "PS|FS", nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelValues01Ready", "Pixel Values 01 Ready",
            "The percentage of time in which pixel values 01 are ready",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer0OutputReady", "Slice0 Rasterizer Output Ready",
            "The percentage of time in which slice0 rasterizer output is ready",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer1OutputReady", "Slice1 Rasterizer Output Ready",
            "The percentage of time in which slice1 rasterizer output is ready",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x260b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x262b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02014000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02044000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140b0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020a8000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02211000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02241000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a020126, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a820126, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020e31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02028000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820e31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02822000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00057000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020395a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00047000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010060, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010806, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRenderPipeProfile1MetricSet::CRenderPipeProfile1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRenderPipeProfile1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vf0Bottleneck", "VF0 Bottleneck",
            "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vs0Bottleneck", "VS0 Bottleneck",
            "The percentage of time in which VS0 pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Vertex Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_VS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl0Bottleneck", "Clipper0 Bottleneck",
            "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs0Bottleneck", "HS0 Bottleneck",
            "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 3, 9, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds0Bottleneck", "DS0 Bottleneck",
            "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Gs0Bottleneck", "GS0 Bottleneck",
            "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf0Bottleneck", "SF0 Bottleneck",
            "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 10, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So0Bottleneck", "SO0 Bottleneck",
            "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl0Stall", "CL0 Stall",
            "The percentage of time in which clipper pipeline stage was stalled.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs0Stall", "HS0 Stall",
            "The percentage of time in which hull stall pipeline stage was stalled.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds0Stall", "DS0 Stall",
            "The percentage of time in which domain shader pipeline stage was stalled.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf0Stall", "SF0 Stall",
            "The percentage of time in which strip-fans pipeline stage was stalled.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So0Stall", "SO0 Stall",
            "The percentage of time in which stream-output pipeline stage was stalled.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth00Bottleneck", "Hi-Depth00 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth01Bottleneck", "Hi-Depth01 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Bc00Bottleneck", "BC00 Bottleneck",
            "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Barycentric Calc", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_BC * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1407001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200303c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160401f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14050640, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1406001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0600c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16092400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x180a0009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02011555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06030880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030029, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c030001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0300c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100308eb, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000331a1, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04040200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14040025, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004a96a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04054200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c050002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10050880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00052120, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00060002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02060010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08060007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10060032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a090007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160a0007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020a2aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010a04, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010a04, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010805, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54011207, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRenderPipeProfile2MetricSet::CRenderPipeProfile2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRenderPipeProfile2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vf1Bottleneck", "VF1 Bottleneck",
            "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vs1Bottleneck", "VS1 Bottleneck",
            "The percentage of time in which VS1 pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Vertex Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_VS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl1Bottleneck", "Clipper1 Bottleneck",
            "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs1Bottleneck", "HS1 Bottleneck",
            "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 3, 9, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds1Bottleneck", "DS1 Bottleneck",
            "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Gs1Bottleneck", "GS1 Bottleneck",
            "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf1Bottleneck", "SF1 Bottleneck",
            "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 10, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So1Bottleneck", "SO1 Bottleneck",
            "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl1Stall", "CL1 Stall",
            "The percentage of time in which clipper pipeline stage was stalled.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs1Stall", "HS1 Stall",
            "The percentage of time in which hull stall pipeline stage was stalled.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds1Stall", "DS1 Stall",
            "The percentage of time in which domain shader pipeline stage was stalled.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf1Stall", "SF1 Stall",
            "The percentage of time in which strip-fans pipeline stage was stalled.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So1Stall", "SO1 Stall",
            "The percentage of time in which stream-output pipeline stage was stalled.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth10Bottleneck", "Hi-Depth10 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth11Bottleneck", "Hi-Depth11 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Bc10Bottleneck", "BC10 Bottleneck",
            "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Barycentric Calc", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_BC * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1487001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00870000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04870002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x202303c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x162401f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14250640, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a250021, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1426001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a260000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16292400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x182a0009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00215551, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02215555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a23002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c230040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e230ae3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122300c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00235c60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04240200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14240940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0024aa91, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02242aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02250000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e250080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10250022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00255040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00260002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02260010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082601c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2600c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10260c80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04290004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08290007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00290002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042a0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082a0007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002aaaa2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010a05, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010a05, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010e04, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSamplerMetricSet::CSamplerMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSamplerMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler00InputAvailable", "Slice0 Xe Core0 Input Available",
            "The percentage of time in which slice0 Xe core0 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler01InputAvailable", "Slice0 Xe Core1 Input Available",
            "The percentage of time in which slice0 Xe core1 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler02InputAvailable", "Slice0 Xe Core2 Input Available",
            "The percentage of time in which slice0 Xe core2 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler03InputAvailable", "Slice0 Xe Core3 Input Available",
            "The percentage of time in which slice0 Xe core3 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler00OutputReady", "Slice0 Xe Core0 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core0 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler01OutputReady", "Slice0 Xe Core1 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core1 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler02OutputReady", "Slice0 Xe Core2 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core2 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler03OutputReady", "Slice0 Xe Core3 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core3 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler10InputAvailable", "Slice1 Xe Core0 Input Available",
            "The percentage of time in which slice1 Xe core0 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler11InputAvailable", "Slice1 Xe Core1 Input Available",
            "The percentage of time in which slice1 Xe core1 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler12InputAvailable", "Slice1 Xe Core2 Input Available",
            "The percentage of time in which slice1 Xe core2 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler13InputAvailable", "Slice1 Xe Core3 Input Available",
            "The percentage of time in which slice1 Xe core3 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler10OutputReady", "Slice1 Xe Core0 Sampler Output Ready",
            "The percentage of time in which slice1 Xe core0 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler11OutputReady", "Slice1 Xe Core1 Sampler Output Ready",
            "The percentage of time in which slice1 Xe core1 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler12OutputReady", "Slice1 Xe Core2 Sampler Output Ready",
            "The percentage of time in which slice1 Xe core2 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler13OutputReady", "Slice1 Xe Core3 Sampler Output Ready",
            "The percentage of time in which slice1 Xe core3 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14032c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c210013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14232c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c410013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14432c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c610013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14632c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14832c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ca10013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14a32c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc10013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c32c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce10013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e32c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06011200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08210024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00210400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00220404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00280404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08410900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00421010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a430016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04430000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00430000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00481010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00614000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00624040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a630580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04630000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00630000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00684040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16810024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02824040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e830580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04830000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02830000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02884040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14a10900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a21010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ea30016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a81010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c10024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e10900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e20101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce30016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e80101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00013535, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0033, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090e0e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a2a2a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02215c5c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02245050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002bcc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0229b0b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aa8a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002eaea, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282abab, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58011207, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010a02, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010605, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL1MetricSet::CTDL1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread00ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread00ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00Ready", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort0", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort1", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort2", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort3", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread01ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread01ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01Ready", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort0", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort1", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort2", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort3", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e070020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c270000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e270020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0207020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10070cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12070c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0227020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a270821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c270cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e270c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04270000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0028aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000bffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0009ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0209aaff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL2MetricSet::CTDL2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread02ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread02ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02Ready", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort0", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort1", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort2", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort3", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread03ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread03ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03Ready", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort0", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort1", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort2", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort3", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c470000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e470020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c670000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e670020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0247020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06470821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10470cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12470c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x004800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0248aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0267020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x086708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a670821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c670cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e670c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04670000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0068aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x026800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aaa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL3MetricSet::CTDL3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread10ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread10ReadyForDispatch", "PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader10Ready", "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader10ReadyPort0", "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader10ReadyPort1", "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader10ReadyPort2", "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader10ReadyPort3", "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread11ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread11ReadyForDispatch", "PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader11Ready", "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader11ReadyPort0", "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader11ReadyPort1", "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader11ReadyPort2", "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader11ReadyPort3", "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c870000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e870020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ca70000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ea70020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0287020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06870821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10870cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12870c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0288aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a7020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08a708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0aa70821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ca70cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ea70c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a70000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a8aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00215555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02215555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00245555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02245555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002bffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0029ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0229aaff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL4MetricSet::CTDL4MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL4MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread12ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread12ReadyForDispatch", "PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader12Ready", "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader12ReadyPort0", "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader12ReadyPort1", "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader12ReadyPort2", "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader12ReadyPort3", "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread13ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread13ReadyForDispatch", "PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader13Ready", "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader13ReadyPort0", "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader13ReadyPort1", "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader13ReadyPort2", "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader13ReadyPort3", "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2cc70000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ec70020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ce70000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ee70020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c7020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c70821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c70cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c70c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c8aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e7020a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae70821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce70cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee70c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e70000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e8aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e800aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0221ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTestOaMetricSet::CTestOaMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTestOaMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Counter0", "TestCounter0",
            "HW test counter 0. Factor: 0.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter1", "TestCounter1",
            "HW test counter 1. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter2", "TestCounter2",
            "HW test counter 2. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter3", "TestCounter3",
            "HW test counter 3. Factor: 0.5",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter4", "TestCounter4",
            "HW test counter 4. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter5", "TestCounter5",
            "HW test counter 5. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter6", "TestCounter6",
            "HW test counter 6. Factor: 0.16666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter7", "TestCounter7",
            "HW test counter 7. Factor: 0.6666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter8", "TestCounter8",
            "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter9", "TestCounter9 - OAR enable",
            "HW test counter 9. Should be equal to 1 in query.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x42020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0602000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020cc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0801000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00100082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x001000c2, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00100001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeOverviewMetricSet::CComputeOverviewMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeOverviewMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BYTE_READ", "L3 Byte Read",
            "Number of bytes read from L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_SUBSLICE_BANK, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "L3_BYTE_WRITE", "L3 Byte Write",
            "Number of bytes written to L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_SUBSLICE_BANK, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XVE_ATOMIC_ACCESS_COUNT", "XVE Atomic Access Count",
            "Number of shader atomic memory accesses",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_BARRIER_MESSAGE_COUNT", "XVE Barrier Message Count",
            "Number of shader barrier messages",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL", "XVE Inst Executed XMX All",
            "Number of execution slots taken by instructions executed in XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL", "XVE Inst Executed Send All",
            "Number of instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL", "XVE Inst Executed Control All",
            "Number of instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE", "XVE Pipe ALU0 And ALU1 Active",
            "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_XMX_ACTIVE", "XVE Pipe ALU0 And XMX Active",
            "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION", "XVE Inst Executed Send All Utilization",
            "Percentage of time taken by instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION", "XVE Inst Executed Control All Utilization",
            "Percentage of time taken by instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION", "XVE Inst Executed XMX All Utilization",
            "Percentage of execution slots taken by instructions executed in XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05016000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05216000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05416000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05616000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05816000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05a16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c16140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e16005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b010140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b210005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1321000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09410140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09610005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1161000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201009c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07810140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07a10005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008104e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010602, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00009001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x02001002, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x0000a003, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportWritesMetricSet::CDataportWritesMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportWritesMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SAMPLER_L3_READ", "Sampler L3 Read",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "8 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SAMPLER_L3_BYTE_READ", "Sampler L3 Byte Read",
            "Number of L3 read bytes resulting from Sampler local cache miss",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_SUBSLICE_BANK, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 8 UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE", "Dataport Byte Write",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_DUALSUBSLICE, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "32 dw@0xdc dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "32 qw@0x178 qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c026800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c226800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c426800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c626800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c826800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ca26800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc26800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce26800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00084000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c220880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00281000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c420022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a620880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a820022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08a20880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c20022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e24400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ab00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008200ab, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13210006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11610006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0009b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aa800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0021005c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002900b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a00a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60011207, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50011409, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54011200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportReadsMetricSet::CDataportReadsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportReadsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ", "Dataport Byte Read",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 2 UMUL dw@0xc0 dw@0xc4 UADD dw@0xc8 UADD dw@0xcc UADD dw@0xd0 UADD dw@0xd4 UADD dw@0xd8 UADD dw@0xdc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 2 UMUL qw@0x140 qw@0x148 UADD qw@0x150 UADD qw@0x158 UADD qw@0x160 UADD qw@0x168 UADD qw@0x170 UADD qw@0x178 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c22a019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e22b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c42a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e42b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c62a580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e62b019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06022e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1002001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04220b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a220580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12220500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1422001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02220000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00280500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02280500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04420b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x084205c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a420018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10420540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1242001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02420000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04620b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14620500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1662001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02620000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00685000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02685000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x480200a5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c021400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020c60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820c60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0214a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e8214a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002faaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202faaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000105f5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020105f5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b3333, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090f0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02090f0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a0aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020a0aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c82a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e82b540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ca2a019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ea2b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc2a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec2b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce2a580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee2b019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06822e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1082001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02880005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a20b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0aa20580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12a20500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14a2001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a80500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a80500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c20b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c205c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac20018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c20540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c2001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e20b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e20500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16e2001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e20000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e85000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e85000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x480200a5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c021400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020c60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820c60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0214a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e8214a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082faaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282faaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002105f5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022105f5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02240505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b3333, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00290f0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02290f0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a0aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022a0aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x000000ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet::CL1ProfileSlmBankConflictsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xdc 2 dw@0xd8 UMUL UADD 4 dw@0xd4 UMUL UADD 8 dw@0xd0 UMUL UADD UADD 2 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x178 2 qw@0x170 UMUL UADD 4 qw@0x168 UMUL UADD 8 qw@0x160 UMUL UADD UADD 2 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x260818a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c2800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c4800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x266814c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080809e6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080a68, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06280800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14280c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16280fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02280000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06480800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10480c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12480fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06680032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c680821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e680baf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c0214a5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020614, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020a14, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820a14, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020155ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000bf00f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000900aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0209ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x268818a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2ca800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2cc800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26e814c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06880032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x088809e6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a880a68, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06a80800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14a80c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16a80fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02a80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c80800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c80c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c80fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e80032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce80821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee80baf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c0214a5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020614, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020a14, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820a14, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820063, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00210055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022155ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02245500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002bf00f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002900aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0229ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CLoadStoreCacheProfileMetricSet_XeCore0::CLoadStoreCacheProfileMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CLoadStoreCacheProfileMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1208030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000bfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0009aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0209aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aaaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18880085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04880010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a880146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c8800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e880042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10880380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1288030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1488028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16880209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00215550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02215555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00245550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02245555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002bfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0029aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0229aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002aaaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CLoadStoreCacheProfileMetricSet_XeCore3::CLoadStoreCacheProfileMetricSet_XeCore3( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CLoadStoreCacheProfileMetricSet_XeCore3::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18680085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04680010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a680146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c6800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e680042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10680380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1268030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1468028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16680209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18e80085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae80146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee80042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e80380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e8030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e8028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16e80209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSLMProfileMetricSet_XeCore0::CSLMProfileMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSLMProfileMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe4 2 dw@0xfc UMUL UADD 4 dw@0xf8 UMUL UADD 8 dw@0xf4 UMUL UADD 16 dw@0xf0 UMUL UADD 32 dw@0xec UMUL UADD 64 dw@0xe8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x188 2 qw@0x1b8 UMUL UADD 4 qw@0x1b0 UMUL UADD 8 qw@0x1a8 UMUL UADD 16 qw@0x1a0 UMUL UADD 32 qw@0x198 UMUL UADD 64 qw@0x190 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x180802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1208030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000bfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0009aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0209aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aaaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x188802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04880010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a880146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c8800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e880042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x108801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1288030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1488028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16880209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02880000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00215550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02215555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00245550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02245555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002bfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0029aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0229aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002aaaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022aaaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSLMProfileMetricSet_XeCore3::CSLMProfileMetricSet_XeCore3( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSLMProfileMetricSet_XeCore3::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x186802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04680010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a680146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c6800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e680042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10680340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x126802cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1468024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x166801c8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02680000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18e802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae80146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee80042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e80340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e802cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e8024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16e801c8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e80000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x44020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x48020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0082fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0282ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28820001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt1MetricSet::CExt1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI0", "GPU Memory Byte Write Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI1", "GPU Memory Byte Write Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE_SQIDI0", "GPU Memory Write Sqidi0",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE_SQIDI1", "GPU Memory Write Sqidi1",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE", "GPU Memory Write",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_WRITE_SQIDI0 $$GPU_MEMORY_WRITE_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_READ_SQIDI0", "GPU Memory Read Sqidi0",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_READ_SQIDI1", "GPU Memory Read Sqidi1",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0 dw@0xe4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180 qw@0x188 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_READ", "GPU Memory Read",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_READ_SQIDI0 $$GPU_MEMORY_READ_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI0", "GPU Memory Byte Read Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI1", "GPU Memory Byte Read Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_ACTIVE_SQIDI0", "GPU Memory Active Sqidi0",
            "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_ACTIVE_SQIDI1", "GPU Memory Active Sqidi1",
            "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_BW_SQIDI0", "GPU Memory Byte Read Bw Sqidi0",
            "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_READ_SQIDI0 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_BW_SQIDI1", "GPU Memory Byte Read Bw Sqidi1",
            "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_READ_SQIDI1 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0", "GPU Memory Byte Write Bw Sqidi0",
            "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_WRITE_SQIDI0 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1", "GPU Memory Byte Write Bw Sqidi1",
            "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_WRITE_SQIDI1 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0", "GPU Memory Request Queue Full Sqidi0",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1", "GPU Memory Request Queue Full Sqidi1",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x150100e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17051000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x152100e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17251000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0007aee0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0207beef, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07010005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09010007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b0103cd, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1101000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01018000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03050004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15050005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07210140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d2103cd, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f210180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11210380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01214000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03250004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13250140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01250000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt3MetricSet::CExt3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI0", "GPU Memory 32b Transaction Read Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI1", "GPU Memory 32b Transaction Read Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI0", "GPU Memory 64b Transaction Read Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI1", "GPU Memory 64b Transaction Read Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI0", "GPU Memory 32b Transaction Write Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI1", "GPU Memory 32b Transaction Write Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI0", "GPU Memory 64b Transaction Write Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI1", "GPU Memory 64b Transaction Write Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_READ", "GPU Memory 32b Transaction Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GPU_MEMORY_32B_TRANSACTION_READ_SQIDI0 $GPU_MEMORY_32B_TRANSACTION_READ_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_READ", "GPU Memory 64b Transaction Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GPU_MEMORY_64B_TRANSACTION_READ_SQIDI0 $GPU_MEMORY_64B_TRANSACTION_READ_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_32B_TRANSACTION_WRITE", "GPU Memory 32b Transaction Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI0 $GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_64B_TRANSACTION_WRITE", "GPU Memory 64b Transaction Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI0 $GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI1 UADD" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17250000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0207eeee, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01015500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03050004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d050140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0501c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11050100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13050180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0121aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03250004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f250005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11250007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13250004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15250006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01250000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt4MetricSet::CExt4MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt4MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK0", "L3 Read L3bank0",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK1", "L3 Read L3bank1",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK2", "L3 Read L3bank2",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK3", "L3 Read L3bank3",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK4", "L3 Read L3bank4",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK5", "L3 Read L3bank5",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK6", "L3 Read L3bank6",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK7", "L3 Read L3bank7",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK0", "L3 Write L3bank0",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK1", "L3 Write L3bank1",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK2", "L3 Write L3bank2",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK3", "L3 Write L3bank3",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK4", "L3 Write L3bank4",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK5", "L3 Write L3bank5",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK6", "L3 Write L3bank6",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK7", "L3 Write L3bank7",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05016005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05216140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05416000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05616000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05816000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05a16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00825500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1321000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07610140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1161000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010b1a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b810140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba10005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c10140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e10005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00815000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a9c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000355aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010602, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt5MetricSet::CExt5MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt5MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK0", "Dataport L3 Read L3bank0",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK1", "Dataport L3 Read L3bank1",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK2", "Dataport L3 Read L3bank2",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK3", "Dataport L3 Read L3bank3",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK4", "Dataport L3 Read L3bank4",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK5", "Dataport L3 Read L3bank5",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK6", "Dataport L3 Read L3bank6",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK7", "Dataport L3 Read L3bank7",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK0", "Dataport L3 Write L3bank0",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK1", "Dataport L3 Write L3bank1",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK2", "Dataport L3 Write L3bank2",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK3", "Dataport L3 Write L3bank3",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK4", "Dataport L3 Write L3bank4",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK5", "Dataport L3 Write L3bank5",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK6", "Dataport L3 Write L3bank6",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK7", "Dataport L3 Write L3bank7",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b0100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b210003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x094100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09610003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11610004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201009c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x078100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07a10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008104e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010602, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt6MetricSet::CExt6MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt6MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_HIT_L3BANK0", "L3 Hit L3bank0",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK1", "L3 Hit L3bank1",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK2", "L3 Hit L3bank2",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK3", "L3 Hit L3bank3",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK4", "L3 Hit L3bank4",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK5", "L3 Hit L3bank5",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK6", "L3 Hit L3bank6",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK7", "L3 Hit L3bank7",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE0", "Sampler Busy Xecore0",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE1", "Sampler Busy Xecore1",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE2", "Sampler Busy Xecore2",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE3", "Sampler Busy Xecore3",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE4", "Sampler Busy Xecore4",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore0", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE5", "Sampler Busy Xecore5",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE6", "Sampler Busy Xecore6",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore2", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE7", "Sampler Busy Xecore7",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice1XeCore3", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18230004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18430004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18630004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18830004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18a30004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18e30004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00014000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00024000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a030d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00084000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00211000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00221000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00281000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00420400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08430d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04430000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00430000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00620100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08630034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04630000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00630000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00680100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06830d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04830000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00830000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00880040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a20010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06a30034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04a30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00a80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e30034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ab00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008200ab, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13210001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11610001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0009b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000aa800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0021005c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00240050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002900b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002a00a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010220, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010622, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010241, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010424, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt7MetricSet::CExt7MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt7MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK0", "Sampler L3 Read L3bank0",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK1", "Sampler L3 Read L3bank1",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK2", "Sampler L3 Read L3bank2",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK3", "Sampler L3 Read L3bank3",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK4", "Sampler L3 Read L3bank4",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK5", "Sampler L3 Read L3bank5",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK6", "Sampler L3 Read L3bank6",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK7", "Sampler L3 Read L3bank7",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK0", "Sampler L3 Hit L3bank0",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK1", "Sampler L3 Hit L3bank1",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK2", "Sampler L3 Hit L3bank2",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK3", "Sampler L3 Hit L3bank3",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK4", "Sampler L3 Hit L3bank4",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK5", "Sampler L3 Hit L3bank5",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK6", "Sampler L3 Hit L3bank6",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK7", "Sampler L3 Hit L3bank7",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00825500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05210180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13210008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07610180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11610008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010b1a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09810006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09a10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814b63, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000355aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010602, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt8MetricSet::CExt8MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt8MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK0", "ICache L3 Read L3bank0",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK1", "ICache L3 Read L3bank1",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK2", "ICache L3 Read L3bank2",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK3", "ICache L3 Read L3bank3",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK4", "ICache L3 Read L3bank4",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK5", "ICache L3 Read L3bank5",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK6", "ICache L3 Read L3bank6",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK7", "ICache L3 Read L3bank7",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK0", "ICache L3 Hit L3bank0",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK1", "ICache L3 Hit L3bank1",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK2", "ICache L3 Hit L3bank2",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK3", "ICache L3 Hit L3bank3",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK4", "ICache L3 Hit L3bank4",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK5", "ICache L3 Hit L3bank5",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK6", "ICache L3 Hit L3bank6",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK7", "ICache L3 Hit L3bank7",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b010280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b21000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x070101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07210007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x054101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09410280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05610007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0961000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000154e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201009c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x138103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813953, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt9MetricSet::CExt9MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt9MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK0", "Z L3 Access L3bank0",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK1", "Z L3 Access L3bank1",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK2", "Z L3 Access L3bank2",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK3", "Z L3 Access L3bank3",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK4", "Z L3 Access L3bank4",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK5", "Z L3 Access L3bank5",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK6", "Z L3 Access L3bank6",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK7", "Z L3 Access L3bank7",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03014000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03214000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03414000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03614000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03814000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f210007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d4101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d610007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02014a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x138101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020355aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010803, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt10MetricSet::CExt10MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt10MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK0", "Dataport L3 Hit L3bank0",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK1", "Dataport L3 Hit L3bank1",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK2", "Dataport L3 Hit L3bank2",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK3", "Dataport L3 Hit L3bank3",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK4", "Dataport L3 Hit L3bank4",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK5", "Dataport L3 Hit L3bank5",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK6", "Dataport L3 Hit L3bank6",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK7", "Dataport L3 Hit L3bank7",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK0", "Color L3 Hit L3bank0",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK1", "Color L3 Hit L3bank1",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK2", "Color L3 Hit L3bank2",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK3", "Color L3 Hit L3bank3",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK4", "Color L3 Hit L3bank4",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK5", "Color L3 Hit L3bank5",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK6", "Color L3 Hit L3bank6",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK7", "Color L3 Hit L3bank7",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05210100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00012b1a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010163, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813953, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt11MetricSet::CExt11MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt11MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK0", "Z L3 Hit L3bank0",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK1", "Z L3 Hit L3bank1",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK2", "Z L3 Hit L3bank2",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK3", "Z L3 Hit L3bank3",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK4", "Z L3 Hit L3bank4",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK5", "Z L3 Hit L3bank5",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK6", "Z L3 Hit L3bank6",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK7", "Z L3 Hit L3bank7",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK0", "L3 Atomic Access L3bank0",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK1", "L3 Atomic Access L3bank1",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK2", "L3 Atomic Access L3bank2",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK3", "L3 Atomic Access L3bank3",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK4", "L3 Atomic Access L3bank4",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK5", "L3 Atomic Access L3bank5",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK6", "L3 Atomic Access L3bank6",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK7", "L3 Atomic Access L3bank7",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b010300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b21000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07010140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07210005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05410140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09410300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05610005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0961000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000154e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201009c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c10340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813953, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt12MetricSet::CExt12MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt12MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK0", "L3 Input Available L3bank0",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK1", "L3 Input Available L3bank1",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK2", "L3 Input Available L3bank2",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK3", "L3 Input Available L3bank3",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK4", "L3 Input Available L3bank4",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK5", "L3 Input Available L3bank5",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK6", "L3 Input Available L3bank6",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK7", "L3 Input Available L3bank7",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK0", "L3 Output Ready L3bank0",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK1", "L3 Output Ready L3bank1",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK2", "L3 Output Ready L3bank2",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK3", "L3 Output Ready L3bank3",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK4", "L3 Output Ready L3bank4",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK5", "L3 Output Ready L3bank5",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK6", "L3 Output Ready L3bank6",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK7", "L3 Output Ready L3bank7",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05010007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09210180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x076101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b610180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00012b1a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010163, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f810180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x138101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fa10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02814a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813953, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt13MetricSet::CExt13MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt13MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK0", "L3 Superq Full L3bank0",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK1", "L3 Superq Full L3bank1",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK2", "L3 Superq Full L3bank2",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK3", "L3 Superq Full L3bank3",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK0", "Color L3 Access L3bank0",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK1", "Color L3 Access L3bank1",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK2", "Color L3 Access L3bank2",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK3", "Color L3 Access L3bank3",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03016000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b011183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03216000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b211000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03416000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03616000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b611000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x130103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09210183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1321000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x114103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05610183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1161000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001392d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010093, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000060, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000600, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt14MetricSet::CExt14MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt14MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK4", "L3 Superq Full L3bank4",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK5", "L3 Superq Full L3bank5",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK6", "L3 Superq Full L3bank6",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK7", "L3 Superq Full L3bank7",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK4", "Color L3 Access L3bank4",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK5", "Color L3 Access L3bank5",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK6", "Color L3 Access L3bank6",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK7", "Color L3 Access L3bank7",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03816000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ba11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be11183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05810183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x138103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07a10183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c10183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x008146d2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0281016c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813940, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005f0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004f0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000060, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000600, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt15MetricSet::CExt15MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt15MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BUSY_L3BANK0", "L3 Busy L3bank0",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK1", "L3 Busy L3bank1",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK2", "L3 Busy L3bank2",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK3", "L3 Busy L3bank3",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK0", "L3 Stall L3bank0",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK1", "L3 Stall L3bank1",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK2", "L3 Stall L3bank2",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK3", "L3 Stall L3bank3",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05010042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03212000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05210000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02025555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11010008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01210010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07210080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09210001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11210200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13410008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01610010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d610080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f610001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13610200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00013692, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015923, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040146ad, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000001c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000e00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00007000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt16MetricSet::CExt16MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt16MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BUSY_L3BANK4", "L3 Busy L3bank4",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK5", "L3 Busy L3bank5",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK6", "L3 Busy L3bank6",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK7", "L3 Busy L3bank7",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK4", "L3 Stall L3bank4",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK5", "L3 Stall L3bank5",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK6", "L3 Stall L3bank6",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK7", "L3 Stall L3bank7",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05810042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03a12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05a10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02825555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13810200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01a10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07a10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09a10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13a10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc10042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00813692, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02815923, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0481396d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0005ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02015555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4c010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x72010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000001c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000e00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00007000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt17MetricSet::CExt17MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt17MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USA