﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appflow/Appflow_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Appflow {
namespace Model {

/**
 * <p> The connector-specific credentials required when using Amplitude.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/AmplitudeConnectorProfileCredentials">AWS
 * API Reference</a></p>
 */
class AmplitudeConnectorProfileCredentials {
 public:
  AWS_APPFLOW_API AmplitudeConnectorProfileCredentials() = default;
  AWS_APPFLOW_API AmplitudeConnectorProfileCredentials(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API AmplitudeConnectorProfileCredentials& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> A unique alphanumeric identifier used to authenticate a user, developer, or
   * calling program to your API. </p>
   */
  inline const Aws::String& GetApiKey() const { return m_apiKey; }
  inline bool ApiKeyHasBeenSet() const { return m_apiKeyHasBeenSet; }
  template <typename ApiKeyT = Aws::String>
  void SetApiKey(ApiKeyT&& value) {
    m_apiKeyHasBeenSet = true;
    m_apiKey = std::forward<ApiKeyT>(value);
  }
  template <typename ApiKeyT = Aws::String>
  AmplitudeConnectorProfileCredentials& WithApiKey(ApiKeyT&& value) {
    SetApiKey(std::forward<ApiKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Secret Access Key portion of the credentials. </p>
   */
  inline const Aws::String& GetSecretKey() const { return m_secretKey; }
  inline bool SecretKeyHasBeenSet() const { return m_secretKeyHasBeenSet; }
  template <typename SecretKeyT = Aws::String>
  void SetSecretKey(SecretKeyT&& value) {
    m_secretKeyHasBeenSet = true;
    m_secretKey = std::forward<SecretKeyT>(value);
  }
  template <typename SecretKeyT = Aws::String>
  AmplitudeConnectorProfileCredentials& WithSecretKey(SecretKeyT&& value) {
    SetSecretKey(std::forward<SecretKeyT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_apiKey;

  Aws::String m_secretKey;
  bool m_apiKeyHasBeenSet = false;
  bool m_secretKeyHasBeenSet = false;
};

}  // namespace Model
}  // namespace Appflow
}  // namespace Aws
