/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import os.shaded_org_apache_tools_zip.CentralDirectoryParsingZipExtraField;
import os.shaded_org_apache_tools_zip.ExtraFieldUtils;
import os.shaded_org_apache_tools_zip.GeneralPurposeBit;
import os.shaded_org_apache_tools_zip.UnparseableExtraFieldData;
import os.shaded_org_apache_tools_zip.ZipExtraField;
import os.shaded_org_apache_tools_zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    public static final int PLATFORM_UNIX = 3;
    public static final int PLATFORM_FAT = 0;
    public static final int CRC_UNKNOWN = -1;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private static final byte[] EMPTY = new byte[0];
    private int method = -1;
    private long size = -1L;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private ZipExtraField[] extraFields;
    private UnparseableExtraFieldData unparseableExtra = null;
    private String name = null;
    private byte[] rawName = null;
    private GeneralPurposeBit gpb = new GeneralPurposeBit();
    private static final ZipExtraField[] noExtraFields = new ZipExtraField[0];

    public ZipEntry(String string2) {
        super(string2);
        this.setName(string2);
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        this.setName(zipEntry.getName());
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ));
        } else {
            this.setExtra();
        }
        this.setMethod(zipEntry.getMethod());
        this.size = zipEntry.getSize();
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(this.getAllExtraFieldsNoCopy());
        this.setPlatform(zipEntry.getPlatform());
        GeneralPurposeBit generalPurposeBit = zipEntry.getGeneralPurposeBit();
        this.setGeneralPurposeBit(generalPurposeBit == null ? null : (GeneralPurposeBit)generalPurposeBit.clone());
    }

    protected ZipEntry() {
        this("");
    }

    public ZipEntry(File file, String string2) {
        this((String)(file.isDirectory() && !string2.endsWith("/") ? string2 + "/" : string2));
        if (file.isFile()) {
            this.setSize(file.length());
        }
        this.setTime(file.lastModified());
    }

    @Override
    public Object clone() {
        ZipEntry zipEntry = (ZipEntry)super.clone();
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getAllExtraFieldsNoCopy());
        return zipEntry;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("ZIP compression method can not be negative: " + n);
        }
        this.method = n;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    public void setUnixMode(int n) {
        this.setExternalAttributes(n << 16 | ((n & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n) {
        this.platform = n;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            if (zipExtraField instanceof UnparseableExtraFieldData) {
                this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
                continue;
            }
            arrayList.add(zipExtraField);
        }
        this.extraFields = arrayList.toArray(new ZipExtraField[0]);
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        return this.getParseableExtraFields();
    }

    public ZipExtraField[] getExtraFields(boolean bl) {
        return bl ? this.getAllExtraFields() : this.getParseableExtraFields();
    }

    private ZipExtraField[] getParseableExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return noExtraFields;
        }
        return this.extraFields;
    }

    private ZipExtraField[] getParseableExtraFields() {
        ZipExtraField[] zipExtraFieldArray = this.getParseableExtraFieldsNoCopy();
        return zipExtraFieldArray == this.extraFields ? this.copyOf(zipExtraFieldArray) : zipExtraFieldArray;
    }

    private ZipExtraField[] copyOf(ZipExtraField[] zipExtraFieldArray) {
        return this.copyOf(zipExtraFieldArray, zipExtraFieldArray.length);
    }

    private ZipExtraField[] copyOf(ZipExtraField[] zipExtraFieldArray, int n) {
        ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[n];
        System.arraycopy(zipExtraFieldArray, 0, zipExtraFieldArray2, 0, Math.min(zipExtraFieldArray.length, n));
        return zipExtraFieldArray2;
    }

    private ZipExtraField[] getMergedFields() {
        ZipExtraField[] zipExtraFieldArray = this.copyOf(this.extraFields, this.extraFields.length + 1);
        zipExtraFieldArray[this.extraFields.length] = this.unparseableExtra;
        return zipExtraFieldArray;
    }

    private ZipExtraField[] getUnparseableOnly() {
        ZipExtraField[] zipExtraFieldArray;
        if (this.unparseableExtra == null) {
            zipExtraFieldArray = noExtraFields;
        } else {
            ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
            zipExtraFieldArray = zipExtraFieldArray2;
            zipExtraFieldArray2[0] = this.unparseableExtra;
        }
        return zipExtraFieldArray;
    }

    private ZipExtraField[] getAllExtraFields() {
        ZipExtraField[] zipExtraFieldArray = this.getAllExtraFieldsNoCopy();
        return zipExtraFieldArray == this.extraFields ? this.copyOf(zipExtraFieldArray) : zipExtraFieldArray;
    }

    private ZipExtraField[] getAllExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return this.getUnparseableOnly();
        }
        return this.unparseableExtra != null ? this.getMergedFields() : this.extraFields;
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else if (this.extraFields == null) {
            this.extraFields = new ZipExtraField[]{zipExtraField};
        } else {
            if (this.getExtraField(zipExtraField.getHeaderId()) != null) {
                this.removeExtraField(zipExtraField.getHeaderId());
            }
            ZipExtraField[] zipExtraFieldArray = this.copyOf(this.extraFields, this.extraFields.length + 1);
            zipExtraFieldArray[this.extraFields.length] = zipExtraField;
            this.extraFields = zipExtraFieldArray;
        }
        this.setExtra();
    }

    public void addAsFirstExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else {
            if (this.getExtraField(zipExtraField.getHeaderId()) != null) {
                this.removeExtraField(zipExtraField.getHeaderId());
            }
            ZipExtraField[] zipExtraFieldArray = this.extraFields;
            int n = this.extraFields != null ? this.extraFields.length + 1 : 1;
            this.extraFields = new ZipExtraField[n];
            this.extraFields[0] = zipExtraField;
            if (zipExtraFieldArray != null) {
                System.arraycopy(zipExtraFieldArray, 0, this.extraFields, 1, this.extraFields.length - 1);
            }
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            throw new NoSuchElementException();
        }
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        for (ZipExtraField zipExtraField : this.extraFields) {
            if (zipShort.equals(zipExtraField.getHeaderId())) continue;
            arrayList.add(zipExtraField);
        }
        if (this.extraFields.length == arrayList.size()) {
            throw new NoSuchElementException();
        }
        this.extraFields = arrayList.toArray(new ZipExtraField[0]);
        this.setExtra();
    }

    public void removeUnparseableExtraFieldData() {
        if (this.unparseableExtra == null) {
            throw new NoSuchElementException();
        }
        this.unparseableExtra = null;
        this.setExtra();
    }

    public ZipExtraField getExtraField(ZipShort zipShort) {
        if (this.extraFields != null) {
            for (ZipExtraField zipExtraField : this.extraFields) {
                if (!zipShort.equals(zipExtraField.getHeaderId())) continue;
                return zipExtraField;
            }
        }
        return null;
    }

    public UnparseableExtraFieldData getUnparseableExtraFieldData() {
        return this.unparseableExtra;
    }

    @Override
    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, true);
        }
        catch (ZipException zipException) {
            throw new RuntimeException("Error parsing extra fields for entry: " + this.getName() + " - " + zipException.getMessage(), zipException);
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields(true)));
    }

    public void setCentralDirectoryExtra(byte[] byArray) {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, false, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, false);
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException.getMessage(), zipException);
        }
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : EMPTY;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields(true));
    }

    @Deprecated
    public void setComprSize(long l) {
        this.setCompressedSize(l);
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string2) {
        if (string2 != null && this.getPlatform() == 0 && !string2.contains("/")) {
            string2 = string2.replace('\\', '/');
        }
        this.name = string2;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = l;
    }

    protected void setName(String string2, byte[] byArray) {
        this.setName(string2);
        this.rawName = byArray;
    }

    public byte[] getRawName() {
        if (this.rawName != null) {
            byte[] byArray = new byte[this.rawName.length];
            System.arraycopy(this.rawName, 0, byArray, 0, this.rawName.length);
            return byArray;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public GeneralPurposeBit getGeneralPurposeBit() {
        return this.gpb;
    }

    public void setGeneralPurposeBit(GeneralPurposeBit generalPurposeBit) {
        this.gpb = generalPurposeBit;
    }

    private void mergeExtraFields(ZipExtraField[] zipExtraFieldArray, boolean bl) throws ZipException {
        if (this.extraFields == null) {
            this.setExtraFields(zipExtraFieldArray);
        } else {
            for (ZipExtraField zipExtraField : zipExtraFieldArray) {
                byte[] byArray;
                ZipExtraField zipExtraField2 = zipExtraField instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(zipExtraField.getHeaderId());
                if (zipExtraField2 == null) {
                    this.addExtraField(zipExtraField);
                    continue;
                }
                if (bl || !(zipExtraField2 instanceof CentralDirectoryParsingZipExtraField)) {
                    byArray = zipExtraField.getLocalFileDataData();
                    zipExtraField2.parseFromLocalFileData(byArray, 0, byArray.length);
                    continue;
                }
                byArray = zipExtraField.getCentralDirectoryData();
                ((CentralDirectoryParsingZipExtraField)zipExtraField2).parseFromCentralDirectoryData(byArray, 0, byArray.length);
            }
            this.setExtra();
        }
    }

    public Date getLastModifiedDate() {
        return new Date(this.getTime());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ZipEntry zipEntry = (ZipEntry)object;
        String string2 = this.getName();
        String string3 = zipEntry.getName();
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            return false;
        }
        String string4 = this.getComment();
        String string5 = zipEntry.getComment();
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        return this.getTime() == zipEntry.getTime() && string4.equals(string5) && this.getInternalAttributes() == zipEntry.getInternalAttributes() && this.getPlatform() == zipEntry.getPlatform() && this.getExternalAttributes() == zipEntry.getExternalAttributes() && this.getMethod() == zipEntry.getMethod() && this.getSize() == zipEntry.getSize() && this.getCrc() == zipEntry.getCrc() && this.getCompressedSize() == zipEntry.getCompressedSize() && Arrays.equals(this.getCentralDirectoryExtra(), zipEntry.getCentralDirectoryExtra()) && Arrays.equals(this.getLocalFileDataExtra(), zipEntry.getLocalFileDataExtra()) && this.gpb.equals(zipEntry.gpb);
    }
}

