/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.filebased;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.ox.store.abstr.AbstractOpenPgpKeyStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpMetadataStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class FileBasedOpenPgpKeyStore
extends AbstractOpenPgpKeyStore {
    private static final String PUB_RING = "pubring.pkr";
    private static final String SEC_RING = "secring.skr";
    private static final String FETCH_DATES = "fetchDates.list";
    private final File basePath;

    public FileBasedOpenPgpKeyStore(File basePath) {
        this.basePath = Objects.requireNonNull(basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePublicKeysOf(BareJid owner2, PGPPublicKeyRingCollection publicKeys) throws IOException {
        File file = this.getPublicKeyRingPath(owner2);
        if (publicKeys == null) {
            FileUtils.maybeDeleteFileOrThrow(file);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = FileUtils.prepareFileOutputStream(file);
            publicKeys.encode(outputStream);
        }
        finally {
            CloseableUtil.maybeClose(outputStream, LOGGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSecretKeysOf(BareJid owner2, PGPSecretKeyRingCollection secretKeys) throws IOException {
        File file = this.getSecretKeyRingPath(owner2);
        if (secretKeys == null) {
            FileUtils.maybeDeleteFileOrThrow(file);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = FileUtils.prepareFileOutputStream(file);
            secretKeys.encode(outputStream);
        }
        finally {
            CloseableUtil.maybeClose(outputStream, LOGGER);
        }
    }

    @Override
    public PGPPublicKeyRingCollection readPublicKeysOf(BareJid owner2) throws IOException, PGPException {
        File file = this.getPublicKeyRingPath(owner2);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = FileUtils.prepareFileInputStream(file);
        PGPPublicKeyRingCollection collection = PGPainless.readKeyRing().publicKeyRingCollection(inputStream);
        inputStream.close();
        return collection;
    }

    @Override
    public PGPSecretKeyRingCollection readSecretKeysOf(BareJid owner2) throws IOException, PGPException {
        File file = this.getSecretKeyRingPath(owner2);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = FileUtils.prepareFileInputStream(file);
        PGPSecretKeyRingCollection collection = PGPainless.readKeyRing().secretKeyRingCollection(inputStream);
        inputStream.close();
        return collection;
    }

    @Override
    protected Map<OpenPgpV4Fingerprint, Date> readKeyFetchDates(BareJid owner2) throws IOException {
        return FileBasedOpenPgpMetadataStore.readFingerprintsAndDates(this.getFetchDatesPath(owner2));
    }

    @Override
    protected void writeKeyFetchDates(BareJid owner2, Map<OpenPgpV4Fingerprint, Date> dates) throws IOException {
        FileBasedOpenPgpMetadataStore.writeFingerprintsAndDates(dates, this.getFetchDatesPath(owner2));
    }

    private File getPublicKeyRingPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), PUB_RING);
    }

    private File getSecretKeyRingPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), SEC_RING);
    }

    private File getFetchDatesPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), FETCH_DATES);
    }
}

