/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.message_markup.element.ListElement;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;
import org.jivesoftware.smackx.message_markup.element.SpanElement;
import org.jxmpp.JxmppContext;

public class MarkupElementProvider
extends ExtensionElementProvider<MarkupElement> {
    @Override
    public MarkupElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws IOException, XmlPullParserException {
        MarkupElement.Builder markup = MarkupElement.getBuilder();
        int spanStart = -1;
        int spanEnd = -1;
        HashSet<SpanElement.SpanStyle> spanStyles = new HashSet<SpanElement.SpanStyle>();
        int listStart = -1;
        int listEnd = -1;
        ArrayList<ListElement.ListEntryElement> lis = new ArrayList<ListElement.ListEntryElement>();
        while (true) {
            XmlPullParser.Event tag = parser.next();
            block0 : switch (tag) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "bquote": {
                            int start = ParserUtils.getIntegerAttributeOrThrow(parser, "start", "Message Markup BlockQuoteElement MUST contain a 'start' attribute.");
                            int end = ParserUtils.getIntegerAttributeOrThrow(parser, "end", "Message Markup BlockQuoteElement MUST contain a 'end' attribute.");
                            markup.setBlockQuote(start, end);
                            break block0;
                        }
                        case "bcode": {
                            int start = ParserUtils.getIntegerAttributeOrThrow(parser, "start", "Message Markup CodeBlockElement MUST contain a 'start' attribute.");
                            int end = ParserUtils.getIntegerAttributeOrThrow(parser, "end", "Message Markup CodeBlockElement MUST contain a 'end' attribute.");
                            markup.setCodeBlock(start, end);
                            break block0;
                        }
                        case "span": {
                            spanStyles = new HashSet();
                            spanStart = ParserUtils.getIntegerAttributeOrThrow(parser, "start", "Message Markup SpanElement MUST contain a 'start' attribute.");
                            spanEnd = ParserUtils.getIntegerAttributeOrThrow(parser, "end", "Message Markup SpanElement MUST contain a 'end' attribute.");
                            break block0;
                        }
                        case "code": {
                            spanStyles.add(SpanElement.SpanStyle.code);
                            break block0;
                        }
                        case "emphasis": {
                            spanStyles.add(SpanElement.SpanStyle.emphasis);
                            break block0;
                        }
                        case "deleted": {
                            spanStyles.add(SpanElement.SpanStyle.deleted);
                            break block0;
                        }
                        case "list": {
                            lis = new ArrayList();
                            listStart = ParserUtils.getIntegerAttributeOrThrow(parser, "start", "Message Markup ListElement MUST contain a 'start' attribute.");
                            listEnd = ParserUtils.getIntegerAttributeOrThrow(parser, "end", "Message Markup ListElement MUST contain a 'end' attribute.");
                            break block0;
                        }
                        case "li": {
                            int start = ParserUtils.getIntegerAttributeOrThrow(parser, "start", "Message Markup ListElement 'li' MUST contain a 'start' attribute.");
                            lis.add(new ListElement.ListEntryElement(start));
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String name;
                    if (parser.getDepth() == initialDepth) {
                        return markup.build();
                    }
                    switch (name = parser.getName()) {
                        case "span": {
                            markup.addSpan(spanStart, spanEnd, spanStyles);
                            spanStart = -1;
                            spanEnd = -1;
                            break block0;
                        }
                        case "list": {
                            MarkupElement.Builder.ListBuilder listBuilder = markup.beginList();
                            if (lis.size() > 0 && ((ListElement.ListEntryElement)lis.get(0)).getStart() != listStart) {
                                throw new IOException("Error while parsing incoming MessageMarkup ListElement: 'start' attribute of first 'li' element must equal 'start' attribute of list.");
                            }
                            for (int i = 0; i < lis.size(); ++i) {
                                int elemStart = ((ListElement.ListEntryElement)lis.get(i)).getStart();
                                int elemEnd = i < lis.size() - 1 ? ((ListElement.ListEntryElement)lis.get(i + 1)).getStart() : listEnd;
                                listBuilder.addEntry(elemStart, elemEnd);
                            }
                            listBuilder.endList();
                        }
                    }
                    break;
                }
            }
        }
    }
}

