/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Plugin(name="DataSource", category="Core", elementType="connectionSource", printObject=true)
public final class DataSourceConnectionSource
extends AbstractConnectionSource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private DataSource dataSource;
    private final String description;
    private final String jndiName;
    private final boolean lazy;
    private ServiceTracker<DataSource, DataSource> tracker;

    private DataSourceConnectionSource(String jndiName, final BundleContext context, Filter filter, DataSource dataSource, boolean lazy) {
        this.dataSource = dataSource;
        this.lazy = lazy;
        if (jndiName != null) {
            this.jndiName = jndiName;
            Object filter1 = null;
            this.description = "dataSource{ jndiName=" + jndiName + ", value=" + dataSource + ", lazy=" + lazy + " }";
        } else {
            this.jndiName = null;
            Filter filter1 = filter;
            this.description = "dataSource{ filter=" + filter.toString() + ", value=" + dataSource + ", lazy=" + lazy + " }";
            this.tracker = new ServiceTracker(context, filter1, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DataSource, DataSource>(){

                public DataSource addingService(ServiceReference<DataSource> reference) {
                    DataSource ds = (DataSource)context.getService(reference);
                    DataSourceConnectionSource.this.setDataSource(ds);
                    return ds;
                }

                public void modifiedService(ServiceReference<DataSource> reference, DataSource service) {
                    DataSourceConnectionSource.this.setDataSource(service);
                }

                public void removedService(ServiceReference<DataSource> reference, DataSource service) {
                    DataSourceConnectionSource.this.setDataSource(null);
                }
            });
            this.tracker.open();
        }
    }

    private synchronized void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.lazy) {
            DataSource ds = this.dataSource;
            if (ds != null) {
                return ds.getConnection();
            }
            if (this.jndiName != null) {
                ds = DataSourceConnectionSource.acquireDataSourceFromJNDI(this.jndiName, true);
                return ds == null ? null : ds.getConnection();
            }
            return null;
        }
        return this.dataSource.getConnection();
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static DataSourceConnectionSource createConnectionSource(@PluginAttribute(value="jndiName") String jndiName, @PluginAttribute(value="service") String serviceFilter, @PluginAttribute(value="lazy") boolean lazy) {
        if (Strings.isEmpty((CharSequence)jndiName) && Strings.isEmpty((CharSequence)serviceFilter)) {
            LOGGER.error("No JNDI name or OSGi service filter provided.");
            return null;
        }
        String lazyJndiName = null;
        String lazyServiceFilter = null;
        DataSource dataSource = null;
        if (serviceFilter != null && !"".trim().equals(serviceFilter)) {
            lazyServiceFilter = serviceFilter.trim();
            dataSource = null;
        } else if (jndiName != null && !"".trim().equals(jndiName)) {
            if (jndiName.startsWith("osgi:service/")) {
                lazyServiceFilter = String.format("(&(objectClass=javax.sql.DataSource)(%s=%s))", "osgi.jndi.service.name", jndiName.substring("osgi:service/".length()).trim());
                dataSource = null;
            } else {
                if (!JndiManager.isJndiJdbcEnabled()) {
                    LOGGER.error("JNDI must be enabled by setting log4j2.enableJndiJdbc=true");
                    return null;
                }
                lazyJndiName = jndiName.trim();
                dataSource = DataSourceConnectionSource.acquireDataSourceFromJNDI(lazyJndiName, lazy);
            }
        }
        BundleContext context = null;
        Filter filter = null;
        if (lazyServiceFilter != null) {
            Bundle b = FrameworkUtil.getBundle(DataSourceConnectionSource.class);
            if (b == null || (context = b.getBundleContext()) == null) {
                LOGGER.error("Can't access Bundle and Bundle context required to access {}", (Object)lazyServiceFilter);
                return null;
            }
            try {
                filter = context.createFilter(lazyServiceFilter);
            }
            catch (InvalidSyntaxException e) {
                LOGGER.error("Can't parse {}", (Object)lazyServiceFilter, (Object)e);
                return null;
            }
        }
        return new DataSourceConnectionSource(lazyJndiName, context, filter, dataSource, lazy);
    }

    private static DataSource acquireDataSourceFromJNDI(String jndiName, boolean lazy) {
        try {
            DataSource dataSource = (DataSource)JndiManager.getDefaultManager(DataSourceConnectionSource.class.getCanonicalName()).lookup(jndiName);
            if (dataSource == null) {
                if (lazy) {
                    LOGGER.warn("No DataSource found with JNDI name [" + jndiName + "].");
                } else {
                    LOGGER.error("No DataSource found with JNDI name [" + jndiName + "].");
                }
                return null;
            }
            return dataSource;
        }
        catch (NamingException e) {
            if (lazy) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

