/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class FrameworkEventAdapter
extends AbstractAdapter
implements FrameworkListener {
    public FrameworkEventAdapter(BundleContext context, EventAdmin admin) {
        super(admin);
        context.addFrameworkListener((FrameworkListener)this);
    }

    @Override
    public void destroy(BundleContext context) {
        context.removeFrameworkListener((FrameworkListener)this);
    }

    public void frameworkEvent(FrameworkEvent event) {
        Throwable thrown;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", event);
        Bundle bundle = event.getBundle();
        if (null != bundle) {
            ((Dictionary)properties).put("bundle.id", bundle.getBundleId());
            String symbolicName = bundle.getSymbolicName();
            if (null != symbolicName) {
                ((Dictionary)properties).put("bundle.symbolicName", symbolicName);
            }
            ((Dictionary)properties).put("bundle", bundle);
        }
        if (null != (thrown = event.getThrowable())) {
            ((Dictionary)properties).put("exception.class", thrown.getClass().getName());
            String message = thrown.getMessage();
            if (null != message) {
                ((Dictionary)properties).put("exception.message", message);
            }
            ((Dictionary)properties).put("exception", thrown);
        }
        StringBuilder topic = new StringBuilder(FrameworkEvent.class.getName().replace('.', '/')).append('/');
        switch (event.getType()) {
            case 1: {
                topic.append("STARTED");
                break;
            }
            case 2: {
                topic.append("ERROR");
                break;
            }
            case 4: {
                topic.append("PACKAGES_REFRESHED");
                break;
            }
            case 8: {
                topic.append("STARTLEVEL_CHANGED");
                break;
            }
            case 16: {
                topic.append("WARNING");
                break;
            }
            case 32: {
                topic.append("INFO");
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.getEventAdmin().postEvent(new Event(topic.toString(), (Dictionary<String, ?>)properties));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

