/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;

abstract class AbstractClasspathConfigurationProvider
implements ConfigurationProvider {
    static final String DEFAULT_CONFIGURATION_FILE_NAME = "jollyday.properties";
    private final Properties properties;

    AbstractClasspathConfigurationProvider() {
        this(false);
    }

    AbstractClasspathConfigurationProvider(boolean searchOnlyInJar) {
        this.properties = this.loadProperties(searchOnlyInJar);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadProperties(boolean searchOnlyInJar) {
        return this.getConfigurationFile(searchOnlyInJar).map(this::toProperties).orElseGet(Properties::new);
    }

    private Properties toProperties(URL propertiesFile) {
        Properties props = new Properties();
        try (InputStream inputStream = propertiesFile.openStream();){
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default configuration from classpath.", e);
        }
        return props;
    }

    private Optional<URL> getConfigurationFile(boolean searchOnlyInJar) {
        return ResourceUtil.getResource(DEFAULT_CONFIGURATION_FILE_NAME, searchOnlyInJar);
    }
}

