/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Map;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import shaded.org.eclipse.aether.named.NamedLockFactory;

public abstract class NamedLockFactorySelectorSupport
implements NamedLockFactorySelector {
    public static final String FACTORY_KEY = "aether.syncContext.named.factory";
    public static final String NAME_MAPPER_KEY = "aether.syncContext.named.nameMapper";
    private final NamedLockFactory namedLockFactory;
    private final NameMapper nameMapper;

    public NamedLockFactorySelectorSupport(Map<String, NamedLockFactory> factories, String defaultFactoryName, Map<String, NameMapper> nameMappers, String defaultNameMapperName) {
        this.namedLockFactory = this.selectNamedLockFactory(factories, this.getFactoryName(defaultFactoryName));
        this.nameMapper = this.selectNameMapper(nameMappers, this.getNameMapperName(defaultNameMapperName));
    }

    @Override
    public NamedLockFactory getSelectedNamedLockFactory() {
        return this.namedLockFactory;
    }

    @Override
    public NameMapper getSelectedNameMapper() {
        return this.nameMapper;
    }

    protected String getFactoryName(String defaultFactoryName) {
        return System.getProperty(FACTORY_KEY, defaultFactoryName);
    }

    protected String getNameMapperName(String defaultNameMapperName) {
        return System.getProperty(NAME_MAPPER_KEY, defaultNameMapperName);
    }

    private NamedLockFactory selectNamedLockFactory(Map<String, NamedLockFactory> factories, String factoryName) {
        NamedLockFactory factory = factories.get(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: " + factoryName + ", known ones: " + factories.keySet());
        }
        return factory;
    }

    private NameMapper selectNameMapper(Map<String, NameMapper> nameMappers, String mapperName) {
        NameMapper nameMapper = nameMappers.get(mapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: " + mapperName + ", known ones: " + nameMappers.keySet());
        }
        return nameMapper;
    }
}

