/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Expression {
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    private MathContext mc = MathContext.DECIMAL32;
    private String expression = null;
    private List<Token> rpn = null;
    private Map<String, Operator> operators = new HashMap<String, Operator>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private Map<String, Object> constants = new HashMap<String, Object>();
    private final char decimalSeparator = (char)46;
    private final char minusSign = (char)45;

    public Expression(String expression) {
        this.expression = expression;
        this.addOperator(new Assignment("=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v2;
            }
        });
        this.addOperator(new Assignment("+=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.add(v2, Expression.this.mc);
            }

            @Override
            public Object eval(String v1, String v2) {
                return v1 + v2;
            }
        });
        this.addOperator(new Assignment("-=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.subtract(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("*=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.multiply(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("/=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.divide(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("%=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.remainder(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("|=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().or(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("&=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().and(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("^=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().xor(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Assignment("<<=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().shiftLeft(v2.intValue()), Expression.this.mc);
            }
        });
        this.addOperator(new Assignment(">>=", 5){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().shiftRight(v2.intValue()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator("<<", 10, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().shiftLeft(v2.intValue()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator(">>", 10, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().shiftRight(v2.intValue()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator("|", 15, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().or(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator("&", 15, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().and(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator("^", 15, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return new BigDecimal(v1.toBigInteger().xor(v2.toBigInteger()), Expression.this.mc);
            }
        });
        this.addOperator(new Operator("+", 20, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.add(v2, Expression.this.mc);
            }

            @Override
            public Object eval(String v1, String v2) {
                return v1 + v2;
            }
        });
        this.addOperator(new Operator("-", 20, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.subtract(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("*", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.multiply(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("/", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.divide(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("%", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.remainder(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("**", 40, false){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                int signOf2 = v2.signum();
                double dn1 = v1.doubleValue();
                v2 = v2.multiply(new BigDecimal(signOf2));
                BigDecimal remainderOf2 = v2.remainder(BigDecimal.ONE);
                BigDecimal n2IntPart = v2.subtract(remainderOf2);
                BigDecimal intPow = v1.pow(n2IntPart.intValueExact(), Expression.this.mc);
                BigDecimal doublePow = new BigDecimal(Math.pow(dn1, remainderOf2.doubleValue()));
                BigDecimal result = intPow.multiply(doublePow, Expression.this.mc);
                if (signOf2 == -1) {
                    result = BigDecimal.ONE.divide(result, Expression.this.mc.getPrecision(), RoundingMode.HALF_UP);
                }
                return result;
            }
        });
        this.addOperator(new Operator("&&", 4, false){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 && b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("||", 2, false){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 || b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Comparator(">", 10){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) > 0;
            }
        });
        this.addOperator(new Comparator(">=", 10){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) >= 0;
            }
        });
        this.addOperator(new Comparator("<", 10){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) < 0;
            }
        });
        this.addOperator(new Comparator("<=", 10){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) <= 0;
            }
        });
        this.addOperator(new Comparator("==", 7){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) == 0;
            }
        });
        this.addOperator(new Comparator("!=", 7){

            public boolean compare(Comparable v1, Comparable v2) {
                return v1.compareTo(v2) != 0;
            }
        });
        this.addFunction(new Function("NOT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                boolean zero = parameters.get(0).compareTo(BigDecimal.ZERO) == 0;
                return zero ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addFunction(new Function("IF", 3){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                boolean isTrue = !parameters.get(0).equals(BigDecimal.ZERO);
                return isTrue ? parameters.get(1) : parameters.get(2);
            }
        });
        this.addFunction(new Function("RANDOM", 0){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.random();
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.sin(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.cos(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.tan(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SINH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.sinh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COSH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.cosh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TANH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.tanh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("RAD", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toRadians(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("DEG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toDegrees(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("MAX", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal v2;
                BigDecimal v1 = parameters.get(0);
                return v1.compareTo(v2 = parameters.get(1)) > 0 ? v1 : v2;
            }
        });
        this.addFunction(new Function("MIN", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal v2;
                BigDecimal v1 = parameters.get(0);
                return v1.compareTo(v2 = parameters.get(1)) < 0 ? v1 : v2;
            }
        });
        this.addFunction(new Function("ABS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                return parameters.get(0).abs(Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.log(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ROUND", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                int precision = parameters.get(1).intValue();
                return toRound.setScale(precision, Expression.this.mc.getRoundingMode());
            }
        });
        this.addFunction(new Function("FLOOR", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.FLOOR);
            }
        });
        this.addFunction(new Function("CEILING", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.CEILING);
            }
        });
        this.addFunction(new Function("SQRT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigInteger ixPrev;
                BigDecimal x = parameters.get(0);
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    return new BigDecimal(0);
                }
                if (x.signum() < 0) {
                    throw new ExpressionException("Argument to SQRT() function must not be negative");
                }
                BigInteger n = x.movePointRight(Expression.this.mc.getPrecision() << 1).toBigInteger();
                int bits = n.bitLength() + 1 >> 1;
                BigInteger ix = n.shiftRight(bits);
                do {
                    ixPrev = ix;
                    ix = ix.add(n.divide(ix)).shiftRight(1);
                    Thread.yield();
                } while (ix.compareTo(ixPrev) != 0);
                return new BigDecimal(ix, Expression.this.mc.getPrecision());
            }
        });
        this.constants.put("PI", PI);
        this.constants.put("TRUE", Boolean.TRUE);
        this.constants.put("FALSE", Boolean.FALSE);
    }

    private boolean isNumber(String st) {
        if (st == null || st.isEmpty() || st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isNumber(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        if (obj != null) {
            return this.isNumber(obj.toString());
        }
        return false;
    }

    private List<Token> shuntingYard(String expression) {
        ArrayList<Token> outputQueue = new ArrayList<Token>();
        Stack<Token> stack = new Stack<Token>();
        Tokenizer tokenizer = new Tokenizer(expression);
        String previousToken = null;
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (token.charAt(0) == '\"') {
                StringBuilder sb = new StringBuilder();
                boolean escaped = false;
                for (int i = 1; i < token.length() - 1; ++i) {
                    char ch = token.charAt(i);
                    if (escaped || ch != '\\') {
                        sb.append(ch);
                        continue;
                    }
                    escaped = true;
                }
                outputQueue.add(new Constant(sb.toString()));
            } else if (this.isNumber(token)) {
                outputQueue.add(new Constant(this.toBigDecimal(token)));
            } else if (this.constants.containsKey(token)) {
                outputQueue.add(new Constant(this.constants.get(token)));
            } else if (this.functions.containsKey(token.toUpperCase())) {
                stack.push(this.functions.get(token.toUpperCase()));
            } else if (Character.isLetter(token.charAt(0))) {
                outputQueue.add(new Variable(token));
            } else if (",".equals(token)) {
                while (!stack.isEmpty() && !(stack.peek() instanceof LeftParen)) {
                    outputQueue.add((Token)stack.pop());
                }
                if (stack.isEmpty()) {
                    outputQueue.add(new Comma());
                }
            } else if (this.operators.containsKey(token)) {
                Token token2;
                Operator o1 = this.operators.get(token);
                Token token3 = token2 = stack.isEmpty() ? null : (Token)stack.peek();
                while (token2 instanceof Operator && (o1.isLeftAssoc() && o1.getPrecedence() <= ((Operator)token2).getPrecedence() || o1.getPrecedence() < ((Operator)token2).getPrecedence())) {
                    outputQueue.add((Token)stack.pop());
                    token2 = stack.isEmpty() ? null : (Token)stack.peek();
                }
                stack.push(o1);
            } else if ("(".equals(token)) {
                if (previousToken != null && this.isNumber(previousToken)) {
                    throw new ExpressionException("Missing operator at character position " + tokenizer.getPos());
                }
                stack.push(new LeftParen());
            } else if (")".equals(token)) {
                while (!stack.isEmpty() && !(stack.peek() instanceof LeftParen)) {
                    outputQueue.add((Token)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new RuntimeException("Mismatched parentheses");
                }
                stack.pop();
                if (!stack.isEmpty() && stack.peek() instanceof Function) {
                    outputQueue.add((Token)stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Token element = (Token)stack.pop();
            if (element instanceof LeftParen) {
                throw new RuntimeException("Mismatched parentheses");
            }
            if (!(element instanceof Operator)) {
                throw new RuntimeException("Unknown operator or function: " + element);
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    public Object eval() {
        return this.eval(new HashMap<String, Object>());
    }

    public Object eval(Map<String, Object> variables) {
        Stack<Object> stack = new Stack<Object>();
        for (Token token : this.getRPN()) {
            if (token instanceof Operator) {
                Object v1 = stack.pop();
                Object v2 = stack.pop();
                Object oResult = ((Operator)token).eval(variables, v2, v1);
                stack.push(oResult);
                continue;
            }
            if (token instanceof Constant) {
                stack.push(((Constant)token).getValue());
                continue;
            }
            if (token instanceof Function) {
                Function f = (Function)token;
                ArrayList<Object> p = new ArrayList<Object>(f.getNumParams());
                for (int i = 0; i < f.numParams; ++i) {
                    p.add(0, stack.pop());
                }
                BigDecimal fResult = f.eval(variables, p);
                stack.push(fResult);
                continue;
            }
            if (token instanceof Comma) {
                stack.pop();
                continue;
            }
            stack.push(token);
        }
        if (stack.size() > 1) {
            throw new IllegalArgumentException("Missing operator");
        }
        Object result = stack.pop();
        if (result instanceof Variable) {
            result = variables.get(((Variable)result).getName());
        }
        if (result instanceof BigDecimal) {
            result = this.toResult((BigDecimal)result);
        }
        return result;
    }

    private Number toResult(BigDecimal r) {
        long l = r.longValue();
        if (new BigDecimal(l).compareTo(r) == 0) {
            return l;
        }
        double d = r.doubleValue();
        if (new BigDecimal(d).compareTo(r) == 0) {
            return d;
        }
        return r.stripTrailingZeros();
    }

    private BigDecimal toBigDecimal(Map<String, Object> variables, Object o) {
        if (o instanceof Variable) {
            o = variables.get(((Variable)o).getName());
        }
        if (o instanceof String) {
            if (this.isNumber((String)o)) {
                return new BigDecimal((String)o, this.mc);
            }
            if (Character.isLetter(((String)o).charAt(0))) {
                o = variables.get(o);
            }
        }
        return this.toBigDecimal(o);
    }

    private BigDecimal toBigDecimal(Object o) {
        if (o == null) {
            return BigDecimal.ZERO;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).round(this.mc);
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o, this.mc);
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue(), this.mc);
        }
        try {
            return new BigDecimal(o.toString(), this.mc);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(Double.NaN);
        }
    }

    public Expression setPrecision(int precision) {
        this.mc = new MathContext(precision);
        return this;
    }

    public Expression setRoundingMode(RoundingMode roundingMode) {
        this.mc = new MathContext(this.mc.getPrecision(), roundingMode);
        return this;
    }

    public Operator addOperator(Operator operator) {
        return this.operators.put(operator.getOper(), operator);
    }

    public Function addFunction(Function function) {
        return this.functions.put(function.getName(), function);
    }

    public Expression addConstant(String name, Object value) {
        this.constants.put(name, value);
        return this;
    }

    public Iterator<String> getExpressionTokenizer() {
        return new Tokenizer(this.expression);
    }

    private List<Token> getRPN() {
        if (this.rpn == null) {
            this.rpn = this.shuntingYard(this.expression);
        }
        return this.rpn;
    }

    public String toRPN() {
        StringBuilder result = new StringBuilder();
        for (Token st : this.getRPN()) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(st);
        }
        return result.toString();
    }

    private class Tokenizer
    implements Iterator<String> {
        private int pos = 0;
        private String input;
        private String previousToken;

        public Tokenizer(String input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        private char peekNextChar() {
            if (this.pos < this.input.length() - 1) {
                return this.input.charAt(this.pos + 1);
            }
            return '\u0000';
        }

        @Override
        public String next() {
            StringBuilder token = new StringBuilder();
            if (this.pos >= this.input.length()) {
                this.previousToken = null;
                return null;
            }
            char ch = this.input.charAt(this.pos);
            while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                ch = this.input.charAt(++this.pos);
            }
            if (Character.isDigit(ch)) {
                while ((Character.isDigit(ch) || ch == '.') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '-' && Character.isDigit(this.peekNextChar()) && ("(".equals(this.previousToken) || ",".equals(this.previousToken) || this.previousToken == null || Expression.this.operators.containsKey(this.previousToken))) {
                token.append('-');
                ++this.pos;
                token.append(this.next());
            } else if (Character.isLetter(ch)) {
                while ((Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '\"') {
                boolean escaped = false;
                token.append(this.input.charAt(this.pos++));
                do {
                    if (this.pos == this.input.length()) {
                        throw new IllegalArgumentException("Non terminated quote");
                    }
                    ch = this.input.charAt(this.pos++);
                    escaped = !escaped && ch == '\\';
                    token.append(ch);
                } while (escaped || ch != '\"');
            } else if (ch == '(' || ch == ')' || ch == ',') {
                token.append(ch);
                ++this.pos;
            } else {
                while (!(Character.isLetter(ch) || Character.isDigit(ch) || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                    token.append(this.input.charAt(this.pos));
                    ++this.pos;
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                    if (ch != '-') continue;
                }
                if (!Expression.this.operators.containsKey(token.toString())) {
                    throw new ExpressionException("Unknown operator '" + token + "' at position " + (this.pos - token.length() + 1));
                }
            }
            this.previousToken = token.toString();
            return this.previousToken;
        }

        @Override
        public void remove() {
            throw new ExpressionException("remove() not supported");
        }

        public int getPos() {
            return this.pos;
        }
    }

    public abstract class Assignment
    extends Operator {
        public Assignment(String assign, int precedence) {
            super(assign, precedence, true);
        }

        @Override
        public Object eval(Map<String, Object> variables, Object v1, Object v2) {
            if (!(v1 instanceof Variable)) {
                throw new IllegalArgumentException("Left hand side of operator " + this.getOper() + " should be a variable but found " + v1.toString());
            }
            String name = ((Variable)v1).getName();
            Object r = super.eval(variables, v1, v2);
            if (r instanceof Number) {
                r = Expression.this.toResult(Expression.this.toBigDecimal(r));
            }
            variables.put(name, r);
            return r;
        }
    }

    public abstract class Comparator
    extends Operator {
        public Comparator(String oper, int precedence) {
            super(oper, precedence, false);
        }

        @Override
        public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
            return this.compare(v1, v2) ? BigDecimal.ONE : BigDecimal.ZERO;
        }

        @Override
        public Object eval(String v1, String v2) {
            return this.compare((Comparable<?>)((Object)v1), (Comparable<?>)((Object)v2)) ? BigDecimal.ONE : BigDecimal.ZERO;
        }

        public abstract boolean compare(Comparable<?> var1, Comparable<?> var2);
    }

    public abstract class Operator
    implements Token {
        private String oper;
        private int precedence;
        private boolean leftAssoc;

        public Operator(String oper, int precedence, boolean leftAssoc) {
            this.oper = oper;
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        public String getOper() {
            return this.oper;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }

        public Object eval(Map<String, Object> variables, Object v1, Object v2) {
            boolean numeric;
            if (v1 instanceof Variable) {
                v1 = variables.get(((Variable)v1).getName());
            }
            if (v2 instanceof Variable) {
                v2 = variables.get(((Variable)v2).getName());
            }
            boolean bl = numeric = Expression.this.isNumber(v1) && Expression.this.isNumber(v2);
            if (numeric) {
                return this.eval(Expression.this.toBigDecimal(variables, v1), Expression.this.toBigDecimal(variables, v2));
            }
            return this.eval(v1 != null ? v1.toString() : "", v2 != null ? v2.toString() : "");
        }

        public Object eval(String v1, String v2) {
            return this.eval(Expression.this.toBigDecimal(v1), Expression.this.toBigDecimal(v2));
        }

        public abstract BigDecimal eval(BigDecimal var1, BigDecimal var2);

        public String toString() {
            return this.oper;
        }
    }

    public abstract class Function
    implements Token {
        private String name;
        private int numParams;

        public Function(String name, int numParams) {
            this.name = name.toUpperCase();
            this.numParams = numParams;
        }

        public String getName() {
            return this.name;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public BigDecimal eval(Map<String, Object> variables, List<Object> parameters) {
            ArrayList<BigDecimal> numericParameters = new ArrayList<BigDecimal>();
            for (Object o : parameters) {
                numericParameters.add(Expression.this.toBigDecimal(variables, o));
            }
            return this.eval(numericParameters);
        }

        public abstract BigDecimal eval(List<BigDecimal> var1);

        public String toString() {
            return this.name;
        }
    }

    public class Comma
    implements Token {
    }

    public class LeftParen
    implements Token {
        public String toString() {
            return "(";
        }
    }

    public class Variable
    implements Token {
        private final String name;

        public Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Constant
    implements Token {
        private final Object value;

        public Constant(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    static interface Token {
    }

    public class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;

        public ExpressionException(String message) {
            super(message);
        }
    }
}

