/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PemReader.class);
    private static final Pattern BEGIN_PATTERN = Pattern.compile("^\\-+BEGIN\\s+([\\w\\s]+)\\-+$");
    private static final Pattern END_PATTERN = Pattern.compile("^\\-+END\\s+([\\w\\s]+)\\-+$");
    private BufferedReader reader;
    private String tag;
    private int lines;

    public PemReader(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public PemReader(Reader in) {
        this.reader = new BufferedReader(in);
    }

    public PemReader(BufferedReader in) {
        this.reader = in;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String readNextBegin() throws IOException {
        String line;
        this.tag = null;
        while ((line = this.reader.readLine()) != null) {
            ++this.lines;
            Matcher matcher = BEGIN_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            this.tag = matcher.group(1);
            LOGGER.debug("Found Begin of {}", (Object)this.tag);
            break;
        }
        return this.tag;
    }

    public byte[] readToEnd() throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        while ((line = this.reader.readLine()) != null) {
            ++this.lines;
            Matcher matcher = END_PATTERN.matcher(line);
            if (matcher.matches()) {
                String end = matcher.group(1);
                if (end.equals(this.tag)) {
                    byte[] decode = StringUtil.base64ToByteArray(buffer.toString());
                    LOGGER.debug("Found End of {}", (Object)this.tag);
                    return decode;
                }
                LOGGER.warn("Found End of {}, but expected {}!", (Object)end, (Object)this.tag);
                break;
            }
            buffer.append(line);
        }
        this.tag = null;
        return null;
    }

    public int lines() {
        int lines = this.lines;
        this.lines = 0;
        return lines;
    }
}

