/// Set value of an interval timer.
pub unsafe fn __setitimer50(
    which: i32,
    new_val: &itimerval_t,
    old_val: &mut itimerval_t,
) -> Result<(), Errno> {
    let which = which as usize;
    let new_val_ptr = new_val as *const itimerval_t as usize;
    let old_val_ptr = old_val as *mut itimerval_t as usize;
    syscall3(SYS___SETITIMER50, which, new_val_ptr, old_val_ptr).map(drop)
}
