# This file contains test cases where the with items has an ambiguous left parenthesis.
# These cases should raise the correct syntax error and recover properly.

with (item1, item2),: ...
with (item1, item2), as f: ...
with (item1, item2), item3,: ...
with (*item): ...
with (*item) as f: ...
with (item := 10 as f): ...
with (item1, item2 := 10 as f): ...
with (x for x in range(10), item): ...
with (item, x for x in range(10)): ...

# Make sure the parser doesn't report the same error twice
with ((*item)): ...

with (*x for x in iter, item): ...
with (item1, *x for x in iter, item2): ...
with (x as f, *y): ...
with (*x, y as f): ...
with (x, yield y): ...
with (x, yield y, z): ...
with (x, yield from y): ...
with (x as f, y) as f: ...
with (x for x in iter as y): ...

# The inner `(...)` is parsed as parenthesized expression
with ((item as f)): ...

with (item as f), x: ...
with (item as f1) as f2: ...
with (item1 as f, item2 := 0): ...