// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// from ../pps-girs
// DO NOT EDIT

use crate::{ffi, Page, RenderAnnotsFlags};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "PpsRenderContext")]
    pub struct RenderContext(Object<ffi::PpsRenderContext, ffi::PpsRenderContextClass>);

    match fn {
        type_ => || ffi::pps_render_context_get_type(),
    }
}

impl RenderContext {
    pub const NONE: Option<&'static RenderContext> = None;

    #[doc(alias = "pps_render_context_new")]
    pub fn new(
        page: &impl IsA<Page>,
        rotation: i32,
        scale: f64,
        annot_flags: RenderAnnotsFlags,
    ) -> RenderContext {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::pps_render_context_new(
                page.as_ref().to_glib_none().0,
                rotation,
                scale,
                annot_flags.into_glib(),
            ))
        }
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::RenderContext>> Sealed for T {}
}

pub trait RenderContextExt: IsA<RenderContext> + sealed::Sealed + 'static {
    #[doc(alias = "pps_render_context_compute_scaled_size")]
    fn compute_scaled_size(&self, width_points: f64, height_points: f64) -> (i32, i32) {
        unsafe {
            let mut scaled_width = std::mem::MaybeUninit::uninit();
            let mut scaled_height = std::mem::MaybeUninit::uninit();
            ffi::pps_render_context_compute_scaled_size(
                self.as_ref().to_glib_none().0,
                width_points,
                height_points,
                scaled_width.as_mut_ptr(),
                scaled_height.as_mut_ptr(),
            );
            (scaled_width.assume_init(), scaled_height.assume_init())
        }
    }

    #[doc(alias = "pps_render_context_compute_scales")]
    fn compute_scales(&self, width_points: f64, height_points: f64) -> (f64, f64) {
        unsafe {
            let mut scale_x = std::mem::MaybeUninit::uninit();
            let mut scale_y = std::mem::MaybeUninit::uninit();
            ffi::pps_render_context_compute_scales(
                self.as_ref().to_glib_none().0,
                width_points,
                height_points,
                scale_x.as_mut_ptr(),
                scale_y.as_mut_ptr(),
            );
            (scale_x.assume_init(), scale_y.assume_init())
        }
    }

    #[doc(alias = "pps_render_context_compute_transformed_size")]
    fn compute_transformed_size(&self, width_points: f64, height_points: f64) -> (i32, i32) {
        unsafe {
            let mut transformed_width = std::mem::MaybeUninit::uninit();
            let mut transformed_height = std::mem::MaybeUninit::uninit();
            ffi::pps_render_context_compute_transformed_size(
                self.as_ref().to_glib_none().0,
                width_points,
                height_points,
                transformed_width.as_mut_ptr(),
                transformed_height.as_mut_ptr(),
            );
            (
                transformed_width.assume_init(),
                transformed_height.assume_init(),
            )
        }
    }

    #[doc(alias = "pps_render_context_set_page")]
    fn set_page(&self, page: &impl IsA<Page>) {
        unsafe {
            ffi::pps_render_context_set_page(
                self.as_ref().to_glib_none().0,
                page.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "pps_render_context_set_rotation")]
    fn set_rotation(&self, rotation: i32) {
        unsafe {
            ffi::pps_render_context_set_rotation(self.as_ref().to_glib_none().0, rotation);
        }
    }

    #[doc(alias = "pps_render_context_set_scale")]
    fn set_scale(&self, scale: f64) {
        unsafe {
            ffi::pps_render_context_set_scale(self.as_ref().to_glib_none().0, scale);
        }
    }

    #[doc(alias = "pps_render_context_set_target_size")]
    fn set_target_size(&self, target_width: i32, target_height: i32) {
        unsafe {
            ffi::pps_render_context_set_target_size(
                self.as_ref().to_glib_none().0,
                target_width,
                target_height,
            );
        }
    }
}

impl<O: IsA<RenderContext>> RenderContextExt for O {}
