// Copyright 2025 The Fuchsia Authors
//
// Licensed under a BSD-style license <LICENSE-BSD>, Apache License, Version 2.0
// <LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0>, or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your option.
// This file may not be copied, modified, or distributed except according to
// those terms.

#![allow(unused_braces)]

#[macro_use]
extern crate zerocopy;

fn main() {}

// These tests cause errors which are generated by a later compilation pass than
// the other errors we generate, and so if they're compiled in the same file,
// the compiler will never get to that pass, and so we won't get the errors.

mod private {
    #[derive(TryFromBytes)]
    pub struct StructWithNamedFields {
        pub a: u8,
        pub(self) b: u16,
    }

    const _: () = {
        let _: <StructWithNamedFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type = 0u8;
        let _: <StructWithNamedFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(b) }>>::Type = 0u16;
    };

    #[derive(TryFromBytes)]
    pub struct StructWithAnonFields(pub u8, pub(self) u16);

    const _: () = {
        let _: <StructWithAnonFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(0) }>>::Type = 0u8;
        let _: <StructWithAnonFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(1) }>>::Type = 0u16;
    };

    #[derive(TryFromBytes)]
    pub struct Union {
        pub a: u8,
        pub(self) b: u16,
    }

    const _: () = {
        let _: <Union as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type = 0u8;
        let _: <Union as zerocopy::HasField<_, _, { zerocopy::ident_id!(b) }>>::Type = 0u16;
    };

    #[derive(TryFromBytes)]
    #[repr(C)]
    pub enum Enum {
        A(u8, u16),
        B { a: u8, b: u16 },
    }

    const _: () = {
        let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(0) }>>::Type = 0u8;
        let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(1) }>>::Type = 0u16;

        let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type = 0u8;
        let _: <Enum as zerocopy::HasField<
            _,
            { zerocopy::ident_id!(B) },
            { zerocopy::ident_id!(b) },
        >>::Type = 0u16;
    };
}

use private::*;

const _: () = {
    let _: <StructWithNamedFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type =
        0u8;
    let _: <StructWithNamedFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(b) }>>::Type =
        0u16;
};

const _: () = {
    let _: <StructWithAnonFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(0) }>>::Type =
        0u8;
    let _: <StructWithAnonFields as zerocopy::HasField<_, _, { zerocopy::ident_id!(1) }>>::Type =
        0u16;
};

const _: () = {
    let _: <Union as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type = 0u8;
    let _: <Union as zerocopy::HasField<_, _, { zerocopy::ident_id!(b) }>>::Type = 0u16;
};

const _: () = {
    let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(0) }>>::Type = 0u8;
    let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(1) }>>::Type = 0u16;

    let _: <Enum as zerocopy::HasField<_, _, { zerocopy::ident_id!(a) }>>::Type = 0u8;
    let _: <Enum as zerocopy::HasField<
        _,
        { zerocopy::ident_id!(B) },
        { zerocopy::ident_id!(b) },
    >>::Type = 0u16;
};
