/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public abstract class AbstractDescriptor {
    private static final Log log = Log.getLog(AbstractDescriptor.class);
    public static final String VAR_OBJECT = "object";
    public static final String VAR_CONTEXT = "context";
    private static JexlEngine jexlEngine;
    private static final Map<String, Map<String, Boolean>> classInfoCache;
    private static final List<JexlUberspect.PropertyResolver> POJO;
    private static final JexlUberspect.ResolverStrategy JEXL_STRATEGY;
    @NotNull
    private String pluginId;
    @Nullable
    private Bundle originBundle;

    static {
        classInfoCache = new HashMap<String, Map<String, Boolean>>();
        POJO = List.of(JexlUberspect.JexlResolver.PROPERTY, JexlUberspect.JexlResolver.MAP, JexlUberspect.JexlResolver.LIST, JexlUberspect.JexlResolver.DUCK, JexlUberspect.JexlResolver.FIELD, JexlUberspect.JexlResolver.CONTAINER);
        JEXL_STRATEGY = (op, obj) -> {
            if (op == JexlOperator.ARRAY_GET) {
                return JexlUberspect.MAP;
            }
            if (op == JexlOperator.ARRAY_SET) {
                return JexlUberspect.MAP;
            }
            if (op == null && obj instanceof Map) {
                return JexlUberspect.MAP;
            }
            return POJO;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JexlExpression parseExpression(@NotNull String exprString) throws DBException {
        Class<AbstractDescriptor> clazz = AbstractDescriptor.class;
        synchronized (AbstractDescriptor.class) {
            if (jexlEngine == null) {
                jexlEngine = new JexlBuilder().cache(100).strategy(JEXL_STRATEGY).create();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return jexlEngine.createExpression(exprString);
            }
            catch (JexlException e) {
                throw new DBException("Bad expression", e);
            }
        }
    }

    @NotNull
    public static JexlContext makeContext(final @Nullable Object object, final @Nullable Object context) {
        return new JexlContext(){

            public Object get(String name) {
                return name.equals(AbstractDescriptor.VAR_OBJECT) ? object : (name.equals(AbstractDescriptor.VAR_CONTEXT) ? context : null);
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented");
            }

            public boolean has(String name) {
                return name.equals(AbstractDescriptor.VAR_OBJECT) && object != null || name.equals(AbstractDescriptor.VAR_CONTEXT) && context != null;
            }
        };
    }

    @Nullable
    public static Object evalExpression(@NotNull String exprString, @Nullable Object object, @Nullable Object context) {
        try {
            JexlExpression expression = AbstractDescriptor.parseExpression(exprString);
            return expression.evaluate(AbstractDescriptor.makeContext(object, context));
        }
        catch (DBException e) {
            log.error("Bad expression: " + exprString, e);
            return null;
        }
    }

    @NotNull
    private static synchronized Map<String, Boolean> getTypeInfoCache(@NotNull Class<?> clazz) {
        Map<String, Boolean> intCache = classInfoCache.get(clazz.getName());
        if (intCache != null) {
            return intCache;
        }
        intCache = new HashMap<String, Boolean>();
        classInfoCache.put(clazz.getName(), intCache);
        Class<?> sc = clazz;
        while (sc != null && sc != Object.class) {
            AbstractDescriptor.collectInterface(sc, intCache);
            sc = sc.getSuperclass();
        }
        return intCache;
    }

    private static void collectInterface(@NotNull Class<?> clazz, @NotNull Map<String, Boolean> intCache) {
        intCache.put(clazz.getName(), Boolean.TRUE);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            AbstractDescriptor.collectInterface(i, intCache);
            ++n2;
        }
    }

    @Nullable
    protected static Expression getEnablementExpression(@NotNull IConfigurationElement config) {
        return AbstractDescriptor.getEnablementExpression(config, "enabledWhen");
    }

    @Nullable
    protected static Expression getEnablementExpression(@NotNull IConfigurationElement config, @NotNull String expressionElementName) {
        IConfigurationElement[] elements = config.getChildren(expressionElementName);
        if (elements.length > 0) {
            try {
                IConfigurationElement[] enablement = elements[0].getChildren();
                if (enablement.length > 0) {
                    return ExpressionConverter.getDefault().perform(enablement[0]);
                }
            }
            catch (Exception e) {
                log.debug(e);
            }
        }
        return null;
    }

    protected static boolean isExpressionTrue(@Nullable Expression expression, @Nullable Object exprContext) {
        if (expression != null) {
            try {
                EvaluationContext context = new EvaluationContext(null, exprContext);
                EvaluationResult result = expression.evaluate((IEvaluationContext)context);
                if (result != EvaluationResult.TRUE) {
                    return false;
                }
            }
            catch (CoreException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return true;
    }

    protected AbstractDescriptor(@NotNull IConfigurationElement contributorConfig) {
        this.pluginId = contributorConfig.getContributor().getName();
    }

    protected AbstractDescriptor(@NotNull String pluginId) {
        this.pluginId = pluginId;
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public Bundle getContributorBundle() {
        if (this.originBundle == null) {
            this.originBundle = Platform.getBundle((String)this.pluginId);
            if (this.originBundle == null) {
                throw new IllegalStateException("Bundle '" + this.pluginId + "' not found in platform");
            }
        }
        return this.originBundle;
    }

    protected void replaceContributor(@NotNull IContributor contributor) {
        this.pluginId = contributor.getName();
        this.originBundle = null;
    }

    @NotNull
    protected DBPImage iconToImage(String icon, @NotNull DBPImage defIcon) {
        DBPImage result = this.iconToImage(icon);
        return Objects.requireNonNullElse(result, defIcon);
    }

    @Nullable
    public DBPImage iconToImage(@Nullable String icon) {
        if (CommonUtils.isEmpty((String)icon)) {
            return null;
        }
        if (((String)icon).startsWith("#")) {
            return DBIcon.getImageById(((String)icon).substring(1));
        }
        if (!((String)icon).startsWith("platform:")) {
            icon = "platform:/plugin/" + this.pluginId + "/" + (String)icon;
        }
        return new DBIcon((String)icon);
    }

    @NotNull
    public Class<?> getImplClass(@NotNull String className) {
        return AbstractDescriptor.getImplClass(this.getContributorBundle(), className, null);
    }

    @NotNull
    public <T> Class<T> getImplClass(@NotNull String className, @NotNull Class<T> type) {
        return AbstractDescriptor.getImplClass(this.getContributorBundle(), className, type);
    }

    @NotNull
    public static <T> Class<T> getImplClass(@NotNull Bundle fromBundle, @NotNull String className, @Nullable Class<T> type) {
        Class objectClass;
        try {
            objectClass = fromBundle.loadClass(className);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't determine object class '" + className + "'", ex);
        }
        if (type != null && !type.isAssignableFrom(objectClass)) {
            throw new IllegalStateException("Object class '" + className + "' doesn't match requested type '" + type.getName() + "'");
        }
        return objectClass;
    }

    @Nullable
    public Class<?> getObjectClass(@NotNull String className) {
        return AbstractDescriptor.getObjectClass(this.getContributorBundle(), className, null);
    }

    @Nullable
    public <T> Class<T> getObjectClass(@NotNull String className, @NotNull Class<T> type) {
        return AbstractDescriptor.getObjectClass(this.getContributorBundle(), className, type);
    }

    @Nullable
    public static <T> Class<T> getObjectClass(@NotNull Bundle fromBundle, @NotNull String className, @Nullable Class<T> type) {
        Class objectClass;
        try {
            objectClass = fromBundle.loadClass(className);
        }
        catch (Throwable ex) {
            log.error("Can't determine object class '" + className + "'", ex);
            return null;
        }
        if (type != null && !type.isAssignableFrom(objectClass)) {
            log.error("Object class '" + className + "' doesn't match requested type '" + type.getName() + "'");
            return null;
        }
        return objectClass;
    }

    public class ObjectType {
        private static final String ATTR_NAME = "name";
        private static final String ATTR_IF = "if";
        private static final String ATTR_FORCE_CHECK = "forceCheck";
        @Nullable
        private final String implName;
        @Nullable
        private Class<?> implClass;
        @Nullable
        private JexlExpression expression;
        private boolean forceCheck;

        public ObjectType(String implName) {
            this.implName = implName;
        }

        public ObjectType(IConfigurationElement cfg) {
            this(cfg, ATTR_NAME);
        }

        public ObjectType(@NotNull IConfigurationElement cfg, String typeAttr) {
            String fcAttr;
            this.implName = cfg.getAttribute(typeAttr);
            String condition = cfg.getAttribute(ATTR_IF);
            if (!CommonUtils.isEmpty((String)condition)) {
                try {
                    this.expression = AbstractDescriptor.parseExpression(condition);
                }
                catch (DBException ex) {
                    log.warn("Can't parse object type expression: " + condition, ex);
                }
            }
            if (!CommonUtils.isEmpty((String)(fcAttr = cfg.getAttribute(ATTR_FORCE_CHECK)))) {
                this.forceCheck = CommonUtils.toBoolean((Object)fcAttr);
            }
        }

        @Nullable
        public String getImplName() {
            return this.implName;
        }

        @NotNull
        public Class<?> getImplClass() {
            return this.getImplClass(Object.class);
        }

        @NotNull
        public <T> Class<? extends T> getImplClass(Class<T> type) {
            if (this.implName == null) {
                throw new IllegalStateException("Class name not specified");
            }
            if (this.implClass == null) {
                this.implClass = AbstractDescriptor.this.getImplClass(this.implName, type);
            }
            return this.implClass;
        }

        @Nullable
        public Class<?> getObjectClass() {
            return this.getObjectClass(Object.class);
        }

        @Nullable
        public <T> Class<? extends T> getObjectClass(@NotNull Class<T> type) {
            if (this.implName == null) {
                return null;
            }
            if (this.implClass == null) {
                this.implClass = AbstractDescriptor.this.getObjectClass(this.implName, type);
            }
            return this.implClass;
        }

        public <T> void checkObjectClass(@NotNull Class<T> type) throws DBException {
            Class<T> objectClass = this.getObjectClass(type);
            if (this.implName == null) {
                throw new DBException("Implementation class not specified");
            }
            if (objectClass == null) {
                throw new DBException("Class '" + this.implName + "' not found");
            }
            if (!type.isAssignableFrom(objectClass)) {
                throw new DBException("Class '" + this.implName + "' do not implements '" + type.getName() + "'");
            }
        }

        public boolean appliesTo(@NotNull Object object, @Nullable Object context) {
            if (!this.matchesType(object.getClass())) {
                return false;
            }
            if (this.expression != null) {
                try {
                    Object result = this.expression.evaluate(AbstractDescriptor.makeContext(object, context));
                    return Boolean.TRUE.equals(result);
                }
                catch (Exception e) {
                    log.debug("Error evaluating EL expression '" + String.valueOf(this.expression) + "'", e);
                    return false;
                }
            }
            return true;
        }

        @NotNull
        public <T> T createInstance(@NotNull Class<T> type, Object ... args) throws DBException {
            if (this.implName == null) {
                throw new DBException("No implementation class name set for '" + type.getName() + "'");
            }
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Can't load class '" + this.getImplName() + "'");
            }
            try {
                Constructor<?>[] constructorArray = objectClass.getConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> c = constructorArray[n2];
                    Class<?>[] parameterTypes = c.getParameterTypes();
                    if (parameterTypes.length == args.length) {
                        boolean matches = true;
                        int i = 0;
                        while (i < parameterTypes.length) {
                            if (!parameterTypes[i].isInstance(args[i])) {
                                matches = false;
                                break;
                            }
                            ++i;
                        }
                        if (matches) {
                            return (T)c.newInstance(args);
                        }
                    }
                    ++n2;
                }
                throw new DBException("Cannot find constructor matching args " + Arrays.toString(args));
            }
            catch (Exception e) {
                throw new DBException("Can't instantiate class '" + this.getImplName() + "'", e);
            }
        }

        @NotNull
        public <T> T createInstance(@NotNull Class<T> type) throws DBException {
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Can't load class '" + this.getImplName() + "'");
            }
            try {
                return objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new DBException("Can't instantiate class '" + this.getImplName() + "'", e);
            }
        }

        public boolean matchesType(@NotNull Class<?> clazz) {
            if (AbstractDescriptor.this.getContributorBundle().getState() != 32 && !this.forceCheck) {
                return AbstractDescriptor.getTypeInfoCache(clazz).containsKey(this.implName);
            }
            this.getObjectClass();
            return this.implClass != null && this.implClass.isAssignableFrom(clazz);
        }

        public String toString() {
            return this.implName;
        }
    }
}

