//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilewrapperreadingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileWrapperReadingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileWrapperReadingOptions: NSUInteger {
        #[doc(alias = "NSFileWrapperReadingImmediate")]
        const Immediate = 1<<0;
        #[doc(alias = "NSFileWrapperReadingWithoutMapping")]
        const WithoutMapping = 1<<1;
    }
}

unsafe impl Encode for NSFileWrapperReadingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileWrapperReadingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilewrapperwritingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileWrapperWritingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileWrapperWritingOptions: NSUInteger {
        #[doc(alias = "NSFileWrapperWritingAtomic")]
        const Atomic = 1<<0;
        #[doc(alias = "NSFileWrapperWritingWithNameUpdating")]
        const WithNameUpdating = 1<<1;
    }
}

unsafe impl Encode for NSFileWrapperWritingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileWrapperWritingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilewrapper?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileWrapper;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSFileWrapper {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFileWrapper {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSFileWrapper {}
);

impl NSFileWrapper {
    extern_methods!(
        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithURL:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithURL_options_error(
            this: Allocated<Self>,
            url: &NSURL,
            options: NSFileWrapperReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(initDirectoryWithFileWrappers:))]
        #[unsafe(method_family = init)]
        pub fn initDirectoryWithFileWrappers(
            this: Allocated<Self>,
            children_by_preferred_name: &NSDictionary<NSString, NSFileWrapper>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initRegularFileWithContents:))]
        #[unsafe(method_family = init)]
        pub fn initRegularFileWithContents(
            this: Allocated<Self>,
            contents: &NSData,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(initSymbolicLinkWithDestinationURL:))]
        #[unsafe(method_family = init)]
        pub fn initSymbolicLinkWithDestinationURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithSerializedRepresentation:))]
        #[unsafe(method_family = init)]
        pub fn initWithSerializedRepresentation(
            this: Allocated<Self>,
            serialize_representation: &NSData,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSCoder")]
        /// # Safety
        ///
        /// `in_coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            in_coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(isDirectory))]
        #[unsafe(method_family = none)]
        pub fn isDirectory(&self) -> bool;

        #[unsafe(method(isRegularFile))]
        #[unsafe(method_family = none)]
        pub fn isRegularFile(&self) -> bool;

        #[unsafe(method(isSymbolicLink))]
        #[unsafe(method_family = none)]
        pub fn isSymbolicLink(&self) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(preferredFilename))]
        #[unsafe(method_family = none)]
        pub fn preferredFilename(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`preferredFilename`][Self::preferredFilename].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setPreferredFilename:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredFilename(&self, preferred_filename: Option<&NSString>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(filename))]
        #[unsafe(method_family = none)]
        pub fn filename(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`filename`][Self::filename].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setFilename:))]
        #[unsafe(method_family = none)]
        pub fn setFilename(&self, filename: Option<&NSString>);

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(fileAttributes))]
        #[unsafe(method_family = none)]
        pub fn fileAttributes(&self) -> Retained<NSDictionary<NSString, AnyObject>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// Setter for [`fileAttributes`][Self::fileAttributes].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `file_attributes` generic should be of the correct type.
        #[unsafe(method(setFileAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFileAttributes(&self, file_attributes: &NSDictionary<NSString, AnyObject>);

        #[cfg(feature = "NSURL")]
        #[unsafe(method(matchesContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub fn matchesContentsOfURL(&self, url: &NSURL) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(readFromURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn readFromURL_options_error(
            &self,
            url: &NSURL,
            options: NSFileWrapperReadingOptions,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(writeToURL:options:originalContentsURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn writeToURL_options_originalContentsURL_error(
            &self,
            url: &NSURL,
            options: NSFileWrapperWritingOptions,
            original_contents_url: Option<&NSURL>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(serializedRepresentation))]
        #[unsafe(method_family = none)]
        pub fn serializedRepresentation(&self) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(addFileWrapper:))]
        #[unsafe(method_family = none)]
        pub fn addFileWrapper(&self, child: &NSFileWrapper) -> Retained<NSString>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        #[unsafe(method(addRegularFileWithContents:preferredFilename:))]
        #[unsafe(method_family = none)]
        pub fn addRegularFileWithContents_preferredFilename(
            &self,
            data: &NSData,
            file_name: &NSString,
        ) -> Retained<NSString>;

        #[unsafe(method(removeFileWrapper:))]
        #[unsafe(method_family = none)]
        pub fn removeFileWrapper(&self, child: &NSFileWrapper);

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(fileWrappers))]
        #[unsafe(method_family = none)]
        pub fn fileWrappers(&self) -> Option<Retained<NSDictionary<NSString, NSFileWrapper>>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(keyForFileWrapper:))]
        #[unsafe(method_family = none)]
        pub fn keyForFileWrapper(&self, child: &NSFileWrapper) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(regularFileContents))]
        #[unsafe(method_family = none)]
        pub fn regularFileContents(&self) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(symbolicLinkDestinationURL))]
        #[unsafe(method_family = none)]
        pub fn symbolicLinkDestinationURL(&self) -> Option<Retained<NSURL>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileWrapper {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFileWrapper {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSDeprecated.
impl NSFileWrapper {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[deprecated = "Use -initWithURL:options:error: instead."]
        #[unsafe(method(initWithPath:))]
        #[unsafe(method_family = init)]
        pub fn initWithPath(this: Allocated<Self>, path: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -initSymbolicLinkWithDestinationURL: and -setPreferredFileName:, if necessary, instead."]
        #[unsafe(method(initSymbolicLinkWithDestination:))]
        #[unsafe(method_family = init)]
        pub fn initSymbolicLinkWithDestination(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -matchesContentsOfURL: instead."]
        #[unsafe(method(needsToBeUpdatedFromPath:))]
        #[unsafe(method_family = none)]
        pub fn needsToBeUpdatedFromPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -readFromURL:options:error: instead."]
        #[unsafe(method(updateFromPath:))]
        #[unsafe(method_family = none)]
        pub fn updateFromPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -writeToURL:options:originalContentsURL:error: instead."]
        #[unsafe(method(writeToFile:atomically:updateFilenames:))]
        #[unsafe(method_family = none)]
        pub fn writeToFile_atomically_updateFilenames(
            &self,
            path: &NSString,
            atomic_flag: bool,
            update_filenames_flag: bool,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[deprecated = "Instantiate a new NSFileWrapper with -initWithURL:options:error:, send it -setPreferredFileName: if necessary, then use -addFileWrapper: instead."]
        #[unsafe(method(addFileWithPath:))]
        #[unsafe(method_family = none)]
        pub fn addFileWithPath(&self, path: &NSString) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Instantiate a new NSFileWrapper with -initWithSymbolicLinkDestinationURL:, send it -setPreferredFileName: if necessary, then use -addFileWrapper: instead."]
        #[unsafe(method(addSymbolicLinkWithDestination:preferredFilename:))]
        #[unsafe(method_family = none)]
        pub fn addSymbolicLinkWithDestination_preferredFilename(
            &self,
            path: &NSString,
            filename: &NSString,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -symbolicLinkDestinationURL instead."]
        #[unsafe(method(symbolicLinkDestination))]
        #[unsafe(method_family = none)]
        pub fn symbolicLinkDestination(&self) -> Retained<NSString>;
    );
}
