## RabbitMQ 3.7.17

RabbitMQ `3.7.17` is a maintenance release. It focuses on bug fixes and upgrades
a JavaScript dependency in the management UI to patch three CVEs in that library.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * `amqqueue` module and the feature flag subsystem were backported from 3.8. This makes it possible
   for plugin developers to target both `3.7.x` and `3.8.x` release series.

   Note that this only backports the API. There are no feature flags to enable in `3.7.17`.
   No 3.8-specific features that must be enabled via feature flags were backported and there are no
   plans to do it in later `3.7.x` releases.

   GitHub issue: [rabbitmq/rabbitmq-server#2028](https://github.com/rabbitmq/rabbitmq-server/issues/2028)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl stop` description had a typo.

   Contributed by Eugene Pirogov.

   GitHub issue: [rabbitmq/rabbitmq-cli#363](https://github.com/rabbitmq/rabbitmq-cli/pull/363)

#### Enhancements

 * Commands that take passwords as arguments now accept them via standard input.

   GitHub issue: [rabbitmq/rabbitmq-cli#365](https://github.com/rabbitmq/rabbitmq-cli/issues/365)

 * `rabbitmq-diagnostics observer` no longer requires RabbitMQ application to be running on
   the target node.

   GitHub issue: [rabbitmq/rabbitmq-cli#368](https://github.com/rabbitmq/rabbitmq-cli/pull/368)


### Management Plugin

#### Bug Fixes

 * jQuery has been upgraded to `3.4.x`. This series addresses a number of known CVEs in the library: [CVE-2015-9251](https://nvd.nist.gov/vuln/detail/CVE-2015-9251), [CVE-2017-16012](https://nvd.nist.gov/vuln/detail/CVE-2017-16012), [CVE-2019-11358](https://nvd.nist.gov/vuln/detail/CVE-2019-11358).

   GitHub issue: [rabbitmq/rabbitmq-management#714](https://github.com/rabbitmq/rabbitmq-management/issues/714)

 * Blank effective policy definitions were formatted as a JSON array instead of an empty object in API responses.

   GitHub issue: [rabbitmq/rabbitmq-management#701](https://github.com/rabbitmq/rabbitmq-management/issues/701)

#### Usability

 * Definition import endpoint no longer reports progress via `102 Processing` responses. They proved to be problematic
   for some HTTP clients, including `rabbitmqadmin`.

   GitHub issues: [rabbitmq/rabbitmq-management#715](https://github.com/rabbitmq/rabbitmq-management/issues/715), [rabbitmq/rabbitmq-management#718](https://github.com/rabbitmq/rabbitmq-management/pull/718)

 * Leading and trailing white space characters are now highlighted in queue and exchange names to make them easier to spot.
   Tab characters are highlighted as well, even in the middle of the word. The idea is that those characters are typically used by mistake and should be easier to notice.

   GitHub issue: [rabbitmq/rabbitmq-management#721](https://github.com/rabbitmq/rabbitmq-management/pull/721)

 * It wasn't possible to delete a binding declared with `routing_key` set to `null` (only possible via the HTTP API).
   Now such bindings can be deleted but this practice is highly discouraged. Future HTTP API versions might refuse to accept
   `null` values as they are impossible to declare via AMQP 0-9-1.

   GitHub issue: [rabbitmq/rabbitmq-management#723](https://github.com/rabbitmq/rabbitmq-management/pull/723)


### Shovel Management Plugin

#### Bug Fixes

 * Shovel restart link conflicted with that in the Federation management plugin. When both were enabled, only one
   was actually functional.

   GitHub issue: [rabbitmq/rabbitmq-shovel-management#35](https://github.com/rabbitmq/rabbitmq-shovel-management/issues/35)

 * Shovel URI was misformatted for a period of time after UI refresh happened and before the Shovel was fully initialised and running.

   GitHub issue: [rabbitmq/rabbitmq-shovel-management#37](https://github.com/rabbitmq/rabbitmq-shovel-management/issues/37)

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.17.tar.xz`.
