<?php
/**
 * Aliases for special pages for extension Echo
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'Notifications' => [ 'Notifications' ],
	'DisplayNotificationsConfiguration' => [ 'DisplayNotificationsConfiguration' ],
	'NotificationsMarkRead' => [ 'NotificationsMarkRead' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'Notifications' => [ 'إشعارات' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'Notifications' => [ 'اخطارات' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'Notifications' => [ 'Уведомления' ],
];

/** Azerbaijani (Azərbaycanca) */
$specialPageAliases['az'] = [
	'Notifications' => [ 'Bildirişlər' ],
	'DisplayNotificationsConfiguration' => [ 'BildirişKonfiqurasiyasınıGöstər' ],
	'NotificationsMarkRead' => [ 'OxunmuşOlaraqİşarələ' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'Notifications' => [ 'آگاه_کورتینۆک_ئان' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'Notifications' => [ 'বিজ্ঞপ্তি' ],
	'DisplayNotificationsConfiguration' => [ 'বিজ্ঞপ্তি_কনফিগারেশন_প্রদর্শন' ],
	'NotificationsMarkRead' => [ 'বিজ্ঞপ্তি_পঠিতরূপে_চিহ্নিত', 'বিজ্ঞপ্তি_পঠিত_হিসেবে_চিহ্নিত' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'Notifications' => [ '提醒' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'Notifications' => [ 'ДӀахаийтар' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'Notifications' => [ 'Upozornění' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'Notifications' => [ 'Benachrichtigungen' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'Notifications' => [ 'Mengeneyi' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'Notifications' => [ 'Ειδοποιήσεις' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'Notifications' => [ 'Atentigoj' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'Notifications' => [ 'Notificaciones' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'Notifications' => [ 'Teavitused' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'Notifications' => [ 'آگاه‌سازی‌ها' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'Notifications' => [ 'Ilmoitukset' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Notifications' => [ 'Notificacións' ],
];

/** Hawaiian (Hawai`i) */
$specialPageAliases['haw'] = [
	'Notifications' => [ 'Notikala' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'Notifications' => [ 'הודעות', 'כל_ההודעות' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'Notifications' => [ 'Zdźělenja' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'Notifications' => [ 'Notifikasi' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'Notifications' => [ 'Notifiche' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'Notifications' => [ '通知' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'Notifications' => [ '알림' ],
];

/** Kurdish (Latin script) (Kurdî (latînî)) */
$specialPageAliases['ku-latn'] = [
	'Notifications' => [ 'Agahdarî' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'Notifications' => [ 'Argemynow' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'Notifications' => [ 'Notifikatiounen' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'Notifications' => [ 'ڤارسیاریا' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'Notifications' => [ 'Известувања' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'Notifications' => [ 'അറിയിപ്പുകൾ' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'Notifications' => [ 'संदेश' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'Notifications' => [ 'Pemberitahuan' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'Notifications' => [ 'Notifiki' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'Notifications' => [ 'Varsler' ],
	'DisplayNotificationsConfiguration' => [ 'Vis_varselkonfigurasjon' ],
	'NotificationsMarkRead' => [ 'Merk_varsel_som_lest' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'Notifications' => [ 'Meldingen' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'Notifications' => [ 'Varsel' ],
	'DisplayNotificationsConfiguration' => [ 'Syn_varselkonfigurasjon' ],
	'NotificationsMarkRead' => [ 'Merk_varsel_som_lese' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'Notifications' => [ 'ਇਤਲਾਹਾਂ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'Notifications' => [ 'Powiadomienia' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'Notifications' => [ 'Notificações' ],
];

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = [
	'Notifications' => [ 'Notificações' ],
];

/** Quechua (Runa Simi) */
$specialPageAliases['qu'] = [
	'Notifications' => [ 'Willaykuykuna' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'Notifications' => [ 'Уведомления' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'Notifications' => [ 'Notifiche' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$specialPageAliases['sr-ec'] = [
	'Notifications' => [ 'Обавештења' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$specialPageAliases['sr-el'] = [
	'Notifications' => [ 'Obaveštenja' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'Notifications' => [ 'Meddelanden' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'Notifications' => [ 'Сповіщення', 'Уведомления' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'Notifications' => [ 'اطلاعات' ],
	'DisplayNotificationsConfiguration' => [ 'ترتیب_نمائش_اطلاعات' ],
	'NotificationsMarkRead' => [ 'اطلاعات_کی_خواندہ_نشان_زدگی' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'Notifications' => [ 'Notifiche' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'Notifications' => [ 'Thông_báo' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'Notifications' => [ 'Notifications' ],
	'DisplayNotificationsConfiguration' => [ 'DisplayNotificationsConfiguration' ],
	'NotificationsMarkRead' => [ 'NotificationsMarkRead' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'Notifications' => [ '通知' ],
	'DisplayNotificationsConfiguration' => [ '显示通知配置' ],
	'NotificationsMarkRead' => [ '标记通知为已读' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'Notifications' => [ '通知' ],
	'DisplayNotificationsConfiguration' => [ '顯示通知設定' ],
	'NotificationsMarkRead' => [ '標記通知為已讀' ],
];
