/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SyspropsMapWrapper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.IgnoringEmptyMap;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityProviderChoice;
import org.apache.sshd.common.util.security.SecurityUtils;

public interface SecurityProviderRegistrar
extends SecurityProviderChoice,
OptionalFeature,
PropertyResolver {
    public static final String CONFIG_PROP_BASE = "org.apache.sshd.security.provider";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String NAMED_PROVIDER_PROPERTY = "useNamed";
    public static final String ALL_OPTIONS_VALUE = "all";
    public static final String ALL_OPTIONS_WILDCARD = "*";
    public static final String NO_OPTIONS_VALUE = "none";
    public static final List<Class<?>> SECURITY_ENTITIES = Collections.unmodifiableList(Arrays.asList(Cipher.class, KeyFactory.class, MessageDigest.class, KeyPairGenerator.class, KeyAgreement.class, Mac.class, Signature.class, CertificateFactory.class));

    default public String getBasePropertyName() {
        return "org.apache.sshd.security.provider." + this.getName();
    }

    default public String getConfigurationPropertyName(String name) {
        return this.getBasePropertyName() + "." + name;
    }

    default public boolean isEnabled() {
        if (SecurityUtils.isAPrioriDisabledProvider(this.getName())) {
            return false;
        }
        String configPropName = this.getConfigurationPropertyName(ENABLED_PROPERTY);
        return this.getBooleanProperty(configPropName, true);
    }

    @Override
    default public PropertyResolver getParentPropertyResolver() {
        return SyspropsMapWrapper.RAW_PROPS_RESOLVER;
    }

    @Override
    default public Map<String, Object> getProperties() {
        return IgnoringEmptyMap.getInstance();
    }

    default public boolean isCipherSupported(String transformation) {
        return this.isSecurityEntitySupported(Cipher.class, transformation);
    }

    default public boolean isKeyFactorySupported(String algorithm) {
        return this.isSecurityEntitySupported(KeyFactory.class, algorithm);
    }

    default public boolean isMessageDigestSupported(String algorithm) {
        return this.isSecurityEntitySupported(MessageDigest.class, algorithm);
    }

    default public boolean isKeyPairGeneratorSupported(String algorithm) {
        return this.isSecurityEntitySupported(KeyPairGenerator.class, algorithm);
    }

    default public boolean isKeyAgreementSupported(String algorithm) {
        return this.isSecurityEntitySupported(KeyAgreement.class, algorithm);
    }

    default public boolean isMacSupported(String algorithm) {
        return this.isSecurityEntitySupported(Mac.class, algorithm);
    }

    default public boolean isSignatureSupported(String algorithm) {
        return this.isSecurityEntitySupported(Signature.class, algorithm);
    }

    default public boolean isCertificateFactorySupported(String type) {
        return this.isSecurityEntitySupported(CertificateFactory.class, type);
    }

    default public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        return "";
    }

    default public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        String defaultValue = this.getDefaultSecurityEntitySupportValue(entityType);
        return SecurityProviderRegistrar.isSecurityEntitySupported(this, entityType, name, defaultValue);
    }

    @Override
    default public boolean isNamedProviderUsed() {
        return PropertyResolverUtils.getBooleanProperty(this, this.getConfigurationPropertyName(NAMED_PROVIDER_PROPERTY), SecurityProviderChoice.super.isNamedProviderUsed());
    }

    public static boolean isAllOptionsValue(String v) {
        return ALL_OPTIONS_VALUE.equalsIgnoreCase(v) || ALL_OPTIONS_WILDCARD.equalsIgnoreCase(v);
    }

    public static boolean isSecurityEntitySupported(SecurityProviderRegistrar registrar, Class<?> entityType, String name, String defaultValue) {
        return Objects.requireNonNull(registrar, "No registrar instance").isSupported() && SecurityProviderRegistrar.isSecurityEntitySupported(registrar, registrar.getConfigurationPropertyName(entityType.getSimpleName()), entityType, name, defaultValue);
    }

    public static boolean isSecurityEntitySupported(PropertyResolver resolver, String propName, Class<?> entityType, String name, String defaultValue) {
        if (GenericUtils.isEmpty(name)) {
            return false;
        }
        String propValue = resolver.getString(propName);
        if (GenericUtils.isEmpty(propValue)) {
            propValue = defaultValue;
        }
        if (NO_OPTIONS_VALUE.equalsIgnoreCase(propValue)) {
            return false;
        }
        String[] values = GenericUtils.split(propValue, ',');
        if (GenericUtils.isEmpty(values)) {
            return false;
        }
        if (values.length == 1 && SecurityProviderRegistrar.isAllOptionsValue(values[0])) {
            return true;
        }
        String effectiveName = SecurityProviderRegistrar.getEffectiveSecurityEntityName(entityType, name);
        int index = Arrays.binarySearch(values, effectiveName, String.CASE_INSENSITIVE_ORDER);
        return index >= 0;
    }

    public static String getEffectiveSecurityEntityName(Class<?> entityType, String name) {
        if (entityType == null || GenericUtils.isEmpty(name) || !Cipher.class.isAssignableFrom(entityType)) {
            return name;
        }
        int pos = name.indexOf(47);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static boolean registerSecurityProvider(SecurityProviderRegistrar registrar) {
        String name = ValidateUtils.checkNotNullAndNotEmpty(registrar == null ? null : registrar.getProviderName(), "No name for registrar=%s", (Object)registrar);
        Provider p = Security.getProvider(name);
        if (p != null) {
            return false;
        }
        p = ValidateUtils.checkNotNull(registrar.getSecurityProvider(), "No provider created for registrar %s of %s", registrar.getName(), name);
        if (registrar.isNamedProviderUsed()) {
            Security.addProvider(p);
        }
        return true;
    }

    public static SecurityProviderRegistrar findSecurityProviderRegistrarBySecurityEntity(Predicate<? super SecurityProviderRegistrar> entitySelector, Collection<? extends SecurityProviderRegistrar> registrars) {
        return GenericUtils.findFirstMatchingMember(r -> r.isEnabled() && r.isSupported() && entitySelector.test((SecurityProviderRegistrar)r), registrars);
    }
}

