/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ConditionBuilder;
import org.openhab.core.automation.util.ModuleBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ModuleI18nUtil {
    private final TranslationProvider i18nProvider;

    public ModuleI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public <T extends Module> List<T> getLocalizedModules(List<T> modules, Bundle bundle, String uid, String prefix, @Nullable Locale locale) {
        ArrayList<Module> lmodules = new ArrayList<Module>();
        for (Module module : modules) {
            String description;
            String label;
            @Nullable Module lmodule = this.createLocalizedModule(module, label = this.getModuleLabel(bundle, uid, module.getId(), module.getLabel(), prefix, locale), description = this.getModuleDescription(bundle, uid, module.getId(), module.getDescription(), prefix, locale));
            lmodules.add(lmodule == null ? module : lmodule);
        }
        return lmodules;
    }

    private <T extends Module> @Nullable T createLocalizedModule(T module, @Nullable String label, @Nullable String description) {
        if (module instanceof Action) {
            Action action = (Action)module;
            return (T)this.createLocalizedAction(action, label, description);
        }
        if (module instanceof Condition) {
            Condition condition = (Condition)module;
            return (T)this.createLocalizedCondition(condition, label, description);
        }
        if (module instanceof Trigger) {
            Trigger trigger = (Trigger)module;
            return (T)this.createLocalizedTrigger(trigger, label, description);
        }
        return null;
    }

    private Trigger createLocalizedTrigger(Trigger module, @Nullable String label, @Nullable String description) {
        return ((TriggerBuilder)((TriggerBuilder)ModuleBuilder.createTrigger(module).withLabel(label)).withDescription(description)).build();
    }

    private Condition createLocalizedCondition(Condition module, @Nullable String label, @Nullable String description) {
        return ((ConditionBuilder)((ConditionBuilder)ModuleBuilder.createCondition(module).withLabel(label)).withDescription(description)).build();
    }

    private Action createLocalizedAction(Action module, @Nullable String label, @Nullable String description) {
        return ((ActionBuilder)((ActionBuilder)ModuleBuilder.createAction(module).withLabel(label)).withDescription(description)).build();
    }

    private @Nullable String getModuleLabel(Bundle bundle, String uid, String moduleName, @Nullable String defaultLabel, String prefix, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferModuleKey(prefix, uid, moduleName, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private @Nullable String getModuleDescription(Bundle bundle, String uid, String moduleName, @Nullable String defaultDescription, String prefix, @Nullable Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferModuleKey(prefix, uid, moduleName, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    private String inferModuleKey(String prefix, String uid, String moduleName, String lastSegment) {
        return prefix + uid + ".input." + moduleName + "." + lastSegment;
    }
}

