/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.sddp;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class SddpDevice {
    public final String from;
    public final String host;
    public final String maxAge;
    public final String type;
    public final String primaryProxy;
    public final String proxies;
    public final String manufacturer;
    public final String model;
    public final String driver;
    public final String ipAddress;
    public final String port;
    public final String macAddress;
    public final Instant expireInstant;

    public SddpDevice(Map<String, String> headers, boolean offline) {
        this.from = headers.getOrDefault("From", "").replaceAll("^\"|\"$", "");
        this.host = headers.getOrDefault("Host", "").replaceAll("^\"|\"$", "");
        this.maxAge = headers.getOrDefault("Max-Age", "").replaceAll("^\"|\"$", "");
        this.type = headers.getOrDefault("Type", "").replaceAll("^\"|\"$", "");
        this.primaryProxy = headers.getOrDefault("Primary-Proxy", "").replaceAll("^\"|\"$", "");
        this.proxies = headers.getOrDefault("Proxies", "").replaceAll("^\"|\"$", "");
        this.manufacturer = headers.getOrDefault("Manufacturer", "").replaceAll("^\"|\"$", "");
        this.model = headers.getOrDefault("Model", "").replaceAll("^\"|\"$", "");
        this.driver = headers.getOrDefault("Driver", "").replaceAll("^\"|\"$", "");
        String[] fromParts = this.from.split(":");
        this.ipAddress = fromParts[0];
        this.port = fromParts.length > 1 ? fromParts[1] : "";
        String[] hostParts = this.host.split("-|_");
        String string = this.macAddress = hostParts.length <= 1 ? "" : hostParts[hostParts.length - 1].replace(":", "").replaceAll("(..)(?!$)", "$1-").toLowerCase();
        this.expireInstant = offline ? Instant.now().minusMillis(1L) : Instant.now().plusSeconds(this.maxAge.isBlank() ? 0 : Integer.parseInt(this.maxAge));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof SddpDevice) {
            SddpDevice other = (SddpDevice)obj;
            return Objects.equals(this.from, other.from);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from);
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expireInstant);
    }

    public String toString() {
        return "SddpDevice [from=" + this.from + ", host=" + this.host + ", maxAge=" + this.maxAge + ", type=" + this.type + ", primaryProxy=" + this.primaryProxy + ", proxies=" + this.proxies + ", manufacturer=" + this.manufacturer + ", model=" + this.model + ", driver=" + this.driver + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ", macAddress=" + this.macAddress + ", expireInstant=" + String.valueOf(this.expireInstant) + "]";
    }
}

