/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.cache.lru;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.cache.lru.InputStreamCacheWrapper;
import org.openhab.core.common.Disposable;
import org.openhab.core.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class LRUMediaCacheEntry<V> {
    private final Logger logger = LoggerFactory.getLogger(LRUMediaCacheEntry.class);
    private static final int CHUNK_SIZE = 10000;
    private int countStreamClient = 0;
    private final String key;
    private @Nullable InputStream inputStream;
    private @Nullable V metadata;
    private @Nullable File file;
    private @Nullable Storage<V> storage;
    protected long currentSize = 0L;
    private boolean completed;
    private boolean faulty = false;
    private @Nullable FileChannel fileChannel;
    private final Lock fileOperationLock = new ReentrantLock();

    public LRUMediaCacheEntry(String key) {
        this.key = key;
        this.completed = true;
    }

    public LRUMediaCacheEntry(String key, InputStream inputStream, @Nullable V metadata) {
        this.key = key;
        this.inputStream = inputStream;
        this.metadata = metadata;
        this.completed = false;
    }

    protected void setCacheContext(Path cacheDirectory, Storage<V> storage) {
        File fileLocal;
        this.file = fileLocal = cacheDirectory.resolve(this.key).toFile();
        this.storage = storage;
        V actualDataInStorage = storage.get(this.key);
        if (actualDataInStorage == null) {
            storage.put(this.key, this.metadata);
        } else {
            this.metadata = actualDataInStorage;
        }
        this.currentSize = fileLocal.length();
    }

    protected long getTotalSize() {
        if (this.completed) {
            return this.currentSize;
        }
        try {
            this.read(0, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            this.logger.debug("Cannot read the total size of the cache result. Using 0", (Throwable)e);
        }
        return this.currentSize;
    }

    protected long getCurrentSize() {
        return this.currentSize;
    }

    protected String getKey() {
        return this.key;
    }

    public InputStream getInputStream() throws IOException {
        File localFile = this.file;
        if (localFile == null) {
            InputStream inputStreamLocal = this.inputStream;
            if (inputStreamLocal != null) {
                return inputStreamLocal;
            }
            throw new IllegalStateException("Shouldn't happen. This cache entry is not tied to a file on disk and the inner input stream is null.");
        }
        this.logger.debug("Trying to open a cache inputstream for {}", (Object)localFile.getName());
        this.fileOperationLock.lock();
        try {
            ++this.countStreamClient;
            FileChannel fileChannelLocal = this.fileChannel;
            if (fileChannelLocal == null || !localFile.exists()) {
                this.fileChannel = fileChannelLocal = FileChannel.open(localFile.toPath(), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE), new FileAttribute[0]);
                if (this.completed && fileChannelLocal.size() == 0L) {
                    this.logger.debug("The cached file {} is not present anymore. We will have to recreate it", (Object)localFile.getName());
                    this.faulty = true;
                }
            }
        }
        finally {
            this.fileOperationLock.unlock();
        }
        return new InputStreamCacheWrapper(this);
    }

    protected void closeStreamClient() throws IOException {
        block12: {
            File fileLocal = this.file;
            if (fileLocal == null) {
                this.logger.debug("Trying to close a non existent-file. Is there a bug");
                return;
            }
            this.logger.debug("Trying to close a cached inputstream client for {}", (Object)fileLocal.getName());
            this.fileOperationLock.lock();
            try {
                --this.countStreamClient;
                if (this.countStreamClient > 0) break block12;
                try {
                    FileChannel fileChannelLocal = this.fileChannel;
                    if (fileChannelLocal == null) break block12;
                    try {
                        this.logger.debug("Effectively close the cache filechannel for {}", (Object)fileLocal.getName());
                        fileChannelLocal.close();
                    }
                    finally {
                        this.fileChannel = null;
                    }
                }
                finally {
                    InputStream inputStreamLocal = this.inputStream;
                    if (inputStreamLocal != null) {
                        inputStreamLocal.close();
                    }
                    if (inputStreamLocal instanceof Disposable) {
                        Disposable disposableStream = (Disposable)((Object)inputStreamLocal);
                        disposableStream.dispose();
                    }
                }
            }
            finally {
                this.fileOperationLock.unlock();
            }
        }
    }

    public @Nullable V getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] read(int start, int sizeToRead) throws IOException {
        FileChannel fileChannelLocal = this.fileChannel;
        if (fileChannelLocal == null || this.isFaulty()) {
            throw new IOException("Cannot read cache from null file channel or deleted file.");
        }
        if ((long)(start + sizeToRead) > fileChannelLocal.size() && !this.completed) {
            this.logger.trace("Maybe need to get data from inner stream");
            InputStream streamLocal = this.inputStream;
            if (streamLocal != null) {
                this.logger.trace("Trying to synchronize for reading inner inputstream");
                InputStream inputStream = streamLocal;
                synchronized (inputStream) {
                    while ((long)(start + sizeToRead) > fileChannelLocal.size() && !this.completed) {
                        this.logger.trace("Really need to get data from inner stream");
                        byte[] readFromSupplierStream = streamLocal.readNBytes(10000);
                        if (readFromSupplierStream.length == 0) {
                            this.logger.trace("End of the stream reached");
                            this.completed = true;
                            continue;
                        }
                        fileChannelLocal.write(ByteBuffer.wrap(readFromSupplierStream), this.currentSize);
                        this.logger.trace("writing {} bytes to {}", (Object)readFromSupplierStream.length, (Object)this.key);
                        this.currentSize += (long)readFromSupplierStream.length;
                    }
                }
            } else {
                this.faulty = true;
                this.logger.warn("Shouldn't happen : trying to get data from upstream for {} but original stream is null", (Object)this.key);
            }
        }
        long maxToRead = Math.min(fileChannelLocal.size(), (long)sizeToRead);
        ByteBuffer byteBufferFromChannelFile = ByteBuffer.allocate((int)maxToRead);
        int byteReadNumber = fileChannelLocal.read(byteBufferFromChannelFile, Integer.valueOf(start).longValue());
        this.logger.trace("Read {} bytes from the filechannel", (Object)byteReadNumber);
        if (byteReadNumber > 0) {
            byte[] resultByteArray = new byte[byteReadNumber];
            byteBufferFromChannelFile.rewind();
            byteBufferFromChannelFile.get(resultByteArray);
            return resultByteArray;
        }
        return new byte[0];
    }

    protected int availableFrom(int offset) {
        FileChannel fileChannelLocal = this.fileChannel;
        if (fileChannelLocal == null) {
            return 0;
        }
        try {
            long nBytes = Math.min(Integer.MAX_VALUE, Math.max(0L, fileChannelLocal.size() - (long)offset));
            return (int)nBytes;
        }
        catch (IOException e) {
            this.logger.debug("Cannot get file length for cache file {}", (Object)this.key);
            return 0;
        }
    }

    protected void deleteFile() {
        this.logger.debug("Receiving call to delete the cache file {}", (Object)this.key);
        this.fileOperationLock.lock();
        try {
            if (this.countStreamClient <= 0) {
                Storage<V> storageLocal;
                this.logger.debug("Effectively deleting the cached file {}", (Object)this.key);
                File fileLocal = this.file;
                if (fileLocal != null) {
                    fileLocal.delete();
                }
                if ((storageLocal = this.storage) != null) {
                    storageLocal.remove(this.key);
                }
            }
        }
        finally {
            this.fileOperationLock.unlock();
        }
    }

    public boolean isFaulty() {
        return this.faulty;
    }
}

