/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.Color;
import java.awt.Font;
import java.util.function.Function;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.theme.Theme;

public class XYStyler
extends AxesChartStyler {
    private XYSeries.XYSeriesRenderStyle xySeriesRenderStyle;
    private boolean isZoomEnabled;
    private Color zoomSelectionColor;
    private boolean zoomResetByDoubleClick;
    private boolean zoomResetByButton;
    private boolean isCursorEnabled;
    private Color cursorColor;
    private float cursorLineWidth;
    private Font cursorFont;
    private Color cursorFontColor;
    private Color cursorBackgroundColor;
    private Function<Double, String> customCursorXDataFormattingFunction;
    private Function<Double, String> customCursorYDataFormattingFunction;

    public XYStyler() {
        this.setAllStyles();
    }

    @Override
    protected void setAllStyles() {
        super.setAllStyles();
        this.xySeriesRenderStyle = XYSeries.XYSeriesRenderStyle.Line;
        this.isZoomEnabled = false;
        this.zoomSelectionColor = ChartColor.LIGHT_GREY.getColorTranslucent();
        this.zoomResetByDoubleClick = true;
        this.zoomResetByButton = true;
        this.isCursorEnabled = this.theme.isCursorEnabled();
        this.cursorColor = this.theme.getCursorColor();
        this.cursorLineWidth = this.theme.getCursorSize();
        this.cursorFont = this.theme.getCursorFont();
        this.cursorFontColor = this.theme.getCursorFontColor();
        this.cursorBackgroundColor = this.theme.getCursorBackgroundColor();
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.setAllStyles();
    }

    public XYSeries.XYSeriesRenderStyle getDefaultSeriesRenderStyle() {
        return this.xySeriesRenderStyle;
    }

    public XYStyler setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle xySeriesRenderStyle) {
        this.xySeriesRenderStyle = xySeriesRenderStyle;
        return this;
    }

    public boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public XYStyler setZoomEnabled(boolean isZoomEnabled) {
        this.isZoomEnabled = isZoomEnabled;
        return this;
    }

    public Color getZoomSelectionColor() {
        return this.zoomSelectionColor;
    }

    public XYStyler setZoomSelectionColor(Color zoomSelectionColor) {
        this.zoomSelectionColor = zoomSelectionColor;
        return this;
    }

    public boolean isZoomResetByDoubleClick() {
        return this.zoomResetByDoubleClick;
    }

    public XYStyler setZoomResetByDoubleClick(boolean zoomResetByDoubleClick) {
        this.zoomResetByDoubleClick = zoomResetByDoubleClick;
        return this;
    }

    public boolean isZoomResetByButton() {
        return this.zoomResetByButton;
    }

    public XYStyler setZoomResetByButton(boolean zoomResetByButton) {
        this.zoomResetByButton = zoomResetByButton;
        return this;
    }

    public boolean isCursorEnabled() {
        return this.isCursorEnabled;
    }

    public XYStyler setCursorEnabled(boolean isCursorEnabled) {
        this.isCursorEnabled = isCursorEnabled;
        return this;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public XYStyler setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
        return this;
    }

    public float getCursorLineWidth() {
        return this.cursorLineWidth;
    }

    public XYStyler setCursorLineWidth(float cursorLineWidth) {
        this.cursorLineWidth = cursorLineWidth;
        return this;
    }

    public Font getCursorFont() {
        return this.cursorFont;
    }

    public XYStyler setCursorFont(Font cursorFont) {
        this.cursorFont = cursorFont;
        return this;
    }

    public Color getCursorFontColor() {
        return this.cursorFontColor;
    }

    public XYStyler setCursorFontColor(Color cursorFontColor) {
        this.cursorFontColor = cursorFontColor;
        return this;
    }

    public Color getCursorBackgroundColor() {
        return this.cursorBackgroundColor;
    }

    public XYStyler setCursorBackgroundColor(Color cursorBackgroundColor) {
        this.cursorBackgroundColor = cursorBackgroundColor;
        return this;
    }

    public Function<Double, String> getCustomCursorXDataFormattingFunction() {
        return this.customCursorXDataFormattingFunction;
    }

    public XYStyler setCustomCursorXDataFormattingFunction(Function<Double, String> customCursorXDataFormattingFunction) {
        this.customCursorXDataFormattingFunction = customCursorXDataFormattingFunction;
        return this;
    }

    public Function<Double, String> getCustomCursorYDataFormattingFunction() {
        return this.customCursorYDataFormattingFunction;
    }

    public XYStyler setCustomCursorYDataFormattingFunction(Function<Double, String> customCursorYDataFormattingFunction) {
        this.customCursorYDataFormattingFunction = customCursorYDataFormattingFunction;
        return this;
    }
}

