// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by ./generator. DO NOT EDIT.
package dynrpcserver

import (
	"context"
	"sync"

	dependencies "github.com/hashicorp/terraform/internal/rpcapi/terraform1/dependencies"
)

type Dependencies struct {
	impl dependencies.DependenciesServer
	mu   sync.RWMutex
}

var _ dependencies.DependenciesServer = (*Dependencies)(nil)

func NewDependenciesStub() *Dependencies {
	return &Dependencies{}
}

func (s *Dependencies) BuildProviderPluginCache(a0 *dependencies.BuildProviderPluginCache_Request, a1 dependencies.Dependencies_BuildProviderPluginCacheServer) error {
	impl, err := s.realRPCServer()
	if err != nil {
		return err
	}
	return impl.BuildProviderPluginCache(a0, a1)
}

func (s *Dependencies) CloseDependencyLocks(a0 context.Context, a1 *dependencies.CloseDependencyLocks_Request) (*dependencies.CloseDependencyLocks_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CloseDependencyLocks(a0, a1)
}

func (s *Dependencies) CloseProviderPluginCache(a0 context.Context, a1 *dependencies.CloseProviderPluginCache_Request) (*dependencies.CloseProviderPluginCache_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CloseProviderPluginCache(a0, a1)
}

func (s *Dependencies) CloseSourceBundle(a0 context.Context, a1 *dependencies.CloseSourceBundle_Request) (*dependencies.CloseSourceBundle_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CloseSourceBundle(a0, a1)
}

func (s *Dependencies) CreateDependencyLocks(a0 context.Context, a1 *dependencies.CreateDependencyLocks_Request) (*dependencies.CreateDependencyLocks_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.CreateDependencyLocks(a0, a1)
}

func (s *Dependencies) GetBuiltInProviders(a0 context.Context, a1 *dependencies.GetBuiltInProviders_Request) (*dependencies.GetBuiltInProviders_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.GetBuiltInProviders(a0, a1)
}

func (s *Dependencies) GetCachedProviders(a0 context.Context, a1 *dependencies.GetCachedProviders_Request) (*dependencies.GetCachedProviders_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.GetCachedProviders(a0, a1)
}

func (s *Dependencies) GetLockedProviderDependencies(a0 context.Context, a1 *dependencies.GetLockedProviderDependencies_Request) (*dependencies.GetLockedProviderDependencies_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.GetLockedProviderDependencies(a0, a1)
}

func (s *Dependencies) GetProviderSchema(a0 context.Context, a1 *dependencies.GetProviderSchema_Request) (*dependencies.GetProviderSchema_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.GetProviderSchema(a0, a1)
}

func (s *Dependencies) OpenDependencyLockFile(a0 context.Context, a1 *dependencies.OpenDependencyLockFile_Request) (*dependencies.OpenDependencyLockFile_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.OpenDependencyLockFile(a0, a1)
}

func (s *Dependencies) OpenProviderPluginCache(a0 context.Context, a1 *dependencies.OpenProviderPluginCache_Request) (*dependencies.OpenProviderPluginCache_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.OpenProviderPluginCache(a0, a1)
}

func (s *Dependencies) OpenSourceBundle(a0 context.Context, a1 *dependencies.OpenSourceBundle_Request) (*dependencies.OpenSourceBundle_Response, error) {
	impl, err := s.realRPCServer()
	if err != nil {
		return nil, err
	}
	return impl.OpenSourceBundle(a0, a1)
}

func (s *Dependencies) ActivateRPCServer(impl dependencies.DependenciesServer) {
	s.mu.Lock()
	s.impl = impl
	s.mu.Unlock()
}

func (s *Dependencies) realRPCServer() (dependencies.DependenciesServer, error) {
	s.mu.RLock()
	impl := s.impl
	s.mu.RUnlock()
	if impl == nil {
		return nil, unavailableErr
	}
	return impl, nil
}
