# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import whyp


__tests__ = (
{
    "#url"     : "https://whyp.it/tracks/13721/fallout-3-intro-remake",
    "#class"   : whyp.WhypAudioExtractor,
    "#pattern" : r"https://cdn.whyp.it/5e9de576-f33a-40ea-bd43-1693a568a6a0.mp3\?token=.+",

    "allow_downloads": False,
    "artwork_url"    : None,
    "artwork_url_fallback": "https://cdn.whyp.it/a46f3485-8d19-4753-98e0-76011c7e33b0.jpg",
    "comments_count" : int,
    "created_at"     : "2025-11-24T16:59:50+00:00",
    "date"           : "dt:2025-11-24 16:59:50",
    "description"    : "",
    "duration"       : 46.34,
    "extension"      : "mp3",
    "filename"       : "5e9de576-f33a-40ea-bd43-1693a568a6a0",
    "id"             : 13721,
    "lossless_size"  : None,
    "lossless_url"   : None,
    "lossy_size"     : 1853719,
    "lossy_url"      : r"re:https://cdn.whyp.it/5e9de576-f33a-40ea-bd43-1693a568a6a0.mp3",
    "original"       : False,
    "public"         : True,
    "settings_comments": "users",
    "slug"           : "fallout-3-intro-remake",
    "title"          : "Fallout 3 Intro Remake",
    "token"          : "k5E2z",
    "user_id"        : 1,
    "waveform_url"   : r"re:https://cdn.whyp.it/5e9de576-f33a-40ea-bd43-1693a568a6a0.json",
    "user"           : {
        "avatar"          : "https://cdn.whyp.it/a46f3485-8d19-4753-98e0-76011c7e33b0.jpg",
        "has_enterprise"  : True,
        "has_pro"         : True,
        "has_pro_lifetime": False,
        "id"              : 1,
        "slug"            : "brad",
        "status"          : "Coding 👨🏻‍💻",
        "tracks_count"    : 3,
        "username"        : "Brad",
    },
},

{
    "#url"     : "https://whyp.it/users/1/brad",
    "#class"   : whyp.WhypUserExtractor,
    "#pattern" : (
        r"https://cdn.whyp.it/5e9de576-f33a-40ea-bd43-1693a568a6a0.mp3\?token=.+",
        r"https://cdn.whyp.it/0d7a196b-3e1a-4510-a4a4-6189c56ecb27.flac\?token=.+",
        r"https://cdn.whyp.it/3d134d07-7c55-4a6b-b321-56ce90ee1fc8.flac\?token=.+",
    ),

    "allow_downloads": bool,
    "artwork_url"    : {str, None},
    "artwork_url_fallback": str,
    "comments_count" : int,
    "created_at"     : "iso:dt",
    "date"           : "type:datetime",
    "description"    : str,
    "duration"       : float,
    "extension"      : {"mp3", "flac"},
    "filename"       : "iso:uuid",
    "id"             : {13721, 18337, 324260},
    "lossless_size"  : {int, None},
    "lossless_url"   : {str, None},
    "lossy_size"     : int,
    "lossy_url"      : str,
    "original"       : bool,
    "public"         : True,
    "settings_comments": "users",
    "slug"           : str,
    "title"          : str,
    "token"          : str,
    "user_id"        : 1,
    "waveform_url"   : str,
    "user"           : {
        "avatar"          : "https://cdn.whyp.it/a46f3485-8d19-4753-98e0-76011c7e33b0.jpg",
        "has_enterprise"  : True,
        "has_pro"         : True,
        "has_pro_lifetime": False,
        "id"              : 1,
        "slug"            : "brad",
        "status"          : "Coding 👨🏻‍💻",
        "tracks_count"    : 3,
        "username"        : "Brad",
    },
},

{
    "#url"     : "https://whyp.it/collections/1/example-collection",
    "#class"   : whyp.WhypCollectionExtractor,
    "#pattern" : (
        r"https://cdn.whyp.it/3d134d07-7c55-4a6b-b321-56ce90ee1fc8.flac\?token=.+",
        r"https://cdn.whyp.it/0d7a196b-3e1a-4510-a4a4-6189c56ecb27.flac\?token=.+",
    ),

    "extension"       : "flac",
    "id"              : {18337, 324260},
    "original"        : True,
    "pivot_collection_id": 1,
    "pivot_created_at": "iso:dt",
    "pivot_order"     : int,
    "public"          : True,
    "collection"      : {
        "artwork_url" : "https://cdn.whyp.it/60fff341-02ef-4fe2-86f7-f283b2df1557.jpg",
        "artwork_url_fallback": "https://cdn.whyp.it/b42b34d3-5839-4a26-9c32-41e917f31f6b.jpg",
        "created_at"  : "2023-07-20T16:14:33+00:00",
        "description" : "This is an example collection on Whyp!",
        "duration"    : 352.59,
        "hidden_tracks_count": 0,
        "id"          : 1,
        "order"       : 1,
        "public"      : True,
        "slug"        : "example-collection",
        "title"       : "Example Collection",
        "token"       : "VFc7Q",
        "tracks_count": 2,
        "updated_at"  : "2025-11-17T19:45:01+00:00",
        "user_id"     : 1,
        "user"        : dict,
    },
    "user"            : {
        "avatar"          : "https://cdn.whyp.it/a46f3485-8d19-4753-98e0-76011c7e33b0.jpg",
        "has_enterprise"  : True,
        "has_pro"         : True,
        "has_pro_lifetime": False,
        "id"              : 1,
        "slug"            : "brad",
        "status"          : "Coding 👨🏻‍💻",
        "tracks_count"    : 3,
        "username"        : "Brad",
    },
},

)
