// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --version 3
// REQUIRES: amdgpu-registered-target

// Tests if -fno-openmp-allow-kernel-io suppresses print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fno-openmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fno-openmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK-NOPE %s

// Tests if -fopenmp-allow-kernel-io produces print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK %s

// Tests if -fopenmp-target-fast -fopenmp-allow-kernel-io produces print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-target-fast -fopenmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-target-fast -fopenmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK %s

// Tests if -fopenmp-target-fast -fno-openmp-allow-kernel-io suppresses print.
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa  -fopenmp-target-fast -fno-openmp-allow-kernel-io -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-target-fast -fno-openmp-allow-kernel-io -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -check-prefix=CHECK-NOPE %s


extern "C" int printf(const char *format, ...);

int main(void) {

#pragma omp target
  {
    printf("howdy GPU\n");
  }

  return 0;
}


// CHECK-NOPE-LABEL: define weak_odr protected amdgpu_kernel void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l25(
// CHECK-NOPE-SAME: ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NOPE-NEXT:  entry:
// CHECK-NOPE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NOPE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NOPE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NOPE-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr addrspacecast (ptr addrspace(1) @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l25_kernel_environment to ptr), ptr [[DYN_PTR]])
// CHECK-NOPE-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-NOPE-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK-NOPE:       user_code.entry:
// CHECK-NOPE-NEXT:    [[TMP1:%.*]] = call ptr @printf_allocate(i32 27)
// CHECK-NOPE-NEXT:    [[VARFN_ARGS_STORE_CASTED:%.*]] = addrspacecast ptr [[TMP1]] to ptr addrspace(1)
// CHECK-NOPE-NEXT:    [[TMP2:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE:%.*]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 0
// CHECK-NOPE-NEXT:    store i32 16, ptr addrspace(1) [[TMP2]], align 4
// CHECK-NOPE-NEXT:    [[TMP3:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 1
// CHECK-NOPE-NEXT:    store i32 1, ptr addrspace(1) [[TMP3]], align 4
// CHECK-NOPE-NEXT:    [[TMP4:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 2
// CHECK-NOPE-NEXT:    store i32 917505, ptr addrspace(1) [[TMP4]], align 4
// CHECK-NOPE-NEXT:    [[TMP5:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 3
// CHECK-NOPE-NEXT:    store i32 11, ptr addrspace(1) [[TMP5]], align 4
// CHECK-NOPE-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i64 16
// CHECK-NOPE-NEXT:    call void @llvm.memcpy.p1.p0.i64(ptr addrspace(1) align 1 [[TMP6]], ptr align 1 addrspacecast (ptr addrspace(4) @.str to ptr), i64 11, i1 false)
// CHECK-NOPE-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[TMP6]], i64 11
// CHECK-NOPE-NEXT:    [[TMP8:%.*]] = call i32 @printf_execute(ptr [[TMP1]], i32 27)
// CHECK-NOPE-NEXT:    call void @__kmpc_target_deinit()
// CHECK-NOPE-NEXT:    ret void
// CHECK-NOPE:       worker.exit:
// CHECK-NOPE-NEXT:    ret void
//
//
// CHECK-LABEL: define weak_odr protected amdgpu_kernel void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l25(
// CHECK-SAME: ptr noalias noundef [[DYN_PTR:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_target_init(ptr addrspacecast (ptr addrspace(1) @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l25_kernel_environment to ptr), ptr [[DYN_PTR]])
// CHECK-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP0]], -1
// CHECK-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// CHECK:       user_code.entry:
// CHECK-NEXT:    [[TMP1:%.*]] = call ptr @printf_allocate(i32 27)
// CHECK-NEXT:    [[VARFN_ARGS_STORE_CASTED:%.*]] = addrspacecast ptr [[TMP1]] to ptr addrspace(1)
// CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE:%.*]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 0
// CHECK-NEXT:    store i32 16, ptr addrspace(1) [[TMP2]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 1
// CHECK-NEXT:    store i32 1, ptr addrspace(1) [[TMP3]], align 4
// CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 2
// CHECK-NEXT:    store i32 917505, ptr addrspace(1) [[TMP4]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds nuw [[VARFN_ARGS_STORE]], ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i32 0, i32 3
// CHECK-NEXT:    store i32 11, ptr addrspace(1) [[TMP5]], align 4
// CHECK-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[VARFN_ARGS_STORE_CASTED]], i64 16
// CHECK-NEXT:    call void @llvm.memcpy.p1.p0.i64(ptr addrspace(1) align 1 [[TMP6]], ptr align 1 addrspacecast (ptr addrspace(4) @.str to ptr), i64 11, i1 false)
// CHECK-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[TMP6]], i64 11
// CHECK-NEXT:    [[TMP8:%.*]] = call i32 @printf_execute(ptr [[TMP1]], i32 27)
// CHECK-NEXT:    call void @__kmpc_target_deinit()
// CHECK-NEXT:    ret void
// CHECK:       worker.exit:
// CHECK-NEXT:    ret void
//
