//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package eachval

import (
	context "context"
	fmt "fmt"

	equality "k8s.io/apimachinery/pkg/api/equality"
	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	// type StructWithMaps
	scheme.AddValidationFunc((*StructWithMaps)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_StructWithMaps(ctx, op, nil /* fldPath */, obj.(*StructWithMaps), safe.Cast[*StructWithMaps](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_StructWithMaps validates an instance of StructWithMaps according
// to declarative validation rules in the API schema.
func Validate_StructWithMaps(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *StructWithMaps) (errs field.ErrorList) {
	// field StructWithMaps.TypeMeta has no validation

	// field StructWithMaps.MapPrimitiveField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, validate.DirectEqual, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *string) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field MapTest.MapPrimitiveField[*]")
			})...)
			return
		}(fldPath.Child("mapPrimitiveField"), obj.MapPrimitiveField, safe.Field(oldObj, func(oldObj *StructWithMaps) map[string]string { return oldObj.MapPrimitiveField }), oldObj != nil)...)

	// field StructWithMaps.MapTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]StringType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, validate.DirectEqual, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *StringType) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field MapTest.MapTypedefField[*]")
			})...)
			return
		}(fldPath.Child("mapTypedefField"), obj.MapTypedefField, safe.Field(oldObj, func(oldObj *StructWithMaps) map[string]StringType { return oldObj.MapTypedefField }), oldObj != nil)...)

	// field StructWithMaps.MapComparableStructField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]ComparableStruct, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, validate.DirectEqual, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *ComparableStruct) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field MapTest.MapComparableStructField[*]")
			})...)
			return
		}(fldPath.Child("mapComparableStructField"), obj.MapComparableStructField, safe.Field(oldObj, func(oldObj *StructWithMaps) map[string]ComparableStruct { return oldObj.MapComparableStructField }), oldObj != nil)...)

	// field StructWithMaps.MapNonComparableStructField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]NonComparableStruct, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			errs = append(errs, validate.EachMapVal(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual, func(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *NonComparableStruct) field.ErrorList {
				return validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field MapTest.MapNonComparableStructField[*]")
			})...)
			return
		}(fldPath.Child("mapNonComparableStructField"), obj.MapNonComparableStructField, safe.Field(oldObj, func(oldObj *StructWithMaps) map[string]NonComparableStruct { return oldObj.MapNonComparableStructField }), oldObj != nil)...)

	return errs
}
