/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "hora do meridiano de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "",
               "",
               "",
               "",
               "hora de Acre",
               "",
            };
        final String[] Apia = new String[] {
               "hora estándar de Apia",
               "",
               "hora de verán de Apia",
               "",
               "hora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "hora estándar das Illas Cook",
               "",
               "hora de verán medio das Illas Cook",
               "",
               "hora das Illas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "hora estándar de Cuba",
               "CST",
               "hora de verán de Cuba",
               "CDT",
               "hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "hora estándar de Fixi",
               "",
               "hora de verán de Fixi",
               "",
               "hora de Fixi",
               "",
            };
        final String[] Gulf = new String[] {
               "hora do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hora estándar de Hovd",
               "",
               "hora de verán de Hovd",
               "",
               "hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "hora estándar de Irán",
               "",
               "hora de verán de Irán",
               "",
               "hora de Irán",
               "",
            };
        final String[] Niue = new String[] {
               "hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "hora estándar de Omsk",
               "",
               "hora de verán de Omsk",
               "",
               "hora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "hora estándar do Perú",
               "",
               "hora de verán do Perú",
               "",
               "hora do Perú",
               "",
            };
        final String[] Truk = new String[] {
               "hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "hora da Illa Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "hora estándar de Chile",
               "",
               "hora de verán de Chile",
               "",
               "hora de Chile",
               "",
            };
        final String[] China = new String[] {
               "hora estándar da China",
               "CST",
               "hora de verán da China",
               "CDT",
               "hora da China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "hora das Illas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "hora da India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "hora estándar do Xapón",
               "JST",
               "hora de verán do Xapón",
               "JDT",
               "hora do Xapón",
               "JT",
            };
        final String[] Korea = new String[] {
               "hora estándar de Corea",
               "KST",
               "hora de verán de Corea",
               "KST",
               "hora de Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "hora de Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "hora estándar de Samoa",
               "SST",
               "hora de verán de Samoa",
               "SST",
               "hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "hora estándar de Tonga",
               "",
               "hora de verán de Tonga",
               "",
               "hora de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "hora de Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "hora estándar de Alasca",
               "AKST",
               "hora de verán de Alasca",
               "AKDT",
               "hora de Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "hora estándar do Amazonas",
               "",
               "hora de verán do Amazonas",
               "",
               "hora do Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "Horario estándar de Anadir",
               "",
               "Horario de verán de Anadir",
               "",
               "hora de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "hora estándar dos Azores",
               "",
               "hora de verán dos Azores",
               "",
               "hora dos Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "hora de Bután",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "hora de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "hora estándar da Illa de Pascua",
               "",
               "hora de verán da Illa de Pascua",
               "",
               "hora da Illa de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "hora da Güiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "hora estándar de Israel",
               "IST",
               "hora de verán de Israel",
               "IDT",
               "hora de Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "hora estándar de Moscova",
               "MSK",
               "hora de verán de Moscova",
               "MSK",
               "hora de Moscova",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "hora de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Horario estándar de Samara",
               "",
               "Horario de verán de Samara",
               "",
               "hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "hora de Tahití",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "hora estándar de Taipei",
               "CST",
               "hora de verán de Taipei",
               "CDT",
               "hora de Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "hora de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "hora estándar árabe",
               "",
               "hora de verán árabe",
               "",
               "hora árabe",
               "",
            };
        final String[] Armenia = new String[] {
               "hora estándar de Armenia",
               "",
               "hora de verán de Armenia",
               "",
               "hora de Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "hora estándar de Chatham",
               "",
               "hora de verán de Chatham",
               "",
               "hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "hora universal coordinada",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "hora de Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "hora estándar de Xeorxia",
               "",
               "hora de verán de Xeorxia",
               "",
               "hora de Xeorxia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "hora estándar de Irkutsk",
               "",
               "hora de verán de Irkutsk",
               "",
               "hora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "hora estándar de Magadan",
               "",
               "hora de verán de Magadan",
               "",
               "hora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "hora estándar da Illa Norfolk",
               "",
               "hora de verán da Illa Norfolk",
               "",
               "hora da Illa Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "hora estándar de Fernando de Noronha",
               "",
               "hora de verán de Fernando de Noronha",
               "",
               "hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "hora de Reunión",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "hora das Illas Salomón",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "hora estándar do Uruguai",
               "",
               "hora de verán do Uruguai",
               "",
               "hora do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "hora estándar de Vanuatu",
               "",
               "hora de verán de Vanuatu",
               "",
               "hora de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "hora estándar de Iakutsk",
               "",
               "hora de verán de Iakutsk",
               "",
               "hora de Iakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "hora estándar do Atlántico",
               "AST",
               "hora de verán do Atlántico",
               "AST",
               "hora do Atlántico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "hora estándar de Brasilia",
               "",
               "hora de verán de Brasilia",
               "",
               "hora de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "hora estándar chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "hora estándar de Colombia",
               "",
               "hora de verán de Colombia",
               "",
               "hora de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "hora estándar das Illas Malvinas",
               "",
               "hora de verán das Illas Malvinas",
               "",
               "hora das Illas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "hora de Malaisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "hora das Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "hora estándar de Ulaanbaatar",
               "",
               "hora de verán de Ulaanbaatar",
               "",
               "hora de Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "hora estándar de Paquistán",
               "PKT",
               "hora de verán de Paquistán",
               "PKST",
               "hora de Paquistán",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "hora estándar do Paraguai",
               "",
               "hora de verán do Paraguai",
               "",
               "hora do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "hora estándar de Sakhalín",
               "",
               "hora de verán de Sakhalín",
               "",
               "hora de Sakhalín",
               "",
            };
        final String[] Suriname = new String[] {
               "hora de Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "hora estándar da Arxentina",
               "",
               "hora de verán da Arxentina",
               "",
               "hora da Arxentina",
               "",
            };
        final String[] Christmas = new String[] {
               "hora da Illa Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "hora das Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hora estándar de Hong Kong",
               "HKT",
               "hora de verán de Hong Kong",
               "HKST",
               "hora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "hora de Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Horario estándar de Petropávlovsk-Kamchatski",
               "",
               "Horario de verán de Petropávlovsk-Kamchatski",
               "",
               "hora estándar de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "hora de Kirguizistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "hora estándar de Lord Howe",
               "",
               "hora de verán de Lord Howe",
               "",
               "hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "hora das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "hora estándar de Mauricio",
               "",
               "hora de verán de Mauricio",
               "",
               "hora de Mauricio",
               "",
            };
        final String[] Singapore = new String[] {
               "hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "hora estándar de Volgogrado",
               "MSK",
               "hora de verán de Volgogrado",
               "MSK",
               "hora de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "hora estándar de Acerbaixán",
               "",
               "hora de verán de Acerbaixán",
               "",
               "hora de Acerbaixán",
               "",
            };
        final String[] Bangladesh = new String[] {
               "hora estándar de Bangladesh",
               "",
               "hora de verán de Bangladesh",
               "",
               "hora de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "hora estándar de Cabo Verde",
               "",
               "hora de verán de Cabo Verde",
               "",
               "hora de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "hora de Timor Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "hora de Kazakistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "hora das Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "hora de Taxiquistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "hora estándar de Uzbekistán",
               "",
               "hora de verán de Uzbekistán",
               "",
               "hora de Uzbekistán",
               "",
            };
        final String[] Afghanistan = new String[] {
               "hora de Afganistán",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora estándar de Krasnoiarsk",
               "",
               "hora de verán de Krasnoiarsk",
               "",
               "hora de Krasnoiarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "hora estándar de Nova Zelandia",
               "NZST",
               "hora de verán de Nova Zelandia",
               "NZDT",
               "hora de Nova Zelandia",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "hora estándar de Novosibirsk",
               "",
               "hora de verán de Novosibirsk",
               "",
               "hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "hora estándar de Filipinas",
               "PST",
               "hora de verán de Filipinas",
               "PDT",
               "hora de Filipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "hora estándar de Vladivostok",
               "",
               "hora de verán de Vladivostok",
               "",
               "hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "hora do Océano Índico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "hora das Illas da Liña",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "hora estándar de Terra Nova",
               "NST",
               "hora de verán de Terra Nova",
               "NDT",
               "hora de Terra Nova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "hora estándar de Turkmenistán",
               "",
               "hora de verán de Turkmenistán",
               "",
               "hora de Turkmenistán",
               "",
            };
        final String[] French_Guiana = new String[] {
               "hora da Güiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "hora estándar de Nova Caledonia",
               "",
               "hora de verán de Nova Caledonia",
               "",
               "hora de Nova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "hora de Xeorxia do Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "hora estándar de Ekaterimburgo",
               "",
               "hora de verán de Ekaterimburgo",
               "",
               "hora de Ekaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "hora de África Central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "hora de África Oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "hora estándar de África Occidental",
               "WAT",
               "hora de verán de África Occidental",
               "WAT",
               "hora de África Occidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "hora de Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "hora estándar de Europa Central",
               "CET",
               "hora de verán de Europa Central",
               "CEST",
               "hora de Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "hora estándar de Europa Oriental",
               "EET",
               "hora de verán de Europa Oriental",
               "EEST",
               "hora de Europa Oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "hora estándar de Europa Occidental",
               "WET",
               "hora de verán de Europa Occidental",
               "WEST",
               "hora de Europa Occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora estándar do Pacífico mexicano",
               "MST",
               "hora de verán do Pacífico mexicano",
               "MDT",
               "hora do Pacífico mexicano",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "hora de África Meridional",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "hora estándar central, Norteamérica",
               "CST",
               "hora de verán central, Norteamérica",
               "CDT",
               "hora central, Norteamérica",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "hora estándar do leste, América do Norte",
               "EST",
               "hora de verán do leste, América do Norte",
               "EST",
               "hora do leste, América do Norte",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "hora estándar do Pacífico, América do Norte",
               "PST",
               "hora de verán do Pacífico, América do Norte",
               "PDT",
               "hora do Pacífico, América do Norte",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "hora das Terras Austrais e Antárticas Francesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora das Illas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora estándar de Hawai-illas Aleutianas",
               "HST",
               "hora de verán de Hawai-illas Aleutianas",
               "HST",
               "hora de Hawai-illas Aleutianas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora das Illas Fénix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora estándar de Saint Pierre et Miquelon",
               "",
               "hora de verán de Saint Pierre et Miquelon",
               "",
               "hora de Saint Pierre et Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora estándar da montaña, América do Norte",
               "MST",
               "hora de verán da montaña, América do Norte",
               "MST",
               "hora da montaña, América do Norte",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "hora das Illas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "hora de Papúa-Nova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "hora estándar de Australia Central",
               "ACST",
               "hora de verán de Australia Central",
               "ACDT",
               "hora de Australia Central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "hora estándar de Australia Oriental",
               "AEST",
               "hora de verán de Australia Oriental",
               "AEDT",
               "hora de Australia Oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "hora estándar de Australia Occidental",
               "AWST",
               "hora de verán de Australia Occidental",
               "AWDT",
               "hora de Australia Occidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "hora de Indonesia Central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "hora de Indonesia Oriental",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "hora de Indonesia Occidental",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "hora estándar de Australia Occidental Central",
               "",
               "hora de verán de Australia Occidental Central",
               "",
               "hora de Australia Occidental Central",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora estándar irlandesa",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "hora universal coordinada",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora estándar irlandesa",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "hora do meridiano de Greenwich",
                    "GMT",
                    "hora de verán británica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adén" },
            { "timezone.excity.Asia/Baku", "Bacú" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amán" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chitá" },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Seoul", "Seúl" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lomé" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Hebron", "Hebrón" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Tehran", "Teherán" },
            { "timezone.excity.Asia/Urumqi", "Ürümqi" },
            { "timezone.excity.Etc/Unknown", "cidade descoñecida" },
            { "timezone.excity.Europe/Kiev", "Kíiv" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mahé" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "O Cairo" },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Jakarta", "Iacarta" },
            { "timezone.excity.Asia/Yakutsk", "Iakutsk" },
            { "timezone.excity.Asia/Yerevan", "Iereván" },
            { "timezone.excity.Europe/Paris", "París" },
            { "timezone.excity.Europe/Sofia", "Sofía" },
            { "timezone.excity.Pacific/Fiji", "Fixi" },
            { "timezone.excity.Africa/Bamako", "Bamaco" },
            { "timezone.excity.Africa/Lusaka", "Lusaca" },
            { "timezone.excity.America/Bahia", "Baía" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.Asia/Ashgabat", "Achkhabad" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Katmandu", "Katmandú" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Qostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalín" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berlín" },
            { "timezone.excity.Europe/Dublin", "Dublín" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Monaco", "Mónaco" },
            { "timezone.excity.Europe/Moscow", "Moscova" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alxer" },
            { "timezone.excity.Africa/Tripoli", "Trípoli" },
            { "timezone.excity.America/Bogota", "Bogotá" },
            { "timezone.excity.America/Cayman", "Illas Caimán" },
            { "timezone.excity.America/Cuiaba", "Cuiabá" },
            { "timezone.excity.America/Guyana", "Güiana" },
            { "timezone.excity.America/Havana", "A Habana" },
            { "timezone.excity.America/La_Paz", "A Paz" },
            { "timezone.excity.America/Maceio", "Maceió" },
            { "timezone.excity.America/Panama", "Panamá" },
            { "timezone.excity.Asia/Jerusalem", "Xerusalén" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Indian/Reunion", "Reunión" },
            { "timezone.excity.Pacific/Easter", "Illa de Pascua" },
            { "timezone.excity.Pacific/Tahiti", "Tahití" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "O Aiún" },
            { "timezone.excity.Africa/Khartoum", "Khartún" },
            { "timezone.excity.Africa/Ndjamena", "N’Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "San Tomé" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Jamaica", "Xamaica" },
            { "timezone.excity.America/Tortola", "Tórtola" },
            { "timezone.excity.Atlantic/Canary", "Illas Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Feroe" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "timezone.excity.Europe/Helsinki", "Helsinqui" },
            { "timezone.excity.Europe/Sarajevo", "Saraievo" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Africa/Mogadishu", "Mogadixo" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/Mazatlan", "Mazatlán" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Santarem", "Santarém" },
            { "timezone.excity.America/St_Johns", "Saint John’s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Santa Lucía" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Atlantic/Bermuda", "Illas Bermudas" },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Europe/Amsterdam", "Ámsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrakán" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Xibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Illa Christmas" },
            { "timezone.excity.Indian/Mauritius", "Mauricio" },
            { "timezone.excity.Pacific/Honolulu", "Honolulú" },
            { "timezone.excity.America/Araguaina", "Araguaína" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Europe/Simferopol", "Simferópol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Illas Galápagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Adís Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Rio_Branco", "Río Branco" },
            { "timezone.excity.America/St_Vincent", "San Vicente" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reiquiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Europe/Isle_of_Man", "Illa de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Africa/Johannesburg", "Xohanesburgo" },
            { "timezone.excity.America/El_Salvador", "O Salvador" },
            { "timezone.excity.America/Los_Angeles", "Os Ánxeles" },
            { "timezone.excity.America/Mexico_City", "Cidade de México" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.America/Indianapolis", "Indianápolis" },
            { "timezone.excity.America/Port_of_Spain", "Porto España" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthélemy" },
            { "timezone.excity.America/Port-au-Prince", "Porto Príncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Xeorxia do Sur" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumán" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dacota do Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dacota do Norte" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Río Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dacota do Norte" },
        };
        return data;
    }
}
